/*
 * Decompiled with CFR 0.152.
 */
package com.pt.io;

import com.pt.io.FSFileRPM;
import com.pt.io.FileSystem;
import com.pt.io.InputUni;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.zip.GZIPInputStream;
import phelps.io.Files;

public class FileSystemRPM
extends FileSystem {
    public static final char separatorChar = '/';
    public static final int RPMTAG_NAME = 1000;
    public static final int RPMTAG_VERSION = 1001;
    public static final int RPMTAG_RELEASE = 1002;
    public static final int RPMTAG_SERIAL = 1003;
    public static final int RPMTAG_SUMMARY = 1004;
    public static final int RPMTAG_DESCRIPTION = 1005;
    public static final int RPMTAG_BUILDTIME = 1006;
    public static final int RPMTAG_BUILDHOST = 1007;
    public static final int RPMTAG_INSTALLTIME = 1008;
    public static final int RPMTAG_SIZE = 1009;
    public static final int RPMTAG_DISTRIBUTION = 1010;
    public static final int RPMTAG_VENDOR = 1011;
    public static final int RPMTAG_GIF = 1012;
    public static final int RPMTAG_XPM = 1013;
    public static final int RPMTAG_COPYRIGHT = 1014;
    public static final int RPMTAG_PACKAGER = 1015;
    public static final int RPMTAG_GROUP = 1016;
    public static final int RPMTAG_CHANGELOG = 1017;
    public static final int RPMTAG_SOURCE = 1018;
    public static final int RPMTAG_PATCH = 1019;
    public static final int RPMTAG_URL = 1020;
    public static final int RPMTAG_OS = 1021;
    public static final int RPMTAG_ARCH = 1022;
    public static final int RPMTAG_PREIN = 1023;
    public static final int RPMTAG_POSTIN = 1024;
    public static final int RPMTAG_PREUN = 1025;
    public static final int RPMTAG_POSTUN = 1026;
    public static final int RPMTAG_FILENAMES = 1027;
    public static final int RPMTAG_FILESIZES = 1028;
    public static final int RPMTAG_FILESTATES = 1029;
    public static final int RPMTAG_FILEMODES = 1030;
    public static final int RPMTAG_FILEUIDS = 1031;
    public static final int RPMTAG_FILEGIDS = 1032;
    public static final int RPMTAG_FILERDEVS = 1033;
    public static final int RPMTAG_FILEMTIMES = 1034;
    public static final int RPMTAG_FILEMD5S = 1035;
    public static final int RPMTAG_FILELINKTOS = 1036;
    public static final int RPMTAG_FILEFLAGS = 1037;
    public static final int RPMTAG_ROOT = 1038;
    public static final int RPMTAG_FILEUSERNAME = 1039;
    public static final int RPMTAG_FILEGROUPNAME = 1040;
    public static final int RPMTAG_EXCLUDE = 1041;
    public static final int RPMTAG_EXCLUSIVE = 1042;
    public static final int RPMTAG_ICON = 1043;
    public static final int RPMTAG_SOURCERPM = 1044;
    public static final int RPMTAG_FILEVERIFYFLAGS = 1045;
    public static final int RPMTAG_ARCHIVESIZE = 1046;
    public static final int RPMTAG_PROVIDES = 1047;
    public static final int RPMTAG_REQUIREFLAGS = 1048;
    public static final int RPMTAG_REQUIRENAME = 1049;
    public static final int RPMTAG_REQUIREVERSION = 1050;
    public static final int RPMTAG_NOSOURCE = 1051;
    public static final int RPMTAG_NOPATCH = 1052;
    public static final int RPMTAG_CONFLICTFLAGS = 1053;
    public static final int RPMTAG_CONFLICTNAME = 1054;
    public static final int RPMTAG_CONFLICTVERSION = 1055;
    public static final int RPMTAG_DEFAULTPREFIX = 1056;
    public static final int RPMTAG_BUILDROOT = 1057;
    public static final int RPMTAG_INSTALLPREFIX = 1058;
    public static final int RPMTAG_EXCLUDEARCH = 1059;
    public static final int RPMTAG_EXCLUDEOS = 1060;
    public static final int RPMTAG_EXCLUSIVEARCH = 1061;
    public static final int RPMTAG_EXCLUSIVEOS = 1062;
    public static final int RPMTAG_AUTOREQPROV = 1063;
    public static final int RPMTAG_RPMVERSION = 1064;
    public static final int RPMTAG_TRIGGERSCRIPTS = 1065;
    public static final int RPMTAG_TRIGGERNAME = 1066;
    public static final int RPMTAG_TRIGGERVERSION = 1067;
    public static final int RPMTAG_TRIGGERFLAGS = 1068;
    public static final int RPMTAG_TRIGGERINDEX = 1069;
    public static final int RPMTAG_VERIFYSCRIPT = 1079;
    public static final int SIGTAG_SIZE = 1000;
    public static final int SIGTAG_MD5 = 1001;
    public static final int SIGTAG_PGP = 1002;
    public static final int NULL = 0;
    public static final int CHAR = 1;
    public static final int INT8 = 2;
    public static final int INT16 = 3;
    public static final int INT32 = 4;
    public static final int INT64 = 5;
    public static final int STRING = 6;
    public static final int BIN = 7;
    public static final int STRING_ARRAY = 8;
    public static final int C_IRUSR = 256;
    public static final int C_IWUSR = 128;
    public static final int C_IXUSR = 64;
    public static final int C_IRGRP = 32;
    public static final int C_IWGRP = 16;
    public static final int C_IXGRP = 8;
    public static final int C_IROTH = 4;
    public static final int C_IWOTH = 2;
    public static final int C_IXOTH = 1;
    public static final int C_ISUID = 2048;
    public static final int C_ISGID = 1024;
    public static final int C_ISVTX = 512;
    public static final int C_ISBLK = 24576;
    public static final int C_ISCHR = 8192;
    public static final int C_ISDIR = 16384;
    public static final int C_ISFIFO = 4096;
    public static final int C_ISSOCK = 49152;
    public static final int C_ISLNK = 40960;
    public static final int C_ISCTG = 36864;
    public static final int C_ISREG = 32768;
    private static final String CPIO_END = "TRAILER!!!";
    private static final int CPIO_MAGIC = 29121;
    private InputStream is_ = null;

    public FileSystemRPM(InputUni inputUni) throws IOException {
        super(inputUni.getURI());
        this.init();
    }

    public FileSystemRPM(File file) throws IOException {
        super(file.toURI());
        this.init();
    }

    private void init() throws IOException {
        int n;
        int n2;
        this.is_ = null;
        InputStream inputStream = null;
        if (inputStream.read() != 237 || inputStream.read() != 171 || inputStream.read() != 238 || inputStream.read() != 219) {
            throw new IOException("Not a valid RPM file -- bad magic number.");
        }
        int n3 = 96;
        for (n2 = 4; n2 < n3; ++n2) {
            inputStream.read();
        }
        if (inputStream.read() != 142 || inputStream.read() != 173 || inputStream.read() != 232) {
            throw new IOException("Not a valid RPM file -- in signature's \"header structure header\".");
        }
        inputStream.read();
        this.read4();
        n2 = this.read4();
        n3 = this.read4();
        int n4 = 16 * n2 + n3 + 4;
        for (n = 0; n < n4; ++n) {
            inputStream.read();
        }
        if (inputStream.read() != 142 || inputStream.read() != 173 || inputStream.read() != 232) {
            throw new IOException("Not a valid RPM file -- in \"header structure header\".");
        }
        inputStream.read();
        this.read4();
        n = this.read4();
        n4 = this.read4();
        Index[] indexArray = new Index[n];
        for (int i = 0; i < n; ++i) {
            int n5 = this.read4();
            int n6 = this.read4();
            int n7 = this.read4();
            int n8 = this.read4();
            indexArray[i] = new Index(n5, n6, n7, n8);
        }
        byte[] byArray = new byte[n4];
        inputStream.read(byArray);
        this.is_ = new GZIPInputStream(this.is_);
    }

    private FSFileRPM readEntry() throws IOException {
        int n;
        int n2 = 0;
        while ((n = this.is_.read()) != 48 || (n = this.is_.read()) != 55 || (n = this.is_.read()) != 48 || (n = this.is_.read()) != 55 || (n = this.is_.read()) != 48 || (n = this.is_.read()) != 49) {
            ++n2;
        }
        System.out.println("skip = " + n2);
        n = this.readHex8();
        int n3 = this.readHex8();
        int n4 = this.readHex8();
        int n5 = this.readHex8();
        int n6 = this.readHex8();
        int n7 = this.readHex8();
        int n8 = this.readHex8();
        int n9 = this.readHex8();
        int n10 = this.readHex8();
        int n11 = this.readHex8();
        int n12 = this.readHex8();
        int n13 = this.readHex8();
        int n14 = this.readHex8();
        System.out.println("namesize=" + n13 + ", filesize=" + n8);
        StringBuffer stringBuffer = new StringBuffer(n13);
        int n15 = n13 - 1;
        for (int i = 0; i < n15; ++i) {
            stringBuffer.append((char)this.is_.read());
        }
        this.is_.read();
        String string = stringBuffer.toString();
        System.out.println("read " + string);
        if (string.equals(CPIO_END)) {
            return null;
        }
        for (n15 = 0; n15 < n8; ++n15) {
            this.is_.read();
        }
        n15 = 110 + n13 + n8;
        int n16 = n15 % 4;
        System.out.println("elen=" + n15 + ", /4=" + n15 / 4 * 4 + ", mod4=" + n15 % 4);
        int n17 = 4 - n16;
        for (int i = 0; i < n17; ++i) {
            this.is_.read();
        }
        return null;
    }

    public Iterator iterator() throws IOException {
        return null;
    }

    int read4() throws IOException {
        return ((this.is_.read() << 8 | this.is_.read()) << 8 | this.is_.read()) << 8 | this.is_.read();
    }

    int readoct6() throws IOException {
        int n = 0;
        for (int i = 0; i < 6; ++i) {
            n = (n << 3) + (this.is_.read() - 48);
        }
        return n;
    }

    int readHex8() throws IOException {
        int n = 0;
        for (int i = 0; i < 8; ++i) {
            int n2 = this.is_.read();
            n2 = n2 >= 48 && n2 <= 57 ? (n2 -= 48) : (n2 -= 87);
            n = (n << 4) + n2;
        }
        return n;
    }

    public void close() throws IOException {
    }

    public static void main(String[] stringArray) throws IOException {
        File file = Files.getFile("~/tmp/v/Multivalent.rpm");
        FileSystemRPM fileSystemRPM = new FileSystemRPM(file);
        fileSystemRPM.list();
    }

    class IteratorFSFileRPM
    implements Iterator {
        private FSFileRPM next_;

        public IteratorFSFileRPM() {
            try {
                this.next_ = FileSystemRPM.this.readEntry();
            }
            catch (IOException iOException) {
                this.next_ = null;
            }
        }

        public boolean hasNext() {
            return this.next_ != null;
        }

        public Object next() {
            FSFileRPM fSFileRPM = this.next_;
            if (fSFileRPM == null) {
                throw new NoSuchElementException();
            }
            try {
                this.next_ = FileSystemRPM.this.readEntry();
            }
            catch (IOException iOException) {
                this.next_ = null;
            }
            return fSFileRPM;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class Index {
        int tag;
        int type;
        int offset;
        int count;

        Index(int n, int n2, int n3, int n4) {
            this.tag = n;
            this.type = n2;
            this.offset = n3;
            this.count = n4;
        }
    }
}

