/*
 * Decompiled with CFR 0.152.
 */
package com.pt.awt.font;

import com.pt.awt.font.CMap;
import com.pt.awt.font.Encoding;
import com.pt.awt.font.GlyphRec;
import com.pt.awt.font.NFontSimple;
import com.pt.awt.font.NFontTrueType;
import com.pt.awt.font.NFontType1;
import com.pt.awt.font.OTkern;
import com.pt.awt.font.SfntDirectory;
import com.pt.lang.Mac;
import java.awt.Color;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.net.URL;
import phelps.util.Arrayss;

public class NFontOpenType
extends NFontTrueType
implements Cloneable {
    public static final String COPYRIGHT = "Copyright (c) 2003 - 2005  Thomas A. Phelps.  All rights reserved.";
    public static final String FORMAT = "OpenType";
    public static final String SUBFORMAT_CFF = "CFF";
    private static final int TAG_OTTO;
    private static final int TAG_MORX;
    private NFontType1 cff_;
    private boolean flayout_;
    private AffineTransform u_;
    private OTkern kern_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public NFontOpenType(URL uRL) throws FontFormatException, IOException {
        super(uRL);
    }

    public NFontOpenType(URL uRL, byte[] byArray) throws FontFormatException, IOException {
        super(uRL, byArray);
    }

    void parse() throws FontFormatException, IOException {
        this.flayout_ = false;
        this.kern_ = null;
        super.parse();
        if (TAG_OTTO == this.getID()) {
            if (!$assertionsDisabled && this.getTableDirectory(1735162214) != null) {
                throw new AssertionError();
            }
            SfntDirectory sfntDirectory = this.getTableDirectory(1128678944);
            this.cff_ = new NFontType1(this.getSource(), sfntDirectory.offset, sfntDirectory.length);
            this.cff_.widths_ = this.widths_;
            this.cff_ = this.cff_.deriveFont(Encoding.IDENTITY, CMap.IDENTITY);
        } else {
            this.cff_ = null;
        }
    }

    public NFontOpenType deriveFont(float f) {
        NFontOpenType nFontOpenType = (NFontOpenType)super.deriveFont(f);
        if (SUBFORMAT_CFF == this.getSubformat()) {
            nFontOpenType.cff_ = this.cff_.deriveFont(f);
        }
        return nFontOpenType;
    }

    public NFontOpenType deriveFont(AffineTransform affineTransform) {
        NFontOpenType nFontOpenType = (NFontOpenType)super.deriveFont(affineTransform);
        if (SUBFORMAT_CFF == this.getSubformat()) {
            nFontOpenType.cff_ = this.cff_.deriveFont(affineTransform);
        }
        return nFontOpenType;
    }

    public NFontOpenType deriveFont(int[] nArray, int n, int n2, int n3, int n4, Rectangle2D rectangle2D) {
        NFontOpenType nFontOpenType = (NFontOpenType)super.deriveFont(nArray, n, n2, n3, n4, rectangle2D);
        if (SUBFORMAT_CFF == this.getSubformat()) {
            nFontOpenType.cff_ = (NFontType1)this.cff_.deriveFont(nArray, n, n2, n3, n4, rectangle2D);
        }
        return nFontOpenType;
    }

    public String getFormat() {
        return FORMAT;
    }

    public String getSubformat() {
        return this.cff_ != null ? SUBFORMAT_CFF : super.getSubformat();
    }

    public boolean isHinted() {
        return SUBFORMAT_CFF == this.getSubformat() ? this.cff_.isHinted() : super.isHinted();
    }

    public int getNumGlyphs() {
        return SUBFORMAT_CFF == this.getSubformat() ? this.cff_.getNumGlyphs() : super.getNumGlyphs();
    }

    private void readLayoutTables() {
        if (this.flayout_) {
            return;
        }
        this.flayout_ = true;
        if (this == this.ur_) {
            this.readGSUBTable();
            this.kern_ = new OTkern(this);
            this.readGPOSTable();
            this.readGDEFTable();
        } else {
            NFontOpenType nFontOpenType = (NFontOpenType)this.ur_;
            nFontOpenType.readLayoutTables();
            this.kern_ = nFontOpenType.kern_;
        }
    }

    private void readGSUBTable() {
        int n;
        int n2;
        int n3;
        if (this.getTable(1196643650).length < 10) {
            return;
        }
        float f = this.readFixed();
        int n4 = this.readUint16();
        int n5 = this.readUint16();
        int n6 = this.readUint16();
        this.offset_ = n4;
        int n7 = this.readUint16();
        for (n3 = 0; n3 < n7; ++n3) {
            n2 = (int)this.readUint32();
            n = this.readUint16();
            System.out.println("script: " + Mac.strTag(n2) + " " + Integer.toHexString(n2) + " @ " + n);
        }
        this.offset_ = n5;
        n7 = this.readUint16();
        for (n3 = 0; n3 < n7; ++n3) {
            n2 = (int)this.readUint32();
            n = this.readUint16();
            System.out.println("feature: " + Mac.strTag(n2) + " " + Integer.toHexString(n2) + " @ " + n);
        }
    }

    private void readGPOSTable() {
    }

    private void readGDEFTable() {
    }

    private void readBASETable() {
    }

    private void readJSTFTable() {
    }

    private void readFeatTable() {
        if (this.getTable(1717920116).length < 10) {
            return;
        }
        float f = this.readFixed();
        int n = this.readUint16();
        this.offset_ += 6;
        for (int i = 0; i < n; ++i) {
            int n2 = this.offset_;
            int n3 = this.readUint16();
            int n4 = this.readUint16();
            int n5 = (int)this.readUint32();
            int n6 = this.readUint16();
            int n7 = this.readInt16();
        }
    }

    private void readMortTable() {
        if (this.getTable(1836020340).length < 6) {
            return;
        }
        float f = this.readFixed();
        int n = (int)this.readUint32();
        for (int i = 0; i < n; ++i) {
            int n2 = this.offset_;
            int n3 = (int)this.readUint32();
            int n4 = (int)this.readUint32();
            int n5 = this.readUint16();
            int n6 = this.readUint16();
            int n7 = n3;
            for (int j = 0; j < n5; ++j) {
                int n8 = this.readUint16();
                int n9 = this.readUint16();
                int n10 = (int)this.readUint32();
                int n11 = (int)this.readUint32();
                System.out.println("mort feature type = " + n8 + ", setting = " + n9);
            }
            this.offset_ = n2 + n4;
        }
    }

    private void readMorxTable() {
        if (this.getTable(TAG_MORX).length < 6) {
            return;
        }
    }

    GlyphRec getGlyphRec(int n) {
        return SUBFORMAT_CFF == this.getSubformat() ? this.cff_.getGlyphRec(n) : super.getGlyphRec(n);
    }

    private int[] estr2glyphs(String string, long l) {
        this.readLayoutTables();
        int n = string.length();
        int[] nArray = new int[n * 3];
        int n2 = 0;
        CMap cMap = this.c2g_;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            char c2 = cMap.toSelector(c);
            nArray[n2++] = c2;
        }
        if ((0x20L & l) != 0L) {
            // empty if block
        }
        return Arrayss.resize(nArray, n2);
    }

    private int[] gsub() {
        return null;
    }

    private int[] gpos() {
        return null;
    }

    public int getKern(int n, int n2) {
        return this.kern_ != null ? this.kern_.getKern(n, n2) : 0;
    }

    public void drawEstring(Graphics2D graphics2D, String string, float f, float f2, long l, int n, Color color) {
        if (3 == n) {
            return;
        }
        CMap cMap = this.c2g_;
        if (SUBFORMAT_CFF == this.getSubformat()) {
            this.cff_.drawEstring(graphics2D, cMap.toSelector(string), f, f2, l, n, color);
        } else {
            super.drawEstring(graphics2D, string, f, f2, l, n, color);
        }
    }

    public /* synthetic */ NFontTrueType deriveFont(AffineTransform affineTransform) {
        return this.deriveFont(affineTransform);
    }

    public /* synthetic */ NFontTrueType deriveFont(float f) {
        return this.deriveFont(f);
    }

    public /* synthetic */ NFontSimple deriveFont(int[] nArray, int n, int n2, int n3, int n4, Rectangle2D rectangle2D) {
        return this.deriveFont(nArray, n, n2, n3, n4, rectangle2D);
    }

    static {
        $assertionsDisabled = !NFontOpenType.class.desiredAssertionStatus();
        TAG_OTTO = Mac.intTag("OTTO");
        TAG_MORX = Mac.intTag("morx");
    }
}

