/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.CIHashtable;
import HTTPClient.GlobalConstants;
import HTTPClient.HTTPClientModule;
import HTTPClient.HTTPClientModuleConstants;
import HTTPClient.HttpOutputStream;
import HTTPClient.Log;
import HTTPClient.ModuleException;
import HTTPClient.ParseException;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.RetryException;
import HTTPClient.URI;
import HTTPClient.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import sun.net.ProgressData;
import sun.net.ProgressEntry;

public class HTTPResponse
implements GlobalConstants,
HTTPClientModuleConstants {
    private HTTPClientModule[] modules;
    private int timeout;
    private Request request;
    Response response;
    private HttpOutputStream out_stream;
    private InputStream inp_stream;
    private int StatusCode;
    private String ReasonLine;
    private String Version;
    private URI OriginalURI;
    private URI EffectiveURI;
    private CIHashtable Headers;
    private CIHashtable Trailers;
    private int ContentLength = -1;
    private byte[] Data;
    private boolean initialized = false;
    private boolean got_trailers = false;
    private boolean aborted = false;
    private boolean retry = false;
    private String method;
    private boolean handle_trailers = false;
    private boolean trailers_handled = false;
    ProgressEntry pe;

    HTTPResponse(HTTPClientModule[] hTTPClientModuleArray, int n, Request request) {
        this.modules = hTTPClientModuleArray;
        this.timeout = n;
        try {
            int n2 = request.getRequestURI().indexOf(63);
            this.OriginalURI = new URI(request.getConnection().getProtocol(), null, request.getConnection().getHost(), request.getConnection().getPort(), n2 < 0 ? request.getRequestURI() : request.getRequestURI().substring(0, n2), n2 < 0 ? null : request.getRequestURI().substring(n2 + 1), null);
        }
        catch (ParseException parseException) {}
        this.method = request.getMethod();
    }

    void set(Request request, Response response) {
        this.request = request;
        this.response = response;
        response.http_resp = this;
        response.timeout = this.timeout;
        this.aborted = response.final_resp;
    }

    void set(Request request, HttpOutputStream httpOutputStream) {
        this.request = request;
        this.out_stream = httpOutputStream;
    }

    public final int getStatusCode() throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        return this.StatusCode;
    }

    public final String getReasonLine() throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        return this.ReasonLine;
    }

    public final String getVersion() throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        return this.Version;
    }

    public final String getServer() throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        return this.getHeader("Server");
    }

    public final URI getOriginalURI() {
        return this.OriginalURI;
    }

    public final URL getEffectiveURL() throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        if (this.EffectiveURI != null) {
            return this.EffectiveURI.toURL();
        }
        return null;
    }

    public final URI getEffectiveURI() throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        if (this.EffectiveURI != null) {
            return this.EffectiveURI;
        }
        return this.OriginalURI;
    }

    public String getHeader(String string) throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        return (String)this.Headers.get(string.trim());
    }

    public int getHeaderAsInt(String string) throws IOException, ModuleException, NumberFormatException {
        String string2 = this.getHeader(string);
        if (string2 == null) {
            throw new NumberFormatException("null");
        }
        return Integer.parseInt(string2);
    }

    public Date getHeaderAsDate(String string) throws IOException, IllegalArgumentException, ModuleException {
        Date date;
        String string2 = this.getHeader(string);
        if (string2 == null) {
            return null;
        }
        if (string2.toUpperCase().indexOf("GMT") == -1 && string2.indexOf(32) > 0) {
            string2 = String.valueOf(string2) + " GMT";
        }
        try {
            date = Util.parseHttpDate(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            long l;
            try {
                l = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw illegalArgumentException;
            }
            if (l < 0L) {
                l = 0L;
            }
            date = new Date(l * 1000L);
        }
        return date;
    }

    public Enumeration listHeaders() throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        return this.Headers.keys();
    }

    public String getTrailer(String string) throws IOException, ModuleException {
        if (!this.got_trailers) {
            this.getTrailers();
        }
        return (String)this.Trailers.get(string.trim());
    }

    public int getTrailerAsInt(String string) throws IOException, ModuleException, NumberFormatException {
        String string2 = this.getTrailer(string);
        if (string2 == null) {
            throw new NumberFormatException("null");
        }
        return Integer.parseInt(string2);
    }

    public Date getTrailerAsDate(String string) throws IOException, IllegalArgumentException, ModuleException {
        Date date;
        String string2 = this.getTrailer(string);
        if (string2 == null) {
            return null;
        }
        if (string2.toUpperCase().indexOf("GMT") == -1 && string2.indexOf(32) > 0) {
            string2 = String.valueOf(string2) + " GMT";
        }
        try {
            date = Util.parseHttpDate(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            long l;
            try {
                l = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw illegalArgumentException;
            }
            if (l < 0L) {
                l = 0L;
            }
            date = new Date(l * 1000L);
        }
        return date;
    }

    public Enumeration listTrailers() throws IOException, ModuleException {
        if (!this.got_trailers) {
            this.getTrailers();
        }
        return this.Trailers.keys();
    }

    public synchronized byte[] getData() throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        if (this.Data == null) {
            try {
                this.readResponseData(this.inp_stream);
            }
            catch (InterruptedIOException interruptedIOException) {
                throw interruptedIOException;
            }
            catch (IOException iOException) {
                Log.write(2, "HResp: (\"" + this.method + " " + this.OriginalURI.getPathAndQuery() + "\")");
                Log.write(2, "       ", iOException);
                try {
                    this.inp_stream.close();
                }
                catch (Exception exception) {}
                throw iOException;
            }
            this.inp_stream.close();
        }
        return this.Data;
    }

    public synchronized InputStream getInputStream() throws IOException, ModuleException {
        if (!this.initialized) {
            this.handleResponse();
        }
        if (this.Data == null) {
            return this.inp_stream;
        }
        this.getData();
        return new ByteArrayInputStream(this.Data);
    }

    public boolean retryRequest() throws IOException, ModuleException {
        if (!this.initialized) {
            try {
                this.handleResponse();
            }
            catch (RetryException retryException) {
                this.retry = this.response.retry;
            }
        }
        return this.retry;
    }

    public String toString() {
        if (!this.initialized) {
            try {
                this.handleResponse();
            }
            catch (Exception exception) {
                if (!(exception instanceof InterruptedIOException)) {
                    Log.write(2, "HResp: (\"" + this.method + " " + this.OriginalURI.getPathAndQuery() + "\")");
                    Log.write(2, "       ", exception);
                }
                return "Failed to read headers: " + exception;
            }
        }
        String string = System.getProperty("line.separator", "\n");
        StringBuffer stringBuffer = new StringBuffer(this.Version);
        stringBuffer.append(' ');
        stringBuffer.append(this.StatusCode);
        stringBuffer.append(' ');
        stringBuffer.append(this.ReasonLine);
        stringBuffer.append(string);
        if (this.EffectiveURI != null) {
            stringBuffer.append("Effective-URI: ");
            stringBuffer.append(this.EffectiveURI);
            stringBuffer.append(string);
        }
        Enumeration enumeration = this.Headers.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            stringBuffer.append(string2);
            stringBuffer.append(": ");
            stringBuffer.append(this.Headers.get(string2));
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    HTTPClientModule[] getModules() {
        return this.modules;
    }

    /*
     * Exception decompiling
     */
    synchronized boolean handleResponse() throws IOException, ModuleException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void init(Response response) {
        if (this.initialized) {
            return;
        }
        this.StatusCode = response.StatusCode;
        this.ReasonLine = response.ReasonLine;
        this.Version = response.Version;
        this.EffectiveURI = response.EffectiveURI;
        this.ContentLength = response.ContentLength;
        this.Headers = response.Headers;
        this.inp_stream = response.inp_stream;
        this.Data = response.Data;
        this.retry = response.retry;
        this.initialized = true;
        try {
            if (this.pe != null && this.ContentLength != -1) {
                this.pe.setType(Util.getPath(this.request.getRequestURI()), this.getHeader("Content-type"));
                ProgressData.pdata.register(this.pe);
                this.pe.update(0, this.ContentLength);
                return;
            }
        }
        catch (Throwable throwable) {
            Log.write(2, "Resp: ", throwable);
        }
    }

    void invokeTrailerHandlers(boolean bl) throws IOException, ModuleException {
        if (this.trailers_handled) {
            return;
        }
        if (!bl && !this.initialized) {
            this.handle_trailers = true;
            return;
        }
        int n = 0;
        while (n < this.modules.length && !this.aborted) {
            this.modules[n].trailerHandler(this.response, this.request);
            ++n;
        }
        this.trailers_handled = true;
    }

    void setProgressEntry(ProgressEntry progressEntry) {
        this.pe = progressEntry;
    }

    void unsetProgressEntry() {
        if (this.pe != null) {
            try {
                ProgressData.pdata.unregister(this.pe);
            }
            catch (Throwable throwable) {}
            this.pe = null;
        }
    }

    void markAborted() {
        this.aborted = true;
    }

    private synchronized void getTrailers() throws IOException, ModuleException {
        if (this.got_trailers) {
            return;
        }
        if (!this.initialized) {
            this.handleResponse();
        }
        this.response.getTrailer("Any");
        this.Trailers = this.response.Trailers;
        this.got_trailers = true;
        this.invokeTrailerHandlers(false);
    }

    private void readResponseData(InputStream inputStream) throws IOException, ModuleException {
        if (this.ContentLength == 0) {
            return;
        }
        if (this.Data == null) {
            this.Data = new byte[0];
        }
        int n = this.Data.length;
        try {
            try {
                if (this.getHeader("Content-Length") != null) {
                    int n2 = 0;
                    this.Data = new byte[this.ContentLength];
                    while ((n2 = inputStream.read(this.Data, n += n2, this.ContentLength - n)) != -1 && n + n2 < this.ContentLength) {
                    }
                } else {
                    int n3 = 0;
                    do {
                        this.Data = Util.resizeArray(this.Data, (n += n3) + 1000);
                    } while ((n3 = inputStream.read(this.Data, n, 1000)) != -1);
                    this.Data = Util.resizeArray(this.Data, n);
                }
            }
            catch (IOException iOException) {
                this.Data = Util.resizeArray(this.Data, n);
                throw iOException;
            }
            Object var4_6 = null;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
    }

    int getTimeout() {
        return this.timeout;
    }
}

