/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.util;

import java.io.IOException;
import java.io.Reader;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SAXValidate
extends DefaultHandler
implements ErrorHandler {
    private boolean schemavalidate = false;
    public static final String DEFAULT_PARSER = "org.apache.xerces.parsers.SAXParser";

    public SAXValidate(boolean validateschema) {
        this.schemavalidate = validateschema;
    }

    public void error(SAXParseException exception) throws SAXException {
        throw exception;
    }

    public void warning(SAXParseException exception) throws SAXException {
        throw new SAXException("WARNING: " + exception.getMessage());
    }

    public void runTest(Reader xml) throws IOException, ClassNotFoundException, SAXException, SAXParseException {
        this.runTest(xml, DEFAULT_PARSER);
    }

    public void runTest(Reader xml, String parserName) throws IOException, ClassNotFoundException, SAXException, SAXParseException {
        this.runTest(xml, parserName, ".");
    }

    public void runTest(Reader xml, String parserName, String schemaLocation) throws IOException, ClassNotFoundException, SAXException, SAXParseException {
        XMLReader parser = parserName.equals("DEFAULT") ? XMLReaderFactory.createXMLReader(DEFAULT_PARSER) : XMLReaderFactory.createXMLReader(parserName);
        parser.setContentHandler(this);
        parser.setErrorHandler(this);
        parser.setFeature("http://xml.org/sax/features/namespaces", true);
        parser.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        parser.setFeature("http://xml.org/sax/features/validation", true);
        parser.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", schemaLocation);
        if (this.schemavalidate) {
            parser.setFeature("http://apache.org/xml/features/validation/schema", true);
        }
        parser.parse(new InputSource(xml));
    }
}

