/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.util;

import edu.ucsb.nceas.morpho.util.Log;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public class IOUtil {
    private IOUtil() {
    }

    public static StringBuffer getAsStringBuffer(Reader reader, boolean closeWhenFinished) throws IOException {
        if (reader == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        try {
            int numCharsRead;
            char[] buff = new char[4096];
            while ((numCharsRead = reader.read(buff, 0, buff.length)) != -1) {
                sb.append(buff, 0, numCharsRead);
            }
        }
        catch (IOException ioe) {
            Log.debug(12, "IOUtil.getAsStringBuffer(): Error reading Reader: " + ioe.getMessage());
            throw ioe;
        }
        finally {
            if (closeWhenFinished) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException ce) {
                    Log.debug(12, "IOUtil.getAsStringBuffer(): closing Reader: " + ce.getMessage());
                }
            }
        }
        return sb;
    }

    public static void writeToWriter(StringBuffer buffer, Writer writer, boolean closeWhenFinished) throws IOException {
        if (writer == null) {
            throw new IOException("IOUtil.writeToWriter(): Writer is NULL!");
        }
        char[] bufferChars = new char[buffer.length()];
        buffer.getChars(0, buffer.length(), bufferChars, 0);
        try {
            writer.write(bufferChars);
            writer.flush();
        }
        catch (IOException ioe) {
            Log.debug(12, "IOUtil.writeToWriter(): Error writing to Writer: " + ioe.getMessage());
            throw ioe;
        }
        finally {
            if (closeWhenFinished) {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException ce) {
                    Log.debug(12, "IOUtil.writeToWriter(): closing Writer: " + ce.getMessage());
                }
            }
        }
    }

    public static String getStringArrayAsString(String[] stringArray) {
        if (stringArray == null) {
            return "\n* * * RECEIVED NULL ARRAY! * * *";
        }
        if (stringArray.length < 1) {
            return "\n* * * RECEIVED EMPTY ARRAY! (length=0) * * *";
        }
        if (!(stringArray[0] instanceof String)) {
            return "\n* * * ARRAY DOES NOT CONTAIN STRINGS! * * *";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n---------------------------\n");
        for (int i = 0; i < stringArray.length; ++i) {
            buffer.append(" element[" + i + "] => ");
            buffer.append(stringArray[i]);
            buffer.append("\n");
        }
        buffer.append("---------------------------\n");
        return buffer.toString();
    }
}

