/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.util;

import edu.ucsb.nceas.morpho.util.GUIAction;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;

public class HyperlinkButton
extends JButton {
    private GUIAction action;
    private String originalTextLabel;
    private StringBuffer buff = new StringBuffer();
    private MouseAdapter mouseAdapter;

    public HyperlinkButton(GUIAction action) {
        super(action);
        this.action = action;
        this.originalTextLabel = action.getTextLabel();
        this.initButton();
        this.initRollover();
    }

    private void initButton() {
        this.styleText();
        this.setCursor(new Cursor(12));
        this.setFocusPainted(false);
        this.setBorderPainted(false);
        this.setContentAreaFilled(false);
        this.setRolloverEnabled(true);
        this.setHorizontalAlignment(2);
        this.setMargin(new Insets(0, 0, 0, 0));
    }

    private void initRollover() {
        this.styleRolloverText();
        this.setRolloverIcon(this.action.getRolloverSmallIcon());
        this.mouseAdapter = new MouseAdapter(){
            String upText;
            {
                this.upText = HyperlinkButton.this.action.getTextLabel();
            }

            public void mouseEntered(MouseEvent e) {
                this.upText = HyperlinkButton.this.getText();
                HyperlinkButton.this.setText(HyperlinkButton.this.action.getRolloverTextLabel());
            }

            public void mouseExited(MouseEvent e) {
                HyperlinkButton.this.setText(this.upText);
            }
        };
        this.addMouseListener(this.mouseAdapter);
    }

    private void styleText() {
        this.buff.delete(0, this.buff.length());
        this.buff.append("<html><p style=\"color: #0000d2; align: left; font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 9px;\">&nbsp;");
        this.buff.append(this.originalTextLabel);
        this.buff.append("</p></html>");
        this.action.setTextLabel(this.buff.toString());
        this.setText(this.action.getTextLabel());
    }

    private void styleRolloverText() {
        this.buff.delete(0, this.buff.length());
        this.buff.append("<html><a href=\"#\" style=\"color: #ee5500; font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 9px; align: left;\">&nbsp;");
        this.buff.append(this.originalTextLabel);
        this.buff.append("</a></html>");
        this.action.setRolloverTextLabel(this.buff.toString());
    }

    public void resetRollovers() {
        this.mouseAdapter.mouseExited(null);
    }
}

