/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.util;

import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.morpho.util.StateChangeEvent;
import edu.ucsb.nceas.morpho.util.StateChangeListener;
import edu.ucsb.nceas.morpho.util.StateChangeMonitor;
import java.awt.Component;
import java.awt.Container;
import java.awt.MenuComponent;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class GUIAction
extends AbstractAction
implements StateChangeListener {
    public static final int EVENT_LOCAL = 100;
    public static final int EVENT_GLOBAL = 200;
    private static final String ROLLOVER_SMALL_ICON = "rolloverSmallIcon";
    private static final String ROLLOVER_TEXT_LABEL = "rolloverTextLabel";
    private Command command;
    private Icon defaultIcon;
    private String menuName;
    private int menuPosition;
    private int toolbarPosition;
    private MappingsTable enabledList;
    private MappingsTable commandList;
    private GUIAction originalAction;

    public GUIAction(String name, Icon icon, Command cmd) {
        super(name, icon);
        Log.debug(50, "Creating GUIAction: " + name + " " + this.toString());
        this.defaultIcon = icon;
        this.command = cmd;
        this.menuPosition = -1;
        this.toolbarPosition = -1;
        this.setEnabled(true);
        this.enabledList = new MappingsTable();
        this.commandList = new MappingsTable();
    }

    public GUIAction cloneAction() {
        GUIAction clone = null;
        try {
            clone = (GUIAction)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            Log.debug(1, "Fatal error: cloning operation not supported.");
        }
        clone.setOriginalAction(this);
        clone.setTextLabel(this.getTextLabel());
        clone.setCommand(this.getCommand());
        clone.setDefaultIcon(this.getDefaultIcon());
        clone.setSmallIcon(this.getSmallIcon());
        clone.setEnabled(this.isEnabled());
        clone.setSeparatorPosition(this.getSeparatorPosition());
        clone.setMenu(this.getMenuName(), this.getMenuPosition());
        clone.setAcceleratorKey(this.getAcceleratorKey());
        clone.setRolloverSmallIcon(this.getRolloverSmallIcon());
        clone.setRolloverTextLabel(this.getRolloverTextLabel());
        Enumeration enabledKeys = this.enabledList.keys();
        while (enabledKeys.hasMoreElements()) {
            String key = (String)enabledKeys.nextElement();
            String changedState = new String(key);
            boolean enabled = (Boolean)this.enabledList.getNewState(key);
            clone.setEnabledOnStateChange(changedState, enabled, this.enabledList.getRespondsTo(key));
        }
        Enumeration commandKeys = this.commandList.keys();
        while (commandKeys.hasMoreElements()) {
            String key = (String)commandKeys.nextElement();
            String changedState = new String(key);
            Command command = (Command)this.commandList.getNewState(key);
            clone.setCommandOnStateChange(changedState, command, this.commandList.getRespondsTo(key));
        }
        return clone;
    }

    public void setTextLabel(String name) {
        super.putValue("Name", name);
    }

    public String getTextLabel() {
        return (String)super.getValue("Name");
    }

    public Icon getDefaultIcon() {
        return this.defaultIcon;
    }

    public void setDefaultIcon(Icon icon) {
        this.defaultIcon = icon;
    }

    public String getToolTipText() {
        return (String)super.getValue("ShortDescription");
    }

    public void setToolTipText(String toolTipText) {
        super.putValue("ShortDescription", toolTipText);
    }

    public void setRolloverSmallIcon(Icon rolloverSmallIcon) {
        super.putValue(ROLLOVER_SMALL_ICON, rolloverSmallIcon);
    }

    public Icon getRolloverSmallIcon() {
        return (Icon)super.getValue(ROLLOVER_SMALL_ICON);
    }

    public void setRolloverTextLabel(String rolloverTextLabel) {
        super.putValue(ROLLOVER_TEXT_LABEL, rolloverTextLabel);
    }

    public String getRolloverTextLabel() {
        return (String)super.getValue(ROLLOVER_TEXT_LABEL);
    }

    public void setSmallIcon(Icon smallIcon) {
        super.putValue("SmallIcon", smallIcon);
    }

    public Icon getSmallIcon() {
        return (Icon)super.getValue("SmallIcon");
    }

    public void setAcceleratorKeyString(String keyString) {
        if (keyString != null) {
            super.putValue("AcceleratorKey", KeyStroke.getKeyStroke(keyString));
        }
    }

    public KeyStroke getAcceleratorKey() {
        return (KeyStroke)super.getValue("AcceleratorKey");
    }

    public void setAcceleratorKey(KeyStroke key) {
        if (key != null) {
            super.putValue("AcceleratorKey", key);
        }
    }

    public void setSubMenu(boolean flag) {
        if (flag) {
            super.putValue("pull_right_menu", "yes");
        }
    }

    public void setSubMenuPath(String path) {
        super.putValue("menu_path", path);
    }

    public void setMenu(String menuName, int position) {
        this.menuName = menuName;
        this.menuPosition = position;
    }

    public String getMenuName() {
        return this.menuName;
    }

    public int getMenuPosition() {
        return this.menuPosition;
    }

    public void setMenuItemPosition(int position) {
        super.putValue("menuPosition", new Integer(position));
    }

    public int getMenuItemPosition() {
        Integer position = (Integer)super.getValue("menuPosition");
        int menuPos = position != null ? position : -1;
        return menuPos;
    }

    public void setSeparatorPosition(String position) {
        super.putValue("Default", position);
    }

    public String getSeparatorPosition() {
        String position = (String)super.getValue("Default");
        return position;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.command.execute(actionEvent);
    }

    public Command getCommand() {
        return this.command;
    }

    public void setCommand(Command cmd) {
        this.command = cmd;
    }

    public void setEnabledOnStateChange(String changedState, boolean enabled, int respondTo) {
        this.enabledList.put(changedState, new Boolean(enabled), respondTo);
        StateChangeMonitor.getInstance().addStateChangeListener(changedState, this);
    }

    public void setCommandOnStateChange(String changedState, Command command, int respondTo) {
        this.commandList.put(changedState, command, respondTo);
        StateChangeMonitor.getInstance().addStateChangeListener(changedState, this);
    }

    public void handleStateChange(StateChangeEvent event) {
        String changedState = event.getChangedState();
        if (this.enabledList.containsKey(changedState)) {
            if (this.enabledList.getRespondsTo(changedState) == 100 && !this.isLocalEvent(event)) {
                Log.debug(50, "GUIAction.handleStateChange: event in enabledList but not of this frame");
            } else {
                boolean enabled = (Boolean)this.enabledList.getNewState(changedState);
                this.setEnabled(enabled);
            }
        }
        if (this.commandList.containsKey(changedState)) {
            if (this.commandList.getRespondsTo(changedState) == 100 && !this.isLocalEvent(event)) {
                Log.debug(50, "GUIAction.handleStateChange: event in commandList but not of this frame");
            } else {
                Command newCommand = (Command)this.commandList.getNewState(changedState);
                this.setCommand(newCommand);
            }
        }
    }

    public int getToolbarPosition() {
        return this.toolbarPosition;
    }

    public void setToolbarPosition(int position) {
        this.toolbarPosition = position;
    }

    public GUIAction getOriginalAction() {
        return this.originalAction;
    }

    private void setOriginalAction(GUIAction action) {
        this.originalAction = action;
    }

    public static MorphoFrame getMorphoFrameAncestor(Component c) {
        Container parent = null;
        if (c instanceof MorphoFrame) {
            return (MorphoFrame)c;
        }
        parent = c.getParent();
        if (parent == null || parent instanceof MorphoFrame) {
            return (MorphoFrame)parent;
        }
        return GUIAction.getMorphoFrameAncestor(parent);
    }

    private boolean isLocalEvent(StateChangeEvent event) {
        Object source = event.getSource();
        if (source == null) {
            Log.debug(52, "GUIAction.isLocalEvent: got event with NULL source");
            return false;
        }
        MorphoFrame eventAncestor = null;
        if (source instanceof Component) {
            eventAncestor = GUIAction.getMorphoFrameAncestor((Component)source);
        } else if (source instanceof MenuComponent) {
            eventAncestor = GUIAction.getMorphoFrameAncestor((Component)((MenuComponent)source).getParent());
        } else {
            return false;
        }
        MorphoFrame thisAncestor = UIController.getMorphoFrameContainingGUIAction(this);
        Log.debug(52, "\n# # GUIAction.isLocalEvent: GUIAction name:: " + this.getTextLabel() + " thisAncestor=" + thisAncestor + " And!!!! event name: " + event.getChangedState() + " comparing eventAncestor=" + eventAncestor);
        Log.debug(52, "\n# # result = " + (eventAncestor == thisAncestor));
        return eventAncestor == thisAncestor;
    }

    class MappingsTable {
        private final int MAX_COLUMNS = 2;
        private Hashtable table = new Hashtable();

        public Object getNewState(String key) {
            return this.getColumn(key, 1);
        }

        public int getRespondsTo(String key) {
            return (Integer)this.getColumn(key, 2);
        }

        public void put(String key, Object newState, int respondsTo) {
            if (!this.table.containsKey(key)) {
                this.table.put(key, new Object[]{newState, new Integer(respondsTo)});
            }
        }

        MappingsTable() {
        }

        public Enumeration keys() {
            return this.table.keys();
        }

        public boolean containsKey(Object key) {
            return this.table.containsKey(key);
        }

        private Object getColumn(Object key, int colNum) {
            if (!this.table.containsKey(key)) {
                Log.debug(50, "MappingsTable: invalid key" + key);
                return null;
            }
            if (colNum > 2 || colNum < 1) {
                Log.debug(50, "MappingsTable: invalid colNum" + colNum);
                Log.debug(50, "(max allowed = 2)");
                return null;
            }
            return ((Object[])this.table.get(key))[colNum - 1];
        }

        public void put(Object key, Object[] params) {
            if (params.length > 2) {
                Log.debug(50, "MappingsTable: too many params: " + params.length);
                return;
            }
            if (params.length < 2) {
                Log.debug(50, "MappingsTable: insufficient params; padding out " + params.length);
                Object[] newArray = new Object[2];
                for (int i = 0; i < params.length; ++i) {
                    newArray[i] = params[i];
                }
                params = newArray;
            }
            this.table.put(key, params);
        }
    }
}

