/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.query;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.query.HeadResultSet;
import edu.ucsb.nceas.morpho.query.OpenDialogBox;
import edu.ucsb.nceas.morpho.query.Query;
import edu.ucsb.nceas.morpho.query.QueryDialog;
import edu.ucsb.nceas.morpho.query.ResultPanel;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.StateChangeEvent;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Vector;

public class SearchCommand
implements Command {
    private OpenDialogBox dialogBox = null;
    private Morpho morpho = null;

    public SearchCommand(OpenDialogBox myDialogBox, Morpho morpho) {
        this.dialogBox = myDialogBox;
        this.morpho = morpho;
    }

    public void execute(ActionEvent event) {
        MorphoFrame morphoFrame = null;
        if (this.dialogBox != null) {
            morphoFrame = this.dialogBox.getParentFrame();
            this.dialogBox.setVisible(false);
            this.dialogBox.dispose();
            this.dialogBox = null;
        } else {
            morphoFrame = UIController.getInstance().getCurrentActiveWindow();
        }
        if (morphoFrame != null) {
            Query query;
            QueryDialog queryDialog = new QueryDialog((Frame)morphoFrame, this.morpho);
            queryDialog.setModal(true);
            queryDialog.show();
            if (queryDialog.isSearchStarted() && (query = queryDialog.getQuery()) != null) {
                MorphoFrame box = UIController.getInstance().addWindow(query.getQueryTitle());
                SearchCommand.doQuery(box, query, true, 5, "decending", true);
            }
        }
    }

    public static void doQuery(MorphoFrame resultWindow, Query query, boolean sorted, int sortedIndex, String sortedOder, boolean sendEvent) {
        Morpho morphoInQuery = query.getMorpho();
        resultWindow.setVisible(true);
        Vector vector = new Vector();
        String source = "";
        HeadResultSet results = new HeadResultSet(query, source, vector, morphoInQuery);
        ResultPanel resultDisplayPanel = new ResultPanel(null, results, 12, null, resultWindow.getDefaultContentAreaSize());
        resultDisplayPanel.setVisible(true);
        resultWindow.setMainContentPane(resultDisplayPanel);
        boolean showSearchNumber = true;
        StateChangeEvent event = null;
        if (sendEvent) {
            event = new StateChangeEvent(resultDisplayPanel, StateChangeEvent.CREATE_SEARCH_RESULT_FRAME);
        }
        query.displaySearchResult(resultWindow, resultDisplayPanel, sorted, sortedIndex, sortedOder, showSearchNumber, event);
    }
}

