/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.query;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.framework.ConfigXML;
import edu.ucsb.nceas.morpho.query.ResultSet;
import edu.ucsb.nceas.morpho.query.SynchronizeVector;
import edu.ucsb.nceas.morpho.util.Log;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ResultsetHandler
implements ContentHandler,
Runnable {
    private Stack elementStack = null;
    private String[] headers;
    private String docid;
    private String docname;
    private String doctype;
    private String createdate;
    private String updatedate;
    private String paramName;
    private Hashtable params;
    private Morpho morpho;
    private Hashtable triple;
    private Vector tripleList;
    private Vector returnFields;
    private String accumulatedCharacters = null;
    private boolean isLocal = false;
    private boolean isMetacat = false;
    private SynchronizeVector resultsVector;
    private InputStream resultsXMLStream;
    private String source;
    private boolean isdone = false;

    public ResultsetHandler(InputStream resultsXMLStream, SynchronizeVector resultsVector, Morpho morpho, String source) {
        if (resultsXMLStream == null) {
            this.isdone = true;
        }
        this.resultsXMLStream = resultsXMLStream;
        this.resultsVector = resultsVector;
        this.morpho = morpho;
        this.source = source;
        this.init();
    }

    public ResultsetHandler(Morpho morpho, String source) {
        this.resultsVector = new SynchronizeVector();
        this.morpho = morpho;
        this.source = source;
        this.init();
    }

    private void init() {
        ResultsetHandler resultsetHandler = this;
        ConfigXML config = resultsetHandler.morpho.getConfiguration();
        this.returnFields = config.get("returnfield");
        if (this.source.equals("local")) {
            this.isLocal = true;
            this.isMetacat = false;
        } else if (this.source.equals("metacat")) {
            this.isLocal = false;
            this.isMetacat = true;
        }
    }

    public void run() {
        XMLReader parser = null;
        if (!this.isdone) {
            try {
                parser = Morpho.createSaxParser(this, null);
                Log.debug(30, "(2.43) Creating result set ...");
                parser.parse(new InputSource(new InputStreamReader(this.resultsXMLStream)));
                Log.debug(30, "(2.44) Creating result set ...");
            }
            catch (Exception e) {
                this.isdone = true;
                Log.debug(30, "(2.431) Exception creating result set ...");
                Log.debug(6, "(2.432) " + e.toString());
                Log.debug(30, "(2.433) Exception is: " + e.getClass().getName());
            }
        }
    }

    public SynchronizeVector getSynchronizeVector() {
        return this.resultsVector;
    }

    public boolean isDone() {
        return this.isdone && this.resultsVector.isEmpty();
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.paramName = localName.equalsIgnoreCase("param") ? atts.getValue("name") : null;
        this.elementStack.push(localName);
        if (localName.equals("document")) {
            this.docid = "";
            this.docname = "";
            this.doctype = "";
            this.createdate = "";
            this.updatedate = "";
            this.paramName = "";
            this.params = new Hashtable();
            this.tripleList = new Vector();
        } else if (localName.equals("triple")) {
            this.triple = new Hashtable();
        }
        this.accumulatedCharacters = "";
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.setRSValues(localName);
        if (localName.equals("triple")) {
            this.tripleList.addElement(this.triple);
        } else if (localName.equals("document")) {
            int cnt = 0;
            if (this.returnFields != null) {
                cnt = this.returnFields.size();
                cnt = 3;
            }
            Vector<Object> row = new Vector<Object>();
            boolean hasData = false;
            Enumeration tripleEnum = this.tripleList.elements();
            while (tripleEnum.hasMoreElements()) {
                String rel;
                Hashtable currentTriple = (Hashtable)tripleEnum.nextElement();
                if (!currentTriple.containsKey("relationship") || (rel = (String)currentTriple.get("relationship")).indexOf("isDataFileFor") == -1) continue;
                hasData = true;
            }
            if (this.params.containsKey("entityName")) {
                hasData = true;
            }
            if (hasData) {
                row.addElement(ResultSet.packageDataIcon);
            } else {
                row.addElement(ResultSet.packageIcon);
            }
            for (int i = 0; i < cnt; ++i) {
                row.addElement((String)this.params.get(this.returnFields.elementAt(i)));
            }
            row.addElement(this.createdate);
            row.addElement(this.updatedate);
            row.addElement(this.docid);
            row.addElement(this.docname);
            row.addElement(this.doctype);
            row.addElement(new Boolean(this.isLocal));
            row.addElement(new Boolean(this.isMetacat));
            row.addElement(this.tripleList);
            this.resultsVector.addVector(row);
        }
        String leaving = (String)this.elementStack.pop();
    }

    public void characters(char[] ch, int start, int length) {
        String inputString = new String(ch, start, length);
        this.accumulatedCharacters = this.accumulatedCharacters + inputString;
    }

    private void setRSValues(String currentTag) {
        String inputString = this.accumulatedCharacters.trim();
        if (currentTag.equals("docid")) {
            this.docid = inputString;
        } else if (currentTag.equals("docname")) {
            this.docname = inputString;
        } else if (currentTag.equals("doctype")) {
            this.doctype = inputString;
        } else if (currentTag.equals("createdate")) {
            this.createdate = inputString;
        } else if (currentTag.equals("updatedate")) {
            this.updatedate = inputString;
        } else if (currentTag.equals("param")) {
            String val = inputString;
            if (this.params.containsKey(this.paramName)) {
                String cur = (String)this.params.get(this.paramName);
                val = cur + " " + val;
            }
            this.params.put(this.paramName, val);
        } else if (currentTag.equals("subject")) {
            this.triple.put("subject", inputString);
        } else if (currentTag.equals("subjectdoctype")) {
            this.triple.put("subjectdoctype", inputString);
        } else if (currentTag.equals("relationship")) {
            this.triple.put("relationship", inputString);
        } else if (currentTag.equals("object")) {
            this.triple.put("object", inputString);
        } else if (currentTag.equals("objectdoctype")) {
            this.triple.put("objectdoctype", inputString);
        }
    }

    public void startDocument() throws SAXException {
        this.elementStack = new Stack();
    }

    public void endDocument() throws SAXException {
        this.isdone = true;
    }

    public void ignorableWhitespace(char[] cbuf, int start, int len) {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }
}

