/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.query;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.framework.ConnectionListener;
import edu.ucsb.nceas.morpho.framework.QueryRefreshInterface;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.PluginInterface;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceExistsException;
import edu.ucsb.nceas.morpho.plugins.ServiceProvider;
import edu.ucsb.nceas.morpho.query.HeadResultSet;
import edu.ucsb.nceas.morpho.query.LocalQuery;
import edu.ucsb.nceas.morpho.query.OpenDeleteDialogCommand;
import edu.ucsb.nceas.morpho.query.OpenDialogBoxCommand;
import edu.ucsb.nceas.morpho.query.OpenExportDialogCommand;
import edu.ucsb.nceas.morpho.query.OpenPreviousVersionCommand;
import edu.ucsb.nceas.morpho.query.OpenSynchronizeDialogCommand;
import edu.ucsb.nceas.morpho.query.Query;
import edu.ucsb.nceas.morpho.query.RefreshCommand;
import edu.ucsb.nceas.morpho.query.ReviseSearchCommand;
import edu.ucsb.nceas.morpho.query.SaveQueryCommand;
import edu.ucsb.nceas.morpho.query.SearchCommand;
import edu.ucsb.nceas.morpho.util.ColumnSortableTableModel;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.GUIAction;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.morpho.util.StateChangeEvent;
import edu.ucsb.nceas.morpho.util.UISettings;
import java.util.Vector;
import javax.swing.ImageIcon;

public class QueryPlugin
implements PluginInterface,
ConnectionListener,
ServiceProvider,
QueryRefreshInterface {
    private static Morpho morpho = null;

    public void initialize(Morpho morpho) {
        QueryPlugin.morpho = morpho;
        this.initializeActions();
        try {
            ServiceController services = ServiceController.getInstance();
            services.addService(QueryRefreshInterface.class, this);
            Log.debug(20, "Service added: QueryRefreshInterface.");
        }
        catch (ServiceExistsException see) {
            Log.debug(6, "Service registration failed: QueryRefreshInterface.");
            Log.debug(6, see.toString());
        }
        morpho.addConnectionListener(this);
    }

    private void initializeActions() {
        UIController controller = UIController.getInstance();
        GUIAction searchItemAction = new GUIAction("Search...", UISettings.SEARCH_ICON, new SearchCommand(null, morpho));
        searchItemAction.setToolTipText("Search for data");
        searchItemAction.setMenuItemPosition(0);
        searchItemAction.setMenu("Search", 2);
        searchItemAction.setToolbarPosition(4);
        controller.addGuiAction(searchItemAction);
        RefreshCommand refreshCommand = new RefreshCommand();
        GUIAction refreshItemAction = new GUIAction("Refresh", UISettings.REFRESH_ICON, refreshCommand);
        refreshItemAction.setToolTipText("Refresh...");
        refreshItemAction.setMenuItemPosition(1);
        refreshItemAction.setMenu("Search", 2);
        refreshItemAction.setToolbarPosition(5);
        refreshItemAction.setEnabled(false);
        refreshItemAction.setEnabledOnStateChange(StateChangeEvent.CREATE_SEARCH_RESULT_FRAME, true, 100);
        refreshItemAction.setEnabledOnStateChange(StateChangeEvent.CREATE_DATAPACKAGE_FRAME, false, 100);
        controller.addGuiAction(refreshItemAction);
        SaveQueryCommand saveCommand = new SaveQueryCommand(morpho);
        GUIAction saveQueryItemAction = new GUIAction("Save Search", UISettings.SAVE_QUERY_ICON, saveCommand);
        saveQueryItemAction.setToolTipText("Save search");
        saveQueryItemAction.setMenuItemPosition(2);
        saveQueryItemAction.setMenu("Search", 2);
        saveQueryItemAction.setToolbarPosition(6);
        saveQueryItemAction.setEnabled(false);
        saveQueryItemAction.setEnabledOnStateChange(StateChangeEvent.CREATE_SEARCH_RESULT_FRAME, true, 100);
        saveQueryItemAction.setEnabledOnStateChange(StateChangeEvent.CREATE_DATAPACKAGE_FRAME, false, 100);
        controller.addGuiAction(saveQueryItemAction);
        GUIAction reviseSearchItemAction = new GUIAction("Revise Search", null, new ReviseSearchCommand(morpho));
        reviseSearchItemAction.setSmallIcon(new ImageIcon(this.getClass().getResource("revisesearch16.gif")));
        reviseSearchItemAction.setToolTipText("Revise search");
        reviseSearchItemAction.setMenuItemPosition(3);
        reviseSearchItemAction.setSeparatorPosition(Morpho.SEPARATOR_FOLLOWING);
        reviseSearchItemAction.setMenu("Search", 2);
        reviseSearchItemAction.setToolbarPosition(7);
        reviseSearchItemAction.setEnabled(false);
        reviseSearchItemAction.setEnabledOnStateChange(StateChangeEvent.CREATE_SEARCH_RESULT_FRAME, true, 100);
        reviseSearchItemAction.setEnabledOnStateChange(StateChangeEvent.CREATE_DATAPACKAGE_FRAME, false, 100);
        controller.addGuiAction(reviseSearchItemAction);
        saveCommand.loadSavedQueries();
        GUIAction openDialogBoxAction = new GUIAction("Open...", UISettings.OPEN_DATAPACKAGE_ICON, new OpenDialogBoxCommand(morpho));
        openDialogBoxAction.setMenuItemPosition(2);
        openDialogBoxAction.setToolTipText("Open...");
        openDialogBoxAction.setMenu("File", 0);
        openDialogBoxAction.setToolbarPosition(1);
        controller.addGuiAction(openDialogBoxAction);
        GUIAction openPreviousAction = new GUIAction("Open Previous Version", null, new OpenPreviousVersionCommand(null, morpho));
        openPreviousAction.setMenuItemPosition(3);
        openPreviousAction.setToolTipText("Open a previous version...");
        openPreviousAction.setMenu("File", 0);
        openPreviousAction.setEnabledOnStateChange(StateChangeEvent.CREATE_DATAPACKAGE_FRAME_VERSIONS, true, 100);
        openPreviousAction.setEnabledOnStateChange(StateChangeEvent.SEARCH_RESULT_SELECTED_VERSIONS, true, 100);
        openPreviousAction.setEnabledOnStateChange(StateChangeEvent.CREATE_DATAPACKAGE_FRAME_NO_VERSIONS, false, 100);
        openPreviousAction.setEnabledOnStateChange(StateChangeEvent.SEARCH_RESULT_SELECTED_NO_VERSIONS, false, 100);
        openPreviousAction.setEnabledOnStateChange(StateChangeEvent.SEARCH_RESULT_NONSELECTED, false, 100);
        openPreviousAction.setEnabled(false);
        controller.addGuiAction(openPreviousAction);
        GUIAction synchronizeAction = new GUIAction("Synchronize...", null, new OpenSynchronizeDialogCommand());
        synchronizeAction.setMenuItemPosition(13);
        synchronizeAction.setToolTipText("Synchronize...");
        synchronizeAction.setSeparatorPosition(Morpho.SEPARATOR_FOLLOWING);
        synchronizeAction.setMenu("File", 0);
        synchronizeAction.setEnabledOnStateChange(StateChangeEvent.CREATE_DATAPACKAGE_FRAME_UNSYNCHRONIZED, true, 100);
        synchronizeAction.setEnabledOnStateChange(StateChangeEvent.SEARCH_RESULT_SELECTED_UNSYNCHRONIZED, true, 100);
        synchronizeAction.setEnabledOnStateChange(StateChangeEvent.CREATE_DATAPACKAGE_FRAME_SYNCHRONIZED, false, 100);
        synchronizeAction.setEnabledOnStateChange(StateChangeEvent.SEARCH_RESULT_SELECTED_SYNCHRONIZED, false, 100);
        synchronizeAction.setEnabledOnStateChange(StateChangeEvent.SEARCH_RESULT_NONSELECTED, false, 100);
        synchronizeAction.setEnabled(false);
        controller.addGuiAction(synchronizeAction);
        GUIAction deleteDialogAction = new GUIAction("Delete...", null, new OpenDeleteDialogCommand());
        deleteDialogAction.setMenuItemPosition(13);
        deleteDialogAction.setToolTipText("Delete...");
        deleteDialogAction.setSeparatorPosition(Morpho.SEPARATOR_FOLLOWING);
        deleteDialogAction.setEnabledOnStateChange(StateChangeEvent.CREATE_DATAPACKAGE_FRAME, true, 100);
        deleteDialogAction.setEnabledOnStateChange(StateChangeEvent.SEARCH_RESULT_SELECTED, true, 100);
        deleteDialogAction.setEnabledOnStateChange(StateChangeEvent.SEARCH_RESULT_NONSELECTED, false, 100);
        deleteDialogAction.setEnabled(false);
        deleteDialogAction.setMenu("File", 0);
        controller.addGuiAction(deleteDialogAction);
        GUIAction exportAction = new GUIAction("Export...", null, new OpenExportDialogCommand());
        exportAction.setMenuItemPosition(16);
        exportAction.setToolTipText("Export data package...");
        exportAction.setMenu("File", 0);
        exportAction.setEnabledOnStateChange(StateChangeEvent.CREATE_DATAPACKAGE_FRAME, true, 100);
        exportAction.setEnabledOnStateChange(StateChangeEvent.SEARCH_RESULT_SELECTED, true, 100);
        exportAction.setEnabledOnStateChange(StateChangeEvent.SEARCH_RESULT_NONSELECTED, false, 100);
        exportAction.setEnabled(false);
        controller.addGuiAction(exportAction);
    }

    public void usernameChanged(String newUsername) {
        Log.debug(20, "New username: " + newUsername);
        this.refresh();
    }

    public void connectionChanged(boolean connected) {
        Log.debug(20, "Connection changed: " + new Boolean(connected).toString());
        this.refresh();
    }

    public void refresh() {
        RefreshCommand refresh = new RefreshCommand();
        refresh.execute(null);
    }

    public void updateSavedQueryMenuItems(Morpho newMorpho) {
        SaveQueryCommand.loadSavedQueries(newMorpho);
    }

    public Command getCommandObject(int commandIdentifier) throws ClassNotFoundException {
        switch (commandIdentifier) {
            case 20: {
                return new OpenDialogBoxCommand(morpho);
            }
            case 30: {
                return new SearchCommand(null, morpho);
            }
        }
        ClassNotFoundException e = new ClassNotFoundException("command with ID=" + commandIdentifier + " not found");
        e.fillInStackTrace();
        throw e;
    }

    public ColumnSortableTableModel doOwnerQueryForCurrentUser(String[] headNames, String deletedDocid) {
        OpenDialogBoxCommand odbCmd = new OpenDialogBoxCommand(morpho);
        Query ownerQuery = new Query(odbCmd.getOwnerQuery(), morpho);
        LocalQuery localOwnerQuery = new LocalQuery(ownerQuery, morpho);
        HeadResultSet originalSet = (HeadResultSet)localOwnerQuery.execute();
        Vector results = originalSet.getResultsVector();
        Vector newResults = new Vector();
        if (deletedDocid != null && !deletedDocid.equals("")) {
            for (int i = 0; i < results.size(); ++i) {
                Vector rowVector = (Vector)results.elementAt(i);
                String docid = (String)rowVector.elementAt(6);
                if (docid != null && docid.equals(deletedDocid)) continue;
                newResults.add(rowVector);
            }
        } else {
            newResults = results;
        }
        originalSet.setResultsVector(newResults);
        originalSet.setHeader(headNames);
        return originalSet;
    }
}

