/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.query;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.framework.ConfigXML;
import edu.ucsb.nceas.morpho.query.LiveMapPanel;
import edu.ucsb.nceas.morpho.query.Query;
import edu.ucsb.nceas.morpho.query.QueryGroup;
import edu.ucsb.nceas.morpho.query.QueryTerm;
import edu.ucsb.nceas.morpho.query.SubjectTermPanel;
import edu.ucsb.nceas.morpho.query.TaxonTermPanel;
import edu.ucsb.nceas.morpho.util.Log;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class QueryDialog
extends JDialog {
    private Morpho morpho = null;
    private ConfigXML config = null;
    Vector textPanels;
    Vector taxonPanels;
    boolean caseSensitive = false;
    boolean includeSynonyms = false;
    String titleSearchPath = "title";
    String abstractSearchPath = "abstract";
    String keywordSearchPath = "keyword";
    String taxonRankSearchPath = "taxonomicClassification/taxonRankName";
    String taxonValueSearchPath = "taxonomicClassification/taxonRankValue";
    String northBCSearchPath = "northBoundingCoordinate";
    String westBCSearchPath = "westBoundingCoordinate";
    String southBCSearchPath = "southBoundingCoordinate";
    String eastBCSearchPath = "eastBoundingCoordinate";
    private boolean searchMetacat = true;
    private boolean searchLocal = true;
    private Query savedQuery;
    private boolean searchStarted = false;
    private static int untitledCounter = 0;
    boolean buildSubject = false;
    boolean buildTaxon = false;
    boolean buildSpatial = false;
    LiveMapPanel liveMap = null;
    private JTabbedPane queryTabs = new JTabbedPane();
    private JPanel subjectPanel = new JPanel();
    private JPanel queryChoicesPanel = new JPanel();
    private JRadioButton andRadioButton = new JRadioButton();
    private JRadioButton orRadioButton = new JRadioButton();
    private JButton moreButton = new JButton();
    private JButton lessButton = new JButton();
    private JPanel taxonPanel = new JPanel();
    private JPanel taxonChoicesPanel = new JPanel();
    private JRadioButton taxonAndRadioButton = new JRadioButton();
    private JRadioButton taxonOrRadioButton = new JRadioButton();
    private JButton taxonMoreButton = new JButton();
    private JButton taxonLessButton = new JButton();
    private JPanel spatialPanel = new JPanel();
    private JTextField queryTitleTF = new JTextField(20);
    private JCheckBox allTabsCheckBox = new JCheckBox();
    private JCheckBox catalogSearchCheckBox = new JCheckBox();
    private JCheckBox localSearchCheckBox = new JCheckBox();
    private JButton executeButton = new JButton();
    private JButton cancelButton = new JButton();
    private JPanel queryOptionsPanel = new JPanel();
    private JCheckBox caseSensitiveCheckBox = new JCheckBox("Case sensitive match");
    private JCheckBox includeItisSynonymsCheckBox = new JCheckBox("Include taxon synonyms from ITIS in query");
    private JButton saveDefaultsButton = new JButton();
    KeyPressActionListener keyPressListener = new KeyPressActionListener();

    public QueryDialog(Frame parent, Morpho morpho) {
        super(parent);
        this.morpho = morpho;
        this.config = Morpho.getConfiguration();
        String temp = this.config.get("titleSearchPath", 0);
        if (temp != null) {
            this.titleSearchPath = temp;
        }
        if ((temp = this.config.get("abstractSearchPath", 0)) != null) {
            this.abstractSearchPath = temp;
        }
        if ((temp = this.config.get("keywordSearchPath", 0)) != null) {
            this.keywordSearchPath = temp;
        }
        if ((temp = this.config.get("northBCSearchPath", 0)) != null) {
            this.northBCSearchPath = temp;
        }
        if ((temp = this.config.get("westBCSearchPath", 0)) != null) {
            this.westBCSearchPath = temp;
        }
        if ((temp = this.config.get("southBCSearchPath", 0)) != null) {
            this.southBCSearchPath = temp;
        }
        if ((temp = this.config.get("eastBCSearchPath", 0)) != null) {
            this.eastBCSearchPath = temp;
        }
        if ((temp = this.config.get("taxonValueSearchPath", 0)) != null) {
            this.taxonValueSearchPath = temp;
        }
        if ((temp = this.config.get("taxonRankSearchPath", 0)) != null) {
            this.taxonRankSearchPath = temp;
        }
        ConfigXML profile = morpho.getProfile();
        String searchMetacatString = profile.get("searchmetacat", 0);
        this.searchMetacat = new Boolean(searchMetacatString);
        String searchLocalString = profile.get("searchlocal", 0);
        this.searchLocal = new Boolean(searchLocalString);
        if (!this.searchMetacat) {
            this.searchLocal = true;
        }
        ++untitledCounter;
        this.textPanels = new Vector();
        this.taxonPanels = new Vector();
        this.setTitle("Search");
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        int parentWidth = parent.getWidth();
        int parentHeight = parent.getHeight();
        int dialogWidth = 650;
        int dialogHeight = 390;
        this.setSize(dialogWidth, dialogHeight);
        double parentX = parent.getLocation().getX();
        double parentY = parent.getLocation().getY();
        double centerX = parentX + 0.5 * (double)parentWidth;
        double centerY = parentY + 0.5 * (double)parentHeight;
        int dialogX = new Double(centerX - 0.5 * (double)dialogWidth).intValue();
        int dialogY = new Double(centerY - 0.5 * (double)dialogHeight).intValue();
        this.setLocation(dialogX, dialogY);
        this.setVisible(false);
        JPanel queryPanel = new JPanel();
        queryPanel.setLayout(new BoxLayout(queryPanel, 1));
        this.getContentPane().add("Center", queryPanel);
        queryPanel.add(Box.createVerticalStrut(8));
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BoxLayout(titlePanel, 0));
        titlePanel.add(Box.createHorizontalStrut(8));
        JLabel queryTitleLabel = new JLabel();
        queryTitleLabel.setText("Query Title ");
        titlePanel.add(queryTitleLabel);
        titlePanel.add(Box.createHorizontalStrut(8));
        this.queryTitleTF.setText("Untitled-Search-" + untitledCounter);
        JPanel queryTitleConstraintPanel = new JPanel(){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, 24);
            }

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        queryTitleConstraintPanel.add(this.queryTitleTF);
        titlePanel.add(queryTitleConstraintPanel);
        titlePanel.add(Box.createHorizontalStrut(8));
        titlePanel.add(Box.createHorizontalGlue());
        JPanel searchChoicePanel = new JPanel();
        searchChoicePanel.setLayout(new FlowLayout(1, 5, 5));
        this.catalogSearchCheckBox.setText("Network Search");
        this.catalogSearchCheckBox.setActionCommand("Network Search");
        this.catalogSearchCheckBox.setSelected(this.searchMetacat);
        searchChoicePanel.add(this.catalogSearchCheckBox);
        this.localSearchCheckBox.setText("Local Search");
        this.localSearchCheckBox.setActionCommand("Local Search");
        this.localSearchCheckBox.setSelected(this.searchLocal);
        searchChoicePanel.add(this.localSearchCheckBox);
        titlePanel.add(searchChoicePanel);
        titlePanel.add(Box.createHorizontalStrut(8));
        queryPanel.add(titlePanel);
        queryPanel.add(Box.createVerticalStrut(8));
        queryPanel.add(this.queryTabs);
        this.subjectPanel.setLayout(new BorderLayout(0, 0));
        this.subjectPanel.setVisible(false);
        JScrollPane queryScrollPanel = new JScrollPane();
        queryScrollPanel.setOpaque(true);
        queryScrollPanel.setPreferredSize(new Dimension(queryScrollPanel.getPreferredSize().width, 500));
        this.subjectPanel.add("Center", queryScrollPanel);
        this.queryChoicesPanel.setLayout(new BoxLayout(this.queryChoicesPanel, 1));
        this.queryChoicesPanel.setAlignmentX(0.0f);
        SubjectTermPanel tqt1 = new SubjectTermPanel(this.keyPressListener);
        this.textPanels.addElement(tqt1);
        this.queryChoicesPanel.add(tqt1);
        queryScrollPanel.getViewport().add(this.queryChoicesPanel);
        JPanel subjectMoreLessPanel = new JPanel();
        subjectMoreLessPanel.setLayout(new BoxLayout(subjectMoreLessPanel, 0));
        subjectMoreLessPanel.add(Box.createHorizontalStrut(8));
        this.andRadioButton.setText("And");
        this.andRadioButton.setActionCommand("And");
        subjectMoreLessPanel.add(this.andRadioButton);
        this.orRadioButton.setText("Or");
        this.orRadioButton.setActionCommand("Or");
        this.orRadioButton.setSelected(true);
        ButtonGroup subjectRadioGroup = new ButtonGroup();
        subjectRadioGroup.add(this.andRadioButton);
        subjectRadioGroup.add(this.orRadioButton);
        subjectMoreLessPanel.add(this.orRadioButton);
        subjectMoreLessPanel.add(Box.createHorizontalStrut(8));
        this.moreButton.setText("More");
        this.moreButton.setActionCommand("More");
        subjectMoreLessPanel.add(this.moreButton);
        this.lessButton.setText("Fewer");
        this.lessButton.setActionCommand("Fewer");
        this.lessButton.setEnabled(false);
        subjectMoreLessPanel.add(this.lessButton);
        subjectMoreLessPanel.add(Box.createHorizontalGlue());
        subjectMoreLessPanel.add(Box.createHorizontalStrut(8));
        this.subjectPanel.add("South", subjectMoreLessPanel);
        this.queryTabs.add(this.subjectPanel);
        this.taxonPanel.setLayout(new BorderLayout(0, 0));
        this.taxonPanel.setVisible(false);
        JScrollPane taxonScrollPanel = new JScrollPane();
        taxonScrollPanel.setOpaque(true);
        taxonScrollPanel.setPreferredSize(new Dimension(taxonScrollPanel.getPreferredSize().width, 500));
        this.taxonPanel.add("Center", taxonScrollPanel);
        this.taxonChoicesPanel.setLayout(new BoxLayout(this.taxonChoicesPanel, 1));
        this.taxonChoicesPanel.setAlignmentX(0.0f);
        TaxonTermPanel taxonTerm = new TaxonTermPanel(this.keyPressListener);
        this.taxonPanels.addElement(taxonTerm);
        this.taxonChoicesPanel.add(taxonTerm);
        taxonScrollPanel.getViewport().add(this.taxonChoicesPanel);
        JPanel taxonMoreLessPanel = new JPanel();
        taxonMoreLessPanel.setLayout(new BoxLayout(taxonMoreLessPanel, 0));
        taxonMoreLessPanel.add(Box.createHorizontalStrut(8));
        this.taxonAndRadioButton.setText("And");
        this.taxonAndRadioButton.setActionCommand("And");
        taxonMoreLessPanel.add(this.taxonAndRadioButton);
        this.taxonOrRadioButton.setText("Or");
        this.taxonOrRadioButton.setActionCommand("Or");
        this.taxonOrRadioButton.setSelected(true);
        ButtonGroup taxonRadioGroup = new ButtonGroup();
        taxonRadioGroup.add(this.taxonAndRadioButton);
        taxonRadioGroup.add(this.taxonOrRadioButton);
        taxonMoreLessPanel.add(this.taxonOrRadioButton);
        taxonMoreLessPanel.add(Box.createHorizontalStrut(8));
        this.taxonMoreButton.setText("More");
        this.taxonMoreButton.setActionCommand("More");
        taxonMoreLessPanel.add(this.taxonMoreButton);
        this.taxonLessButton.setText("Fewer");
        this.taxonLessButton.setActionCommand("Fewer");
        this.taxonLessButton.setEnabled(false);
        taxonMoreLessPanel.add(this.taxonLessButton);
        taxonMoreLessPanel.add(Box.createHorizontalGlue());
        taxonMoreLessPanel.add(Box.createHorizontalStrut(8));
        this.taxonPanel.add("South", taxonMoreLessPanel);
        this.queryTabs.add(this.taxonPanel);
        this.spatialPanel.setLayout(new FlowLayout(1, 5, 5));
        this.spatialPanel.setVisible(false);
        this.liveMap = new LiveMapPanel();
        this.spatialPanel.add(this.liveMap);
        this.queryTabs.add(this.spatialPanel);
        this.queryOptionsPanel.setLayout(new BoxLayout(this.queryOptionsPanel, 0));
        this.queryOptionsPanel.setVisible(false);
        this.queryOptionsPanel.add(Box.createHorizontalStrut(8));
        JPanel optionsListPanel = new JPanel();
        optionsListPanel.setLayout(new BoxLayout(optionsListPanel, 1));
        optionsListPanel.add(Box.createVerticalStrut(8));
        optionsListPanel.add(new JLabel("Choose search options for this query:"));
        optionsListPanel.add(Box.createVerticalStrut(8));
        String caseSensitiveString = profile.get("casesensitive", 0);
        this.caseSensitive = new Boolean(caseSensitiveString);
        this.caseSensitiveCheckBox.setSelected(this.caseSensitive);
        optionsListPanel.add(this.caseSensitiveCheckBox);
        String includeSynonymsString = profile.get("includesynonyms", 0);
        this.includeSynonyms = new Boolean(includeSynonymsString);
        this.includeItisSynonymsCheckBox.setSelected(this.includeSynonyms);
        optionsListPanel.add(this.includeItisSynonymsCheckBox);
        optionsListPanel.add(Box.createVerticalGlue());
        this.saveDefaultsButton.setText("Save Default Options");
        this.saveDefaultsButton.setActionCommand("Save Default Options");
        optionsListPanel.add(this.saveDefaultsButton);
        optionsListPanel.add(Box.createVerticalStrut(8));
        this.queryOptionsPanel.add(optionsListPanel);
        this.queryTabs.add(this.queryOptionsPanel);
        this.queryTabs.setSelectedIndex(0);
        this.queryTabs.setSelectedComponent(this.subjectPanel);
        this.queryTabs.setTitleAt(0, "Subject");
        this.queryTabs.setTitleAt(1, "Taxonomic");
        this.queryTabs.setTitleAt(2, "Spatial");
        this.queryTabs.setTitleAt(3, "Options");
        queryPanel.add(Box.createVerticalStrut(8));
        JPanel controlButtonsPanel = new JPanel();
        controlButtonsPanel.setLayout(new BoxLayout(controlButtonsPanel, 0));
        controlButtonsPanel.add(Box.createHorizontalStrut(8));
        this.allTabsCheckBox.setText("Combine constraints from all tabs");
        this.allTabsCheckBox.setActionCommand("Combine constraints from all tabs");
        controlButtonsPanel.add(this.allTabsCheckBox);
        controlButtonsPanel.add(Box.createHorizontalGlue());
        this.executeButton.setText("Search");
        this.executeButton.setActionCommand("Search");
        controlButtonsPanel.add(this.executeButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setActionCommand("Cancel");
        controlButtonsPanel.add(Box.createHorizontalStrut(8));
        controlButtonsPanel.add(this.cancelButton);
        controlButtonsPanel.add(Box.createHorizontalStrut(8));
        queryPanel.add(controlButtonsPanel);
        queryPanel.add(Box.createVerticalStrut(8));
        ActionEventHandler actionHandler = new ActionEventHandler();
        this.moreButton.addActionListener(actionHandler);
        this.lessButton.addActionListener(actionHandler);
        this.taxonMoreButton.addActionListener(actionHandler);
        this.taxonLessButton.addActionListener(actionHandler);
        this.executeButton.addActionListener(actionHandler);
        this.cancelButton.addActionListener(actionHandler);
        this.saveDefaultsButton.addActionListener(actionHandler);
        CheckBoxListener checkboxHandler = new CheckBoxListener();
        this.catalogSearchCheckBox.addItemListener(checkboxHandler);
        this.localSearchCheckBox.addItemListener(checkboxHandler);
        this.addKeyListener(this.keyPressListener);
        SymChange lSymChange = new SymChange();
        this.queryTabs.addChangeListener(lSymChange);
        this.liveMap.setVisible(false);
        this.liveMap.invalidate();
        this.spatialPanel.validate();
    }

    private void handleMoreButtonAction(ActionEvent event) {
        SubjectTermPanel tq = new SubjectTermPanel(this.keyPressListener);
        this.queryChoicesPanel.add(tq);
        this.textPanels.addElement(tq);
        this.lessButton.setEnabled(true);
        this.queryChoicesPanel.invalidate();
        this.subjectPanel.validate();
    }

    private void handleLessButtonAction(ActionEvent event) {
        Component comp = (Component)this.textPanels.lastElement();
        this.queryChoicesPanel.remove(comp);
        this.textPanels.removeElementAt(this.textPanels.size() - 1);
        if (this.textPanels.size() < 2) {
            this.lessButton.setEnabled(false);
        }
        this.queryChoicesPanel.invalidate();
        this.subjectPanel.validate();
    }

    private void handleTaxonMoreButtonAction(ActionEvent event) {
        TaxonTermPanel term = new TaxonTermPanel(this.keyPressListener);
        this.taxonChoicesPanel.add(term);
        this.taxonPanels.addElement(term);
        this.taxonLessButton.setEnabled(true);
        this.taxonChoicesPanel.invalidate();
        this.taxonPanel.validate();
    }

    private void handleTaxonLessButtonAction(ActionEvent event) {
        Component comp = (Component)this.taxonPanels.lastElement();
        this.taxonChoicesPanel.remove(comp);
        this.taxonPanels.removeElementAt(this.taxonPanels.size() - 1);
        if (this.taxonPanels.size() < 2) {
            this.taxonLessButton.setEnabled(false);
        }
        this.taxonChoicesPanel.invalidate();
        this.taxonPanel.validate();
    }

    private void handleSearchCheckboxAction(ItemEvent event) {
        ItemSelectable object = event.getItemSelectable();
        if (event.getStateChange() == 2) {
            String messageText = "You must select at least one of \"Network Search\"\nor \"Local Search\". You can not deselect both.\n";
            if (object == this.catalogSearchCheckBox && !this.localSearchCheckBox.isSelected()) {
                this.catalogSearchCheckBox.setSelected(true);
                JOptionPane.showMessageDialog(this, messageText);
            } else if (object == this.localSearchCheckBox && !this.catalogSearchCheckBox.isSelected()) {
                this.localSearchCheckBox.setSelected(true);
                JOptionPane.showMessageDialog(this, messageText);
            }
        }
    }

    private Query buildQuery() {
        Query newQuery = new Query(this.morpho);
        if (this.queryTitleTF.getText().length() < 1) {
            this.queryTitleTF.setText(new Date().toString());
        }
        newQuery.setQueryTitle(this.queryTitleTF.getText());
        newQuery.setSearchMetacat(this.catalogSearchCheckBox.isSelected());
        newQuery.setSearchLocal(this.localSearchCheckBox.isSelected());
        ConfigXML profile = this.morpho.getProfile();
        Vector returndocList = this.config.get("returndoc");
        newQuery.setReturnDocList(returndocList);
        Vector returnFieldList = this.config.get("returnfield");
        newQuery.setReturnFieldList(returnFieldList);
        QueryGroup rootQG = new QueryGroup("INTERSECT");
        newQuery.setQueryGroup(rootQG);
        if (this.allTabsCheckBox.isSelected()) {
            this.buildSubject = true;
            this.buildTaxon = true;
            this.buildSpatial = true;
        } else {
            int tabIndex = this.queryTabs.getSelectedIndex();
            if (0 == tabIndex) {
                this.buildSubject = true;
                this.buildTaxon = false;
                this.buildSpatial = false;
            } else if (1 == tabIndex) {
                this.buildSubject = false;
                this.buildTaxon = true;
                this.buildSpatial = false;
            } else if (2 == tabIndex) {
                this.buildSubject = false;
                this.buildTaxon = false;
                this.buildSpatial = true;
            }
        }
        if (this.buildSubject) {
            QueryGroup subjectGroup = this.buildSubjectQueryGroup();
            rootQG.addChild(subjectGroup);
        }
        if (this.buildTaxon) {
            QueryGroup taxonGroup = this.buildTaxonQueryGroup();
            rootQG.addChild(taxonGroup);
        }
        if (this.buildSpatial) {
            QueryGroup spatialGroup = this.buildSpatialQueryGroup();
            rootQG.addChild(spatialGroup);
        }
        System.out.println(newQuery.toXml());
        return newQuery;
    }

    private QueryGroup buildSubjectQueryGroup() {
        String path = "//*";
        String op = "UNION";
        String value = "*";
        String mode = "contains";
        this.caseSensitive = this.caseSensitiveCheckBox.isSelected();
        op = this.orRadioButton.isSelected() ? "UNION" : "INTERSECT";
        QueryGroup subjectGroup = new QueryGroup(op);
        Enumeration enumeration = this.textPanels.elements();
        while (enumeration.hasMoreElements()) {
            QueryTerm newTerm;
            SubjectTermPanel tqtp = (SubjectTermPanel)enumeration.nextElement();
            QueryGroup termGroup = new QueryGroup("UNION");
            subjectGroup.addChild(termGroup);
            if (tqtp.getAllState()) {
                path = "//*";
                value = tqtp.getValue();
                mode = tqtp.getSearchMode();
                QueryTerm allTerm = new QueryTerm(this.caseSensitive, mode, value);
                termGroup.addChild(allTerm);
                continue;
            }
            value = tqtp.getValue();
            mode = tqtp.getSearchMode();
            if (tqtp.getTitleState()) {
                path = this.titleSearchPath;
                newTerm = new QueryTerm(this.caseSensitive, mode, value, path);
                termGroup.addChild(newTerm);
            }
            if (tqtp.getAbstractState()) {
                path = this.abstractSearchPath;
                if (!value.equals("")) {
                    newTerm = new QueryTerm(this.caseSensitive, mode, value, path);
                    termGroup.addChild(newTerm);
                }
            }
            if (!tqtp.getKeywordsState()) continue;
            path = this.keywordSearchPath;
            newTerm = new QueryTerm(this.caseSensitive, mode, value, path);
            termGroup.addChild(newTerm);
        }
        return subjectGroup;
    }

    private QueryGroup buildSpatialQueryGroup() {
        String path = "//*";
        String op = "INTERSECT";
        String value = "*";
        String mode = "greater-than";
        this.caseSensitive = false;
        QueryGroup boundingBoxGroup = new QueryGroup(op);
        value = new Double(this.liveMap.getTop()).toString();
        mode = "less-than";
        path = this.northBCSearchPath;
        QueryTerm maxLat = new QueryTerm(this.caseSensitive, mode, value, path);
        boundingBoxGroup.addChild(maxLat);
        value = new Double(this.liveMap.getBottom()).toString();
        mode = "greater-than";
        path = this.northBCSearchPath;
        QueryTerm minLat = new QueryTerm(this.caseSensitive, mode, value, path);
        boundingBoxGroup.addChild(minLat);
        value = new Double(this.liveMap.getRight()).toString();
        mode = "less-than";
        path = this.westBCSearchPath;
        QueryTerm maxLong = new QueryTerm(this.caseSensitive, mode, value, path);
        boundingBoxGroup.addChild(maxLong);
        value = new Double(this.liveMap.getLeft()).toString();
        mode = "greater-than";
        path = this.westBCSearchPath;
        QueryTerm minLong = new QueryTerm(this.caseSensitive, mode, value, path);
        boundingBoxGroup.addChild(minLong);
        return boundingBoxGroup;
    }

    private QueryGroup buildTaxonQueryGroup() {
        String path = "//*";
        String op = "UNION";
        String value = "*";
        String mode = "contains";
        this.caseSensitive = this.caseSensitiveCheckBox.isSelected();
        this.includeSynonyms = this.includeItisSynonymsCheckBox.isSelected();
        op = this.taxonOrRadioButton.isSelected() ? "UNION" : "INTERSECT";
        QueryGroup taxonGroup = new QueryGroup(op);
        Enumeration enumeration = this.taxonPanels.elements();
        while (enumeration.hasMoreElements()) {
            QueryGroup parentGroup;
            TaxonTermPanel taxonTermPanel = (TaxonTermPanel)enumeration.nextElement();
            if (this.includeSynonyms) {
                parentGroup = new QueryGroup("UNION");
                taxonGroup.addChild(parentGroup);
            } else {
                parentGroup = taxonGroup;
            }
            QueryGroup termGroup = this.buildTaxonTerm(taxonTermPanel.getTaxonRank(), taxonTermPanel.getValue(), taxonTermPanel.getSearchMode());
            parentGroup.addChild(termGroup);
            if (!this.includeSynonyms) continue;
            Vector synonymList = this.morpho.getTaxonSynonyms(taxonTermPanel.getValue());
            Log.debug(20, "Number of synonyms: " + synonymList.size());
            for (int i = 0; i < synonymList.size(); ++i) {
                Log.debug(20, "Adding synonym to query: " + synonymList.elementAt(i));
                QueryGroup synonymGroup = this.buildTaxonTerm(taxonTermPanel.getTaxonRank(), (String)synonymList.elementAt(i), taxonTermPanel.getSearchMode());
                parentGroup.addChild(synonymGroup);
            }
        }
        return taxonGroup;
    }

    private QueryGroup buildTaxonTerm(String taxonRank, String taxonValue, String mode) {
        QueryGroup termGroup = new QueryGroup("INTERSECT");
        String path = this.taxonRankSearchPath;
        QueryTerm rankTerm = new QueryTerm(false, "contains", taxonRank, path);
        termGroup.addChild(rankTerm);
        path = this.taxonValueSearchPath;
        QueryTerm valueTerm = new QueryTerm(this.caseSensitive, mode, taxonValue, path);
        termGroup.addChild(valueTerm);
        return termGroup;
    }

    private void handleExecuteButtonAction(ActionEvent event) {
        int tabIndex = this.queryTabs.getSelectedIndex();
        if (tabIndex > 2) {
            String message = "Please select one of the Subject, Taxonomic, or Spatial \nquery tabs before clicking the Search button.";
            JOptionPane.showMessageDialog(this, message);
        } else if (tabIndex == 20) {
            String message = "This is a test of the spatial query input tool. \nActual spatial queries are not yet implemented.\nMaximum Latitude:" + new Double(this.liveMap.getTop()).toString() + "\n" + "Minimum Latitude:" + new Double(this.liveMap.getBottom()).toString() + "\n" + "Maximum Longitude:" + new Double(this.liveMap.getRight()).toString() + "\n" + "Minimum Longitude:" + new Double(this.liveMap.getLeft()).toString();
            JOptionPane.showMessageDialog(this, message);
            this.buildQuery();
        } else {
            String metacatflag = "true";
            String localflag = "true";
            if (!this.catalogSearchCheckBox.isSelected()) {
                metacatflag = "false";
            }
            if (!this.localSearchCheckBox.isSelected() && this.catalogSearchCheckBox.isSelected()) {
                localflag = "false";
            }
            ConfigXML profile = this.morpho.getProfile();
            profile.set("searchmetacat", 0, metacatflag);
            profile.set("searchlocal", 0, localflag);
            this.savedQuery = this.buildQuery();
            this.searchStarted = true;
            this.setVisible(false);
        }
    }

    private void handleCancelButtonAction(ActionEvent event) {
        this.searchStarted = false;
        this.setVisible(false);
    }

    private void handleSaveDefaultsButtonAction(ActionEvent event) {
        ConfigXML profile = this.morpho.getProfile();
        profile.set("searchmetacat", 0, this.catalogSearchCheckBox.isSelected() ? "true" : "false");
        profile.set("searchlocal", 0, this.localSearchCheckBox.isSelected() ? "true" : "false");
        profile.set("casesensitive", 0, this.caseSensitiveCheckBox.isSelected() ? "true" : "false");
        profile.set("includesynonyms", 0, this.includeItisSynonymsCheckBox.isSelected() ? "true" : "false");
        JOptionPane.showMessageDialog(this, "Options have been saved.");
    }

    public boolean isSearchStarted() {
        return this.searchStarted;
    }

    public Query getQuery() {
        return this.savedQuery;
    }

    public void setQuery(Query query) {
        this.savedQuery = query;
        this.queryTitleTF.setText(query.getQueryTitle());
        QueryGroup rootGroup = this.savedQuery.getQueryGroup();
        this.buildSubject = false;
        this.buildTaxon = false;
        this.buildSpatial = false;
        this.repopulateSubjectSearchTab(rootGroup);
        this.repopulateTaxonSearchTab(rootGroup);
        if (this.buildSubject && this.buildTaxon || this.buildSubject && this.buildSpatial || this.buildTaxon && this.buildSpatial) {
            this.allTabsCheckBox.setSelected(true);
        }
    }

    private void repopulateSubjectSearchTab(QueryGroup rootGroup) {
        for (int i = 0; i < this.textPanels.size(); ++i) {
            Component comp = (Component)this.textPanels.lastElement();
            this.queryChoicesPanel.remove(comp);
            this.textPanels.removeElementAt(this.textPanels.size() - 1);
        }
        Enumeration rootChildren = rootGroup.getChildren();
        QueryGroup subjectGroup = null;
        boolean foundSubjectGroup = false;
        while (rootChildren.hasMoreElements()) {
            QueryGroup tempSubjectGroup = (QueryGroup)rootChildren.nextElement();
            Enumeration tempSubjectChildren = tempSubjectGroup.getChildren();
            try {
                QueryGroup tempTermsGroup = (QueryGroup)tempSubjectChildren.nextElement();
                Enumeration tempQTList = tempTermsGroup.getChildren();
                QueryTerm tempQT = (QueryTerm)tempQTList.nextElement();
                String path = tempQT.getPathExpression();
                if (path != null && !path.equals(this.titleSearchPath) && !path.equals(this.abstractSearchPath) && !path.equals(this.keywordSearchPath)) continue;
                foundSubjectGroup = true;
                subjectGroup = tempSubjectGroup;
                break;
            }
            catch (ClassCastException cce) {
                foundSubjectGroup = false;
            }
        }
        if (foundSubjectGroup) {
            String op = subjectGroup.getOperator();
            if (op.equalsIgnoreCase("INTERSECT")) {
                this.orRadioButton.setSelected(false);
                this.andRadioButton.setSelected(true);
            } else {
                this.orRadioButton.setSelected(true);
                this.andRadioButton.setSelected(false);
            }
            Enumeration subjectChildren = subjectGroup.getChildren();
            while (subjectChildren.hasMoreElements()) {
                Object obj = subjectChildren.nextElement();
                SubjectTermPanel tq = new SubjectTermPanel(this.keyPressListener);
                tq.setAllState(true);
                tq.setTitleState(false);
                tq.setAbstractState(false);
                tq.setKeywordsState(false);
                try {
                    QueryGroup termsGroup = (QueryGroup)obj;
                    Enumeration qtList = termsGroup.getChildren();
                    while (qtList.hasMoreElements()) {
                        Object obj2 = qtList.nextElement();
                        QueryTerm qt = (QueryTerm)obj2;
                        tq.setValue(qt.getValue());
                        tq.setSearchMode(qt.getSearchMode());
                        this.caseSensitiveCheckBox.setSelected(qt.isCaseSensitive());
                        String pathExpression = qt.getPathExpression();
                        if (pathExpression == null) {
                            tq.setAllState(true);
                            continue;
                        }
                        tq.setAllState(false);
                        if (pathExpression.equals(this.titleSearchPath)) {
                            tq.setTitleState(true);
                            continue;
                        }
                        if (pathExpression.equals(this.abstractSearchPath)) {
                            tq.setAbstractState(true);
                            continue;
                        }
                        if (!pathExpression.equals(this.keywordSearchPath)) continue;
                        tq.setKeywordsState(true);
                    }
                }
                catch (ClassCastException cce) {
                    Log.debug(3, "Query doesn't meet expectations, so couldn't rebuild dialog correctly!");
                    tq = new SubjectTermPanel(this.keyPressListener);
                    tq.setAllState(true);
                }
                this.queryChoicesPanel.add(tq);
                this.textPanels.addElement(tq);
            }
            this.buildSubject = true;
        } else {
            SubjectTermPanel defaultPanel = new SubjectTermPanel(this.keyPressListener);
            defaultPanel.setAllState(true);
            this.queryChoicesPanel.add(defaultPanel);
            this.textPanels.addElement(defaultPanel);
        }
        if (this.textPanels.size() < 2) {
            this.lessButton.setEnabled(false);
        } else {
            this.lessButton.setEnabled(true);
        }
        this.queryChoicesPanel.invalidate();
        this.subjectPanel.validate();
    }

    private void repopulateTaxonSearchTab(QueryGroup rootGroup) {
        for (int i = 0; i < this.taxonPanels.size(); ++i) {
            Component comp = (Component)this.taxonPanels.lastElement();
            this.taxonChoicesPanel.remove(comp);
            this.taxonPanels.removeElementAt(this.taxonPanels.size() - 1);
        }
        Enumeration rootChildren = rootGroup.getChildren();
        QueryGroup taxonGroup = null;
        boolean foundTaxonGroup = false;
        boolean hasSynonymStructure = false;
        while (rootChildren.hasMoreElements()) {
            QueryGroup tempTaxonGroup = (QueryGroup)rootChildren.nextElement();
            Log.debug(20, "Repopulating taxon query: level 2");
            Enumeration tempTaxonChildren = tempTaxonGroup.getChildren();
            try {
                QueryGroup tempTermsGroup = (QueryGroup)tempTaxonChildren.nextElement();
                Log.debug(20, "Repopulating taxon query: level 3");
                Enumeration tempQTList = tempTermsGroup.getChildren();
                QueryTerm tempQT = (QueryTerm)tempQTList.nextElement();
                Log.debug(20, "Repopulating taxon query: level 4 rank");
                String path = tempQT.getPathExpression();
                if (path == null || !path.equals(this.taxonRankSearchPath)) continue;
                tempQT = (QueryTerm)tempQTList.nextElement();
                Log.debug(20, "Repopulating taxon query: level 4 value");
                path = tempQT.getPathExpression();
                if (!path.equals(this.taxonValueSearchPath)) continue;
                Log.debug(20, "Found regular taxon query.");
                foundTaxonGroup = true;
                hasSynonymStructure = false;
                taxonGroup = tempTaxonGroup;
                break;
            }
            catch (ClassCastException cce) {
                Log.debug(20, cce.getMessage());
                Log.debug(20, "Not a regular taxon query, testing for synonyms...");
                tempTaxonChildren = tempTaxonGroup.getChildren();
                try {
                    QueryGroup tempSynonymGroup = (QueryGroup)tempTaxonChildren.nextElement();
                    Log.debug(20, "Repopulating taxon query: level 3");
                    Enumeration tempSynonymChildren = tempSynonymGroup.getChildren();
                    QueryGroup tempTermsGroup = (QueryGroup)tempSynonymChildren.nextElement();
                    Log.debug(20, "Repopulating taxon query: level 4");
                    Enumeration tempQTList = tempTermsGroup.getChildren();
                    QueryTerm tempQT = (QueryTerm)tempQTList.nextElement();
                    Log.debug(20, "Repopulating taxon query: level 5 rank");
                    String path = tempQT.getPathExpression();
                    if (path == null || !path.equals(this.taxonRankSearchPath)) continue;
                    tempQT = (QueryTerm)tempQTList.nextElement();
                    Log.debug(20, "Repopulating taxon query: level 5 value");
                    path = tempQT.getPathExpression();
                    if (!path.equals(this.taxonValueSearchPath)) continue;
                    Log.debug(20, "Found taxon query with synonyms.");
                    foundTaxonGroup = true;
                    hasSynonymStructure = true;
                    taxonGroup = tempTaxonGroup;
                    break;
                }
                catch (ClassCastException cce2) {
                    Log.debug(20, cce2.getMessage());
                    Log.debug(20, "Not a taxon query.");
                    foundTaxonGroup = false;
                }
            }
        }
        if (foundTaxonGroup) {
            String op = taxonGroup.getOperator();
            if (op.equalsIgnoreCase("INTERSECT")) {
                this.taxonOrRadioButton.setSelected(false);
                this.taxonAndRadioButton.setSelected(true);
            } else {
                this.taxonOrRadioButton.setSelected(true);
                this.taxonAndRadioButton.setSelected(false);
            }
            Enumeration taxonChildren = taxonGroup.getChildren();
            while (taxonChildren.hasMoreElements()) {
                TaxonTermPanel termPanel = new TaxonTermPanel(this.keyPressListener);
                try {
                    QueryGroup termsGroup;
                    if (hasSynonymStructure) {
                        QueryGroup synonymGroup = (QueryGroup)taxonChildren.nextElement();
                        Enumeration synonymChildren = synonymGroup.getChildren();
                        termsGroup = (QueryGroup)synonymChildren.nextElement();
                    } else {
                        termsGroup = (QueryGroup)taxonChildren.nextElement();
                    }
                    Enumeration qtList = termsGroup.getChildren();
                    while (qtList.hasMoreElements()) {
                        QueryTerm qt = (QueryTerm)qtList.nextElement();
                        String searchMode = qt.getSearchMode();
                        String pathExpression = qt.getPathExpression();
                        String value = qt.getValue();
                        this.caseSensitiveCheckBox.setSelected(qt.isCaseSensitive());
                        if (pathExpression.equals(this.taxonRankSearchPath)) {
                            termPanel.setTaxonRank(value);
                            continue;
                        }
                        if (!pathExpression.equals(this.taxonValueSearchPath)) continue;
                        termPanel.setSearchMode(searchMode);
                        termPanel.setValue(value);
                    }
                }
                catch (ClassCastException cce) {
                    Log.debug(3, "Query doesn't meet expectations, so couldn't rebuild dialog correctly!");
                    termPanel = new TaxonTermPanel(this.keyPressListener);
                }
                this.taxonChoicesPanel.add(termPanel);
                this.taxonPanels.addElement(termPanel);
            }
            this.buildTaxon = true;
        } else {
            TaxonTermPanel defaultPanel = new TaxonTermPanel(this.keyPressListener);
            this.taxonChoicesPanel.add(defaultPanel);
            this.taxonPanels.addElement(defaultPanel);
        }
        if (this.taxonPanels.size() < 2) {
            this.taxonLessButton.setEnabled(false);
        } else {
            this.taxonLessButton.setEnabled(true);
        }
        this.taxonChoicesPanel.invalidate();
        this.taxonPanel.validate();
    }

    class SymChange
    implements ChangeListener {
        SymChange() {
        }

        public void stateChanged(ChangeEvent event) {
            Object object = event.getSource();
            if (object == QueryDialog.this.queryTabs) {
                int sel = QueryDialog.this.queryTabs.getSelectedIndex();
                System.out.println("Selected index is: " + sel);
                if (sel == 2) {
                    QueryDialog.this.liveMap.setVisible(true);
                    QueryDialog.this.spatialPanel.setVisible(true);
                    QueryDialog.this.liveMap.invalidate();
                    QueryDialog.this.spatialPanel.validate();
                } else {
                    QueryDialog.this.liveMap.setVisible(false);
                    QueryDialog.this.liveMap.invalidate();
                    QueryDialog.this.spatialPanel.validate();
                }
            }
        }
    }

    private class CheckBoxListener
    implements ItemListener {
        private CheckBoxListener() {
        }

        public void itemStateChanged(ItemEvent event) {
            ItemSelectable object = event.getItemSelectable();
            if (object == QueryDialog.this.catalogSearchCheckBox) {
                QueryDialog.this.handleSearchCheckboxAction(event);
            } else if (object == QueryDialog.this.localSearchCheckBox) {
                QueryDialog.this.handleSearchCheckboxAction(event);
            }
        }
    }

    private class ActionEventHandler
    implements ActionListener {
        private ActionEventHandler() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == QueryDialog.this.moreButton) {
                QueryDialog.this.handleMoreButtonAction(event);
            } else if (object == QueryDialog.this.lessButton) {
                QueryDialog.this.handleLessButtonAction(event);
            } else if (object == QueryDialog.this.taxonMoreButton) {
                QueryDialog.this.handleTaxonMoreButtonAction(event);
            } else if (object == QueryDialog.this.taxonLessButton) {
                QueryDialog.this.handleTaxonLessButtonAction(event);
            } else if (object == QueryDialog.this.executeButton) {
                QueryDialog.this.handleExecuteButtonAction(event);
            } else if (object == QueryDialog.this.cancelButton) {
                QueryDialog.this.handleCancelButtonAction(event);
            } else if (object == QueryDialog.this.saveDefaultsButton) {
                QueryDialog.this.handleSaveDefaultsButtonAction(event);
            }
        }
    }

    class KeyPressActionListener
    extends KeyAdapter {
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                ActionEvent event = new ActionEvent(QueryDialog.this.executeButton, 0, "Search");
                QueryDialog.this.handleExecuteButtonAction(event);
            } else if (e.getKeyCode() == 27) {
                QueryDialog.this.dispose();
                ActionEvent event = new ActionEvent(QueryDialog.this.cancelButton, 0, "Cancel");
                QueryDialog.this.handleCancelButtonAction(event);
            }
        }
    }
}

