/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.query;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.framework.ConfigXML;
import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.query.CancelCommand;
import edu.ucsb.nceas.morpho.query.HeadResultSet;
import edu.ucsb.nceas.morpho.query.OpenPackageCommand;
import edu.ucsb.nceas.morpho.query.Query;
import edu.ucsb.nceas.morpho.query.ResultPanel;
import edu.ucsb.nceas.morpho.query.ResultPanelAndFrameMediator;
import edu.ucsb.nceas.morpho.query.ResultSet;
import edu.ucsb.nceas.morpho.query.SearchCommand;
import edu.ucsb.nceas.morpho.util.GUIAction;
import edu.ucsb.nceas.morpho.util.StateChangeEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;

public class OpenDialogBox
extends JDialog {
    private Morpho morpho = null;
    private ConfigXML config = null;
    private ResultPanelAndFrameMediator mediator = null;
    private Query ownerQuery = null;
    private MorphoFrame parentFrame = null;
    private JButton openButton = null;
    private JButton cancelButton = null;
    private JButton searchButton = null;
    private ResultSet results = null;
    private ResultPanel ownerPanel = null;
    private static final double DIMENSIONFACTOR = 0.9;
    private static final int PADDINGWIDTH = 8;

    public OpenDialogBox(MorphoFrame parent, Morpho morpho, Query myQuery) {
        super(parent);
        this.parentFrame = parent;
        this.morpho = morpho;
        this.config = morpho.getConfiguration();
        this.mediator = new ResultPanelAndFrameMediator();
        this.ownerQuery = myQuery;
        int parentWidth = parent.getWidth();
        int parentHeight = parent.getHeight();
        int dialogWidth = 820;
        int dialogHeight = 500;
        this.setSize(dialogWidth, dialogHeight);
        double parentX = parent.getLocation().getX();
        double parentY = parent.getLocation().getY();
        double centerX = parentX + 0.5 * (double)parentWidth;
        double centerY = parentY + 0.5 * (double)parentHeight;
        int dialogX = new Double(centerX - 0.5 * (double)dialogWidth).intValue();
        int dialogY = new Double(centerY - 0.5 * (double)dialogHeight).intValue();
        this.setLocation(dialogX, dialogY);
        this.setTitle("Open");
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.getContentPane().add("North", Box.createVerticalStrut(8));
        this.getContentPane().add("East", Box.createHorizontalStrut(8));
        this.getContentPane().add("West", Box.createHorizontalStrut(8));
        this.createOwnerPanel();
        this.ownerPanel.setBackground(Color.white);
        this.ownerPanel.sortTable(5, "decending");
        this.getContentPane().add("Center", this.ownerPanel);
        Box bottomBox = Box.createVerticalBox();
        this.getContentPane().add("South", bottomBox);
        bottomBox.add(Box.createVerticalStrut(8));
        Box controlButtonsBox = Box.createHorizontalBox();
        controlButtonsBox.add(Box.createHorizontalStrut(8));
        GUIAction searchAction = new GUIAction("Search...", new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Search16.gif")), new SearchCommand(this, morpho));
        searchAction.setToolTipText("Switch to search system to open packages from the whole network");
        this.searchButton = new JButton(searchAction);
        this.searchButton.setHorizontalTextPosition(2);
        controlButtonsBox.add(this.searchButton);
        controlButtonsBox.add(Box.createHorizontalGlue());
        GUIAction openAction = new GUIAction("Open", null, new OpenPackageCommand(this));
        this.openButton = new JButton(openAction);
        this.mediator.registerOpenButton(this.openButton);
        this.mediator.init();
        controlButtonsBox.add(this.openButton);
        controlButtonsBox.add(Box.createHorizontalStrut(8));
        GUIAction cancelAction = new GUIAction("Cancel", null, new CancelCommand(this));
        this.cancelButton = new JButton(cancelAction);
        controlButtonsBox.add(this.cancelButton);
        controlButtonsBox.add(Box.createHorizontalStrut(8));
        bottomBox.add(controlButtonsBox);
        bottomBox.add(Box.createVerticalStrut(10));
        this.addKeyListener(new KeyPressActionListener());
        this.setModal(true);
        this.setVisible(true);
    }

    public MorphoFrame getParentFrame() {
        return this.parentFrame;
    }

    public ResultPanel getResultPanel() {
        return this.ownerPanel;
    }

    public void setResultPanel(ResultPanel resultPanel) {
        if (resultPanel != null) {
            Container contentPane = this.getContentPane();
            if (this.ownerPanel != null) {
                contentPane.remove(this.ownerPanel);
            }
            this.ownerPanel = resultPanel;
            contentPane.add("Center", this.ownerPanel);
            this.validate();
        }
    }

    private void createOwnerPanel() {
        Vector vector = new Vector();
        String source = "";
        HeadResultSet results = new HeadResultSet(this.ownerQuery, source, vector, this.morpho);
        this.ownerPanel = new ResultPanel(this, results, this.mediator);
        this.ownerPanel.setVisible(true);
        StateChangeEvent event = null;
        boolean showSearchNumber = false;
        boolean sort = true;
        int index = 5;
        String order = "decending";
        this.ownerQuery.displaySearchResult(this.parentFrame, this.ownerPanel, sort, index, order, showSearchNumber, event);
    }

    class KeyPressActionListener
    extends KeyAdapter {
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                ActionEvent event = new ActionEvent(OpenDialogBox.this.openButton, 0, "Search");
            } else if (e.getKeyCode() == 27) {
                OpenDialogBox.this.dispose();
                ActionEvent actionEvent = new ActionEvent(OpenDialogBox.this.cancelButton, 0, "Cancel");
            }
        }
    }
}

