/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.query;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.framework.DataPackageInterface;
import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.framework.SwingWorker;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceNotHandledException;
import edu.ucsb.nceas.morpho.plugins.ServiceProvider;
import edu.ucsb.nceas.morpho.query.HeadResultSet;
import edu.ucsb.nceas.morpho.query.OpenDialogBox;
import edu.ucsb.nceas.morpho.query.Query;
import edu.ucsb.nceas.morpho.query.ResultPanel;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.morpho.util.SortableJTable;
import edu.ucsb.nceas.morpho.util.StateChangeEvent;
import edu.ucsb.nceas.morpho.util.StateChangeMonitor;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class DeleteCommand
implements Command {
    private JDialog deleteDialog = null;
    private OpenDialogBox openDialog = null;
    private MorphoFrame morphoFrame = null;
    String morphoFrameType = null;
    private ResultPanel resultPane = null;
    private String state = null;
    private String message = null;
    private static final String LOCALWARNING = "Are you sure you want to delete \nthe package from your local file system?";
    private static final String NETWORKWARNING = "Are you sure you want to delete \nthe package from the Network? You \nwill not be able to upload \nit again with the same identifier.";
    private static final String BOTHWARNING = "Are you sure you want to delete \nthe package from the Network and your \nlocal file system? Deleting a package\n cannot be undone!";
    String selectDocId = null;
    private boolean execute = false;
    private boolean inLocal = false;
    private boolean inNetwork = false;
    private boolean comeFromOpenDialog = false;
    DataPackageInterface dataPackage = null;
    private String BLANK = "Blank";
    private static int index = 1;

    public DeleteCommand(OpenDialogBox myOpenDialog, JDialog myDeleteDialog, MorphoFrame myFrame, String frameType, String myState, String selectId, boolean myInLocal, boolean myInNetwork) {
        if (myOpenDialog != null) {
            this.openDialog = myOpenDialog;
            this.comeFromOpenDialog = true;
            this.morphoFrameType = null;
        } else {
            this.morphoFrameType = frameType;
        }
        this.deleteDialog = myDeleteDialog;
        this.morphoFrame = myFrame;
        this.selectDocId = selectId;
        this.state = myState;
        this.inLocal = myInLocal;
        this.inNetwork = myInNetwork;
    }

    public void execute(ActionEvent event) {
        if (this.state.equals("local")) {
            this.message = LOCALWARNING;
            this.execute = this.inLocal;
        } else if (this.state.equals("metacat")) {
            this.message = NETWORKWARNING;
            this.execute = this.inNetwork;
        } else if (this.state.equals("localmetacat")) {
            this.message = BOTHWARNING;
            this.execute = this.inLocal && this.inNetwork;
        } else {
            Log.debug(20, "Unkown deletion command!");
        }
        if (this.selectDocId != null && !this.selectDocId.equals("") && this.execute) {
            if (this.deleteDialog != null) {
                this.deleteDialog.setVisible(false);
                this.deleteDialog.dispose();
                this.deleteDialog = null;
            }
            this.doDelete(this.selectDocId, this.openDialog);
        }
    }

    private void doDelete(final String docid, final OpenDialogBox open) {
        SwingWorker worker = new SwingWorker(){
            boolean refreshFlag = false;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public Object construct() {
                ResultPanel result;
                if (DeleteCommand.this.morphoFrame != null) {
                    DeleteCommand.this.morphoFrame.setBusy(true);
                }
                try {
                    ServiceController services = ServiceController.getInstance();
                    ServiceProvider provider = services.getServiceProvider(DataPackageInterface.class);
                    DeleteCommand.this.dataPackage = (DataPackageInterface)((Object)provider);
                }
                catch (ServiceNotHandledException snhe) {
                    Log.debug(6, "Error in delete");
                    return null;
                }
                Log.debug(20, "Deleteing the package.");
                int choice = 0;
                choice = DeleteCommand.this.comeFromOpenDialog ? JOptionPane.showConfirmDialog(open, DeleteCommand.this.message, "Morpho", 1, 2) : JOptionPane.showConfirmDialog(DeleteCommand.this.morphoFrame, DeleteCommand.this.message, "Morpho", 1, 2);
                if (choice != 0) return null;
                if (DeleteCommand.this.comeFromOpenDialog) {
                    try {
                        DeleteCommand.this.dataPackage.delete(docid, DeleteCommand.this.state);
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(open, e.getMessage());
                        return null;
                    }
                    this.refreshFlag = true;
                    result = open.getResultPanel();
                    this.refreshSearchResultPanel(result, open, DeleteCommand.this.comeFromOpenDialog);
                    this.refreshFlag = false;
                    return null;
                }
                if (DeleteCommand.this.morphoFrameType != null) {
                    String string = DeleteCommand.this.morphoFrameType;
                    DeleteCommand.this.morphoFrame;
                    if (string.equals("searchResultFrame")) {
                        try {
                            DeleteCommand.this.dataPackage.delete(docid, DeleteCommand.this.state);
                        }
                        catch (Exception e) {
                            JOptionPane.showMessageDialog(DeleteCommand.this.morphoFrame, e.getMessage());
                            return null;
                        }
                        this.refreshFlag = true;
                        result = (ResultPanel)DeleteCommand.this.morphoFrame.getContentComponent();
                        this.refreshSearchResultPanel(result, null, DeleteCommand.this.comeFromOpenDialog);
                        this.refreshFlag = false;
                        return null;
                    }
                }
                if (DeleteCommand.this.morphoFrameType == null) return null;
                String string = DeleteCommand.this.morphoFrameType;
                DeleteCommand.this.morphoFrame;
                if (!string.equals("dataPackageFrame")) return null;
                try {
                    DeleteCommand.this.dataPackage.delete(docid, DeleteCommand.this.state);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(DeleteCommand.this.morphoFrame, e.getMessage());
                    return null;
                }
                this.refreshFlag = true;
                this.refreshDataPackageFrame();
                this.refreshFlag = false;
                return null;
            }

            private void refreshSearchResultPanel(ResultPanel resultPane, OpenDialogBox open2, boolean fromDialog) {
                ResultPanel newResult = null;
                if (resultPane == null) {
                    return;
                }
                boolean sorted = false;
                int index = -1;
                String order = null;
                SortableJTable table = resultPane.getJTable();
                if (table != null) {
                    sorted = table.getSorted();
                    index = table.getIndexOfSortedColumn();
                    order = table.getOrderOfSortedColumn();
                }
                HeadResultSet resultSet = (HeadResultSet)resultPane.getResultSet();
                Morpho morpho = resultSet.getMorpho();
                Query query = resultSet.getQuery();
                Vector resultVector = resultSet.getResultsVector();
                resultVector = this.updateResultVector(resultVector);
                String source = "both";
                HeadResultSet newResultSet = new HeadResultSet(query, source, resultVector, morpho);
                if (!fromDialog) {
                    newResult = new ResultPanel(null, newResultSet, 12, null, DeleteCommand.this.morphoFrame.getDefaultContentAreaSize());
                    if (sorted) {
                        newResult.sortTable(index, order);
                    }
                    newResult.setVisible(true);
                    DeleteCommand.this.morphoFrame.setMainContentPane(newResult);
                    DeleteCommand.this.morphoFrame.setMessage(newResultSet.getRowCount() + " data sets found");
                    StateChangeMonitor monitor = StateChangeMonitor.getInstance();
                    monitor.notifyStateChange(new StateChangeEvent(newResult, StateChangeEvent.SEARCH_RESULT_NONSELECTED));
                } else {
                    newResult = new ResultPanel(open2, newResultSet, null);
                    if (sorted) {
                        newResult.sortTable(index, order);
                    }
                    newResult.setVisible(true);
                    open2.setResultPanel(newResult);
                }
            }

            private Vector updateResultVector(Vector resultVector) {
                Vector newVector = null;
                if (resultVector == null) {
                    return newVector;
                }
                for (int i = 0; i < resultVector.size(); ++i) {
                    Vector row = (Vector)resultVector.elementAt(i);
                    String docid2 = (String)row.elementAt(6);
                    Log.debug(30, "the package id is: " + docid2 + " and row number is " + i);
                    if (!DeleteCommand.this.selectDocId.equals(docid2)) continue;
                    Log.debug(30, "finding the delete packagid: " + docid2);
                    if (DeleteCommand.this.state.equals("local") && DeleteCommand.this.inLocal && DeleteCommand.this.inNetwork) {
                        Log.debug(30, "delete local copy from local copy and networkcopy - delete the local icon");
                        row.set(9, new Boolean(false));
                        continue;
                    }
                    if (DeleteCommand.this.state.equals("local") && DeleteCommand.this.inLocal && !DeleteCommand.this.inNetwork) {
                        Log.debug(30, "delete local copy from local copy - get rid this row");
                        resultVector.remove(i);
                        continue;
                    }
                    if (DeleteCommand.this.state.equals("metacat") && DeleteCommand.this.inLocal && DeleteCommand.this.inNetwork) {
                        Log.debug(30, "delete network copy from local copy and network copy - delete network icon");
                        row.set(10, new Boolean(false));
                        continue;
                    }
                    if (DeleteCommand.this.state.equals("metacat") && !DeleteCommand.this.inLocal && DeleteCommand.this.inNetwork) {
                        Log.debug(30, "delete network copy from network copy - delete the row");
                        resultVector.remove(i);
                        continue;
                    }
                    if (DeleteCommand.this.state.equals("localmetacat") && DeleteCommand.this.inLocal && DeleteCommand.this.inNetwork) {
                        Log.debug(30, "delete both copy, so remove this row");
                        resultVector.remove(i);
                        continue;
                    }
                    Log.debug(20, "Unkown deletion command!");
                }
                newVector = resultVector;
                return newVector;
            }

            private void refreshDataPackageFrame() {
                if (DeleteCommand.this.inLocal && DeleteCommand.this.inNetwork && !DeleteCommand.this.state.equals("localmetacat")) {
                    String location = null;
                    location = DeleteCommand.this.state.equals("local") ? "metacat" : "local";
                    DeleteCommand.this.dataPackage.openDataPackage(location, DeleteCommand.this.selectDocId, null, null, null);
                }
                UIController.getInstance().removeWindow(DeleteCommand.this.morphoFrame);
                DeleteCommand.this.morphoFrame.dispose();
                DeleteCommand.this.morphoFrame = null;
            }

            public void finished() {
                if (DeleteCommand.this.morphoFrame != null && !this.refreshFlag) {
                    DeleteCommand.this.morphoFrame.setBusy(false);
                }
            }
        };
        worker.start();
    }
}

