/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.query;

import edu.ucsb.nceas.morpho.util.Log;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class BasicNode {
    private long node_id;
    private String tagname;
    private long parent_id;
    private long rootnode_id;
    private String doc_id;
    private Hashtable attributes;
    private int childNum = 0;
    private int nodeIndex;
    private String nodeType;
    private Vector children = new Vector();

    public BasicNode() {
        this.attributes = new Hashtable();
    }

    public BasicNode(String tagname) {
        this();
        this.tagname = tagname;
    }

    public BasicNode(String tagname, long parent_id, int nodeIndex) {
        this();
        this.tagname = tagname;
        this.parent_id = parent_id;
        this.nodeIndex = nodeIndex;
    }

    public BasicNode(long node_id, String tagname, long parent_id, int nodeIndex) {
        this(tagname, parent_id, nodeIndex);
        this.node_id = node_id;
    }

    public long getNodeID() {
        return this.node_id;
    }

    public void setNodeID(long node_id) {
        this.node_id = node_id;
    }

    public long getParentID() {
        return this.parent_id;
    }

    public void setParentID(long parent_id) {
        this.parent_id = parent_id;
    }

    public long getRootNodeID() {
        return this.rootnode_id;
    }

    public void setRootNodeID(long rootnode_id) {
        this.rootnode_id = rootnode_id;
    }

    public String getDocID() {
        return this.doc_id;
    }

    public void setDocID(String doc_id) {
        this.doc_id = doc_id;
    }

    public String getTagName() {
        return this.tagname;
    }

    public void setTagName(String tagname) {
        this.tagname = tagname;
    }

    public String getAttributes() {
        StringBuffer buf = new StringBuffer();
        String attName = null;
        String attValue = null;
        Enumeration attList = this.attributes.keys();
        while (attList.hasMoreElements()) {
            attName = (String)attList.nextElement();
            attValue = (String)this.attributes.get(attName);
            buf.append(" ").append(attName).append("=\"");
            buf.append(attValue).append("\"");
        }
        return buf.toString();
    }

    public void setAttribute(String attName, String attValue) {
        if (attName != null) {
            this.attributes.put(attName, attValue);
        } else {
            Log.debug(4, "Attribute name must not be null!");
        }
    }

    public String getAttribute(String attName) {
        return (String)this.attributes.get(attName);
    }

    public int getNodeIndex() {
        return this.nodeIndex;
    }

    public void setNodeIndex(int nodeIndex) {
        this.nodeIndex = nodeIndex;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(String type) {
        this.nodeType = type;
    }

    public void addChildNode(BasicNode child) {
        this.children.addElement(child);
    }

    public Enumeration getChildren() {
        return this.children.elements();
    }

    public int incChildNum() {
        return ++this.childNum;
    }
}

