/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.printer;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.PluginInterface;
import edu.ucsb.nceas.morpho.plugins.PrinterInterface;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceExistsException;
import edu.ucsb.nceas.morpho.plugins.ServiceProvider;
import edu.ucsb.nceas.morpho.plugins.printer.PageSetupCommand;
import edu.ucsb.nceas.morpho.plugins.printer.PreviewCommand;
import edu.ucsb.nceas.morpho.plugins.printer.PrintCommand;
import edu.ucsb.nceas.morpho.plugins.printer.PrintFrame;
import edu.ucsb.nceas.morpho.util.GUIAction;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.morpho.util.StateChangeEvent;
import java.awt.Dimension;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;

public class PrinterPlugin
implements PrinterInterface,
PluginInterface,
ServiceProvider {
    private Morpho instanceOfMorpho;
    private final ClassLoader classLoader;
    private static String SEPARATOR_PRECEDING = "separator_preceding";
    private static String SEPARATOR_FOLLOWING = "separator_following";
    private Dimension PRINT_FRAME_DIMENSION = new Dimension(800, 600);
    private static PageFormat pageFormat = null;

    public PrinterPlugin() {
        this.classLoader = Morpho.class.getClassLoader();
        Thread t = Thread.currentThread();
        t.setContextClassLoader(this.classLoader);
        PrinterJob job = PrinterJob.getPrinterJob();
        pageFormat = job.defaultPage();
    }

    public void initialize(Morpho morpho) {
        this.instanceOfMorpho = morpho;
        this.initializeActions();
        try {
            ServiceController services = ServiceController.getInstance();
            services.addService(PrinterInterface.class, this);
            Log.debug(50, "Service added: PrinterInterface.");
        }
        catch (ServiceExistsException see) {
            Log.debug(1, "PrinterService registration failed: PrinterInterface");
            Log.debug(6, see.toString());
        }
    }

    private void initializeActions() {
        UIController controller = UIController.getInstance();
        GUIAction pageSetupAction = new GUIAction("Page setup...", null, new PageSetupCommand());
        pageSetupAction.setMenuItemPosition(6);
        pageSetupAction.setSeparatorPosition(SEPARATOR_PRECEDING);
        pageSetupAction.setMenu("File", 0);
        pageSetupAction.setEnabled(false);
        controller.addGuiAction(pageSetupAction);
        pageSetupAction.setEnabledOnStateChange(StateChangeEvent.CREATE_DATAPACKAGE_FRAME, true, 100);
        pageSetupAction.setEnabledOnStateChange(StateChangeEvent.CREATE_SEARCH_RESULT_FRAME, false, 100);
        GUIAction previewAction = new GUIAction("Print preview...", null, new PreviewCommand(this.instanceOfMorpho, this));
        previewAction.setMenuItemPosition(7);
        previewAction.setMenu("File", 0);
        previewAction.setEnabled(false);
        controller.addGuiAction(previewAction);
        previewAction.setEnabledOnStateChange(StateChangeEvent.CREATE_DATAPACKAGE_FRAME, true, 100);
        previewAction.setEnabledOnStateChange(StateChangeEvent.CREATE_SEARCH_RESULT_FRAME, false, 100);
        GUIAction printAction = new GUIAction("Print...", null, new PrintCommand(this.instanceOfMorpho, this));
        printAction.setMenuItemPosition(8);
        printAction.setMenu("File", 0);
        printAction.setEnabled(false);
        controller.addGuiAction(printAction);
        printAction.setEnabledOnStateChange(StateChangeEvent.CREATE_DATAPACKAGE_FRAME, true, 100);
        printAction.setEnabledOnStateChange(StateChangeEvent.CREATE_SEARCH_RESULT_FRAME, false, 100);
    }

    private static String stripHTMLMetaTags(String html) {
        boolean META_END = false;
        int META_START = html.indexOf("<META");
        if (META_START >= 0) {
            char[] htmlChars = html.toCharArray();
            int charIndex = META_START;
            int nextChar = 32;
            do {
                nextChar = htmlChars[charIndex];
                htmlChars[charIndex] = 32;
            } while (nextChar != 62 && ++charIndex < htmlChars.length);
            html = String.valueOf(htmlChars);
            return PrinterPlugin.stripHTMLMetaTags(html);
        }
        return html;
    }

    private static String stripComments(String html) {
        int prev = 0;
        String res = "";
        int pos = html.indexOf("<!--");
        if (pos < 0) {
            return html;
        }
        while (pos >= 0) {
            res = res + html.substring(prev, pos);
            html = html.substring(pos);
            int next = html.indexOf("-->");
            prev = 0;
            html = html.substring(next + 3);
            pos = html.indexOf("<!--");
        }
        res = res + html;
        return res;
    }

    private String addTitleTag(String html) {
        int pos = html.indexOf("<title>");
        if (pos != -1) {
            return html;
        }
        pos = html.indexOf("</head>");
        String init = "";
        if (pos != -1) {
            init = html.substring(0, pos);
            init = init + "<title></title>";
            init = init + html.substring(pos);
        } else {
            pos = html.indexOf("<body>");
            init = html.substring(0, pos);
            init = init + "<head><title></title></head>";
            init = init + html.substring(pos);
        }
        return init;
    }

    public void display(String displayString, String contentType) {
        if (displayString == null || displayString.trim().equals("")) {
            return;
        }
        String ctype = contentType == null || contentType.trim().equals("") ? "text/html" : contentType;
        displayString = this.processHTMLString(displayString);
        PrintFrame frame = this.createFrame(displayString, ctype, this.PRINT_FRAME_DIMENSION);
        frame.setPageFormat(pageFormat);
    }

    public void print(String displayString, String contentType) {
        if (displayString == null || displayString.trim().equals("")) {
            return;
        }
        String ctype = contentType == null || contentType.trim().equals("") ? "text/html" : contentType;
        displayString = this.processHTMLString(displayString);
        PrintFrame frame = this.createFrame(displayString, ctype, new Dimension(1, 1));
        frame.setPageFormat(pageFormat);
        frame.print();
        frame.dispose();
    }

    private String processHTMLString(String displayString) {
        displayString = PrinterPlugin.stripHTMLMetaTags(displayString);
        displayString = PrinterPlugin.stripComments(displayString);
        displayString = this.addTitleTag(displayString);
        return displayString;
    }

    private PrintFrame createFrame(String displayString, String ctype, Dimension dims) {
        return new PrintFrame(displayString, ctype, dims);
    }

    public static void setPageFormat(PageFormat pf) {
        pageFormat = pf;
    }

    public static PageFormat getPageFormat() {
        return pageFormat;
    }
}

