/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.metadisplay;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.exception.NullArgumentException;
import edu.ucsb.nceas.morpho.plugins.MetaDisplayFactoryInterface;
import edu.ucsb.nceas.morpho.plugins.MetaDisplayInterface;
import edu.ucsb.nceas.morpho.plugins.PluginInterface;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceExistsException;
import edu.ucsb.nceas.morpho.plugins.ServiceProvider;
import edu.ucsb.nceas.morpho.plugins.XMLFactoryInterface;
import edu.ucsb.nceas.morpho.plugins.metadisplay.MetaDisplay;
import edu.ucsb.nceas.morpho.plugins.xsltresolver.XSLTResolverPlugin;
import edu.ucsb.nceas.morpho.util.DocumentNotFoundException;
import edu.ucsb.nceas.morpho.util.Log;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import org.w3c.dom.Document;

public class MetaDisplayPlugin
implements PluginInterface,
ServiceProvider,
MetaDisplayFactoryInterface {
    private static List displayList;

    public void initialize(Morpho morpho) {
        try {
            ServiceController services = ServiceController.getInstance();
            services.addService(MetaDisplayFactoryInterface.class, this);
            Log.debug(20, "Service added: MetaDisplayFactoryInterface.");
        }
        catch (ServiceExistsException see) {
            Log.debug(6, "Service registration failed: MetaDisplayFactoryInterface");
            Log.debug(6, see.toString());
        }
        displayList = new ArrayList();
    }

    public MetaDisplayInterface getInstance() {
        MetaDisplay display = new MetaDisplay();
        displayList.add(display);
        return display;
    }

    public MetaDisplayInterface getMetaDisplay(int displayNum) {
        if (displayList.size() < displayNum + 1) {
            return null;
        }
        return (MetaDisplayInterface)displayList.get(displayNum);
    }

    public static void main(String[] args) {
        XSLTResolverPlugin xsltResolverPlugin;
        String id = "DEFAULT";
        Log.getLog();
        Log.setDebugLevel(51);
        XMLFactoryInterface xmlFactory = new XMLFactoryInterface(){

            public Reader openAsReader(String id) throws DocumentNotFoundException {
                Log.debug(50, "XMLFactoryInterface openAsReader got: " + id);
                StringReader reader = null;
                if (!id.trim().equals("DEFAULT")) {
                    throw new DocumentNotFoundException("XMLFactory - no match for " + id);
                }
                reader = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<eml:eml packageId=\"eml.1.1\" system=\"knb\" xmlns:eml=\"eml://ecoinformatics.org/eml-2.0.1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"eml://ecoinformatics.org/eml-2.0.1 eml.xsd\"> <dataset/> </eml:eml>");
                Log.debug(50, "XMLFactoryInterface openAsReader returning: " + reader);
                return reader;
            }

            public Document openAsDom(String id) {
                return null;
            }
        };
        ActionListener listener = null;
        block16: for (int i = 0; i < args.length; ++i) {
            switch (i) {
                case 0: {
                    id = args[i];
                    continue block16;
                }
                case 1: {
                    try {
                        xmlFactory = (XMLFactoryInterface)Class.forName(args[i]).newInstance();
                    }
                    catch (ClassNotFoundException cnfe) {
                        Log.debug(2, "XMLFactory - CLASS NOT FOUND - trying to do Class.forName(" + args[i] + ")");
                        System.exit(1);
                    }
                    catch (InstantiationException e) {
                        Log.debug(2, "XMLFactory - Error trying to do newInstance() for " + args[i]);
                        e.printStackTrace();
                        System.exit(1);
                    }
                    catch (IllegalAccessException iae) {
                        Log.debug(2, "XMLFactory - IllegalAccessException for " + args[i]);
                        iae.printStackTrace();
                        System.exit(1);
                    }
                    continue block16;
                }
                case 2: {
                    try {
                        listener = (ActionListener)Class.forName(args[i]).newInstance();
                        continue block16;
                    }
                    catch (ClassNotFoundException cnfe) {
                        Log.debug(2, "XMLFactory - CLASS NOT FOUND - trying to do Class.forName(" + args[i] + ")");
                        System.exit(1);
                        continue block16;
                    }
                    catch (InstantiationException e) {
                        Log.debug(2, "XMLFactory - Error trying to do newInstance() for " + args[i]);
                        e.printStackTrace();
                        System.exit(1);
                        continue block16;
                    }
                    catch (IllegalAccessException iae) {
                        Log.debug(50, "XMLFactory - IllegalAccessException for " + args[i]);
                        iae.printStackTrace();
                        System.exit(1);
                    }
                }
            }
        }
        XSLTResolverPlugin xPlugin = xsltResolverPlugin = new XSLTResolverPlugin();
        xPlugin.initialize(null);
        MetaDisplayPlugin plugin = new MetaDisplayPlugin();
        plugin.initialize(null);
        MetaDisplayInterface metaDisplay = plugin.getInstance();
        Component comp = null;
        Log.debug(50, "Getting display component:\n id         = " + id + ";\n XMLFactory = " + xmlFactory + ";\n listener   = " + listener);
        try {
            comp = metaDisplay.getDisplayComponent(id, xmlFactory, listener);
        }
        catch (NullArgumentException nae) {
            Log.debug(50, "NullArgumentException getting metaDisplay! " + nae);
            nae.printStackTrace();
        }
        catch (DocumentNotFoundException dnfe) {
            Log.debug(50, "DocumentNotFoundException getting metaDisplay! " + dnfe);
            dnfe.printStackTrace();
        }
        JFrame frame = new JFrame();
        frame.setBounds(100, 100, 500, 500);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                System.exit(0);
            }
        });
        frame.getContentPane().setLayout(new BorderLayout(5, 5));
        frame.getContentPane().add(comp, "Center");
        frame.setVisible(true);
    }
}

