/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.metadisplay;

import edu.ucsb.nceas.morpho.plugins.MetaDisplayInterface;
import edu.ucsb.nceas.morpho.util.DocumentNotFoundException;
import edu.ucsb.nceas.morpho.util.Log;
import java.awt.Color;
import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HTMLPanel
extends JEditorPane
implements HyperlinkListener {
    private MetaDisplayInterface controller;
    private JScrollPane scrollPane;

    public HTMLPanel(MetaDisplayInterface controller) throws IOException {
        this("<html><head></head><body bgcolor=\"#eeeeee\">&nbsp;</body></html>");
        this.controller = controller;
    }

    public HTMLPanel(String html) throws IOException {
        this.init();
        this.addHyperlinkListener(this);
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        Log.debug(50, "hyperlinkUpdate called; eventType=" + e.getEventType());
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            Log.debug(50, "eventType=ACTIVATED; description=" + e.getDescription() + "; url=" + e.getURL());
            try {
                this.controller.display(e.getDescription());
            }
            catch (DocumentNotFoundException ex) {
                Log.debug(12, "HTMLPanel.hyperlinkUpdate(): DocumentNotFoundException from HyperlinkEvent: " + e.getEventType() + "; exception is: " + ex);
                ex.printStackTrace(System.err);
            }
        }
    }

    private void init() {
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.setBackground(Color.white);
        this.setContentType("text/html");
        this.setEditable(false);
    }

    public void setHTML(String html) {
        Log.debug(51, "\nHTMLPanel.setHTML() received HTML: \n" + html + "\n");
        html = this.stripHTMLMetaTags(html);
        Log.debug(50, "\nHTMLPanel.setHTML() displaying cleaned up HTML:\n" + html);
        try {
            this.setText(html);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Log.debug(12, "HTMLPanel error - invalid HTML mark-up!\n" + html);
            this.setText("<html><head></head><body bgcolor=\"#eeeeee\">&nbsp;</body></html>");
        }
        this.setCaretPosition(0);
    }

    private String stripHTMLMetaTags(String html) {
        boolean META_END = false;
        int META_START = html.indexOf("<META");
        if (META_START >= 0) {
            char[] htmlChars = html.toCharArray();
            int charIndex = META_START;
            int nextChar = 32;
            do {
                nextChar = htmlChars[charIndex];
                htmlChars[charIndex] = 32;
            } while (nextChar != 62 && ++charIndex < htmlChars.length);
            html = String.valueOf(htmlChars);
            return this.stripHTMLMetaTags(html);
        }
        return html;
    }
}

