/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.metadisplay;

import edu.ucsb.nceas.morpho.framework.EditorInterface;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceProvider;
import edu.ucsb.nceas.morpho.plugins.metadisplay.MetaDisplay;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.DocumentNotFoundException;
import edu.ucsb.nceas.morpho.util.IOUtil;
import edu.ucsb.nceas.morpho.util.Log;
import java.awt.event.ActionEvent;
import java.io.IOException;
import org.w3c.dom.Document;

public class EditCommand
implements Command {
    private final MetaDisplay controller;

    EditCommand(MetaDisplay controller) {
        this.controller = controller;
    }

    public void execute(ActionEvent event) {
        EditorInterface editor = null;
        String id = this.controller.getIdentifier();
        Log.debug(50, "EditCommand.execute() firing EDIT_BEGIN_EVENT. ID = " + id);
        this.controller.fireActionEvent(40, id);
        try {
            ServiceController services = ServiceController.getInstance();
            ServiceProvider provider = services.getServiceProvider(EditorInterface.class);
            editor = (EditorInterface)((Object)provider);
        }
        catch (Exception ee) {
            Log.debug(0, "Error acquiring editor plugin: " + ee.getMessage());
            ee.printStackTrace();
            return;
        }
        StringBuffer buffer = new StringBuffer();
        try {
            buffer = IOUtil.getAsStringBuffer(this.controller.getFactory().openAsReader(id), true);
        }
        catch (DocumentNotFoundException dnfe) {
            Log.debug(0, "Error finding file : " + id + " " + dnfe.getMessage());
            dnfe.printStackTrace();
            return;
        }
        catch (IOException ioe) {
            Log.debug(0, "Error reading file : " + id + " " + ioe.getMessage());
            ioe.printStackTrace();
            return;
        }
        String location = null;
        Document thisdoc = this.controller.getFactory().openAsDom(id);
        String entIndS = this.controller.getTransformerProperty("entityindex");
        int entIndex = -1;
        if (entIndS != null) {
            entIndex = new Integer(entIndS) - 1;
        }
        String attrIndS = this.controller.getTransformerProperty("attributeindex");
        int attrIndex = 0;
        if (attrIndS != null) {
            attrIndex = new Integer(attrIndS) - 1;
        }
        if (entIndex > -1) {
            editor.openEditor(thisdoc, id, location, this.controller, "dataTable[" + entIndex + "]/attribute-", attrIndex);
        } else {
            editor.openEditor(thisdoc, id, location, this.controller, null, 0);
        }
    }
}

