/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages;

import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WidgetFactory;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardPageSubPanelAPI;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.CitationPage;
import edu.ucsb.nceas.utilities.OrderedMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

class ReportPanel
extends JPanel
implements WizardPageSubPanelAPI {
    CitationPage parent;
    private JLabel numberLabel;
    private JLabel pagesLabel;
    private JLabel publisherLabel;
    private JTextField numberField;
    private JTextField pagesField;
    private JTextField publisherField;

    ReportPanel(CitationPage page) {
        this.parent = page;
        this.init();
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel publisherPanel = WidgetFactory.makePanel(1);
        this.publisherLabel = WidgetFactory.makeLabel("Publisher:", true);
        publisherPanel.add(this.publisherLabel);
        this.publisherField = WidgetFactory.makeOneLineTextField();
        publisherPanel.add(this.publisherField);
        publisherPanel.setBorder(new EmptyBorder(0, 5, 0, 10));
        this.add(Box.createGlue());
        this.add(publisherPanel);
        this.add(WidgetFactory.makeHalfSpacer());
        this.add(Box.createGlue());
        JPanel numberPanel = WidgetFactory.makePanel(1);
        this.numberLabel = WidgetFactory.makeLabel("Report Number:", true);
        numberPanel.add(this.numberLabel);
        this.numberField = WidgetFactory.makeOneLineTextField();
        numberPanel.add(this.numberField);
        numberPanel.setBorder(new EmptyBorder(0, 5, 0, 10));
        this.add(numberPanel);
        this.add(WidgetFactory.makeHalfSpacer());
        this.add(Box.createGlue());
        JPanel pagesPanel = WidgetFactory.makePanel(1);
        this.pagesLabel = WidgetFactory.makeLabel("Number of Pages:", false);
        pagesPanel.add(this.pagesLabel);
        this.pagesField = WidgetFactory.makeOneLineTextField();
        pagesPanel.add(this.pagesField);
        pagesPanel.setBorder(new EmptyBorder(0, 5, 0, 10));
        this.add(pagesPanel);
        this.add(WidgetFactory.makeHalfSpacer());
        this.add(Box.createGlue());
    }

    public boolean validateUserInput() {
        String text = this.publisherField.getText();
        String numText = this.numberField.getText();
        if (text.trim().equals("")) {
            WidgetFactory.hiliteComponent(this.publisherLabel);
            this.publisherField.requestFocus();
            return false;
        }
        WidgetFactory.unhiliteComponent(this.publisherLabel);
        if (numText.trim().equals("")) {
            WidgetFactory.hiliteComponent(this.numberLabel);
            this.numberField.requestFocus();
            return false;
        }
        WidgetFactory.unhiliteComponent(this.numberLabel);
        return true;
    }

    public void onLoadAction() {
    }

    public OrderedMap getPanelData(String xPathRoot) {
        String pn;
        String pub;
        OrderedMap map = new OrderedMap();
        String rn = this.numberField.getText().trim();
        if (!rn.equals("")) {
            map.put((Object)(xPathRoot + "/reportNumber[1]"), (Object)rn);
        }
        if (!(pub = this.publisherField.getText().trim()).equals("")) {
            map.put((Object)(xPathRoot + "/publisher[1]/organizationName[1]"), (Object)pub);
        }
        if (!(pn = this.pagesField.getText()).trim().equals("")) {
            map.put((Object)(xPathRoot + "/totalPages[1]"), (Object)pn);
        }
        return map;
    }

    public void setPanelData(String xPathRoot, OrderedMap map) {
        String pn;
        String rn;
        String pub = (String)map.get((Object)(xPathRoot + "/publisher[1]/organizationName[1]"));
        if (pub != null) {
            this.publisherField.setText(pub);
            map.remove((Object)(xPathRoot + "/publisher[1]/organizationName[1]"));
        }
        if ((rn = (String)map.get((Object)(xPathRoot + "/reportNumber[1]"))) != null) {
            this.numberField.setText(rn);
            map.remove((Object)(xPathRoot + "/reportNumber[1]"));
        }
        if ((pn = (String)map.get((Object)(xPathRoot + "/totalPages[1]"))) != null) {
            this.pagesField.setText(pn);
            map.remove((Object)(xPathRoot + "/totalPages[1]"));
        }
    }
}

