/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages;

import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.CustomList;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WidgetFactory;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.OrderedMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class KeywordsPage
extends AbstractUIPage {
    private final String pageID = "KEYWORDS_PAGE";
    private final String nextPageID = "";
    private final String pageNumber = "";
    private final String title = "Keywords Page";
    private final String subtitle = "";
    private final String EMPTY_STRING = "";
    private JTextField thesaurusField;
    private JLabel thesaurusLabel;
    private JLabel kwLabel;
    private CustomList kwList;
    private JPanel middlePanel;
    private JPanel radioPanel;
    private final String[] buttonsText = new String[]{"These keywords are not chosen from a predefined list:", "These keywords are chosen from a predefined list:"};
    private String xPathRoot = "/eml:eml/dataset/keywordSet[1]";
    private final String KEYWORD_REL_XPATH = "keyword[";
    private final String THESAURUS_REL_XPATH = "keywordThesaurus[1]";
    private ActionListener listener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            Log.debug(45, "got radiobutton command: " + e.getActionCommand());
            KeywordsPage.this.onLoadAction();
            if (e.getActionCommand().equals(KeywordsPage.this.buttonsText[0])) {
                KeywordsPage.this.thesaurusField.setVisible(false);
                KeywordsPage.this.thesaurusLabel.setVisible(false);
                KeywordsPage.this.thesaurusField.setText("");
            } else if (e.getActionCommand().equals(KeywordsPage.this.buttonsText[1])) {
                KeywordsPage.this.thesaurusField.setVisible(true);
                KeywordsPage.this.thesaurusLabel.setVisible(true);
            }
        }
    };
    private final StringBuffer surrogateBuff = new StringBuffer();
    private OrderedMap returnMap = new OrderedMap();
    private final OrderedMap listResultsMap = new OrderedMap();
    private final StringBuffer listResultsBuff = new StringBuffer();

    public KeywordsPage() {
        this.init();
    }

    private void init() {
        this.middlePanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.middlePanel.setLayout(new BoxLayout(this.middlePanel, 1));
        this.middlePanel.add(WidgetFactory.makeDefaultSpacer());
        JLabel desc = WidgetFactory.makeHTMLLabel("<font size=\"4\"><b>Define Keyword Set:</b></font>", 1);
        this.middlePanel.add(desc);
        this.middlePanel.add(WidgetFactory.makeDefaultSpacer());
        this.middlePanel.add(WidgetFactory.makeDefaultSpacer());
        JPanel kwPanel = WidgetFactory.makePanel(16);
        this.kwLabel = WidgetFactory.makeLabel("Keywords:", true);
        kwPanel.add(this.kwLabel);
        this.kwList = WidgetFactory.makeList(new String[]{"Keyword"}, new Object[]{new JTextField()}, 8, true, false, false, true, true, true);
        kwPanel.add(this.kwList);
        this.middlePanel.add(kwPanel);
        this.radioPanel = WidgetFactory.makeRadioPanel(this.buttonsText, 0, this.listener);
        this.middlePanel.add(WidgetFactory.makeDefaultSpacer());
        this.middlePanel.add(this.radioPanel);
        JPanel thesaurusPanel = WidgetFactory.makePanel(1);
        this.thesaurusLabel = WidgetFactory.makeLabel("Thesaurus name:", false);
        thesaurusPanel.add(this.thesaurusLabel);
        this.thesaurusLabel.setVisible(false);
        this.thesaurusField = WidgetFactory.makeOneLineTextField();
        this.thesaurusField.setVisible(false);
        thesaurusPanel.add(this.thesaurusField);
        thesaurusPanel.setBorder(new EmptyBorder(0, 0, 0, 5));
        this.middlePanel.add(WidgetFactory.makeHalfSpacer());
        this.middlePanel.add(thesaurusPanel);
        this.middlePanel.setBorder(new EmptyBorder(0, 20, 35, 40));
        this.add((Component)this.middlePanel, "Center");
    }

    public boolean onAdvanceAction() {
        OrderedMap listNVP = this.getKWListAsNVP("");
        if (listNVP == null || listNVP.size() < 1) {
            WidgetFactory.hiliteComponent(this.kwLabel);
            return false;
        }
        return true;
    }

    public List getSurrogate() {
        WidgetFactory.unhiliteComponent(this.kwLabel);
        ArrayList<String> surrogate = new ArrayList<String>();
        this.surrogateBuff.delete(0, this.surrogateBuff.length());
        List rowLists = this.kwList.getListOfRowLists();
        boolean firstKW = true;
        String nextKW = null;
        for (Object nextRowObj : rowLists) {
            List nextRow;
            if (nextRowObj == null || (nextRow = (List)nextRowObj).size() < 1 || nextRow.get(0) == null || (nextKW = ((String)nextRow.get(0)).trim()).equals("")) continue;
            if (firstKW) {
                firstKW = false;
            } else {
                this.surrogateBuff.append(", ");
            }
            this.surrogateBuff.append(nextKW);
        }
        surrogate.add(this.surrogateBuff.toString());
        String thesaurus = this.thesaurusField.getText().trim();
        if (thesaurus == null) {
            thesaurus = "";
        }
        surrogate.add(thesaurus);
        return surrogate;
    }

    public OrderedMap getPageData() {
        return this.getPageData(this.xPathRoot);
    }

    public OrderedMap getPageData(String xPathRoot) {
        this.returnMap.clear();
        this.returnMap.putAll((Map)this.getKWListAsNVP(xPathRoot));
        String thesaurus = this.thesaurusField.getText().trim();
        if (thesaurus != null && !thesaurus.equals("")) {
            this.returnMap.put((Object)(xPathRoot + "/keywordThesaurus"), (Object)thesaurus);
        }
        return this.returnMap;
    }

    private OrderedMap getKWListAsNVP(String xPathRoot) {
        this.listResultsMap.clear();
        this.kwList.deleteEmptyRows((short)51, new short[]{10});
        int rowNumber = -1;
        int predicateIndex = 0;
        List rowLists = this.kwList.getListOfRowLists();
        String nextKWType = null;
        Iterator it = rowLists.iterator();
        while (it.hasNext()) {
            List nextRow;
            ++rowNumber;
            Object nextRowObj = it.next();
            if (nextRowObj == null || (nextRow = (List)nextRowObj).size() < 1) continue;
            this.listResultsBuff.delete(0, this.listResultsBuff.length());
            this.listResultsBuff.append(xPathRoot);
            this.listResultsBuff.append("/keyword[");
            this.listResultsBuff.append(++predicateIndex);
            this.listResultsBuff.append("]");
            this.listResultsMap.put((Object)this.listResultsBuff.toString(), (Object)((String)nextRow.get(0)).trim());
            if (nextRow.get(1) == null || (nextKWType = ((String)nextRow.get(1)).trim()).equals("")) continue;
            this.listResultsBuff.delete(0, this.listResultsBuff.length());
            this.listResultsBuff.append(xPathRoot);
            this.listResultsBuff.append("/keyword[");
            this.listResultsBuff.append(predicateIndex);
            this.listResultsBuff.append("]/@keywordType");
            this.listResultsMap.put((Object)this.listResultsBuff.toString(), (Object)nextKWType);
        }
        return this.listResultsMap;
    }

    public void onRewindAction() {
    }

    public void onLoadAction() {
    }

    public String getPageID() {
        return this.pageID;
    }

    public String getTitle() {
        return "Keywords Page";
    }

    public String getSubtitle() {
        return "";
    }

    public String getNextPageID() {
        this.getClass();
        return "";
    }

    public String getPageNumber() {
        return "";
    }

    private void resetBlankData() {
        this.radioPanel.removeAll();
        this.radioPanel.add(WidgetFactory.makeRadioPanel(this.buttonsText, 0, this.listener));
        this.thesaurusField.setText("");
        this.kwList.removeAllRows();
    }

    public boolean setPageData(OrderedMap map, String _xPathRoot) {
        if (_xPathRoot != null && _xPathRoot.trim().length() > 0) {
            this.xPathRoot = _xPathRoot;
        }
        if (map == null || map.isEmpty()) {
            this.resetBlankData();
            return true;
        }
        ArrayList toDeleteList = new ArrayList();
        Iterator keyIt = map.keySet().iterator();
        Object nextXPathObj = null;
        String nextXPath = null;
        Object nextValObj = null;
        String nextVal = null;
        ArrayList keywordList = new ArrayList();
        while (keyIt.hasNext()) {
            nextXPathObj = keyIt.next();
            if (nextXPathObj == null) continue;
            nextXPath = (String)nextXPathObj;
            nextValObj = map.get(nextXPathObj);
            nextVal = nextValObj == null ? "" : ((String)nextValObj).trim();
            Log.debug(45, "Keyword:  nextXPath = " + nextXPath + "\n nextVal   = " + nextVal);
            if (nextXPath.indexOf("keyword[") > -1) {
                Log.debug(45, ">>>>>>>>>> adding to kwList: nextXPathObj=" + nextXPathObj + "; nextValObj=" + nextValObj);
                ArrayList<String> newRow = new ArrayList<String>();
                newRow.add(nextVal);
                this.kwList.addRow(newRow);
                toDeleteList.add(nextXPathObj);
                continue;
            }
            if (nextXPath.indexOf("keywordThesaurus[1]") <= -1) continue;
            Log.debug(45, ">>>>>>>>>> adding to thesaurus: nextXPathObj=" + nextXPathObj + "; nextValObj=" + nextValObj);
            this.radioPanel.removeAll();
            this.radioPanel.add(WidgetFactory.makeRadioPanel(this.buttonsText, 1, this.listener));
            this.thesaurusField.setVisible(true);
            this.thesaurusField.setEnabled(true);
            this.thesaurusField.setText(nextVal);
            toDeleteList.add(nextXPathObj);
        }
        Iterator dlIt = toDeleteList.iterator();
        while (dlIt.hasNext()) {
            map.remove(dlIt.next());
        }
        boolean returnVal = map.isEmpty();
        if (!returnVal) {
            Log.debug(20, "Keyword.setPageData returning FALSE! Map still contains:" + map);
        }
        return returnVal;
    }
}

