/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages;

import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.AbstractCellEditor;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.AccessTreeCellRenderer;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.TreeTableModel;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.TreeTableModelAdapter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;

public class JTreeTable
extends JTable {
    protected TreeTableCellRenderer tree;

    public JTreeTable(TreeTableModel treeTableModel) {
        this.tree = new TreeTableCellRenderer(treeTableModel);
        super.setModel(new TreeTableModelAdapter(treeTableModel, this.tree));
        this.tree.setSelectionModel(new DefaultTreeSelectionModel(){
            {
                JTreeTable.this.setSelectionModel(this.listSelectionModel);
            }
        });
        this.tree.setCellRenderer(new AccessTreeCellRenderer());
        this.tree.setRowHeight(this.getRowHeight());
        this.setDefaultRenderer(TreeTableModel.class, this.tree);
        this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor());
        this.setSelectionMode(0);
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(1, 1));
    }

    public void expandIt(int row) {
        this.tree.expandRow(row);
    }

    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == TreeTableModel.class ? -1 : this.editingRow;
    }

    public class TreeTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int r, int c) {
            return JTreeTable.this.tree;
        }
    }

    public class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        protected int visibleRow;

        public TreeTableCellRenderer(TreeModel model) {
            super(model);
        }

        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, 0, w, JTreeTable.this.getHeight());
        }

        public void paint(Graphics g) {
            g.translate(0, -this.visibleRow * this.getRowHeight());
            super.paint(g);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            this.visibleRow = row;
            return this;
        }
    }
}

