/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages;

import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.framework.ModalDialog;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.CustomList;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WidgetFactory;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardContainerFrame;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardPageLibrary;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.GeographicPage;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.OrderedMap;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;

public class Geographic
extends AbstractUIPage {
    private final String pageID = "GEOGRAPHIC";
    private final String nextPageID = "TEMPORAL";
    private final String title = "Geographic Coverage";
    private final String subtitle = "";
    private final String xPathRoot = "/eml:eml/dataset/coverage/geographicCoverage[";
    private final String pageNumber = "10";
    private final String[] colNames = new String[]{"Description", "Geographic Coverage"};
    private final Object[] editors = null;
    private CustomList geographicspanList;
    private OrderedMap returnMap = new OrderedMap();

    public Geographic() {
        this.init();
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 1));
        Geographic vbox = this;
        vbox.add(WidgetFactory.makeDefaultSpacer());
        JLabel desc = WidgetFactory.makeHTMLLabel("<b>Describe the geographic region covered by your data</b>. Use the following screen to provide a complete description or assign one of the existing descriptions.", 3);
        vbox.add(desc);
        vbox.add(WidgetFactory.makeDefaultSpacer());
        vbox.add(WidgetFactory.makeDefaultSpacer());
        this.geographicspanList = WidgetFactory.makeList(this.colNames, this.editors, 4, true, true, false, true, true, true);
        this.geographicspanList.setBorder(new EmptyBorder(0, 5, 5, 10));
        vbox.add(this.geographicspanList);
        vbox.add(WidgetFactory.makeDefaultSpacer());
        this.initActions();
    }

    private void initActions() {
        this.geographicspanList.setCustomAddAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Log.debug(45, "\nGeographic: CustomAddAction called");
                Geographic.this.showNewGeographicDialog();
            }
        });
        this.geographicspanList.setCustomEditAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Log.debug(45, "\nGeographic: CustomEditAction called");
                Geographic.this.showEditGeographicDialog();
            }
        });
    }

    private void showNewGeographicDialog() {
        GeographicPage geographicPage = (GeographicPage)WizardPageLibrary.getPage("GEOGRAPHIC_PAGE");
        ModalDialog wpd = new ModalDialog(geographicPage, WizardContainerFrame.getDialogParent(), 770, 570, false);
        wpd.setVisible(true);
        if (wpd.USER_RESPONSE == 10) {
            List newRow = geographicPage.getSurrogate();
            newRow.add(geographicPage);
            this.geographicspanList.addRow(newRow);
        }
    }

    private void showEditGeographicDialog() {
        List selRowList = this.geographicspanList.getSelectedRowList();
        if (selRowList == null || selRowList.size() < 3) {
            return;
        }
        Object dialogObj = selRowList.get(2);
        if (dialogObj == null || !(dialogObj instanceof GeographicPage)) {
            return;
        }
        GeographicPage editGeographicPage = (GeographicPage)dialogObj;
        ModalDialog wpd = new ModalDialog(editGeographicPage, WizardContainerFrame.getDialogParent(), 770, 570, false);
        wpd.resetBounds();
        wpd.setVisible(true);
        if (wpd.USER_RESPONSE == 10) {
            List newRow = editGeographicPage.getSurrogate();
            newRow.add(editGeographicPage);
            this.geographicspanList.replaceSelectedRow(newRow);
        }
    }

    public void onLoadAction() {
    }

    public void onRewindAction() {
    }

    public boolean onAdvanceAction() {
        return true;
    }

    public OrderedMap getPageData(String xPath) {
        this.returnMap.clear();
        int index = 1;
        Object nextRowObj2 = null;
        List nextRowList = null;
        Object nextUserObject = null;
        OrderedMap nextNVPMap = null;
        GeographicPage nextGeographicPage = null;
        List rowLists = this.geographicspanList.getListOfRowLists();
        if (rowLists == null) {
            return null;
        }
        for (Object nextRowObj2 : rowLists) {
            if (nextRowObj2 == null || (nextRowList = (List)nextRowObj2).size() < 3 || (nextUserObject = nextRowList.get(2)) == null) continue;
            nextGeographicPage = nextUserObject;
            nextNVPMap = nextGeographicPage.getPageData(xPath + index++ + "]");
            this.returnMap.putAll((Map)nextNVPMap);
        }
        return this.returnMap;
    }

    public OrderedMap getPageData() {
        return this.getPageData("/eml:eml/dataset/coverage/geographicCoverage[");
    }

    public String getPageID() {
        return "GEOGRAPHIC";
    }

    public String getTitle() {
        return "Geographic Coverage";
    }

    public String getSubtitle() {
        return "";
    }

    public String getNextPageID() {
        return "TEMPORAL";
    }

    public String getPageNumber() {
        return "10";
    }

    public boolean setPageData(OrderedMap data, String xPathRoot) {
        if (xPathRoot.equals("removeAllRows")) {
            this.geographicspanList.removeAllRows();
        }
        boolean res = true;
        GeographicPage geographicPage = (GeographicPage)WizardPageLibrary.getPage("GEOGRAPHIC_PAGE");
        data.remove((Object)"/geographicCoverage/@scope");
        data.remove((Object)"/geographicCoverage/@id");
        boolean flag = geographicPage.setPageData(data, "/geographicCoverage");
        if (!flag) {
            res = false;
        }
        List newRow = geographicPage.getSurrogate();
        newRow.add(geographicPage);
        this.geographicspanList.addRow(newRow);
        return res;
    }
}

