/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.datapackage.DataViewContainerPanel;
import edu.ucsb.nceas.morpho.datastore.FileSystemDataStore;
import edu.ucsb.nceas.morpho.datastore.MetacatDataStore;
import edu.ucsb.nceas.morpho.framework.ConfigXML;
import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.CustomTable;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WidgetFactory;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardPageSubPanelAPI;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardSettings;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.CustomPopupHandler;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.TaxonImportPanel;
import edu.ucsb.nceas.morpho.util.Base64;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.OrderedMap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class CodeDefnPanel
extends JPanel
implements WizardPageSubPanelAPI {
    private final String title = "Import Codes and Definitions";
    private final String subtitle = "";
    public short USER_RESPONSE;
    public static final short CANCEL_OPTION = 20;
    private String[] importChoiceText = new String[]{"Import the definitions table into Morpho later", "The definitions table has already been included in this package"};
    private JLabel choiceLabel;
    private JPanel radioPanel;
    private JPanel definitionsPanel;
    private String[] entityNames = null;
    private String[] attrNames = null;
    private Vector rowData;
    private Vector tableNames;
    private Vector colNames;
    private CustomTable table;
    private short selectedImportChoice = 0;
    private static final int IMPORT_LATER = 1;
    private static final int IMPORT_DONE = 2;
    private static final String ID_XPATH = "attribute/@id";
    private static final String TRUNCATE_STRING = "--truncated--";
    private int entityIdx = -1;
    private String currentEntityID = "";
    private String codeAttributeID = "";
    private String defnAttributeID = "";
    private static Node[] attributeArray = null;
    private AbstractDataPackage adp = null;
    private DataViewContainerPanel resultPane = null;
    private ItemListener namePickListListener;
    private boolean onlyDefnPanel = false;
    private boolean createDataTable = true;

    public CodeDefnPanel() {
        this(false, true);
    }

    public CodeDefnPanel(boolean onlyDefinitionsPanel) {
        this(onlyDefinitionsPanel, true);
    }

    public CodeDefnPanel(boolean onlyDefinitionsPanel, boolean createDataTable) {
        this.onlyDefnPanel = onlyDefinitionsPanel;
        if (this.onlyDefnPanel) {
            this.selectedImportChoice = (short)2;
        }
        this.createDataTable = createDataTable;
        this.init();
    }

    private void init() {
        this.getADP();
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 1));
        this.choiceLabel = WidgetFactory.makeHTMLLabel("Select one of the following", 1, true);
        topPanel.add(this.choiceLabel);
        topPanel.add(WidgetFactory.makeDefaultSpacer());
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Log.debug(45, "got radiobutton command: " + e.getActionCommand());
                if (e.getActionCommand().equals(CodeDefnPanel.this.importChoiceText[0])) {
                    CodeDefnPanel.this.selectedImportChoice = (short)1;
                    CodeDefnPanel.this.definitionsPanel.setVisible(false);
                } else if (e.getActionCommand().equals(CodeDefnPanel.this.importChoiceText[1])) {
                    CodeDefnPanel.this.selectedImportChoice = (short)2;
                    CodeDefnPanel.this.definitionsPanel.setVisible(true);
                }
            }
        };
        this.radioPanel = WidgetFactory.makeRadioPanel(this.importChoiceText, -1, listener);
        topPanel.add(this.radioPanel);
        if (!this.onlyDefnPanel) {
            this.add((Component)topPanel, "North");
        }
        this.definitionsPanel = this.getDefinitionsPanel();
        this.add((Component)this.definitionsPanel, "Center");
        if (!this.onlyDefnPanel) {
            this.definitionsPanel.setVisible(false);
        }
    }

    private JPanel getDefinitionsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JLabel headLabel = WidgetFactory.makeHTMLLabel("Select the two columns that define \tthe codes and definitions. The selected columns should be in the same data table.", 2, false);
        panel.add((Component)headLabel, "North");
        if (this.adp == null) {
            this.getADP();
        }
        if (this.adp == null) {
            Log.debug(5, "Unable to obtain the AbstractDataPackage in the CodeImportPanel");
            return panel;
        }
        Morpho morpho = null;
        if (this.resultPane != null) {
            morpho = this.resultPane.getFramework();
        }
        this.entityNames = this.getEntityNames();
        this.tableNames = new Vector();
        this.colNames = new Vector();
        this.rowData = new Vector();
        if (!this.createDataTable) {
            return panel;
        }
        for (int i = 0; i < this.entityNames.length; ++i) {
            int idx = this.adp.getEntityIndex(this.entityNames[i]);
            boolean text_file = false;
            this.attrNames = this.getAttributeNames(idx);
            File entityFile = CodeDefnPanel.getEntityFile(morpho, this.adp, idx);
            if (entityFile == null) continue;
            String format = this.adp.getPhysicalFormat(idx, 0);
            if (format.indexOf("Text") > -1 || format.indexOf("text") > -1 || format.indexOf("Asci") > -1 || format.indexOf("asci") > -1) {
                text_file = true;
            }
            Vector<Integer> colsToExtract = new Vector<Integer>();
            for (int j = 0; j < this.attrNames.length; ++j) {
                colsToExtract.add(new Integer(j));
            }
            String numHeaders = this.adp.getPhysicalNumberHeaderLines(idx, 0);
            int numHeaderLines = 0;
            try {
                if (numHeaders != null) {
                    numHeaderLines = Integer.parseInt(numHeaders);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            String field_delimiter = this.adp.getPhysicalFieldDelimiter(idx, 0);
            String delimiter = this.getDelimiterString(field_delimiter);
            boolean ignoreConsecutiveDelimiters = this.adp.ignoreConsecutiveDelimiters(idx, 0);
            List<ArrayList<String>> data = null;
            if (text_file) {
                data = CodeDefnPanel.getColumnValues(entityFile, colsToExtract, numHeaderLines, delimiter, ignoreConsecutiveDelimiters, 25);
            } else {
                data = new ArrayList();
                ArrayList<String> row1 = new ArrayList<String>();
                for (int ci = 0; ci < colsToExtract.size(); ++ci) {
                    row1.add("**nontext**");
                }
                data.add(row1);
            }
            for (int k = 0; k < this.attrNames.length; ++k) {
                this.tableNames.add(this.entityNames[i]);
                this.colNames.add(this.attrNames[k]);
            }
            TaxonImportPanel.addColumnsToRowData(this.rowData, data);
        }
        Vector<Vector> headerVector = new Vector<Vector>();
        headerVector.add(this.tableNames);
        headerVector.add(this.colNames);
        this.table = new CustomTable(headerVector, this.rowData);
        this.table.addPopupListener(new CustomPopupHandler());
        panel.add((Component)this.table, "Center");
        return panel;
    }

    private void getADP() {
        this.adp = UIController.getInstance().getCurrentAbstractDataPackage();
        MorphoFrame morphoFrame = UIController.getInstance().getCurrentActiveWindow();
        if (morphoFrame != null) {
            this.resultPane = morphoFrame.getDataViewContainerPanel();
        }
    }

    private String[] getEntityNames() {
        if (this.entityNames != null) {
            return this.entityNames;
        }
        if (this.adp == null) {
            this.getADP();
        }
        String[] entNames = new String[]{};
        if (this.adp != null) {
            int cnt = this.adp.getEntityCount();
            entNames = new String[cnt];
            for (int i = 0; i < cnt; ++i) {
                entNames[i] = this.adp.getEntityName(i);
            }
        } else {
            Log.debug(45, "Error - Unable to get the AbstractDataPackage in CodeImportPanel. ");
        }
        return entNames;
    }

    public String getTableName() {
        if (this.selectedImportChoice == 1 || this.entityNames == null) {
            return null;
        }
        int[] arr = this.table.getSelectedColumns();
        if (arr == null || arr.length < 1) {
            return null;
        }
        Vector header = this.table.getColumnHeaderStrings(arr[0]);
        if (header == null) {
            return null;
        }
        return (String)header.get(0);
    }

    public void setTable(String tableName, List columns, Vector data) {
        this.entityNames = new String[1];
        this.entityNames[0] = tableName;
        this.attrNames = new String[columns.size()];
        this.tableNames = new Vector();
        this.colNames = new Vector();
        this.rowData = data;
        Iterator it = columns.iterator();
        int cnt = 0;
        while (it.hasNext()) {
            String col = (String)it.next();
            this.tableNames.add(tableName);
            this.colNames.add(col);
            this.attrNames[cnt++] = col;
        }
        Vector<Vector> headerInfo = new Vector<Vector>();
        headerInfo.add(this.tableNames);
        headerInfo.add(this.colNames);
        if (this.table != null) {
            this.definitionsPanel.remove(this.table);
        }
        this.table = new CustomTable(headerInfo, this.rowData);
        this.table.addPopupListener(new CustomPopupHandler());
        this.definitionsPanel.add((Component)this.table, "Center");
        this.definitionsPanel.validate();
        this.definitionsPanel.repaint();
    }

    public int getSelectedEntityIndex() {
        String table = this.getTableName();
        if (this.adp == null) {
            return -1;
        }
        if (table == null) {
            return -1;
        }
        return this.adp.getEntityIndex(table);
    }

    private String[] getAttributeNames(int entityIndex) {
        ArrayList names = new ArrayList();
        String[] attrs = new String[]{};
        if (this.adp != null) {
            int num = this.adp.getAttributeCountForAnEntity(entityIndex);
            attrs = new String[num];
            for (int i = 0; i < num; ++i) {
                attrs[i] = this.adp.getAttributeName(entityIndex, i);
            }
        }
        return attrs;
    }

    public void onLoadAction() {
    }

    public boolean validateUserInput() {
        String type2;
        String table2;
        if (this.selectedImportChoice != 1 && this.selectedImportChoice != 2) {
            WidgetFactory.hiliteComponent(this.choiceLabel);
            return false;
        }
        WidgetFactory.unhiliteComponent(this.choiceLabel);
        if (this.selectedImportChoice == 1) {
            return true;
        }
        int[] sel = this.table.getSelectedColumns();
        if (sel.length != 2) {
            JOptionPane.showMessageDialog(this, "Select exactly two columns", "Error", 0);
            return false;
        }
        Vector header1 = this.table.getColumnHeaderStrings(sel[0]);
        Vector header2 = this.table.getColumnHeaderStrings(sel[1]);
        String table1 = (String)header1.get(0);
        if (!table1.equals(table2 = (String)header2.get(0))) {
            JOptionPane.showMessageDialog(this, "Both columns need to be selected from the same data table", "Error", 0);
            return false;
        }
        if (header1.size() < 3 || header2.size() < 3) {
            JOptionPane.showMessageDialog(this, "Select the data type (Code/Definition) for both the columns", "Error", 0);
            return false;
        }
        String type1 = (String)header1.get(2);
        if (type1.equals(type2 = (String)header2.get(2))) {
            JOptionPane.showMessageDialog(this, "Select one column for codes and one for definition", "Error", 0);
            return false;
        }
        this.entityIdx = this.getSelectedEntityIndex();
        if (this.entityIdx < 0) {
            return true;
        }
        this.currentEntityID = this.adp.getEntityID(this.entityIdx);
        if (this.adp != null) {
            int codeIndex = this.getCodeColumnIndex();
            int defnIndex = this.getDefnColumnIndex();
            if (this.currentEntityID.trim().equals("")) {
                this.currentEntityID = WizardSettings.getUniqueID();
                Log.debug(15, "Entity doesnt have an enity ID - assigning it a new ID of " + this.currentEntityID);
                this.adp.setEntityID(this.entityIdx, this.currentEntityID);
            }
            if (codeIndex >= 0) {
                this.codeAttributeID = this.adp.getAttributeID(this.entityIdx, codeIndex);
            }
            if (this.codeAttributeID.trim() == "" && codeIndex >= 0) {
                Log.debug(15, "Attribute " + this.adp.getAttributeName(this.entityIdx, codeIndex) + "has no ID; assigning one now");
                this.codeAttributeID = WizardSettings.getUniqueID();
                this.assignIDToAttribute(codeIndex, this.codeAttributeID);
            }
            Log.debug(45, "Code AttributeID = " + this.codeAttributeID);
            if (defnIndex >= 0) {
                this.defnAttributeID = this.adp.getAttributeID(this.entityIdx, defnIndex);
            }
            if (this.defnAttributeID.trim() == "" && defnIndex >= 0) {
                Log.debug(15, "Attribute " + this.adp.getAttributeName(this.entityIdx, defnIndex) + " has no ID; assigning one now");
                this.defnAttributeID = WizardSettings.getUniqueID();
                this.assignIDToAttribute(defnIndex, this.defnAttributeID);
            }
            Log.debug(45, "Defn AttributeID = " + this.defnAttributeID);
        } else {
            Log.debug(25, "No AbstractDataPackage found! Hence IDs could not be retrieved!");
        }
        return true;
    }

    private void assignIDToAttribute(int attrIndex, String value) {
        if (this.adp == null) {
            Log.debug(15, "Abstract Data Package is null ! Cant assign ID to attribute");
        }
        if (attributeArray == null) {
            attributeArray = this.adp.getAttributeArray(this.entityIdx);
        }
        if (attributeArray[attrIndex] == null) {
            Log.debug(15, " attribute node itself is null; Cant assign ID to it");
            return;
        }
        Log.debug(45, "attribute node =" + attributeArray[attrIndex].getNodeName() + ";" + attributeArray[attrIndex].getNodeValue());
        NamedNodeMap map = attributeArray[attrIndex].getAttributes();
        Node oldIdNode = map.getNamedItem("id");
        if (oldIdNode != null) {
            attributeArray[attrIndex].removeChild(oldIdNode);
            oldIdNode.setNodeValue(value);
            attributeArray[attrIndex].appendChild(oldIdNode);
        } else {
            Log.debug(45, "Attribute element has no 'id' attribute. Adding it.");
            ((Element)attributeArray[attrIndex]).setAttribute("id", value);
        }
        this.adp.setLocation("");
    }

    public OrderedMap getPanelData() {
        return this.getPanelData("");
    }

    private int getCodeColumnIndex() {
        if (this.adp == null) {
            return -1;
        }
        int[] arr = this.table.getSelectedColumns();
        if (arr.length != 2) {
            return -1;
        }
        Vector header = this.table.getColumnHeaderStrings(arr[0]);
        String colType = (String)header.get(2);
        if (colType.equalsIgnoreCase("Code")) {
            String colName = (String)header.get(1);
            return this.adp.getAttributeIndex(this.getSelectedEntityIndex(), colName);
        }
        header = this.table.getColumnHeaderStrings(arr[1]);
        colType = (String)header.get(2);
        if (colType.equalsIgnoreCase("Code")) {
            String colName = (String)header.get(1);
            return this.adp.getAttributeIndex(this.getSelectedEntityIndex(), colName);
        }
        return -1;
    }

    private int getDefnColumnIndex() {
        if (this.adp == null) {
            return -1;
        }
        int[] arr = this.table.getSelectedColumns();
        if (arr.length != 2) {
            return -1;
        }
        Vector header = this.table.getColumnHeaderStrings(arr[0]);
        String colType = (String)header.get(2);
        if (colType.equalsIgnoreCase("Definition")) {
            String colName = (String)header.get(1);
            return this.adp.getAttributeIndex(this.getSelectedEntityIndex(), colName);
        }
        header = this.table.getColumnHeaderStrings(arr[1]);
        colType = (String)header.get(2);
        if (colType.equalsIgnoreCase("Definition")) {
            String colName = (String)header.get(1);
            return this.adp.getAttributeIndex(this.getSelectedEntityIndex(), colName);
        }
        return -1;
    }

    public OrderedMap getPanelData(String xPath) {
        OrderedMap map = new OrderedMap();
        int eIdx = this.getSelectedEntityIndex();
        if (this.adp != null && this.currentEntityID.equals("") && eIdx >= 0) {
            this.currentEntityID = this.adp.getEntityID(eIdx);
        }
        if (this.adp != null && this.codeAttributeID.equals("") && eIdx >= 0) {
            this.codeAttributeID = this.adp.getAttributeID(eIdx, this.getCodeColumnIndex());
        }
        if (this.adp != null && this.defnAttributeID.equals("") && eIdx >= 0) {
            this.defnAttributeID = this.adp.getAttributeID(eIdx, this.getDefnColumnIndex());
        }
        map.put((Object)(xPath + "/entityReference"), (Object)this.currentEntityID);
        map.put((Object)(xPath + "/valueAttributeReference"), (Object)this.codeAttributeID);
        map.put((Object)(xPath + "/definitionAttributeReference"), (Object)this.defnAttributeID);
        return map;
    }

    public void setPanelData(OrderedMap data) {
        boolean b1 = data.containsKey((Object)"/eml:eml/dataset/dataTable/attributeList/attribute/measurementScale/nominal/nonNumericDomain/enumeratedDomain/entityCodeList/entityReference");
        if (b1) {
            this.setPanelData("/eml:eml/dataset/dataTable/attributeList/attribute/measurementScale/nominal/nonNumericDomain/enumeratedDomain/entityCodeList", data);
        } else {
            b1 = data.containsKey((Object)"/eml:eml/dataset/dataTable/attributeList/attribute/measurementScale/ordinal/nonNumericDomain/enumeratedDomain/entityCodeList/entityReference");
            if (b1) {
                this.setPanelData("/eml:eml/dataset/dataTable/attributeList/attribute/measurementScale/ordinal/nonNumericDomain/enumeratedDomain/entityCodeList", data);
            }
        }
    }

    public void setPanelData(String xPath, OrderedMap data) {
        Object o1 = data.get((Object)(xPath + "/entityReference"));
        data.remove((Object)(xPath + "/entityReference"));
        Container c = (Container)this.radioPanel.getComponent(1);
        if (o1 == null) {
            JRadioButton jrb = (JRadioButton)c.getComponent(0);
            jrb.setSelected(true);
            this.selectedImportChoice = 1;
            this.definitionsPanel.setVisible(false);
            return;
        }
        JRadioButton jrb = (JRadioButton)c.getComponent(1);
        jrb.setSelected(true);
        this.selectedImportChoice = (short)2;
        this.definitionsPanel.setVisible(true);
        this.currentEntityID = (String)o1;
        this.codeAttributeID = (String)data.get((Object)(xPath + "/valueAttributeReference"));
        this.defnAttributeID = (String)data.get((Object)(xPath + "/definitionAttributeReference"));
        data.remove((Object)(xPath + "/valueAttributeReference"));
        data.remove((Object)(xPath + "/definitionAttributeReference"));
        int[] selectedCols = new int[2];
        boolean codeSelected = false;
        boolean defnSelected = false;
        int colCount = 0;
        block0: for (int i = 0; i < this.entityNames.length; ++i) {
            int entIdx = this.adp.getEntityIndex(this.entityNames[i]);
            String eID = this.adp.getEntityID(i);
            int attrCnt = this.adp.getAttributeCountForAnEntity(entIdx);
            if (!eID.equals(this.currentEntityID)) {
                colCount += attrCnt;
                continue;
            }
            for (int j = 0; j < attrCnt; ++j) {
                String ID = this.adp.getAttributeID(entIdx, j);
                if (ID.equals(this.codeAttributeID)) {
                    selectedCols[0] = colCount;
                    this.table.setExtraColumnHeaderInfo(colCount, "Code");
                    codeSelected = true;
                } else if (ID.equals(this.defnAttributeID)) {
                    selectedCols[1] = colCount;
                    this.table.setExtraColumnHeaderInfo(colCount, "Definition");
                    defnSelected = true;
                }
                ++colCount;
                if (!codeSelected || !defnSelected) continue;
                this.table.setSelectedColumns(selectedCols);
                break block0;
            }
            break;
        }
    }

    private JLabel getLabel(String text) {
        if (text == null) {
            text = "";
        }
        JLabel label = new JLabel(text);
        label.setAlignmentX(1.0f);
        label.setFont(WizardSettings.WIZARD_CONTENT_FONT);
        label.setBorder(BorderFactory.createMatteBorder(1, 10, 1, 3, (Color)null));
        return label;
    }

    public List getColumnData() {
        ArrayList result = new ArrayList();
        if (this.rowData == null) {
            return null;
        }
        int[] cols = this.table.getSelectedColumns();
        if (cols.length != 2) {
            return null;
        }
        int codeIdx = cols[0];
        int defnIdx = cols[1];
        Vector header = this.table.getColumnHeaderStrings(cols[0]);
        if (header.size() < 3) {
            return null;
        }
        String type = (String)header.get(2);
        if (type.equalsIgnoreCase("Definition")) {
            codeIdx = cols[1];
            defnIdx = cols[0];
        }
        Iterator it = this.rowData.iterator();
        while (it.hasNext()) {
            ArrayList t = new ArrayList();
            Vector row = (Vector)it.next();
            t.add(row.get(codeIdx));
            t.add(row.get(defnIdx));
            result.add(t);
        }
        return result;
    }

    public static File getEntityFile(Morpho morpho, AbstractDataPackage adp, int entityIndex) {
        File entityFile;
        block18: {
            block20: {
                block19: {
                    if (morpho == null) {
                        return null;
                    }
                    entityFile = null;
                    String inline = adp.getDistributionInlineData(entityIndex, 0, 0);
                    if (inline.length() <= 0) break block19;
                    String encMethod = adp.getEncodingMethod(entityIndex, 0);
                    if (encMethod.indexOf("Base64") > -1 || encMethod.indexOf("base64") > -1 || encMethod.indexOf("Base 64") > -1 || encMethod.indexOf("base 64") > -1) {
                        byte[] decodedData = Base64.decode(inline);
                        ByteArrayInputStream bais = new ByteArrayInputStream(decodedData);
                        InputStreamReader isr = new InputStreamReader(bais);
                        FileSystemDataStore fds3 = new FileSystemDataStore(morpho);
                        entityFile = fds3.saveTempDataFile(adp.getAccessionNumber(), isr);
                    } else {
                        FileSystemDataStore fds2 = new FileSystemDataStore(morpho);
                        StringReader sr2 = new StringReader(inline);
                        entityFile = fds2.saveTempDataFile(adp.getAccessionNumber(), sr2);
                    }
                    break block18;
                }
                if (adp.getDistributionUrl(entityIndex, 0, 0).length() <= 0) break block20;
                String urlinfo = adp.getDistributionUrl(entityIndex, 0, 0);
                int indx2 = urlinfo.lastIndexOf("/");
                if (indx2 == -1) {
                    Log.debug(15, "Distribution URL is not in the right format! So data couldnt be retrieved");
                    return null;
                }
                if ((urlinfo = urlinfo.substring(indx2 + 1)).length() == 0) {
                    Log.debug(15, "Distribution URL is not in the right format! So data couldnt be retrieved");
                    return null;
                }
                try {
                    String loc;
                    block22: {
                        block21: {
                            loc = adp.getLocation();
                            if (loc.equals("local")) break block21;
                            if (!loc.equals("localmetacat")) break block22;
                        }
                        FileSystemDataStore fds = new FileSystemDataStore(morpho);
                        entityFile = fds.openFile(urlinfo);
                        break block18;
                    }
                    if (loc.equals("metacat")) {
                        MetacatDataStore mds = new MetacatDataStore(morpho);
                        entityFile = mds.openFile(urlinfo);
                        break block18;
                    }
                    if (!loc.equals("")) break block18;
                    try {
                        ConfigXML profile = morpho.getProfile();
                        String separator = profile.get("separator", 0);
                        separator = separator.trim();
                        FileSystemDataStore fds = new FileSystemDataStore(morpho);
                        String temp = new String();
                        temp = urlinfo.substring(0, urlinfo.indexOf(separator));
                        temp = temp + "/" + urlinfo.substring(urlinfo.indexOf(separator) + 1, urlinfo.length());
                        entityFile = fds.openTempFile(temp);
                        break block18;
                    }
                    catch (Exception q1) {
                        try {
                            FileSystemDataStore fds = new FileSystemDataStore(morpho);
                            entityFile = fds.openFile(urlinfo);
                            break block18;
                        }
                        catch (Exception q2) {
                            try {
                                MetacatDataStore mds = new MetacatDataStore(morpho);
                                entityFile = mds.openFile(urlinfo);
                                break block18;
                            }
                            catch (Exception q3) {
                                Log.debug(15, "Exception opening datafile after trying all sources!");
                                return null;
                            }
                        }
                    }
                }
                catch (Exception q) {
                    Log.debug(15, "Exception opening file!");
                    q.printStackTrace();
                }
                break block18;
            }
            if (adp.getDistributionArray(entityIndex, 0) == null) {
                Log.debug(10, "The selected entity has NO distribution information!");
                return null;
            }
        }
        if (entityFile == null) {
            Log.debug(15, "Unable to get the selected entity's data file!");
            return null;
        }
        return entityFile;
    }

    public static List getColumnValues(File file, Vector colIndices, int numHeaderLines, String delimiter, boolean ignoreConsequtiveDelimiters, int maxLinesNeeded) {
        ArrayList result = new ArrayList();
        String oldToken = "";
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(file));
            int linecnt = 0;
            while ((line = br.readLine()) != null) {
                int lastIdx;
                int idx;
                String token;
                if (++linecnt <= numHeaderLines || line.trim().equals("")) continue;
                ArrayList<String> row = new ArrayList<String>();
                if (maxLinesNeeded != -1 && result.size() >= maxLinesNeeded) {
                    int space = TRUNCATE_STRING.indexOf(" ");
                    for (int ci = 0; ci < colIndices.size(); ++ci) {
                        row.add(TRUNCATE_STRING);
                    }
                    result.add(row);
                    break;
                }
                if (ignoreConsequtiveDelimiters) {
                    StringTokenizer st = new StringTokenizer(line, delimiter, false);
                    int cnt = -1;
                    while (st.hasMoreTokens()) {
                        token = st.nextToken().trim();
                        idx = -1;
                        if ((idx = colIndices.indexOf(new Integer(++cnt))) > -1) {
                            row.add(token);
                            lastIdx = colIndices.lastIndexOf(new Integer(cnt));
                            while (idx < lastIdx) {
                                if ((idx = colIndices.indexOf(new Integer(cnt), idx + 1)) <= -1) continue;
                                row.add(token);
                            }
                        }
                        if (idx != colIndices.size() - 1) continue;
                        break;
                    }
                    result.add(row);
                    continue;
                }
                int cnt = -1;
                StringTokenizer st = new StringTokenizer(line, delimiter, true);
                while (st.hasMoreTokens()) {
                    token = st.nextToken().trim();
                    if (delimiter.indexOf(token) <= -1) {
                        idx = -1;
                        if ((idx = colIndices.indexOf(new Integer(++cnt))) > -1) {
                            row.add(token);
                            lastIdx = colIndices.lastIndexOf(new Integer(cnt));
                            while (idx < lastIdx) {
                                if ((idx = colIndices.indexOf(new Integer(cnt), idx + 1)) <= -1) continue;
                                row.add(token);
                            }
                        }
                        if (idx == colIndices.size() - 1) {
                            break;
                        }
                    } else if (delimiter.indexOf(oldToken) > -1 && delimiter.indexOf(token) > -1) {
                        idx = -1;
                        if ((idx = colIndices.indexOf(new Integer(++cnt))) > -1) {
                            row.add("");
                            lastIdx = colIndices.lastIndexOf(new Integer(cnt));
                            while (idx < lastIdx) {
                                if ((idx = colIndices.indexOf(new Integer(cnt), idx + 1)) <= -1) continue;
                                row.add("");
                            }
                        }
                        if (idx == colIndices.size() - 1) break;
                    }
                    oldToken = token;
                }
                int idx1 = colIndices.lastIndexOf(new Integer(cnt));
                for (int rem = idx1 + 1; rem < colIndices.size(); ++rem) {
                    row.add("");
                }
                result.add(row);
            }
        }
        catch (Exception e) {
            Log.debug(15, "Exception in reading the data File: " + e);
        }
        if (result.size() == 0) {
            ArrayList<String> row = new ArrayList<String>();
            for (int i = 0; i < colIndices.size(); ++i) {
                row.add("");
            }
            result.add(row);
        }
        return result;
    }

    public static List getOneColumnValue(File file, int colIndex, int numHeaderLines, String delimiter, int maxLinesNeeded) {
        ArrayList<String> result = new ArrayList<String>();
        boolean ignoreConsequtiveDelimiters = false;
        String oldToken = "";
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(file));
            int linecnt = 0;
            block2: while ((line = br.readLine()) != null) {
                String token;
                if (++linecnt <= numHeaderLines || line.trim().equals("")) continue;
                if (maxLinesNeeded != -1 && result.size() >= maxLinesNeeded) {
                    result.add(TRUNCATE_STRING);
                    break;
                }
                if (ignoreConsequtiveDelimiters) {
                    StringTokenizer st = new StringTokenizer(line, delimiter, false);
                    int cnt = -1;
                    while (st.hasMoreTokens()) {
                        token = st.nextToken().trim();
                        if (++cnt != colIndex) continue;
                        result.add(token);
                        continue block2;
                    }
                    continue;
                }
                int cnt = -1;
                StringTokenizer st = new StringTokenizer(line, delimiter, true);
                while (st.hasMoreTokens()) {
                    token = st.nextToken().trim();
                    if (delimiter.indexOf(token) <= -1) {
                        if (++cnt == colIndex) {
                            result.add(token);
                            continue block2;
                        }
                    } else if (delimiter.indexOf(oldToken) > -1 && delimiter.indexOf(token) > -1 && ++cnt == colIndex) {
                        result.add("");
                        continue block2;
                    }
                    oldToken = token;
                }
            }
        }
        catch (Exception e) {
            Log.debug(15, "Exception in reading the data File: " + e);
        }
        return result;
    }

    private String getDelimiterString(String field_delimiter) {
        String str = "";
        String temp = field_delimiter.trim();
        if (temp.startsWith("#x")) {
            if ((temp = temp.substring(2)).equals("0A")) {
                str = "\n";
            }
            if (temp.equals("09")) {
                str = "\t";
            }
            if (temp.equals("20")) {
                str = " ";
            }
        } else {
            str = temp;
        }
        return str;
    }
}

