/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard;

import edu.ucsb.nceas.morpho.plugins.datapackagewizard.CustomJTable;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.CustomList;
import edu.ucsb.nceas.morpho.util.Log;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.table.TableCellEditor;

class AddAction
extends AbstractAction {
    private CustomJTable table;
    private CustomList parentList;

    public AddAction(CustomJTable table, CustomList parentList) {
        super("Add");
        this.table = table;
        this.parentList = parentList;
    }

    public void actionPerformed(ActionEvent e) {
        Log.debug(45, "CustomList ADD action");
        if (this.parentList.getCustomAddAction() == null) {
            ArrayList<Object> newRowList = new ArrayList<Object>();
            for (int i = 0; i < this.table.getColumnCount(); ++i) {
                TableCellEditor cellEditor = this.table.getColumnModel().getColumn(i).getCellEditor();
                String cellVal = cellEditor != null ? String.valueOf(cellEditor.getCellEditorValue()) : "";
                String colClassName = this.table.getColumnClass(i).getName();
                if (colClassName.equals("javax.swing.JTextField")) {
                    Log.debug(45, "\nAddAction - (JTextField)");
                    newRowList.add("");
                    continue;
                }
                if (colClassName.equals("javax.swing.JCheckBox")) {
                    Log.debug(45, "\nAddAction - (JCheckBox)");
                    newRowList.add(new Boolean(cellVal));
                    continue;
                }
                if (colClassName.equals("javax.swing.JComboBox")) {
                    Log.debug(45, "\nAddAction - (JComboBox)");
                    newRowList.add(cellVal);
                    continue;
                }
                Log.debug(45, "\nAddAction - NOT RECOGNIZED");
                newRowList.add("");
            }
            this.parentList.addRow(newRowList);
        } else {
            this.parentList.getCustomAddAction().actionPerformed(null);
        }
    }
}

