/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.framework;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.framework.ConfigXML;
import edu.ucsb.nceas.morpho.util.Log;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class MorphoPrefsDialog
extends JDialog {
    Morpho morpho;
    ConfigXML config;
    JPanel CenterPanel = new JPanel();
    JLabel aboutLabel = new JLabel();
    JPanel JPanel1 = new JPanel();
    JPanel JPanel2 = new JPanel();
    JLabel metacatURLLabel = new JLabel();
    JTextField metacataURLTextField = new JTextField();
    JPanel JPanel3 = new JPanel();
    JLabel loggingLabel = new JLabel();
    JRadioButton logYes = new JRadioButton();
    JRadioButton logNo = new JRadioButton();
    JPanel JPanel4 = new JPanel();
    JLabel debugLevelLabel = new JLabel();
    JTextField debugLevelTextField = new JTextField();
    JPanel JPanel5 = new JPanel();
    JPanel JPanel6 = new JPanel();
    JLabel LFLabel = new JLabel();
    JComboBox LFCombo = new JComboBox();
    JPanel ControlPanel = new JPanel();
    JButton setButton = new JButton();
    JButton cancelButton = new JButton();
    JButton clearButton = new JButton();

    public MorphoPrefsDialog(Frame parentFrame, Morpho morpho) {
        super(parentFrame);
        this.morpho = morpho;
        this.setTitle("Morpho Preferences");
        this.setModal(true);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.setSize(560, 400);
        this.setVisible(false);
        this.CenterPanel.setLayout(new GridLayout(7, 1, 0, 0));
        this.getContentPane().add("Center", this.CenterPanel);
        this.aboutLabel.setHorizontalAlignment(0);
        this.aboutLabel.setText("Morpho Preferences");
        this.aboutLabel.setFont(new Font("Dialog", 1, 12));
        this.CenterPanel.add(this.aboutLabel);
        this.JPanel2.setLayout(new FlowLayout(1, 5, 5));
        this.CenterPanel.add(this.JPanel2);
        this.metacatURLLabel.setHorizontalTextPosition(4);
        this.metacatURLLabel.setHorizontalAlignment(4);
        this.metacatURLLabel.setText("Metacat URL: ");
        this.JPanel2.add(this.metacatURLLabel);
        this.metacatURLLabel.setForeground(Color.black);
        this.metacatURLLabel.setFont(new Font("Dialog", 0, 12));
        this.metacataURLTextField.setColumns(35);
        this.JPanel2.add(this.metacataURLTextField);
        this.JPanel3.setLayout(new FlowLayout(1, 5, 5));
        this.CenterPanel.add(this.JPanel3);
        this.loggingLabel.setText("Log Messages?     ");
        this.JPanel3.add(this.loggingLabel);
        this.loggingLabel.setForeground(Color.black);
        this.loggingLabel.setFont(new Font("Dialog", 0, 12));
        this.logYes.setText("yes");
        this.JPanel3.add(this.logYes);
        this.logNo.setText("no");
        this.logNo.setSelected(true);
        this.JPanel3.add(this.logNo);
        this.JPanel4.setLayout(new FlowLayout(1, 5, 5));
        this.CenterPanel.add(this.JPanel4);
        this.debugLevelLabel.setText("Debug Level (1-100)    ");
        this.JPanel4.add(this.debugLevelLabel);
        this.debugLevelLabel.setForeground(Color.black);
        this.debugLevelLabel.setFont(new Font("Dialog", 0, 12));
        this.debugLevelTextField.setColumns(5);
        this.JPanel4.add(this.debugLevelTextField);
        this.JPanel5.setLayout(new FlowLayout(1, 5, 5));
        this.CenterPanel.add(this.JPanel5);
        this.LFLabel.setText("'Look and Feel'    ");
        this.JPanel5.add(this.LFLabel);
        this.LFLabel.setForeground(Color.black);
        this.LFLabel.setFont(new Font("Dialog", 0, 12));
        this.JPanel5.add(this.LFCombo);
        this.LFCombo.addItem("system L&F");
        this.LFCombo.addItem("kunststoff L&F");
        this.LFCombo.addItem("metal L&F");
        this.LFCombo.addItem("windows L&F");
        this.LFCombo.addItem("motif L&F");
        this.LFCombo.setSelectedIndex(0);
        this.clearButton.setText("Clear Temporary Storage");
        this.JPanel6.setLayout(new FlowLayout(1, 5, 5));
        this.JPanel6.add(this.clearButton);
        this.CenterPanel.add(this.JPanel6);
        this.JPanel1.setLayout(new FlowLayout(1, 5, 5));
        this.CenterPanel.add(this.JPanel1);
        this.ControlPanel.setLayout(new FlowLayout(1, 5, 5));
        this.getContentPane().add("South", this.ControlPanel);
        this.setButton.setText("Set");
        this.setButton.setActionCommand("OK");
        this.setButton.setOpaque(false);
        this.setButton.setMnemonic(79);
        this.ControlPanel.add(this.setButton);
        this.cancelButton.setText("Cancel");
        this.ControlPanel.add(this.cancelButton);
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        SymAction lSymAction = new SymAction();
        this.setButton.addActionListener(lSymAction);
        this.cancelButton.addActionListener(lSymAction);
        this.clearButton.addActionListener(lSymAction);
        SymItem lSymItem = new SymItem();
        this.logYes.addItemListener(lSymItem);
        this.logNo.addItemListener(lSymItem);
        this.config = morpho.getConfiguration();
        this.metacataURLTextField.setText(this.config.get("metacat_url", 0));
        if (this.config.get("log_file", 0).equals("true")) {
            this.logYes.setSelected(true);
            this.logNo.setSelected(false);
        } else {
            this.logYes.setSelected(false);
            this.logNo.setSelected(true);
        }
        this.debugLevelTextField.setText(this.config.get("debug_level", 0));
        String lnf = this.config.get("lookAndFeel", 0);
        if (lnf == null) {
            this.LFCombo.setSelectedIndex(0);
        } else if (lnf.equalsIgnoreCase("kunststoff")) {
            this.LFCombo.setSelectedIndex(1);
        } else if (lnf.equalsIgnoreCase("metal")) {
            this.LFCombo.setSelectedIndex(2);
        } else if (lnf.equalsIgnoreCase("windows")) {
            this.LFCombo.setSelectedIndex(3);
        } else if (lnf.equalsIgnoreCase("motif")) {
            this.LFCombo.setSelectedIndex(4);
        }
    }

    public void setVisible(boolean b) {
        if (b) {
            Rectangle bounds = this.getParent().getBounds();
            Dimension size = this.getSize();
            this.setLocation(bounds.x + (bounds.width - size.width) / 2, bounds.y + (bounds.height - size.height) / 2);
        }
        super.setVisible(b);
    }

    void morphoPrefsDialog_windowClosing(WindowEvent event) {
        this.morphoPrefsDialog_windowClosing_Interaction1(event);
    }

    void morphoPrefsDialog_windowClosing_Interaction1(WindowEvent event) {
        try {
            this.setVisible(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void setButton_actionPerformed(ActionEvent event) {
        this.config.set("metacat_url", 0, this.metacataURLTextField.getText());
        if (this.logYes.isSelected()) {
            this.config.set("log_file", 0, "true");
        } else {
            this.config.set("log_file", 0, "false");
        }
        String debugLevelS = this.debugLevelTextField.getText();
        try {
            Integer iii = new Integer(debugLevelS);
            this.config.set("debug_level", 0, debugLevelS);
        }
        catch (Exception e) {
            this.config.set("debug_level", 0, "20");
            Log.debug(20, "Debug Level is NOT an integer! Reset to a value of 20.");
        }
        String lnf = "";
        if (this.LFCombo.getSelectedIndex() == 0) {
            lnf = "";
        } else if (this.LFCombo.getSelectedIndex() == 1) {
            lnf = "kunststoff";
        } else if (this.LFCombo.getSelectedIndex() == 2) {
            lnf = "metal";
        } else if (this.LFCombo.getSelectedIndex() == 3) {
            lnf = "windows";
        } else if (this.LFCombo.getSelectedIndex() == 4) {
            lnf = "motif";
        }
        this.config.set("lookAndFeel", 0, lnf);
        this.config.save();
        this.morpho.setMetacatURLString(this.config.get("metacat_url", 0));
        Morpho.initializeLogging(this.config);
        Morpho.setLookAndFeel(this.config.get("lookAndFeel", 0));
        this.setVisible(false);
        this.dispose();
    }

    void cancelButton_actionPerformed(ActionEvent event) {
        this.setVisible(false);
        this.dispose();
    }

    class SymItem
    implements ItemListener {
        SymItem() {
        }

        public void itemStateChanged(ItemEvent event) {
            Object object = event.getSource();
            if (object == MorphoPrefsDialog.this.logYes && MorphoPrefsDialog.this.logYes.isSelected()) {
                MorphoPrefsDialog.this.logNo.setSelected(false);
            }
            if (object == MorphoPrefsDialog.this.logNo && MorphoPrefsDialog.this.logNo.isSelected()) {
                MorphoPrefsDialog.this.logYes.setSelected(false);
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == MorphoPrefsDialog.this.setButton) {
                MorphoPrefsDialog.this.setButton_actionPerformed(event);
            } else if (object == MorphoPrefsDialog.this.cancelButton) {
                MorphoPrefsDialog.this.cancelButton_actionPerformed(event);
            } else if (object == MorphoPrefsDialog.this.clearButton) {
                Morpho.thisStaticInstance.cleanCache();
                Morpho.thisStaticInstance.cleanTemp();
                JOptionPane.showMessageDialog(null, "Temporary Storage Areas Emptied!", "Message", 1);
            }
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == MorphoPrefsDialog.this) {
                MorphoPrefsDialog.this.morphoPrefsDialog_windowClosing(event);
            }
        }
    }
}

