/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.editor;

import com.wutka.dtd.DTD;
import com.wutka.dtd.DTDAny;
import com.wutka.dtd.DTDAttribute;
import com.wutka.dtd.DTDCardinal;
import com.wutka.dtd.DTDChoice;
import com.wutka.dtd.DTDContainer;
import com.wutka.dtd.DTDDecl;
import com.wutka.dtd.DTDElement;
import com.wutka.dtd.DTDEmpty;
import com.wutka.dtd.DTDEnumeration;
import com.wutka.dtd.DTDItem;
import com.wutka.dtd.DTDMixed;
import com.wutka.dtd.DTDName;
import com.wutka.dtd.DTDPCData;
import com.wutka.dtd.DTDParser;
import com.wutka.dtd.DTDSequence;
import edu.ucsb.nceas.morpho.editor.NodeInfo;
import edu.ucsb.nceas.morpho.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class DTDTree {
    private String DTDFileName;
    Vector elementnames;
    public DefaultMutableTreeNode rootNode;
    public DefaultTreeModel treeModel;
    public DTD dtd = null;
    StringBuffer sb;
    StringBuffer start_buffer;
    StringBuffer start;
    StringBuffer end_buffer;
    Stack tempStack;
    int indent = 0;
    String rootElementName = null;
    DTDElement rootElement = null;
    int cntr = 0;
    boolean Sequence_Flag = true;
    int levels = 12;

    public DTDTree() {
        this.DTDFileName = "";
    }

    public DTDTree(String dtdname) {
        this.DTDFileName = dtdname;
    }

    public void setRootElementName(String name) {
        this.rootElementName = name;
    }

    public void parseDTD() {
        try {
            DefaultMutableTreeNode rootTreeNode;
            DTDElement elem;
            File file = new File(this.DTDFileName);
            if (file == null) {
                Log.debug(0, "DTD file is null!");
            }
            DTDParser parser = new DTDParser(new BufferedReader(new FileReader(file)));
            this.dtd = parser.parse(true);
            this.elementnames = new Vector();
            Enumeration e = this.dtd.elements.elements();
            while (e.hasMoreElements()) {
                elem = (DTDElement)e.nextElement();
                if (this.rootElementName != null && elem.name.equals(this.rootElementName)) {
                    this.rootElement = elem;
                }
                this.elementnames.addElement(elem.name);
            }
            if (this.dtd.rootElement != null) {
                String root = this.dtd.rootElement.name;
                elem = this.dtd.rootElement;
            } else {
                elem = this.rootElement;
            }
            NodeInfo rootNodeInfo = new NodeInfo(elem.name);
            rootNodeInfo.setCardinality("ONE");
            this.rootNode = rootTreeNode = new DefaultMutableTreeNode(rootNodeInfo);
            this.buildTree(rootTreeNode);
            this.treeModel = new DefaultTreeModel(rootTreeNode);
        }
        catch (Exception e) {
            Log.debug(0, "Problem while parsing DTD: " + e.getMessage());
            Log.debug(0, e.getClass().getName());
        }
    }

    public DefaultMutableTreeNode buildTree(DefaultMutableTreeNode root) {
        Vector<DefaultMutableTreeNode> vect = new Vector<DefaultMutableTreeNode>();
        Vector vvvv = new Vector();
        Vector zzzz = new Vector();
        vect.addElement(root);
        for (int i = 0; i < this.levels; ++i) {
            Enumeration e = vect.elements();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)e.nextElement();
                vvvv = this.getChildren((NodeInfo)dmtn.getUserObject(), dmtn);
                Enumeration ee = vvvv.elements();
                while (ee.hasMoreElements()) {
                    zzzz.addElement(ee.nextElement());
                }
            }
            vect = zzzz;
            zzzz = new Vector();
        }
        for (DefaultMutableTreeNode leaf = root.getFirstLeaf(); leaf != null; leaf = leaf.getNextLeaf()) {
            NodeInfo ni = (NodeInfo)leaf.getUserObject();
            ni.setItem(null);
        }
        return root;
    }

    private Vector getChildren(NodeInfo ni, DefaultMutableTreeNode parentNode) {
        Vector vec = new Vector();
        Vector<DefaultMutableTreeNode> vec1 = new Vector<DefaultMutableTreeNode>();
        DTDElement elem = null;
        String name = ni.getName();
        if (!(name.equalsIgnoreCase("Any") || name.equalsIgnoreCase("None") || name.equalsIgnoreCase("#PCDATA"))) {
            DTDItem[] items;
            DTDContainer item;
            Vector vec2;
            if (name.indexOf("SEQUENCE") > -1) {
                vec2 = new Vector();
                item = null;
                if (ni.getItem() != null) {
                    item = (DTDSequence)ni.getItem();
                    ni.setItem(null);
                }
                items = item.getItems();
                for (int i = 0; i < items.length; ++i) {
                    this.DTDItems(items[i], vec2, false);
                }
                Enumeration e = vec2.elements();
                while (e.hasMoreElements()) {
                    NodeInfo node = (NodeInfo)e.nextElement();
                    DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(node);
                    parentNode.add(newNode);
                    vec1.addElement(newNode);
                }
            } else if (name.indexOf("CHOICE") > -1) {
                DefaultMutableTreeNode newNode;
                NodeInfo node;
                Enumeration e;
                vec2 = new Vector();
                item = null;
                if (ni.getItem() != null) {
                    item = (DTDChoice)ni.getItem();
                    ni.setItem(null);
                }
                items = item.getItems();
                for (int i = 0; i < items.length; ++i) {
                    this.DTDItems(items[i], vec2, true);
                }
                boolean first = true;
                if (ni.getCardinality().equalsIgnoreCase("ONE")) {
                    e = vec2.elements();
                    while (e.hasMoreElements()) {
                        node = (NodeInfo)e.nextElement();
                        if (first) {
                            node.setChoice(true);
                            node.setSelected(true);
                        } else {
                            node.setChoice(true);
                            node.setSelected(false);
                        }
                        first = false;
                        newNode = new DefaultMutableTreeNode(node);
                        parentNode.add(newNode);
                        vec1.addElement(newNode);
                    }
                } else {
                    e = vec2.elements();
                    while (e.hasMoreElements()) {
                        node = (NodeInfo)e.nextElement();
                        if (first) {
                            node.setCardinality(ni.getCardinality());
                            first = false;
                        } else {
                            node.setCardinality("ZERO to MANY");
                        }
                        newNode = new DefaultMutableTreeNode(node);
                        parentNode.add(newNode);
                        vec1.addElement(newNode);
                    }
                }
            } else {
                elem = (DTDElement)this.dtd.elements.get(name);
            }
        }
        if (elem != null) {
            this.getAttributes(ni, elem);
            this.DTDItems(elem.content, vec, false);
            Enumeration e = vec.elements();
            while (e.hasMoreElements()) {
                NodeInfo node = (NodeInfo)e.nextElement();
                DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(node);
                parentNode.add(newNode);
                vec1.addElement(newNode);
            }
        }
        return vec1;
    }

    private void DTDItems(DTDItem item, Vector vec, boolean flg) {
        if (item == null) {
            return;
        }
        if (item instanceof DTDAny) {
            NodeInfo ni = new NodeInfo("#PCDATA");
            ni.setPCValue(" ");
            ni.setCardinality(this.getCardinality(item));
            vec.addElement(ni);
        } else if (item instanceof DTDEmpty) {
            NodeInfo ni = new NodeInfo("Empty");
            ni.setCardinality(this.getCardinality(item));
            vec.addElement(ni);
        } else if (item instanceof DTDName) {
            NodeInfo ni = new NodeInfo(((DTDName)item).value);
            ni.setCardinality(this.getCardinality(item));
            vec.addElement(ni);
        } else if (item instanceof DTDChoice) {
            DTDItem[] items = ((DTDChoice)item).getItems();
            if (items.length > 1) {
                ++this.cntr;
                NodeInfo ni = new NodeInfo("CHOICE" + this.cntr);
                ni.setItem(item);
                ni.setCardinality(this.getCardinality(item));
                vec.addElement(ni);
            } else {
                for (int i = 0; i < items.length; ++i) {
                    this.DTDItems(items[i], vec, false);
                }
            }
        } else if (item instanceof DTDSequence) {
            if (this.Sequence_Flag && flg || this.Sequence_Flag && !this.getCardinality(item).equals("ONE")) {
                ++this.cntr;
                NodeInfo ni = new NodeInfo("SEQUENCE" + this.cntr);
                ni.setItem(item);
                ni.setCardinality(this.getCardinality(item));
                vec.addElement(ni);
            } else {
                DTDItem[] items = ((DTDSequence)item).getItems();
                for (int i = 0; i < items.length; ++i) {
                    this.DTDItems(items[i], vec, false);
                }
            }
        } else if (item instanceof DTDMixed) {
            DTDItem[] items = ((DTDMixed)item).getItems();
            for (int i = 0; i < items.length; ++i) {
                this.DTDItems(items[i], vec, false);
            }
        } else if (item instanceof DTDPCData) {
            NodeInfo ni = new NodeInfo("#PCDATA");
            ni.setPCValue(" ");
            ni.setCardinality(this.getCardinality(item));
            vec.addElement(ni);
        }
    }

    private void getAttributes(NodeInfo ni, DTDElement el) {
        Enumeration attrs = el.attributes.elements();
        while (attrs.hasMoreElements()) {
            DTDAttribute attr = (DTDAttribute)attrs.nextElement();
            this.getAttribute(ni, attr);
        }
    }

    private void getAttribute(NodeInfo ni, DTDAttribute attr) {
        this.sb = new StringBuffer();
        if (attr.getDecl().equals(DTDDecl.REQUIRED)) {
            if (attr.defaultValue != null) {
                this.sb.append(attr.defaultValue);
                ni.attr.put(attr.name, this.sb.toString());
            } else if (attr.type instanceof DTDEnumeration) {
                String[] items = ((DTDEnumeration)attr.type).getItems();
                this.sb.append(items[0]);
                ni.attr.put(attr.name, this.sb.toString());
            }
        }
    }

    private String getCardinality(DTDItem item) {
        if (item.cardinal == DTDCardinal.NONE) {
            return "ONE";
        }
        if (item.cardinal == DTDCardinal.OPTIONAL) {
            return "OPTIONAL";
        }
        if (item.cardinal == DTDCardinal.ZEROMANY) {
            return "ZERO to MANY";
        }
        if (item.cardinal == DTDCardinal.ONEMANY) {
            return "ONE to MANY";
        }
        return "ONE";
    }
}

