/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datapackage;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;

public class ObjectFile {
    RandomAccessFile dataFile;
    String sFileName;

    public ObjectFile(String sName) throws IOException {
        this.sFileName = sName;
        File f = new File(sName);
        if (f.exists()) {
            f.delete();
        }
        this.dataFile = new RandomAccessFile(sName, "rw");
    }

    public synchronized long writeObject(Serializable obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(obj);
        oos.flush();
        int datalen = baos.size();
        long pos = this.dataFile.length();
        this.dataFile.seek(pos);
        this.dataFile.writeInt(datalen);
        this.dataFile.write(baos.toByteArray());
        baos = null;
        oos = null;
        return pos;
    }

    public synchronized int getObjectLength(long lPos) throws IOException {
        this.dataFile.seek(lPos);
        return this.dataFile.readInt();
    }

    public synchronized Object readObject(long lPos) throws IOException, ClassNotFoundException {
        this.dataFile.seek(lPos);
        int datalen = this.dataFile.readInt();
        if ((long)datalen > this.dataFile.length()) {
            throw new IOException("Data file is corrupted. datalen: " + datalen);
        }
        byte[] data = new byte[datalen];
        this.dataFile.readFully(data);
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object o = ois.readObject();
        bais = null;
        ois = null;
        data = null;
        return o;
    }

    public long length() throws IOException {
        return this.dataFile.length();
    }

    public void close() throws IOException {
        this.dataFile.close();
    }

    public void delete() {
        try {
            this.dataFile.close();
            File f = new File(this.sFileName);
            if (f.exists()) {
                f.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        String testString = "This is a test!!!";
        try {
            ObjectFile of = new ObjectFile("ObjectFile");
            long pos = of.writeObject((Serializable)((Object)testString));
            Object res = of.readObject(pos);
            System.out.println("Result: " + (String)res);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

