/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datapackage;

import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.OrderedMap;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.util.Map;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Entity {
    private Node entRoot = null;
    private AbstractDataPackage adpContainer = null;

    public Entity(String entName) {
        try {
            DOMImplementation impl = DOMImplementationImpl.getDOMImplementation();
            Document doc = impl.createDocument("", entName, null);
            this.entRoot = doc.getDocumentElement();
        }
        catch (Exception e) {
            Log.debug(5, "Unable to create a DOM for this entity");
        }
    }

    public Entity(String entName, OrderedMap om) {
        this(entName);
        try {
            XMLUtilities.getXPathMapAsDOMTree((Map)om, (Node)this.entRoot);
        }
        catch (Exception w) {
            Log.debug(5, "Unable to add OrderMap elements to DOM");
        }
    }

    public Entity(Node node) {
        this.entRoot = node;
    }

    public Entity(Node node, AbstractDataPackage adp) {
        this(node);
        this.setContainer(adp);
    }

    public void setContainer(AbstractDataPackage adp) {
        this.adpContainer = adp;
    }

    public AbstractDataPackage getContainer() {
        return this.adpContainer;
    }

    public Node getNode() {
        return this.entRoot;
    }
}

