/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datapackage;

import edu.ucsb.nceas.morpho.datapackage.MyURIResolver;
import edu.ucsb.nceas.morpho.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xalan.templates.OutputProperties;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class EMLConvert {
    public static String outputfileName = "eml2out.xml";
    static String path = "";
    static String fname = "";
    private static String indentAmount = "2";

    public static void setIndentAmount(String indentAmount) {
        EMLConvert.indentAmount = indentAmount;
    }

    public static void main(String[] argv) throws TransformerException, TransformerConfigurationException, Exception {
        if (argv.length < 1) {
            Log.debug(20, "Must have an argument with name/path of dataset module");
            System.exit(0);
        }
        EMLConvert.doTransform(argv[0], "");
    }

    public static void doTransform(String datasetID, String metacatURL) throws TransformerException, TransformerConfigurationException, Exception {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        MyURIResolver res = new MyURIResolver();
        tFactory.setURIResolver(res);
        if (tFactory.getFeature("http://javax.xml.transform.sax.SAXSource/feature") && tFactory.getFeature("http://javax.xml.transform.sax.SAXResult/feature")) {
            SAXTransformerFactory saxTFactory = (SAXTransformerFactory)tFactory;
            File f1 = new File("./xsl/triple_info.xsl");
            FileInputStream fis = new FileInputStream(f1);
            File f2 = new File("./xsl/emlb6toeml2.xsl");
            TransformerHandler tHandler1 = saxTFactory.newTransformerHandler(new StreamSource(f1));
            TransformerHandler tHandler2 = saxTFactory.newTransformerHandler(new StreamSource(f2));
            Transformer tr = tHandler1.getTransformer();
            Transformer tr1 = tHandler2.getTransformer();
            EMLConvert.getPathInfo(datasetID);
            if (path.length() > 0) {
                if (!path.startsWith("file://")) {
                    path = "file:///" + path;
                }
                MyURIResolver.setDataDefault(path);
            }
            tr.setParameter("packageName", fname);
            tr1.setParameter("metacatURL", metacatURL);
            Transformer lastTransformer = tHandler2.getTransformer();
            lastTransformer.setOutputProperty(OutputProperties.S_KEY_INDENT_AMOUNT, indentAmount);
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(tHandler1);
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", tHandler1);
            tHandler1.setResult(new SAXResult(tHandler2));
            File outfile = new File(outputfileName);
            FileWriter writer = new FileWriter(outfile);
            StreamResult result = new StreamResult(writer);
            tHandler2.setResult(result);
            reader.parse(new InputSource(fis));
        }
    }

    private static void getPathInfo1(String str) {
        int pos = -1;
        if (str.indexOf("/") > -1 || str.indexOf("\\") > -1) {
            int pos2;
            int pos1 = str.lastIndexOf("/");
            pos = pos1 > (pos2 = str.lastIndexOf("\\")) ? pos1 : pos2;
            path = str.substring(0, pos + 1);
            fname = str.substring(pos + 1, str.length());
        } else {
            fname = str;
        }
    }

    private static void getPathInfo(String str) {
        File nf = new File(str);
        if (nf.exists()) {
            fname = nf.getName();
            path = nf.getAbsolutePath();
            Log.debug(20, "path: " + path + "  --fname: " + fname);
        }
    }
}

