/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datapackage;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.datapackage.EMLConvert;
import edu.ucsb.nceas.morpho.datapackage.PackageUtil;
import edu.ucsb.nceas.morpho.datapackage.Triple;
import edu.ucsb.nceas.morpho.datapackage.TripleCollection;
import edu.ucsb.nceas.morpho.datastore.CacheAccessException;
import edu.ucsb.nceas.morpho.datastore.FileSystemDataStore;
import edu.ucsb.nceas.morpho.datastore.MetacatDataStore;
import edu.ucsb.nceas.morpho.datastore.MetacatUploadException;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class EML2Beta6DataPackage
extends AbstractDataPackage {
    private Morpho morpho = Morpho.thisStaticInstance;
    private TripleCollection triples;
    private File tripleFile;

    public EML2Beta6DataPackage() {
        this.fileSysDataStore = new FileSystemDataStore(this.morpho);
        this.metacatDataStore = new MetacatDataStore(this.morpho);
    }

    public void serialize(String location) throws MetacatUploadException {
    }

    public void load(String location, String identifier, Morpho morpho) {
        this.morpho = morpho;
        this.location = location;
        this.config = morpho.getConfiguration();
        this.id = identifier;
        try {
            this.tripleFile = this.getFileWithID(identifier, morpho);
            this.triples = new TripleCollection(this.tripleFile, morpho);
        }
        catch (Throwable t) {
            Log.debug(1, "Unable to get tripleFile!!!");
            return;
        }
        this.exportToEml2("eml2test");
        File packagefile = new File("eml2test");
        DocumentBuilder parser = Morpho.createDomParser();
        Document doc = null;
        try {
            if (packagefile == null) {
                Log.debug(1, "packagefile is NULL!");
            }
            FileInputStream fs = new FileInputStream(packagefile);
            InputSource in = new InputSource(fs);
            doc = parser.parse(in);
            fs.close();
        }
        catch (Exception e1) {
            Log.debug(4, "Parsing threw: " + e1.toString());
            e1.printStackTrace();
        }
        if (doc == null) {
            Log.debug(1, "doc is NULL!");
        }
        this.metadataNode = doc.getDocumentElement();
        try {
            this.metadataPathNode = XMLUtilities.getXMLAsDOMTreeRootNode((String)"/eml200KeymapConfig.xml");
        }
        catch (Exception e2) {
            Log.debug(4, "getting DOM for Paths threw error: " + e2.toString());
            e2.printStackTrace();
        }
    }

    public void load(InputSource in) {
        Log.debug(15, "Loading from XML is not supported by EML2Beta6DataPackage");
    }

    public AbstractDataPackage upload(String id, boolean updatePackageIds) throws MetacatUploadException {
        return this;
    }

    public AbstractDataPackage download(String id) {
        return this;
    }

    public void exportToEml2(String path) {
        Log.debug(20, "exporting...");
        Log.debug(20, "path: " + path);
        Log.debug(20, "id: " + this.id);
        Log.debug(20, "location: " + this.location);
        Vector<File> fileV = new Vector<File>();
        boolean localloc = false;
        boolean metacatloc = false;
        if (this.location.equals("localmetacat")) {
            localloc = true;
            metacatloc = true;
        } else if (this.location.equals("metacat")) {
            metacatloc = true;
        } else if (this.location.equals("local")) {
            localloc = true;
        }
        String sourcePath = "metadata";
        File savedirSub = new File(sourcePath);
        savedirSub.mkdirs();
        Hashtable dataFileNameMap = this.getMapBetweenDataIdAndDataFileName();
        Vector files = this.getAllIdentifiers();
        for (int i = 0; i < files.size(); ++i) {
            try {
                String docid = (String)files.elementAt(i);
                File f = null;
                if (!dataFileNameMap.containsKey(docid)) {
                    f = new File(sourcePath + "/" + docid);
                }
                File openfile = null;
                if (localloc) {
                    openfile = this.fileSysDataStore.openFile(docid);
                } else if (metacatloc) {
                    openfile = dataFileNameMap.containsKey(docid) ? this.metacatDataStore.openDataFile(docid) : this.metacatDataStore.openFile(docid);
                }
                if (f == null) continue;
                fileV.addElement(openfile);
                FileInputStream fis = new FileInputStream(openfile);
                BufferedInputStream bfis = new BufferedInputStream(fis);
                FileOutputStream fos = new FileOutputStream(f);
                BufferedOutputStream bfos = new BufferedOutputStream(fos);
                int c = bfis.read();
                while (c != -1) {
                    bfos.write(c);
                    c = bfis.read();
                }
                bfos.flush();
                bfis.close();
                bfos.close();
                continue;
            }
            catch (Exception e) {
                System.out.println("Error in DataPackage.exportToEml2(): " + e.getMessage());
                e.printStackTrace();
            }
        }
        try {
            EMLConvert.outputfileName = path;
            String murl = this.morpho.getMetacatURLString();
            if (!metacatloc) {
                murl = "file://" + this.id;
            }
            EMLConvert.doTransform("metadata/" + this.id, murl);
        }
        catch (Exception ee) {
            System.out.println("Error in EMLConvert: " + ee.getMessage());
            ee.printStackTrace();
        }
        String[] filelist = savedirSub.list();
        for (int k = 0; k < filelist.length; ++k) {
            File nf = new File(savedirSub, filelist[k]);
            nf.delete();
        }
        savedirSub.delete();
    }

    private Hashtable getMapBetweenDataIdAndDataFileName() {
        Hashtable<String, String> map = new Hashtable<String, String>();
        Vector triplesV = this.triples.getCollection();
        int i = 1;
        String dataFileName = null;
        for (int j = 0; j < triplesV.size(); ++j) {
            Triple triple = (Triple)triplesV.elementAt(j);
            String relationship = triple.getRelationship();
            String subject = triple.getSubject();
            if (relationship.indexOf("isDataFileFor") == -1) continue;
            int lparenindex = relationship.indexOf("(");
            dataFileName = relationship.substring(lparenindex + 1, relationship.length() - 1);
            if ((dataFileName = this.trimFullPathFromFileName(dataFileName)) == null) continue;
            if (map.containsValue(dataFileName)) {
                dataFileName = this.appendFileNameNumber(dataFileName, i);
                ++i;
            }
            map.put(subject, dataFileName);
        }
        return map;
    }

    public Vector getAllIdentifiers() {
        Vector<String> v = new Vector<String>();
        Vector trips = this.triples.getCollection();
        for (int i = 0; i < trips.size(); ++i) {
            String sub = ((Triple)trips.elementAt(i)).getSubject();
            String obj = ((Triple)trips.elementAt(i)).getObject();
            if (!v.contains(sub.trim())) {
                v.addElement(sub.trim());
            }
            if (v.contains(obj.trim())) continue;
            v.addElement(obj.trim());
        }
        String accessID = this.getAccessFileIdForDataPackage();
        int accessLoc = v.indexOf(accessID = accessID.trim());
        if (accessLoc > -1) {
            v.removeElementAt(accessLoc);
            v.insertElementAt(accessID, 0);
        }
        return v;
    }

    private String trimFullPathFromFileName(String fileName) {
        String onlyFileName = fileName;
        String slash = "/";
        String backSlash = "\\";
        if (fileName == null || fileName.equals("")) {
            return fileName;
        }
        int size = fileName.length();
        int lastBackSlashIndex = fileName.lastIndexOf(backSlash);
        int lastSlashIndex = fileName.lastIndexOf(slash);
        if (lastBackSlashIndex != -1) {
            onlyFileName = fileName.substring(lastBackSlashIndex + 1, size);
            return onlyFileName;
        }
        if (lastSlashIndex != -1) {
            onlyFileName = fileName.substring(lastSlashIndex + 1, size);
            return onlyFileName;
        }
        return onlyFileName;
    }

    private String appendFileNameNumber(String fileName, int number) {
        int index = -1;
        String dot = ".";
        String extension = null;
        String prefix = null;
        if (fileName == null || fileName.equals("")) {
            fileName = "" + number;
            return fileName;
        }
        int size = fileName.length();
        index = fileName.lastIndexOf(dot);
        if (index == -1) {
            fileName = fileName + number;
            return fileName;
        }
        extension = fileName.substring(index + 1, size);
        prefix = fileName.substring(0, index);
        fileName = prefix + number + dot + extension;
        return fileName;
    }

    public String getAccessFileId(String id) {
        File accessfile = null;
        boolean localloc = false;
        boolean metacatloc = false;
        if (this.location.equals("localmetacat")) {
            localloc = true;
            metacatloc = true;
        } else if (this.location.equals("metacat")) {
            metacatloc = true;
        } else if (this.location.equals("local")) {
            localloc = true;
        }
        Vector triplesV = this.triples.getCollectionByObject(id);
        for (int i = 0; i < triplesV.size(); ++i) {
            Triple triple = (Triple)triplesV.elementAt(i);
            String sub = triple.getSubject();
            accessfile = this.getFileType(sub, "access");
            if (accessfile == null) continue;
            return sub.trim();
        }
        return "unknown";
    }

    private String getAccessFileIdForDataPackage() {
        String temp = this.getAccessFileId(this.id);
        return temp;
    }

    private File getFileType(String id, String typeString) {
        File subfile;
        String catalogPath = this.config.get("local_catalog_path", 0);
        String name = "unknown";
        try {
            subfile = this.fileSysDataStore.openFile(id.trim());
        }
        catch (FileNotFoundException fnfe) {
            try {
                subfile = this.metacatDataStore.openFile(id.trim());
            }
            catch (FileNotFoundException fnfe2) {
                Log.debug(0, "File " + id + " not found locally or " + "on metacat.");
                return null;
            }
            catch (CacheAccessException cae) {
                Log.debug(0, "The cache could not be accessed in DataPackage.getRelatedFiles.");
                return null;
            }
        }
        try {
            FileReader fr = new FileReader(subfile);
            String xmlString = "";
            for (int j = 0; j < 5; ++j) {
                xmlString = xmlString + (char)fr.read();
            }
            fr.close();
            if (xmlString.equals("<?xml")) {
                Document subDoc = PackageUtil.getDoc(subfile, catalogPath);
                DocumentType dt = subDoc.getDoctype();
                name = dt.getPublicId();
            } else {
                name = "Data File";
            }
        }
        catch (Exception ww) {
            // empty catch block
        }
        if (name.indexOf(typeString) > -1) {
            return subfile;
        }
        subfile = null;
        return subfile;
    }

    public Node getReferencedNode(Node node) {
        return node;
    }

    public Node getSubtreeAtReference(String refID) {
        return null;
    }

    public Node getSubtreeAtReferenceNoClone(String refID) {
        throw new UnsupportedOperationException("EML2Beta6DataPackage - method not implemented - getSubtreeAtReferenceNoClone()");
    }

    public boolean ignoreConsecutiveDelimiters(int entityIndex, int physicalIndex) {
        return false;
    }

    public Node replaceSubtreeAtReference(String refID, Node newSubtreeRoot) {
        throw new UnsupportedOperationException("EML2Beta6DataPackage - method not implemented - replaceSubtreeAtReference()");
    }

    public List getSubtreesThatReference(String refID) {
        throw new UnsupportedOperationException("EML2Beta6DataPackage - method not implemented - getSubtreesThatReferences()");
    }
}

