/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datapackage;

import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.datapackage.DataViewContainerPanel;
import edu.ucsb.nceas.morpho.datapackage.DataViewer;
import edu.ucsb.nceas.morpho.datapackage.PersistentTableModel;
import edu.ucsb.nceas.morpho.datapackage.PersistentVector;
import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.util.Command;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JTable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DeleteColumnCommand
implements Command {
    private MorphoFrame morphoFrame = null;

    public void execute(ActionEvent event) {
        DataViewer dataView;
        DataViewContainerPanel resultPane = null;
        this.morphoFrame = UIController.getInstance().getCurrentActiveWindow();
        if (this.morphoFrame != null) {
            resultPane = this.morphoFrame.getDataViewContainerPanel();
        }
        if (resultPane != null && (dataView = resultPane.getCurrentDataViewer()) != null) {
            AbstractDataPackage adp = dataView.getAbstractDataPackage();
            int entityIndex = dataView.getEntityIndex();
            JTable jtable = dataView.getDataTable();
            PersistentTableModel ptmodel = (PersistentTableModel)jtable.getModel();
            PersistentVector vector = dataView.getPV();
            Document attributeDocument = dataView.getAttributeDoc();
            Vector columnLabels = dataView.getColumnLabels();
            this.deleteColumn(jtable, ptmodel, vector, adp, entityIndex, columnLabels);
            dataView.setPV(ptmodel.getPersistentVector());
        }
    }

    private void deleteColumn(JTable table, PersistentTableModel ptm, PersistentVector pv, AbstractDataPackage adp, int entityIndex, Vector column_labels) {
        int sel = table.getSelectedColumn();
        if (sel > -1) {
            adp.deleteAttribute(entityIndex, sel);
            column_labels.removeElementAt(sel);
            ptm.deleteColumn(sel);
            pv = ptm.getPersistentVector();
            ptm.fireTableStructureChanged();
        }
    }

    private void deleteColumn(JTable table, PersistentTableModel ptm, PersistentVector pv, Document attributeDoc, Vector column_labels) {
        int sel = table.getSelectedColumn();
        if (sel > -1) {
            NodeList nl = attributeDoc.getElementsByTagName("attribute");
            Node deleteNode = nl.item(sel);
            Element root = attributeDoc.getDocumentElement();
            root.removeChild(deleteNode);
            column_labels.removeElementAt(sel);
            ptm.deleteColumn(sel);
            pv = ptm.getPersistentVector();
            ptm.fireTableStructureChanged();
        }
    }
}

