/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datapackage;

import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.framework.ModalDialog;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.DataPackageWizardInterface;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceNotHandledException;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.OrderedMap;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class AddKeywordCommand
implements Command {
    private final String DATAPACKAGE_KEYWORD_GENERIC_NAME = "keywordSet";
    private Node keywordRoot;
    private AbstractDataPackage adp;
    private AbstractUIPage keywordPage;

    public void execute(ActionEvent event) {
        this.adp = UIController.getInstance().getCurrentAbstractDataPackage();
        if (this.showKeywordDialog()) {
            try {
                this.insertKeyword();
                UIController.showNewPackage(this.adp);
            }
            catch (Exception w) {
                Log.debug(15, "Exception trying to modify keyword DOM: " + w);
                w.printStackTrace();
                Log.debug(5, "Unable to add keyword details!");
            }
        }
    }

    private boolean showKeywordDialog() {
        DataPackageWizardInterface dpwPlugin = null;
        try {
            ServiceController sc = ServiceController.getInstance();
            dpwPlugin = (DataPackageWizardInterface)((Object)sc.getServiceProvider(DataPackageWizardInterface.class));
        }
        catch (ServiceNotHandledException se) {
            Log.debug(6, se.getMessage());
            se.printStackTrace();
        }
        if (dpwPlugin == null) {
            return false;
        }
        this.keywordPage = dpwPlugin.getPage("KEYWORDS");
        OrderedMap existingValuesMap = new OrderedMap();
        List keywordList = this.adp.getSubtrees("keywordSet");
        if (!keywordList.isEmpty()) {
            Iterator listIt = keywordList.iterator();
            Object nextObj = null;
            Object nextTempObj2 = null;
            String nextTempString = null;
            int count = 1;
            while (listIt.hasNext()) {
                nextObj = listIt.next();
                OrderedMap tempMap = XMLUtilities.getDOMTreeAsXPathMap((Node)nextObj);
                for (Object nextTempObj2 : tempMap.keySet()) {
                    nextTempString = nextTempObj2;
                    if (nextTempString == null) continue;
                    existingValuesMap.put((Object)("/keywordSet[" + count + "]" + nextTempString.substring("keywordSet".length() + 1, nextTempString.length())), tempMap.get(nextTempObj2));
                }
                ++count;
            }
        }
        Log.debug(45, "sending previous data to keywordPage -\n\n" + existingValuesMap);
        boolean pageCanHandleAllData = this.keywordPage.setPageData(existingValuesMap, null);
        ModalDialog dialog = null;
        if (!pageCanHandleAllData) {
            UIController.getInstance().launchEditorAtSubtreeForCurrentFrame("keywordSet", 0);
            return false;
        }
        dialog = new ModalDialog(this.keywordPage, UIController.getInstance().getCurrentActiveWindow(), 770, 570);
        return dialog.USER_RESPONSE == 10;
    }

    private void insertKeyword() {
        OrderedMap keyMap;
        OrderedMap map = this.keywordPage.getPageData("/keywordSet[");
        if (map == null) {
            Log.debug(5, "Unable to get keyword details from input!");
            return;
        }
        if (map.isEmpty()) {
            Log.debug(45, "Empty map returned. Deleting all previous keywords!");
        }
        Log.debug(45, "\n insertKeyword() Got keyword details from Keyword page -\n" + map.toString());
        DOMImplementation impl = DOMImplementationImpl.getDOMImplementation();
        this.adp.deleteAllSubtrees("keywordSet");
        Iterator keyIt = map.keySet().iterator();
        Object nextXPathObj2 = null;
        String nextXPath = null;
        HashMap<String, OrderedMap> keySetMap = new HashMap<String, OrderedMap>();
        while (keyIt.hasNext()) {
            nextXPathObj2 = keyIt.next();
            if (nextXPathObj2 == null) continue;
            nextXPath = nextXPathObj2;
            String temp = nextXPath.substring(12, nextXPath.length());
            temp = temp.substring(0, temp.indexOf("]"));
            nextXPath = nextXPath.replaceFirst(temp, "1");
            if (keySetMap.containsKey(temp)) {
                keyMap = (OrderedMap)keySetMap.get(temp);
                keyMap.put((Object)nextXPath, map.get(nextXPathObj2));
                continue;
            }
            keyMap = new OrderedMap();
            keyMap.put((Object)nextXPath, map.get(nextXPathObj2));
            keySetMap.put(temp, keyMap);
        }
        for (Object nextXPathObj2 : keySetMap.keySet()) {
            keyMap = (OrderedMap)keySetMap.get(nextXPathObj2);
            Document doc = impl.createDocument("", "keywordSet", null);
            this.keywordRoot = doc.getDocumentElement();
            try {
                XMLUtilities.getXPathMapAsDOMTree((Map)keyMap, (Node)this.keywordRoot);
            }
            catch (TransformerException w) {
                Log.debug(5, "Unable to add keyword details to package!");
                Log.debug(15, "TransformerException (" + w + ") calling " + "XMLUtilities.getXPathMapAsDOMTree(keywordMap, keywordRoot) with \n" + "map = " + map + " and keywordRoot = " + this.keywordRoot);
                return;
            }
            Node check = this.adp.insertSubtree("keywordSet", this.keywordRoot, 0);
            if (check != null) {
                Log.debug(45, "added new title details to package...");
                continue;
            }
            Log.debug(5, "** ERROR: Unable to add new title details to package **");
        }
    }
}

