/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datapackage;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.datapackage.AccessionNumber;
import edu.ucsb.nceas.morpho.datapackage.Attribute;
import edu.ucsb.nceas.morpho.datapackage.Entity;
import edu.ucsb.nceas.morpho.datapackage.MetadataObject;
import edu.ucsb.nceas.morpho.datastore.CacheAccessException;
import edu.ucsb.nceas.morpho.datastore.FileSystemDataStore;
import edu.ucsb.nceas.morpho.datastore.MetacatDataStore;
import edu.ucsb.nceas.morpho.datastore.MetacatUploadException;
import edu.ucsb.nceas.morpho.framework.ConfigXML;
import edu.ucsb.nceas.morpho.plugins.XMLFactoryInterface;
import edu.ucsb.nceas.morpho.query.LocalQuery;
import edu.ucsb.nceas.morpho.util.DocumentNotFoundException;
import edu.ucsb.nceas.morpho.util.IOUtil;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.morpho.util.XMLTransformer;
import edu.ucsb.nceas.utilities.OrderedMap;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JOptionPane;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.apache.xpath.XPathAPI;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public abstract class AbstractDataPackage
extends MetadataObject
implements XMLFactoryInterface {
    protected String location = "";
    protected String id;
    protected ConfigXML config;
    protected File dataPkgFile;
    protected FileSystemDataStore fileSysDataStore;
    protected MetacatDataStore metacatDataStore;
    private static Map customUnitDictionaryUnitsCacheMap = new HashMap();
    private static String[] customUnitDictionaryUnitTypesArray = new String[0];
    private Node[] lastAttributeArray = null;
    private int lastEntityIndex = -1;
    protected String initialId = null;
    protected Entity[] entityArray;
    private final String HTMLEXTENSION = ".html";
    private final String METADATAHTML = "metadata";
    private final String EXPORTSYLE = "export";
    public static final String METACAT = "metacat";
    public static final String LOCAL = "local";
    public static final String BOTH = "localmetacat";
    private List toBeImported = null;
    private int toBeImportedCount = 0;
    private List lastImportedAttributes;
    private String lastImportedEntityName;
    private Vector lastImportedDataSet;
    private Entity[] originalEntities = null;

    public abstract void serialize(String var1) throws MetacatUploadException;

    public abstract void load(String var1, String var2, Morpho var3);

    public abstract void load(InputSource var1);

    public abstract AbstractDataPackage upload(String var1, boolean var2) throws MetacatUploadException;

    public abstract AbstractDataPackage download(String var1);

    public abstract Node getReferencedNode(Node var1);

    protected File getFileWithID(String ID, Morpho morpho) throws Throwable {
        Object returnFile = null;
        if (this.location.equals(METACAT)) {
            try {
                Log.debug(11, "opening metacat file");
                if (this.metacatDataStore == null) {
                    this.metacatDataStore = new MetacatDataStore(morpho);
                }
                this.dataPkgFile = this.metacatDataStore.openFile(ID);
                Log.debug(11, "metacat file opened");
            }
            catch (FileNotFoundException fnfe) {
                Log.debug(0, "Error in DataPackage.getFileFromDataStore(): metacat file not found: " + fnfe.getMessage());
                fnfe.printStackTrace();
                throw fnfe.fillInStackTrace();
            }
            catch (CacheAccessException cae) {
                Log.debug(0, "Error in DataPackage.getFileFromDataStore(): metacat cache problem: " + cae.getMessage());
                cae.printStackTrace();
                throw cae.fillInStackTrace();
            }
        }
        try {
            Log.debug(11, "opening local file");
            if (this.fileSysDataStore == null) {
                this.fileSysDataStore = new FileSystemDataStore(morpho);
            }
            this.dataPkgFile = this.fileSysDataStore.openFile(ID);
            Log.debug(11, "local file opened");
        }
        catch (FileNotFoundException fnfe) {
            Log.debug(0, "Error in DataPackage.getFileFromDataStore(): local file not found: " + fnfe.getMessage());
            fnfe.printStackTrace();
            throw fnfe.fillInStackTrace();
        }
        return this.dataPkgFile;
    }

    public void setInitialId(String initId) {
        this.initialId = initId;
    }

    public String getInitialId() {
        return this.initialId;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getTitle() {
        String temp = this.getGenericValue("/xpathKeyMap/contextNode[@name='package']/title");
        return temp;
    }

    public String getAuthor() {
        String temp = "";
        temp = this.getGenericValue("/xpathKeyMap/contextNode[@name='package']/author");
        return temp;
    }

    public String getAccessionNumber() {
        String initId = this.getInitialId();
        String temp = this.getGenericValue("/xpathKeyMap/contextNode[@name='package']/accessionNumber");
        if (initId != null) {
            if (!initId.equals(temp)) {
                Log.debug(10, "Internal Id DOES NOT match Storage Id!!!");
            }
            temp = initId;
        }
        return temp;
    }

    public String getPackageId() {
        String temp = "";
        temp = this.getAccessionNumber();
        return temp;
    }

    public String getPackageIdFromDOM() {
        String emlXpath = "/eml:eml/";
        NodeList nodes = null;
        try {
            nodes = XMLUtilities.getNodeListWithXPath((Node)this.getMetadataNode(), (String)emlXpath);
        }
        catch (Exception w) {
            // empty catch block
        }
        if (nodes == null) {
            return null;
        }
        if (nodes.getLength() > 0) {
            NamedNodeMap atts = nodes.item(0).getAttributes();
            String packageId = atts.getNamedItem("packageId").getNodeValue();
            return packageId;
        }
        return "";
    }

    public void setAccessionNumber(String id) {
        this.setGenericValue("/xpathKeyMap/contextNode[@name='package']/accessionNumber", id);
        this.setInitialId(null);
    }

    public String getKeywords() {
        String temp = "";
        NodeList keywordsNodes = null;
        String keywordsXpath = "";
        try {
            keywordsXpath = XMLUtilities.getTextNodeWithXPath((Node)this.getMetadataPath(), (String)"/xpathKeyMap/contextNode[@name='package']/keywords").getNodeValue();
            keywordsNodes = XMLUtilities.getNodeListWithXPath((Node)this.metadataNode, (String)keywordsXpath);
            if (keywordsNodes == null) {
                return "";
            }
        }
        catch (Exception w) {
            Log.debug(50, "exception in getting keyword");
        }
        int numKeywords = keywordsNodes.getLength();
        String kw = "";
        for (int i = 1; i < numKeywords + 1; ++i) {
            kw = this.getXPathValue("(" + keywordsXpath + ")[" + i + "]");
            if (temp.length() > 0) {
                temp = temp + ", ";
            }
            temp = temp + kw;
        }
        return temp;
    }

    public boolean subtreeExists(String genericName, int index) {
        return null != this.getSubtree(genericName, index);
    }

    public Node getSubtree(String genericName, int index) {
        NodeList nodelist = null;
        String genericNamePath = "";
        try {
            genericNamePath = XMLUtilities.getTextNodeWithXPath((Node)this.getMetadataPath(), (String)("/xpathKeyMap/contextNode[@name='package']/" + genericName)).getNodeValue();
            nodelist = XMLUtilities.getNodeListWithXPath((Node)this.metadataNode, (String)genericNamePath);
            if (nodelist == null || nodelist.getLength() == 0) {
                Log.debug(50, "AbstractDataPackage.getSubtree() - no nodes found of type \n /xpathKeyMap/contextNode[@name='package']/" + genericName + "\n returning NULL");
                return null;
            }
            if (index < nodelist.getLength()) {
                Node deepClone = nodelist.item(index).cloneNode(true);
                DOMImplementation impl = DOMImplementationImpl.getDOMImplementation();
                Document doc = impl.createDocument("", "tempRoot", null);
                Node importedClone = doc.importNode(deepClone, true);
                Element tempRoot = doc.getDocumentElement();
                doc.replaceChild(importedClone, tempRoot);
                return importedClone;
            }
            Log.debug(50, "AbstractDataPackage.getSubtree() - index was greater than number of available nodes; returning NULL");
            return null;
        }
        catch (Exception e) {
            Log.debug(50, "Exception in getSubtree!");
            return null;
        }
    }

    public List getSubtrees(String genericName) {
        ArrayList<Node> returnList = new ArrayList<Node>();
        NodeList nodelist = null;
        String genericNamePath = "";
        try {
            genericNamePath = XMLUtilities.getTextNodeWithXPath((Node)this.getMetadataPath(), (String)("/xpathKeyMap/contextNode[@name='package']/" + genericName)).getNodeValue();
            nodelist = XMLUtilities.getNodeListWithXPath((Node)this.metadataNode, (String)genericNamePath);
        }
        catch (Exception e) {
            Log.debug(50, "Exception in getSubtree!");
        }
        if (nodelist == null || nodelist.getLength() == 0) {
            Log.debug(50, "AbstractDataPackage.getSubtrees() - no nodes found of type \n /xpathKeyMap/contextNode[@name='package']/" + genericName + "\n returning empty List");
        } else {
            for (int index = 0; index < nodelist.getLength(); ++index) {
                Node deepClone = nodelist.item(index).cloneNode(true);
                DOMImplementation impl = DOMImplementationImpl.getDOMImplementation();
                Document doc = impl.createDocument("", "tempRoot", null);
                Node importedClone = doc.importNode(deepClone, true);
                Element tempRoot = doc.getDocumentElement();
                doc.replaceChild(importedClone, tempRoot);
                returnList.add(importedClone);
            }
        }
        return returnList;
    }

    public abstract Node getSubtreeAtReference(String var1);

    public abstract Node getSubtreeAtReferenceNoClone(String var1);

    public abstract Node replaceSubtreeAtReference(String var1, Node var2);

    public abstract List getSubtreesThatReference(String var1);

    public List deleteAllSubtrees(String genericName) {
        NodeList nodelist = null;
        ArrayList<Node> returnList = new ArrayList<Node>();
        String genericNamePath = "";
        try {
            int startIdx;
            genericNamePath = XMLUtilities.getTextNodeWithXPath((Node)this.getMetadataPath(), (String)("/xpathKeyMap/contextNode[@name='package']/" + genericName)).getNodeValue();
            nodelist = XMLUtilities.getNodeListWithXPath((Node)this.metadataNode, (String)genericNamePath);
            if (nodelist == null) {
                return returnList;
            }
            for (int index = startIdx = nodelist.getLength() - 1; index > -1; --index) {
                Node node = nodelist.item(index);
                Node parnode = node.getParentNode();
                if (parnode == null) {
                    return returnList;
                }
                returnList.add(parnode.removeChild(node));
            }
        }
        catch (Exception e) {
            Log.debug(15, "Exception in deleteAllSubtrees!" + e);
            e.printStackTrace();
            returnList.clear();
            return returnList;
        }
        return returnList;
    }

    public Node getSubtreeNoClone(String genericName, int index) {
        NodeList nodelist = null;
        String genericNamePath = "";
        try {
            genericNamePath = XMLUtilities.getTextNodeWithXPath((Node)this.getMetadataPath(), (String)("/xpathKeyMap/contextNode[@name='package']/" + genericName)).getNodeValue();
            nodelist = XMLUtilities.getNodeListWithXPath((Node)this.metadataNode, (String)genericNamePath);
            if (nodelist == null || nodelist.getLength() == 0) {
                return null;
            }
            if (index < nodelist.getLength()) {
                Node unClone = nodelist.item(index);
                return unClone;
            }
            return null;
        }
        catch (Exception e) {
            Log.debug(50, "Exception in getSubtreeNoClone!");
            return null;
        }
    }

    public List getIDsForNodesWithName(String genericName) {
        NodeList IDNodes;
        ArrayList<String> returnList = new ArrayList<String>();
        String IDXpath = "";
        try {
            Node textNode = XMLUtilities.getTextNodeWithXPath((Node)this.getMetadataPath(), (String)("/xpathKeyMap/contextNode[@name='package']/" + genericName));
            if (textNode == null) {
                Log.debug(40, "Unable to find text node with the given name!");
                return returnList;
            }
            IDXpath = textNode.getNodeValue();
            IDNodes = XMLUtilities.getNodeListWithXPath((Node)this.metadataNode, (String)IDXpath);
            if (IDNodes == null) {
                Log.debug(40, "IDs returnList is null!");
                return returnList;
            }
        }
        catch (Exception w) {
            Log.debug(50, "exception in getting IDsForNodes");
            w.printStackTrace();
            return returnList;
        }
        for (int i = 0; i < IDNodes.getLength(); ++i) {
            Element node = (Element)IDNodes.item(i);
            String IDValue = node.getAttribute("id");
            if (IDValue.equals("")) continue;
            returnList.add(IDValue);
        }
        return returnList;
    }

    public synchronized String getNewUniqueReferenceID() {
        String newID = null;
        while (this.getSubtreeAtReference(newID = String.valueOf(System.currentTimeMillis())) != null) {
        }
        return newID;
    }

    public Node insertSubtree(String genericName, Node subtreeRootNode, int index) {
        Document thisDom = this.getMetadataNode().getOwnerDocument();
        Node newSubtree = thisDom.importNode(subtreeRootNode, true);
        Node subTreeNode = this.getSubtreeNoClone(genericName, 0);
        if (subTreeNode == null) {
            try {
                NodeList temp;
                String path;
                Node nd;
                int i;
                NodeList insertionList = XMLUtilities.getNodeListWithXPath((Node)this.getMetadataPath(), (String)("/xpathKeyMap/insertionList[@name='" + genericName + "']/prevNode"));
                if (insertionList == null) {
                    insertionList = XMLUtilities.getNodeListWithXPath((Node)this.getMetadataPath(), (String)("/xpathKeyMap/insertionList[@name='" + genericName + "']/nextNode"));
                    if (insertionList == null) {
                        Log.debug(15, "\n** Error in AbstractDataPackage insertSubtree():\nXMLUtilities.getNodeListWithXPath() returned NULL for xpath: /xpathKeyMap/insertionList[@name='" + genericName + "']/prevNode and " + "/xpathKeyMap/insertionList[@name='" + genericName + "']/nextNode");
                        return null;
                    }
                    for (i = 0; i < insertionList.getLength(); ++i) {
                        nd = insertionList.item(i);
                        path = nd.getFirstChild().getNodeValue();
                        temp = XMLUtilities.getNodeListWithXPath((Node)this.metadataNode, (String)path);
                        if (temp == null || temp.getLength() <= 0) continue;
                        Log.debug(40, "found: " + path);
                        Node nextNode = temp.item(0);
                        Node par = nextNode.getParentNode();
                        par.insertBefore(newSubtree, nextNode);
                        return newSubtree;
                    }
                }
                for (i = 0; i < insertionList.getLength(); ++i) {
                    nd = insertionList.item(i);
                    path = nd.getFirstChild().getNodeValue();
                    temp = XMLUtilities.getNodeListWithXPath((Node)this.metadataNode, (String)path);
                    if (temp == null || temp.getLength() <= 0) continue;
                    Log.debug(40, "found: " + path);
                    Node prevNode = temp.item(temp.getLength() - 1);
                    Document doc = prevNode.getOwnerDocument();
                    Node nextNode = prevNode.getNextSibling();
                    Node par = prevNode.getParentNode();
                    if (nextNode == null) {
                        par.appendChild(newSubtree);
                    } else {
                        par.insertBefore(newSubtree, nextNode);
                    }
                    return newSubtree;
                }
            }
            catch (Exception w) {
                Log.debug(15, "Error in 'insertSubtree method in AbstractDataPackage");
                w.printStackTrace();
                return null;
            }
        } else {
            Node subTreeNodeParent = subTreeNode.getParentNode();
            if (subTreeNodeParent == null) {
                return null;
            }
            Node stn = subTreeNode;
            int count = 0;
            while (stn != null) {
                stn = this.getSubtreeNoClone(genericName, ++count);
            }
            if (--count < index) {
                stn = this.getSubtreeNoClone(genericName, count);
                Node nnode = stn.getNextSibling();
                if (nnode != null) {
                    subTreeNodeParent.insertBefore(newSubtree, nnode);
                } else {
                    subTreeNodeParent.appendChild(newSubtree);
                }
            } else {
                stn = this.getSubtreeNoClone(genericName, index);
                subTreeNodeParent.insertBefore(newSubtree, stn);
            }
            return newSubtree;
        }
        return null;
    }

    public Node deleteSubtree(String genericName, int index) {
        NodeList nodelist = null;
        String genericNamePath = "";
        try {
            genericNamePath = XMLUtilities.getTextNodeWithXPath((Node)this.getMetadataPath(), (String)("/xpathKeyMap/contextNode[@name='package']/" + genericName)).getNodeValue();
            nodelist = XMLUtilities.getNodeListWithXPath((Node)this.metadataNode, (String)genericNamePath);
            if (nodelist == null || nodelist.getLength() == 0) {
                return null;
            }
            if (index < nodelist.getLength()) {
                Node node = nodelist.item(index);
                Node parnode = node.getParentNode();
                if (parnode == null) {
                    return null;
                }
                return parnode.removeChild(node);
            }
            return null;
        }
        catch (Exception e) {
            Log.debug(15, "Exception in deleteSubtree! " + e);
            e.printStackTrace();
            return null;
        }
    }

    public Node replaceSubtree(String genericName, Node newSubtreeRootNode, int index) {
        Node deleted = this.deleteSubtree(genericName, index);
        Node added = null;
        if (deleted == null) {
            Log.debug(15, "** ERROR in replaceSubtree! - delete was unsuccessful. Are you sure the node exists? - returning NULL");
            return null;
        }
        added = this.insertSubtree(genericName, newSubtreeRootNode, index);
        if (added == null) {
            Log.debug(15, "** ERROR in replaceSubtree! - add was unsuccessful - trying to undo delete...");
            added = this.insertSubtree(genericName, deleted, index);
            if (added != null) {
                Log.debug(15, "** ...undo was successful...");
            } else {
                Log.debug(15, "** ...UNDO FAILED - DATAPACKAGE NOT RETURNED TO ORIGINAL STATE!!!...");
            }
            Log.debug(15, "** ...finally, returning NULL");
            return null;
        }
        return added;
    }

    public Node getCoverageNode() {
        NodeList covNodes = null;
        String covXpath = "";
        try {
            covXpath = XMLUtilities.getTextNodeWithXPath((Node)this.getMetadataPath(), (String)"/xpathKeyMap/contextNode[@name='package']/coverage").getNodeValue();
            covNodes = XMLUtilities.getNodeListWithXPath((Node)this.metadataNode, (String)covXpath);
            if (covNodes == null) {
                return null;
            }
            return covNodes.item(0);
        }
        catch (Exception w) {
            Log.debug(50, "exception in getting coverageNode");
            return null;
        }
    }

    public NodeList getGeographicNodeList() {
        NodeList geoNodes = null;
        String geoXpath = "";
        try {
            geoXpath = XMLUtilities.getTextNodeWithXPath((Node)this.getMetadataPath(), (String)"/xpathKeyMap/contextNode[@name='package']/geographicCoverage").getNodeValue();
            geoNodes = XMLUtilities.getNodeListWithXPath((Node)this.metadataNode, (String)geoXpath);
        }
        catch (Exception w) {
            Log.debug(50, "exception in getting geoNodeLIst");
        }
        return geoNodes;
    }

    public void removeGeographicNodes() {
        NodeList gList = this.getGeographicNodeList();
        if (gList == null) {
            return;
        }
        for (int i = 0; i < gList.getLength(); ++i) {
            Node node = gList.item(i);
            Node par = node.getParentNode();
            par.removeChild(node);
        }
    }

    public NodeList getTemporalNodeList() {
        NodeList tempNodes = null;
        String tempXpath = "";
        try {
            tempXpath = XMLUtilities.getTextNodeWithXPath((Node)this.getMetadataPath(), (String)"/xpathKeyMap/contextNode[@name='package']/temporalCoverage").getNodeValue();
            tempNodes = XMLUtilities.getNodeListWithXPath((Node)this.metadataNode, (String)tempXpath);
        }
        catch (Exception w) {
            Log.debug(50, "exception in getting tempoNodeLIst");
        }
        return tempNodes;
    }

    public void removeTemporalNodes() {
        NodeList tList = this.getTemporalNodeList();
        if (tList == null) {
            return;
        }
        for (int i = 0; i < tList.getLength(); ++i) {
            Node node = tList.item(i);
            Node par = node.getParentNode();
            par.removeChild(node);
        }
    }

    public NodeList getTaxonomicNodeList() {
        NodeList taxNodes = null;
        String taxXpath = "";
        try {
            taxXpath = XMLUtilities.getTextNodeWithXPath((Node)this.getMetadataPath(), (String)"/xpathKeyMap/contextNode[@name='package']/taxonomicCoverage").getNodeValue();
            taxNodes = XMLUtilities.getNodeListWithXPath((Node)this.metadataNode, (String)taxXpath);
        }
        catch (Exception w) {
            Log.debug(50, "exception in getting taxoNodeLIst");
        }
        return taxNodes;
    }

    public void removeTaxonomicNodes() {
        NodeList tList = this.getTaxonomicNodeList();
        if (tList == null) {
            return;
        }
        for (int i = 0; i < tList.getLength(); ++i) {
            Node node = tList.item(i);
            Node par = node.getParentNode();
            par.removeChild(node);
        }
    }

    public void insertCoverage(Node covSubtree) {
        Document thisDom = this.getMetadataNode().getOwnerDocument();
        Node newCovSubtree = thisDom.importNode(covSubtree, true);
        Node covNode = this.getCoverageNode();
        if (covNode == null) {
            try {
                NodeList insertionList = XMLUtilities.getNodeListWithXPath((Node)this.getMetadataPath(), (String)"/xpathKeyMap/insertionList[@name='coverage']/prevNode");
                for (int i = 0; i < insertionList.getLength(); ++i) {
                    Node nd = insertionList.item(i);
                    String path = nd.getFirstChild().getNodeValue();
                    NodeList temp = XMLUtilities.getNodeListWithXPath((Node)this.metadataNode, (String)path);
                    if (temp == null || temp.getLength() <= 0) continue;
                    Log.debug(40, "found: " + path);
                    Node prevNode = temp.item(0);
                    Document doc = prevNode.getOwnerDocument();
                    Element newCov = doc.createElement("coverage");
                    Node nextNode = prevNode.getNextSibling();
                    Node par = prevNode.getParentNode();
                    if (nextNode == null) {
                        par.appendChild(newCov);
                    } else {
                        par.insertBefore(newCov, nextNode);
                    }
                    newCov.appendChild(newCovSubtree);
                    return;
                }
            }
            catch (Exception w) {
                Log.debug(1, "Error in 'insertCoverage method in AbstractDataPackage");
            }
        } else {
            covNode.appendChild(newCovSubtree);
        }
    }

    public Entity[] getEntityArray() {
        if (this.entityArray != null) {
            return this.entityArray;
        }
        String entityXpath = "";
        try {
            entityXpath = XMLUtilities.getTextNodeWithXPath((Node)this.getMetadataPath(), (String)"/xpathKeyMap/contextNode[@name='package']/entities").getNodeValue();
            NodeList entityNodes = XMLUtilities.getNodeListWithXPath((Node)this.metadataNode, (String)entityXpath);
            if (entityNodes == null) {
                Log.debug(20, "entityList is null!");
                this.entityArray = null;
            } else {
                Node[] entityArrayNodes = XMLUtilities.getNodeListAsNodeArray((NodeList)entityNodes);
                for (int j = 0; j < entityArrayNodes.length; ++j) {
                    entityArrayNodes[j] = this.getReferencedNode(entityArrayNodes[j]);
                }
                this.entityArray = new Entity[entityArrayNodes.length];
                for (int i = 0; i < entityArrayNodes.length; ++i) {
                    this.entityArray[i] = new Entity(entityArrayNodes[i], this);
                }
            }
        }
        catch (Exception w) {
            Log.debug(50, "exception in getting entityArray");
            w.printStackTrace();
            return null;
        }
        return this.entityArray;
    }

    public String getEntityName(int entNum) {
        String temp = "";
        if (entNum < 0) {
            return "No such entity!";
        }
        if (this.entityArray == null || this.entityArray.length < entNum + 1) {
            return "No such entity!";
        }
        Node entity = this.entityArray[entNum].getNode();
        String entityNameXpath = "";
        try {
            entityNameXpath = XMLUtilities.getTextNodeWithXPath((Node)this.getMetadataPath(), (String)"/xpathKeyMap/contextNode[@name='entity']/name").getNodeValue();
            NodeList enameNodes = XPathAPI.selectNodeList((Node)entity, (String)entityNameXpath);
            if (enameNodes == null) {
                return "enameNodes is null !";
            }
            Node child = enameNodes.item(0).getFirstChild();
            temp = child.getNodeValue();
        }
        catch (Exception w) {
            Log.debug(50, "exception in getting entity name" + w.toString());
        }
        return temp;
    }

    public int getEntityIndex(String entName) {
        String temp = "";
        if (this.entityArray == null) {
            return -1;
        }
        for (int i = 0; i < this.entityArray.length; ++i) {
            Node entity = this.entityArray[i].getNode();
            String entityNameXpath = "";
            try {
                entityNameXpath = XMLUtilities.getTextNodeWithXPath((Node)this.getMetadataPath(), (String)"/xpathKeyMap/contextNode[@name='entity']/name").getNodeValue();
                NodeList enameNodes = XPathAPI.selectNodeList((Node)entity, (String)entityNameXpath);
                if (enameNodes == null) continue;
                Node child = enameNodes.item(0).getFirstChild();
                temp = child.getNodeValue();
            }
            catch (Exception w) {
                Log.debug(50, "exception in getting entity name" + w.toString());
                continue;
            }
            if (!temp.equals(entName)) continue;
            return i;
        }
        return -1;
    }

    public String getEntityNumRecords(int entNum) {
        String temp = "";
        if (this.entityArray == null || this.entityArray.length < entNum + 1) {
            return "No such entity!";
        }
        Node entity = this.entityArray[entNum].getNode();
        String entityNumRecordsXpath = "";
        try {
            entityNumRecordsXpath = XMLUtilities.getTextNodeWithXPath((Node)this.getMetadataPath(), (String)"/xpathKeyMap/contextNode[@name='entity']/numRecords").getNodeValue();
            NodeList eNodes = XPathAPI.selectNodeList((Node)entity, (String)entityNumRecordsXpath);
            if (eNodes == null) {
                return "eNodes is null !";
            }
            Node child = eNodes.item(0).getFirstChild();
            temp = child.getNodeValue();
        }
        catch (Exception w) {
            Log.debug(50, "exception in getting entity numRecords" + w.toString());
        }
        return temp;
    }

    public int getEntityCount() {
        if (this.entityArray == null) {
            return 0;
        }
        return this.entityArray.length;
    }

    public int getAttributeCountForAnEntity(int entityIndex) {
        if (entityIndex < 0) {
            return 0;
        }
        if (this.entityArray == null || this.entityArray.length < entityIndex + 1) {
            return 0;
        }
        Node[] attributes = this.getAttributeArray(entityIndex);
        if (attributes == null) {
            return 0;
        }
        return attributes.length;
    }

    public void setEntityNumRecords(int entNum, String numRecS) {
        if (this.entityArray == null || this.entityArray.length < entNum + 1) {
            Log.debug(20, "No such entity!");
            return;
        }
        Node entity = this.entityArray[entNum].getNode();
        String entityNumRecordsXpath = "";
        try {
            entityNumRecordsXpath = XMLUtilities.getTextNodeWithXPath((Node)this.getMetadataPath(), (String)"/xpathKeyMap/contextNode[@name='entity']/numRecords").getNodeValue();
            NodeList eNodes = XPathAPI.selectNodeList((Node)entity, (String)entityNumRecordsXpath);
            if (eNodes == null) {
                return;
            }
            Node child = eNodes.item(0).getFirstChild();
            child.setNodeValue(numRecS);
        }
        catch (Exception w) {
            Log.debug(50, "exception in setting entity numRecords" + w.toString());
        }
    }

    public String getEntityDescription(int entNum) {
        String temp = "";
        if (entNum < 0) {
            return "No such entity!";
        }
        if (this.entityArray == null || this.entityArray.length < entNum + 1) {
            return "No such entity!";
        }
        Node entity = this.entityArray[entNum].getNode();
        String entityXpath = "";
        try {
            entityXpath = XMLUtilities.getTextNodeWithXPath((Node)this.getMetadataPath(), (String)"/xpathKeyMap/contextNode[@name='entity']/entityDescription").getNodeValue();
            NodeList eNodes = XPathAPI.selectNodeList((Node)entity, (String)entityXpath);
            if (eNodes == null) {
                return "eNodes is null !";
            }
            Node child = eNodes.item(0).getFirstChild();
            temp = child.getNodeValue();
        }
        catch (Exception w) {
            Log.debug(50, "exception in getting entity description" + w.toString());
        }
        return temp;
    }

    public String getEntityID(int entNum) {
        String id = "";
        if (entNum < 0) {
            return "";
        }
        if (this.entityArray == null || this.entityArray.length < entNum + 1) {
            return "";
        }
        Node entity = this.entityArray[entNum].getNode();
        NamedNodeMap nnm = entity.getAttributes();
        if (nnm != null) {
            Node idNode = nnm.getNamedItem("id");
            if (idNode != null) {
                id = idNode.getNodeValue();
            } else {
                Log.debug(45, "No ID Attributes for the given entity " + this.getEntityName(entNum));
            }
        } else {
            Log.debug(45, "No Attributes for the given entity : " + this.getEntityName(entNum));
        }
        return id;
    }

    public void setEntityID(int entNum, String ID) {
        if (entNum < 0) {
            return;
        }
        if (this.entityArray == null || this.entityArray.length < entNum + 1) {
            return;
        }
        Node entity = this.entityArray[entNum].getNode();
        NamedNodeMap nnm = entity.getAttributes();
        if (nnm != null) {
            Node idNode = nnm.getNamedItem("id");
            if (idNode != null) {
                idNode.setNodeValue(ID);
                return;
            }
            Log.debug(45, "No ID Attributes for the given entity " + this.getEntityName(entNum) + " - Adding the ID Attribute");
        } else {
            Log.debug(45, "No Attributes for the given entity : " + this.getEntityName(entNum) + " - Adding ID Attribute");
        }
        ((Element)entity).setAttribute("id", ID);
    }

    public void deleteEntity(int entNum) {
        if (this.entityArray == null || this.entityArray.length < entNum + 1) {
            Log.debug(20, "Unable to find entity at index");
            return;
        }
        Node entity = this.entityArray[entNum].getNode();
        Node parent = entity.getParentNode();
        parent.removeChild(entity);
        Entity[] newEntityArray = new Entity[this.entityArray.length - 1];
        int newCount = 0;
        for (int count = 0; count < this.entityArray.length; ++count) {
            if (count == entNum) continue;
            newEntityArray[newCount++] = this.entityArray[count];
        }
        this.entityArray = newEntityArray;
    }

    public void deleteAllEntities() {
        if (this.entityArray == null || this.entityArray.length < 1) {
            Log.debug(20, "Unable to find any entities");
            return;
        }
        Node parent = this.entityArray[0].getNode().getParentNode();
        for (int i = 0; i < this.entityArray.length; ++i) {
            Node entity = this.entityArray[i].getNode();
            parent.removeChild(entity);
        }
        this.entityArray = null;
    }

    public void addEntity(Entity entity) {
        if (this.entityArray == null) {
            this.insertEntity(entity, 0);
        } else {
            this.insertEntity(entity, this.entityArray.length);
        }
    }

    public void insertEntity(Entity entity, int pos) {
        Document thisDom = this.getMetadataNode().getOwnerDocument();
        Node newEntityNode = thisDom.importNode(entity.getNode(), true);
        if (this.entityArray != null && this.entityArray.length > 0) {
            if (this.entityArray.length > pos) {
                Node par = this.entityArray[pos].getNode().getParentNode();
                par.insertBefore(newEntityNode, this.entityArray[pos].getNode());
            } else {
                Node par1 = this.entityArray[0].getNode().getParentNode();
                par1.appendChild(newEntityNode);
            }
            this.entityArray = null;
            this.entityArray = this.getEntityArray();
        } else {
            Node entityPar = null;
            String temp = "";
            try {
                Node tempNode = XMLUtilities.getTextNodeWithXPath((Node)this.getMetadataPath(), (String)"/xpathKeyMap/contextNode[@name='package']/entityParent");
                temp = tempNode.getNodeValue();
                entityPar = XMLUtilities.getNodeWithXPath((Node)this.getMetadataNode(), (String)temp);
            }
            catch (Exception w) {
                Log.debug(20, "Error adding new entity!");
                return;
            }
            entityPar.appendChild(newEntityNode);
            Entity[] newEntArray = new Entity[]{new Entity(newEntityNode, this)};
            this.entityArray = newEntArray;
        }
    }

    public Node[] getAttributeArray(int entityIndex) {
        if (entityIndex == this.lastEntityIndex && this.lastAttributeArray != null) {
            return this.lastAttributeArray;
        }
        if (entityIndex < 0) {
            return null;
        }
        if (entityIndex > this.entityArray.length - 1) {
            Log.debug(15, "entity index > number of entities");
            return null;
        }
        String attributeXpath = "";
        try {
            attributeXpath = XMLUtilities.getTextNodeWithXPath((Node)this.getMetadataPath(), (String)"/xpathKeyMap/contextNode[@name='entity']/attributes").getNodeValue();
            NodeList attributeNodes = XMLUtilities.getNodeListWithXPath((Node)this.entityArray[entityIndex].getNode(), (String)attributeXpath);
            if (attributeNodes == null) {
                Log.debug(15, "attributeList is null for entity " + entityIndex);
                return null;
            }
            Node[] attr = XMLUtilities.getNodeListAsNodeArray((NodeList)attributeNodes);
            for (int i = 0; i < attr.length; ++i) {
                attr[i] = this.getReferencedNode(attr[i]);
            }
            this.lastAttributeArray = attr;
            this.lastEntityIndex = entityIndex;
            return attr;
        }
        catch (Exception w) {
            Log.debug(50, "exception in getting attributeArray");
            return null;
        }
    }

    public void deleteAttribute(int entityIndex, int attributeIndex) {
        if (this.entityArray == null || this.entityArray.length < entityIndex + 1) {
            Log.debug(20, "No such entity!");
            return;
        }
        Node[] attributes = this.getAttributeArray(entityIndex);
        if (attributes == null || attributes.length < 1) {
            Log.debug(20, "No such attribute!");
            return;
        }
        Node attrNode = attributes[attributeIndex];
        Node parent = attrNode.getParentNode();
        parent.removeChild(attrNode);
        this.lastEntityIndex = -1;
        this.lastAttributeArray = null;
    }

    public Node appendAdditionalMetadata(Node addtMetadata) {
        Document thisDom = this.getMetadataNode().getOwnerDocument();
        Element rootNode = thisDom.getDocumentElement();
        Node newMetadataNode = thisDom.importNode(addtMetadata, true);
        if (rootNode == null) {
            return null;
        }
        return rootNode.appendChild(newMetadataNode);
    }

    public void loadCustomUnits() {
        Document thisDom = this.getMetadataNode().getOwnerDocument();
        Element rootNode = thisDom.getDocumentElement();
        NodeList nodeList = rootNode.getChildNodes();
        Log.debug(40, "in loadCustom data, initial size = " + customUnitDictionaryUnitsCacheMap.keySet().size());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (!child.getNodeName().equals("additionalMetadata")) continue;
            OrderedMap map = XMLUtilities.getDOMTreeAsXPathMap((Node)child);
            Log.debug(40, "got Map as - " + map.toString());
            this.extractUnits(map, "/additionalMetadata");
        }
        Log.debug(40, "Extracted units -- \n");
        for (String key : customUnitDictionaryUnitsCacheMap.keySet()) {
            String[] arr = (String[])customUnitDictionaryUnitsCacheMap.get(key);
            Log.debug(40, key);
            for (int j = 0; j < arr.length; ++j) {
                Log.debug(40, "\t" + arr[j]);
            }
        }
        Log.debug(40, "End of Extracted units -- \n");
    }

    private void extractUnits(OrderedMap map, String xPath) {
        String name;
        xPath = xPath + "/unitList[1]";
        int cnt = 1;
        while ((name = (String)map.get((Object)(xPath + "/unit[" + cnt + "]/@name"))) != null) {
            String type = (String)map.get((Object)(xPath + "/unit[" + cnt + "]/@unitType"));
            this.addNewUnit(type, name);
            ++cnt;
        }
    }

    public String[] getUnitDictionaryCustomUnitTypes() {
        return customUnitDictionaryUnitTypesArray;
    }

    public String[] getUnitDictionaryUnitsOfType(String type) {
        String[] ret = (String[])customUnitDictionaryUnitsCacheMap.get(type);
        if (ret == null) {
            return new String[0];
        }
        return ret;
    }

    public static void insertObjectIntoArray(Object[] arr, Object value, Object[] newArr) {
        int idx = Arrays.binarySearch(arr, value);
        int pos = -(idx + 1);
        int i = 0;
        for (i = 0; i < pos; ++i) {
            newArr[i] = arr[i];
        }
        newArr[i] = value;
        for (int j = pos; j < arr.length; ++j) {
            newArr[j + 1] = arr[j];
        }
    }

    public boolean isNewCustomUnit(String type, String unit) {
        boolean newT = customUnitDictionaryUnitsCacheMap.containsKey(type);
        if (newT) {
            Object[] units = (String[])customUnitDictionaryUnitsCacheMap.get(type);
            if (units == null) {
                return true;
            }
            return Arrays.binarySearch(units, unit) < 0;
        }
        return true;
    }

    public void addNewUnit(String unitType, String unit) {
        int idx = Arrays.binarySearch(customUnitDictionaryUnitTypesArray, unitType);
        if (idx < 0) {
            Object[] newArray = new String[customUnitDictionaryUnitTypesArray.length + 1];
            AbstractDataPackage.insertObjectIntoArray(customUnitDictionaryUnitTypesArray, unitType, newArray);
            customUnitDictionaryUnitTypesArray = newArray;
            String[] units = new String[]{unit};
            customUnitDictionaryUnitsCacheMap.put(unitType, units);
        } else {
            Object[] units = (String[])customUnitDictionaryUnitsCacheMap.get(unitType);
            int idx1 = Arrays.binarySearch(units, unit);
            if (idx1 >= 0) {
                return;
            }
            Object[] newUnitArr = new String[units.length + 1];
            AbstractDataPackage.insertObjectIntoArray(units, unit, newUnitArr);
            customUnitDictionaryUnitsCacheMap.put(unitType, newUnitArr);
        }
    }

    public void insertAttribute(int entityIndex, Attribute newAttr, int attrIndex) {
        Node newAttrNode = newAttr.getNode();
        if (this.entityArray == null || this.entityArray.length < entityIndex + 1) {
            Log.debug(20, "No such entity!");
            return;
        }
        Document thisDom = this.getMetadataNode().getOwnerDocument();
        Node newAttributeNode = thisDom.importNode(newAttrNode, true);
        Node[] attributes = this.getAttributeArray(entityIndex);
        if (attributes == null || attributes.length < 1) {
            Node attributeParent = null;
            String temp = "";
            try {
                temp = this.getGenericValue("/xpathKeyMap/contextNode[@name='entity']/attributeParent");
                attributeParent = XMLUtilities.getNodeWithXPath((Node)this.entityArray[entityIndex].getNode(), (String)temp);
            }
            catch (Exception w) {
                Log.debug(20, "Error adding new attribute!");
                return;
            }
            if (attributeParent != null) {
                attributeParent.appendChild(newAttributeNode);
            } else {
                Log.debug(1, "Problem: no attribute parent !!");
            }
            return;
        }
        Node currentAttr = null;
        currentAttr = attrIndex > attributes.length - 1 ? attributes[attributes.length - 1] : attributes[attrIndex];
        if (attrIndex <= attributes.length - 1) {
            Node parent = currentAttr.getParentNode();
            parent.insertBefore(newAttributeNode, currentAttr);
        } else {
            Node parent = currentAttr.getParentNode();
            parent.appendChild(newAttributeNode);
        }
        this.lastEntityIndex = -1;
        this.lastAttributeArray = null;
    }

    public String getAttributeName(int entityIndex, int attributeIndex) {
        String temp = "";
        if (entityIndex < 0) {
            return "No such entity!";
        }
        if (attributeIndex < 0) {
            return "no attributes!";
        }
        if (this.entityArray == null || this.entityArray.length < entityIndex + 1) {
            return "No such entity!";
        }
        Node[] attributes = this.getAttributeArray(entityIndex);
        if (attributes == null || attributes.length < attributeIndex + 1) {
            return "no attributes!";
        }
        Node attribute = attributes[attributeIndex];
        String attrXpath = "";
        try {
            attrXpath = XMLUtilities.getTextNodeWithXPath((Node)this.getMetadataPath(), (String)"/xpathKeyMap/contextNode[@name='attribute']/name").getNodeValue();
            NodeList aNodes = XPathAPI.selectNodeList((Node)attribute, (String)attrXpath);
            if (aNodes == null) {
                return "aNodes is null !";
            }
            Node child = aNodes.item(0).getFirstChild();
            temp = child.getNodeValue();
        }
        catch (Exception w) {
            Log.debug(50, "exception in getting entity description" + w.toString());
        }
        return temp;
    }

    public int getAttributeIndex(int entityIndex, String attributeName) {
        String temp = "";
        if (entityIndex < 0) {
            return -1;
        }
        if (this.entityArray == null || this.entityArray.length < entityIndex + 1) {
            return -1;
        }
        Node[] attributes = this.getAttributeArray(entityIndex);
        if (attributes == null || attributes.length < 1) {
            return -1;
        }
        for (int i = 0; i < attributes.length; ++i) {
            Node attribute = attributes[i];
            String attrXpath = "";
            try {
                attrXpath = XMLUtilities.getTextNodeWithXPath((Node)this.getMetadataPath(), (String)"/xpathKeyMap/contextNode[@name='attribute']/name").getNodeValue();
                NodeList aNodes = XPathAPI.selectNodeList((Node)attribute, (String)attrXpath);
                if (aNodes == null) continue;
                Node child = aNodes.item(0).getFirstChild();
                temp = child.getNodeValue();
            }
            catch (Exception w) {
                Log.debug(50, "exception in getting entity description" + w.toString());
                continue;
            }
            if (!temp.equals(attributeName)) continue;
            return i;
        }
        return -1;
    }

    public String getAttributeID(int entityIndex, int attributeIndex) {
        String id = "";
        if (entityIndex < 0) {
            return "";
        }
        if (attributeIndex < 0) {
            return "";
        }
        if (this.entityArray == null || this.entityArray.length < entityIndex + 1) {
            return "";
        }
        Node[] attributes = this.getAttributeArray(entityIndex);
        if (attributes == null || attributes.length < attributeIndex + 1) {
            return "";
        }
        Node attribute = attributes[attributeIndex];
        NamedNodeMap nnm = attribute.getAttributes();
        if (nnm != null) {
            Node idNode = nnm.getNamedItem("id");
            if (idNode != null) {
                id = idNode.getNodeValue();
            } else {
                Log.debug(45, "No ID Attributes for the given column " + this.getAttributeName(entityIndex, attributeIndex));
            }
        } else {
            Log.debug(45, "No attributes for the given column : " + this.getAttributeName(entityIndex, attributeIndex));
        }
        return id;
    }

    public String getAttributeDataType(int entityIndex, int attributeIndex) {
        String temp = "";
        if (entityIndex < 0) {
            return "No such entity!";
        }
        if (attributeIndex < 0) {
            return "no attributes!";
        }
        if (this.entityArray == null || this.entityArray.length < entityIndex + 1) {
            return "No such entity!";
        }
        Node[] attributes = this.getAttributeArray(entityIndex);
        if (attributes == null || attributes.length < attributeIndex + 1) {
            return "no attributes!";
        }
        Node attribute = attributes[attributeIndex];
        String attrXpath = "";
        try {
            attrXpath = XMLUtilities.getTextNodeWithXPath((Node)this.getMetadataPath(), (String)"/xpathKeyMap/contextNode[@name='attribute']/dataType").getNodeValue();
            NodeList aNodes = XPathAPI.selectNodeList((Node)attribute, (String)attrXpath);
            if (aNodes.getLength() > 0) {
                Node child = aNodes.item(0).getFirstChild();
                temp = child.getNodeValue();
                return temp;
            }
            attrXpath = XMLUtilities.getTextNodeWithXPath((Node)this.getMetadataPath(), (String)"/xpathKeyMap/contextNode[@name='attribute']/isText").getNodeValue();
            XObject xobj = XPathAPI.eval((Node)attribute, (String)attrXpath);
            boolean val = xobj.bool();
            if (val) {
                return "text";
            }
            attrXpath = XMLUtilities.getTextNodeWithXPath((Node)this.getMetadataPath(), (String)"/xpathKeyMap/contextNode[@name='attribute']/isDate").getNodeValue();
            xobj = XPathAPI.eval((Node)attribute, (String)attrXpath);
            val = xobj.bool();
            if (val) {
                return "date";
            }
            attrXpath = XMLUtilities.getTextNodeWithXPath((Node)this.getMetadataPath(), (String)"/xpathKeyMap/contextNode[@name='attribute']/numberType").getNodeValue();
            aNodes = XPathAPI.selectNodeList((Node)attribute, (String)attrXpath);
            if (aNodes == null) {
                return "aNodes is null !";
            }
            Node child = aNodes.item(0).getFirstChild();
            temp = child.getNodeValue();
        }
        catch (Exception w) {
            Log.debug(50, "exception in getting attribute dataType" + w.toString());
        }
        return temp;
    }

    public String getAttributeUnit(int entityIndex, int attributeIndex) {
        String temp = "";
        if (entityIndex < 0) {
            return "No such entity!";
        }
        if (attributeIndex < 0) {
            return "no attributes!";
        }
        if (this.entityArray == null || this.entityArray.length < entityIndex + 1) {
            return "No such entity!";
        }
        Node[] attributes = this.getAttributeArray(entityIndex);
        if (attributes == null || attributes.length < attributeIndex + 1) {
            return "no attributes!";
        }
        Node attribute = attributes[attributeIndex];
        String attrXpath = "";
        try {
            attrXpath = XMLUtilities.getTextNodeWithXPath((Node)this.getMetadataPath(), (String)"/xpathKeyMap/contextNode[@name='attribute']/unit").getNodeValue();
            NodeList aNodes = XPathAPI.selectNodeList((Node)attribute, (String)attrXpath);
            if (aNodes == null) {
                return "aNodes is null !";
            }
            if (aNodes.getLength() < 1) {
                return "";
            }
            Node child = aNodes.item(0).getFirstChild();
            temp = child.getNodeValue().trim();
        }
        catch (Exception w) {
            Log.debug(50, "exception in getting attribute unit -- " + w.toString());
        }
        return temp;
    }

    public Node[] getPhysicalArray(int entityIndex) {
        if (entityIndex > this.entityArray.length - 1) {
            Log.debug(1, "entity index > number of entities");
            return null;
        }
        String physicalXpath = "";
        try {
            physicalXpath = XMLUtilities.getTextNodeWithXPath((Node)this.getMetadataPath(), (String)"/xpathKeyMap/contextNode[@name='entity']/physical").getNodeValue();
            NodeList physicalNodes = XMLUtilities.getNodeListWithXPath((Node)this.entityArray[entityIndex].getNode(), (String)physicalXpath);
            if (physicalNodes == null) {
                Log.debug(1, "physicalList is null!");
                return null;
            }
            return XMLUtilities.getNodeListAsNodeArray((NodeList)physicalNodes);
        }
        catch (Exception w) {
            Log.debug(50, "exception in getting physicalArray");
            return null;
        }
    }

    public String getPhysicalName(int entityIndex, int physicalIndex) {
        String temp = "";
        if (this.entityArray == null || this.entityArray.length < entityIndex + 1) {
            return "No such entity!";
        }
        Node[] physicals = this.getPhysicalArray(entityIndex);
        if (physicals == null || physicals.length < 1) {
            return "no physicals!";
        }
        if (physicalIndex > physicals.length - 1) {
            return "physical index too large!";
        }
        Node physical = physicals[physicalIndex];
        String physXpath = "";
        try {
            physXpath = XMLUtilities.getTextNodeWithXPath((Node)this.getMetadataPath(), (String)"/xpathKeyMap/contextNode[@name='physical']/name").getNodeValue();
            NodeList aNodes = XPathAPI.selectNodeList((Node)physical, (String)physXpath);
            if (aNodes == null) {
                return "aNodes is null !";
            }
            Node child = aNodes.item(0).getFirstChild();
            temp = child.getNodeValue();
        }
        catch (Exception w) {
            Log.debug(50, "exception in getting physical objectName description" + w.toString());
        }
        return temp;
    }

    public String getPhysicalFormat(int entityIndex, int physicalIndex) {
        String temp = "";
        if (this.entityArray == null || this.entityArray.length < entityIndex + 1) {
            return "No such entity!";
        }
        Node[] physicals = this.getPhysicalArray(entityIndex);
        if (physicals == null || physicals.length < 1) {
            return "no physicals!";
        }
        if (physicalIndex > physicals.length - 1) {
            return "physical index too large!";
        }
        Node physical = physicals[physicalIndex];
        String physXpath = "";
        try {
            boolean val;
            physXpath = XMLUtilities.getTextNodeWithXPath((Node)this.getMetadataPath(), (String)"/xpathKeyMap/contextNode[@name='physical']/isText").getNodeValue();
            XObject xobj = XPathAPI.eval((Node)physical, (String)physXpath);
            if (xobj == null) {
                Log.debug(1, "null");
            }
            if (val = xobj.bool()) {
                return "text";
            }
            physXpath = XMLUtilities.getTextNodeWithXPath((Node)this.getMetadataPath(), (String)"/xpathKeyMap/contextNode[@name='physical']/format").getNodeValue();
            NodeList aNodes = XPathAPI.selectNodeList((Node)physical, (String)physXpath);
            if (aNodes == null) {
                return "aNodes is null !";
            }
            Node child = aNodes.item(0).getFirstChild();
            temp = child.getNodeValue();
        }
        catch (Exception w) {
            Log.debug(50, "exception in getting physical format description --- " + w.toString());
        }
        return temp;
    }

    public String getPhysicalSize(int entityIndex, int physicalIndex) {
        String temp = "";
        if (this.entityArray == null || this.entityArray.length < entityIndex + 1) {
            return "No such entity!";
        }
        Node[] physicals = this.getPhysicalArray(entityIndex);
        if (physicals == null || physicals.length < 1) {
            return "no physicals!";
        }
        if (physicalIndex > physicals.length - 1) {
            return "physical index too large!";
        }
        Node physical = physicals[physicalIndex];
        String physXpath = "";
        try {
            physXpath = XMLUtilities.getTextNodeWithXPath((Node)this.getMetadataPath(), (String)"/xpathKeyMap/contextNode[@name='physical']/size").getNodeValue();
            NodeList aNodes = XPathAPI.selectNodeList((Node)physical, (String)physXpath);
            if (aNodes == null) {
                return "aNodes is null !";
            }
            Node child = aNodes.item(0).getFirstChild();
            temp = child.getNodeValue();
        }
        catch (Exception w) {
            Log.debug(50, "exception in getting physical size" + w.toString());
        }
        return temp;
    }

    public void setPhysicalSize(int entityIndex, int physicalIndex, String sizeS) {
        if (this.entityArray == null || this.entityArray.length < entityIndex + 1) {
            Log.debug(20, "No such entity!");
            return;
        }
        Node[] physicals = this.getPhysicalArray(entityIndex);
        if (physicals == null || physicals.length < 1) {
            return;
        }
        if (physicalIndex > physicals.length - 1) {
            return;
        }
        Node physical = physicals[physicalIndex];
        String physXpath = "";
        try {
            physXpath = XMLUtilities.getTextNodeWithXPath((Node)this.getMetadataPath(), (String)"/xpathKeyMap/contextNode[@name='physical']/size").getNodeValue();
            NodeList aNodes = XPathAPI.selectNodeList((Node)physical, (String)physXpath);
            if (aNodes == null) {
                return;
            }
            Node child = aNodes.item(0).getFirstChild();
            child.setNodeValue(sizeS);
        }
        catch (Exception w) {
            Log.debug(50, "exception in getting physical size" + w.toString());
        }
    }

    public String getPhysicalFieldDelimiter(int entityIndex, int physicalIndex) {
        String temp = "";
        if (this.entityArray == null || this.entityArray.length < entityIndex + 1) {
            return "No such entity!";
        }
        Node[] physicals = this.getPhysicalArray(entityIndex);
        if (physicals == null || physicals.length < 1) {
            return "no physicals!";
        }
        if (physicalIndex > physicals.length - 1) {
            return "physical index too large!";
        }
        Node physical = physicals[physicalIndex];
        String physXpath = "";
        try {
            physXpath = XMLUtilities.getTextNodeWithXPath((Node)this.getMetadataPath(), (String)"/xpathKeyMap/contextNode[@name='physical']/fieldDelimiter").getNodeValue();
            NodeList aNodes = XPathAPI.selectNodeList((Node)physical, (String)physXpath);
            if (aNodes == null) {
                return "aNodes is null !";
            }
            Node child = aNodes.item(0).getFirstChild();
            temp = child.getNodeValue();
        }
        catch (Exception w) {
            Log.debug(50, "exception in getting physical field delimiter" + w.toString());
        }
        return temp;
    }

    public abstract boolean ignoreConsecutiveDelimiters(int var1, int var2);

    public void setPhysicalFieldDelimiter(int entityIndex, int physicalIndex, String delim) {
        if (this.entityArray == null || this.entityArray.length < entityIndex + 1) {
            Log.debug(20, "No such entity!");
            return;
        }
        Node[] physicals = this.getPhysicalArray(entityIndex);
        if (physicals == null || physicals.length < 1) {
            return;
        }
        if (physicalIndex > physicals.length - 1) {
            return;
        }
        Node physical = physicals[physicalIndex];
        String physXpath = "";
        try {
            physXpath = XMLUtilities.getTextNodeWithXPath((Node)this.getMetadataPath(), (String)"/xpathKeyMap/contextNode[@name='physical']/fieldDelimiter").getNodeValue();
            NodeList aNodes = XPathAPI.selectNodeList((Node)physical, (String)physXpath);
            if (aNodes == null) {
                return;
            }
            Node child = aNodes.item(0).getFirstChild();
            child.setNodeValue(delim);
        }
        catch (Exception w) {
            Log.debug(50, "exception in getting physical field delimiter" + w.toString());
        }
    }

    public String getPhysicalNumberHeaderLines(int entityIndex, int physicalIndex) {
        String temp = "";
        if (this.entityArray == null || this.entityArray.length < entityIndex + 1) {
            return "No such entity!";
        }
        Node[] physicals = this.getPhysicalArray(entityIndex);
        if (physicals == null || physicals.length < 1) {
            return "no physicals!";
        }
        if (physicalIndex > physicals.length - 1) {
            return "physical index too large!";
        }
        Node physical = physicals[physicalIndex];
        String physXpath = "";
        try {
            physXpath = XMLUtilities.getTextNodeWithXPath((Node)this.getMetadataPath(), (String)"/xpathKeyMap/contextNode[@name='physical']/numberHeaderLines").getNodeValue();
            NodeList aNodes = XPathAPI.selectNodeList((Node)physical, (String)physXpath);
            if (aNodes == null) {
                return "aNodes is null !";
            }
            Node child = aNodes.item(0).getFirstChild();
            temp = child.getNodeValue();
        }
        catch (Exception w) {
            Log.debug(50, "exception in getting physical number HeaderLines" + w.toString());
        }
        return temp;
    }

    public String getEncodingMethod(int entityIndex, int physicalIndex) {
        String temp = "";
        if (entityIndex < 0) {
            return "No such entity!";
        }
        if (physicalIndex < 0) {
            return "no such physical!";
        }
        if (this.entityArray == null || this.entityArray.length < entityIndex + 1) {
            return "No such entity!";
        }
        Node[] physicals = this.getPhysicalArray(entityIndex);
        if (physicals == null || physicals.length < 1) {
            return "no physicals!";
        }
        if (physicalIndex > physicals.length - 1) {
            return "physical index too large!";
        }
        Node physical = physicals[physicalIndex];
        String physXpath = "";
        try {
            physXpath = XMLUtilities.getTextNodeWithXPath((Node)this.getMetadataPath(), (String)"/xpathKeyMap/contextNode[@name='physical']/encodingMethod").getNodeValue();
            NodeList aNodes = XPathAPI.selectNodeList((Node)physical, (String)physXpath);
            if (aNodes == null) {
                return "aNodes is null !";
            }
            Node child = aNodes.item(0).getFirstChild();
            temp = child.getNodeValue();
        }
        catch (Exception w) {
            Log.debug(50, "exception in getting physical encodingMethod" + w.toString());
        }
        return temp;
    }

    public String getCompressionMethod(int entityIndex, int physicalIndex) {
        String temp = "";
        if (this.entityArray == null || this.entityArray.length < entityIndex + 1) {
            return "No such entity!";
        }
        Node[] physicals = this.getPhysicalArray(entityIndex);
        if (physicals == null || physicals.length < 1) {
            return "no physicals!";
        }
        if (physicalIndex > physicals.length - 1) {
            return "physical index too large!";
        }
        Node physical = physicals[physicalIndex];
        String physXpath = "";
        try {
            physXpath = XMLUtilities.getTextNodeWithXPath((Node)this.getMetadataPath(), (String)"/xpathKeyMap/contextNode[@name='physical']/compressionMethod").getNodeValue();
            NodeList aNodes = XPathAPI.selectNodeList((Node)physical, (String)physXpath);
            if (aNodes == null) {
                return "aNodes is null !";
            }
            Node child = aNodes.item(0).getFirstChild();
            temp = child.getNodeValue();
        }
        catch (Exception w) {
            Log.debug(50, "exception in getting physical compressionMethod" + w.toString());
        }
        return temp;
    }

    public Node[] getDistributionArray(int entityIndex, int physicalIndex) {
        Node[] physNodes = this.getPhysicalArray(entityIndex);
        if (physNodes == null) {
            return null;
        }
        if (physicalIndex > physNodes.length - 1) {
            Log.debug(1, "physical index > number of physical objects");
            return null;
        }
        String distributionXpath = "";
        try {
            distributionXpath = XMLUtilities.getTextNodeWithXPath((Node)this.getMetadataPath(), (String)"/xpathKeyMap/contextNode[@name='physical']/distribution").getNodeValue();
            NodeList distributionlNodes = XMLUtilities.getNodeListWithXPath((Node)physNodes[physicalIndex], (String)distributionXpath);
            if (distributionlNodes == null) {
                Log.debug(20, "distributionList is null!");
                return null;
            }
            return XMLUtilities.getNodeListAsNodeArray((NodeList)distributionlNodes);
        }
        catch (Exception w) {
            Log.debug(50, "exception in getting distributionArray");
            return null;
        }
    }

    public String getDistributionInlineData(int entityIndex, int physicalIndex, int distIndex) {
        String temp = "";
        Node[] distNodes = this.getDistributionArray(entityIndex, physicalIndex);
        if (distNodes == null) {
            return temp;
        }
        if (distIndex > distNodes.length - 1) {
            return temp;
        }
        Node distNode = distNodes[distIndex];
        String distXpath = "";
        try {
            distXpath = XMLUtilities.getTextNodeWithXPath((Node)this.getMetadataPath(), (String)"/xpathKeyMap/contextNode[@name='distribution']/inline").getNodeValue();
            NodeList aNodes = XPathAPI.selectNodeList((Node)distNode, (String)distXpath);
            if (aNodes == null) {
                return "aNodes is null !";
            }
            Node child = aNodes.item(0).getFirstChild();
            temp = child.getNodeValue().trim();
        }
        catch (Exception w) {
            Log.debug(50, "exception in getting distribution inline data: " + w.toString());
        }
        return temp;
    }

    public String getDistributionUrl(int entityIndex, int physicalIndex, int distIndex) {
        String temp = "";
        Node[] distNodes = this.getDistributionArray(entityIndex, physicalIndex);
        if (distNodes == null) {
            return temp;
        }
        if (distIndex > distNodes.length - 1) {
            return temp;
        }
        Node distNode = distNodes[distIndex];
        String distXpath = "";
        try {
            distXpath = XMLUtilities.getTextNodeWithXPath((Node)this.getMetadataPath(), (String)"/xpathKeyMap/contextNode[@name='distribution']/url").getNodeValue();
            NodeList aNodes = XPathAPI.selectNodeList((Node)distNode, (String)distXpath);
            if (aNodes == null) {
                return "aNodes is null !";
            }
            Node child = aNodes.item(0).getFirstChild();
            temp = child.getNodeValue().trim();
        }
        catch (Exception w) {
            Log.debug(50, "exception in getting distribution url: " + w.toString());
        }
        return temp;
    }

    public void setDistributionUrl(int entityIndex, int physicalIndex, int distIndex, String urlS) {
        String temp = "";
        Node[] distNodes = this.getDistributionArray(entityIndex, physicalIndex);
        if (distNodes == null) {
            try {
                String entityPar = XMLUtilities.getTextNodeWithXPath((Node)this.getMetadataPath(), (String)"/xpathKeyMap/contextNode[@name='package']/entityParent").getNodeValue();
                String physicalXpath = XMLUtilities.getTextNodeWithXPath((Node)this.getMetadataPath(), (String)"/xpathKeyMap/contextNode[@name='entity']/physical").getNodeValue();
                String distributionXpath = XMLUtilities.getTextNodeWithXPath((Node)this.getMetadataPath(), (String)"/xpathKeyMap/contextNode[@name='physical']/distribution").getNodeValue();
                String urlxpath = XMLUtilities.getTextNodeWithXPath((Node)this.getMetadataPath(), (String)"/xpathKeyMap/contextNode[@name='distribution']/url").getNodeValue();
                Node entnode = this.entityArray[entityIndex].getNode();
                String distxpath = entityPar + "/" + entnode.getNodeName() + "[" + (entityIndex + 1) + "]/" + physicalXpath + "/" + distributionXpath + "/" + urlxpath;
                XMLUtilities.addTextNodeToDOMTree((Node)this.getMetadataNode(), (String)distxpath, (String)urlS);
            }
            catch (Exception w) {
                Log.debug(6, "error inside serDistributionUrl method in adp" + w.toString());
            }
            return;
        }
        if (distIndex > distNodes.length - 1) {
            return;
        }
        Node distNode = distNodes[distIndex];
        String distXpath = "";
        try {
            distXpath = XMLUtilities.getTextNodeWithXPath((Node)this.getMetadataPath(), (String)"/xpathKeyMap/contextNode[@name='distribution']/url").getNodeValue();
            NodeList aNodes = XPathAPI.selectNodeList((Node)distNode, (String)distXpath);
            if (aNodes == null) {
                Log.debug(10, "aNodes is null !");
                return;
            }
            Node child = aNodes.item(0).getFirstChild();
            child.setNodeValue(urlS);
        }
        catch (Exception w) {
            Log.debug(50, "exception in setting distribution url: " + w.toString());
        }
    }

    public void serializeData() throws MetacatUploadException {
        Object dataFile = null;
        Morpho morpho = Morpho.thisStaticInstance;
        FileSystemDataStore fds = new FileSystemDataStore(morpho);
        MetacatDataStore mds = new MetacatDataStore(morpho);
        this.getEntityArray();
        if (this.entityArray == null) {
            Log.debug(30, "Entity array is null!");
            return;
        }
        for (int i = 0; i < this.entityArray.length; ++i) {
            String protocol = this.getUrlProtocol(i);
            if (!protocol.equals("ecogrid:")) continue;
            String urlinfo = this.getUrlInfo(i);
            if (this.location.equals(LOCAL)) {
                this.handleLocal(urlinfo);
                continue;
            }
            if (this.location.equals(METACAT)) {
                this.handleMetacat(urlinfo, i);
                continue;
            }
            if (!this.location.equals(BOTH)) continue;
            this.handleBoth(urlinfo, i);
        }
    }

    private void handleLocal(String urlinfo) {
        File dataFile = null;
        Morpho morpho = Morpho.thisStaticInstance;
        FileSystemDataStore fds = new FileSystemDataStore(morpho);
        try {
            dataFile = fds.openFile(urlinfo);
        }
        catch (FileNotFoundException fnf) {
            ConfigXML profile = morpho.getProfile();
            String separator = profile.get("separator", 0);
            separator = separator.trim();
            String temp = new String();
            temp = urlinfo.substring(0, urlinfo.indexOf(separator));
            temp = temp + "/" + urlinfo.substring(urlinfo.indexOf(separator) + 1, urlinfo.length());
            try {
                dataFile = fds.openTempFile(temp);
                FileInputStream dfis = new FileInputStream(dataFile);
                fds.saveDataFile(urlinfo, dfis);
                ((InputStream)dfis).close();
            }
            catch (Exception qq) {
                try {
                    MetacatDataStore mds = new MetacatDataStore(morpho);
                    dataFile = mds.openDataFile(urlinfo);
                    FileInputStream dfis = new FileInputStream(dataFile);
                    fds.saveDataFile(urlinfo, dfis);
                    ((InputStream)dfis).close();
                }
                catch (Exception qqq) {
                    Log.debug(5, "Some problem with saving local data files has occurred!");
                    qq.printStackTrace();
                }
            }
        }
    }

    private void handleMetacat(String urlinfo, int entityIndex) {
        File dataFile = null;
        Morpho morpho = Morpho.thisStaticInstance;
        FileSystemDataStore fds = new FileSystemDataStore(morpho);
        MetacatDataStore mds = new MetacatDataStore(morpho);
        try {
            dataFile = mds.openDataFile(urlinfo);
        }
        catch (Exception fnf) {
            ConfigXML profile = morpho.getProfile();
            String separator = profile.get("separator", 0);
            separator = separator.trim();
            String temp = new String();
            temp = urlinfo.substring(0, urlinfo.indexOf(separator));
            temp = temp + "/" + urlinfo.substring(urlinfo.indexOf(separator) + 1, urlinfo.length());
            try {
                dataFile = fds.openTempFile(temp);
                FileInputStream dfis = new FileInputStream(dataFile);
                try {
                    mds.newDataFile(urlinfo, dataFile);
                    dataFile.delete();
                }
                catch (MetacatUploadException mue) {
                    AccessionNumber an = new AccessionNumber(morpho);
                    String newid = an.getNextId();
                    try {
                        mds.newDataFile(newid, dataFile);
                        dataFile.delete();
                        this.setDistributionUrl(entityIndex, 0, 0, newid);
                        String newPackageId = an.getNextId();
                        this.setAccessionNumber(newPackageId);
                        this.serialize(METACAT);
                        if (this.location.equals(BOTH)) {
                            this.serialize(LOCAL);
                        }
                    }
                    catch (MetacatUploadException mue1) {
                        Log.debug(5, "Problem saving data to metacat\n" + mue1.getMessage());
                        throw new MetacatUploadException("ERROR SAVING DATA TO METACAT! " + mue1.getMessage());
                    }
                }
            }
            catch (Exception qq) {
                try {
                    dataFile = fds.openFile(urlinfo);
                    FileInputStream dfis = new FileInputStream(dataFile);
                    try {
                        mds.newDataFile(urlinfo, dataFile);
                    }
                    catch (MetacatUploadException mue) {
                        AccessionNumber an = new AccessionNumber(morpho);
                        String newid = an.getNextId();
                        try {
                            mds.newDataFile(newid, dataFile);
                            dataFile.delete();
                            this.setDistributionUrl(entityIndex, 0, 0, newid);
                            String newPackageId = an.getNextId();
                            this.setAccessionNumber(newPackageId);
                            this.serialize(METACAT);
                            if (this.location.equals(BOTH)) {
                                this.serialize(LOCAL);
                            }
                        }
                        catch (MetacatUploadException mue1) {
                            Log.debug(5, "Problem saving data to metacat\n" + mue1.getMessage());
                            throw new MetacatUploadException("ERROR SAVING DATA TO METACAT! " + mue1.getMessage());
                        }
                    }
                }
                catch (Exception qqq) {
                    Log.debug(5, "Some problem with saving data files has occurred!");
                    qq.printStackTrace();
                }
            }
        }
    }

    private void handleBoth(String urlinfo, int entityIndex) {
        Object dataFile = null;
        Morpho morpho = Morpho.thisStaticInstance;
        FileSystemDataStore fds = new FileSystemDataStore(morpho);
        MetacatDataStore mds = new MetacatDataStore(morpho);
        this.handleLocal(urlinfo);
        this.handleMetacat(urlinfo, entityIndex);
    }

    private String getUrlInfo(int entityIndex) {
        String urlinfo = this.getDistributionUrl(entityIndex, 0, 0);
        int indx2 = urlinfo.indexOf("//");
        if (indx2 > -1) {
            urlinfo = urlinfo.substring(indx2 + 2);
        }
        if ((indx2 = urlinfo.indexOf("/")) > -1) {
            urlinfo = urlinfo.substring(indx2 + 1);
        }
        if ((indx2 = urlinfo.indexOf("/")) > -1) {
            urlinfo = urlinfo.substring(0, indx2);
        }
        if (urlinfo.length() == 0) {
            return "";
        }
        return urlinfo;
    }

    private String getUrlProtocol(int entityIndex) {
        String urlinfo = this.getDistributionUrl(entityIndex, 0, 0);
        int indx2 = urlinfo.indexOf("//");
        if (indx2 < 0) {
            return "";
        }
        return urlinfo.substring(0, indx2);
    }

    public void export(String path) {
        Log.debug(20, "exporting...");
        Log.debug(20, "path: " + path);
        Log.debug(20, "id: " + this.id);
        Log.debug(20, "location: " + this.location);
        File f = null;
        boolean localloc = false;
        boolean metacatloc = false;
        if (this.location.equals(BOTH)) {
            localloc = true;
            metacatloc = true;
        } else if (this.location.equals(METACAT)) {
            metacatloc = true;
        } else if (this.location.equals(LOCAL)) {
            localloc = true;
        } else {
            Log.debug(1, "Package has not been saved! Unable to export!");
            return;
        }
        String packagePath = path + "/" + this.id + ".package";
        String sourcePath = packagePath + "/metadata";
        String cssPath = packagePath + "/export";
        String dataPath = packagePath + "/data";
        File savedir = new File(packagePath);
        File savedirSub = new File(sourcePath);
        File cssdirSub = new File(cssPath);
        File savedirDataSub = new File(dataPath);
        savedir.mkdirs();
        savedirSub.mkdirs();
        cssdirSub.mkdirs();
        savedirDataSub.mkdirs();
        StringBuffer[] htmldoc = new StringBuffer[2];
        try {
            InputStream input = this.getClass().getResourceAsStream("/style/CSS/export.css");
            InputStreamReader styleSheetReader = new InputStreamReader(input);
            StringBuffer buffer = IOUtil.getAsStringBuffer(styleSheetReader, true);
            String fileName = cssPath + "/export.css";
            FileWriter writer = new FileWriter(fileName);
            IOUtil.writeToWriter(buffer, writer, true);
        }
        catch (Exception e) {
            Log.debug(30, "Error in copying css: " + e.getMessage());
        }
        f = new File(sourcePath + "/" + this.id);
        File openfile = null;
        try {
            if (localloc) {
                openfile = this.fileSysDataStore.openFile(this.id);
            } else if (metacatloc) {
                openfile = this.metacatDataStore.openFile(this.id);
            }
            FileInputStream fis = new FileInputStream(openfile);
            BufferedInputStream bfis = new BufferedInputStream(fis);
            FileOutputStream fos = new FileOutputStream(f);
            BufferedOutputStream bfos = new BufferedOutputStream(fos);
            int c = bfis.read();
            while (c != -1) {
                bfos.write(c);
                c = bfis.read();
            }
            bfos.flush();
            bfis.close();
            bfos.close();
            FileReader xmlInputReader = null;
            Reader result = null;
            StringBuffer tempPathBuff = new StringBuffer();
            xmlInputReader = new FileReader(openfile);
            XMLTransformer transformer = XMLTransformer.getInstance();
            transformer.removeAllTransformerProperties();
            transformer.addTransformerProperty("displaymodule", "printall");
            transformer.addTransformerProperty("href_path_extension", ".html");
            transformer.addTransformerProperty("package_id", this.id);
            transformer.addTransformerProperty("package_index_name", "metadata");
            transformer.addTransformerProperty("qformat", "export");
            transformer.addTransformerProperty("entitystyle", "export");
            transformer.addTransformerProperty("stylePath", ".");
            try {
                result = transformer.transform(xmlInputReader);
            }
            catch (IOException e) {
                e.printStackTrace();
                Log.debug(9, "Unexpected Error Styling Document: " + e.getMessage());
                e.fillInStackTrace();
                throw e;
            }
            finally {
                ((Reader)xmlInputReader).close();
            }
            transformer.removeAllTransformerProperties();
            try {
                htmldoc[0] = IOUtil.getAsStringBuffer(result, true);
            }
            catch (IOException e) {
                e.printStackTrace();
                Log.debug(9, "Unexpected Error Reading Styled Document: " + e.getMessage());
                e.fillInStackTrace();
                throw e;
            }
            tempPathBuff.delete(0, tempPathBuff.length());
            tempPathBuff.append(packagePath);
            tempPathBuff.append("/");
            tempPathBuff.append("metadata");
            tempPathBuff.append(".html");
            this.saveToFile(htmldoc[0], new File(tempPathBuff.toString()));
        }
        catch (Exception w) {
            w.printStackTrace();
            Log.debug(9, "Unexpected Error Reading Styled Document: " + w.getMessage());
        }
        this.exportDataFiles(savedirDataSub.getAbsolutePath());
        JOptionPane.showMessageDialog(null, "Package export is complete ! ");
    }

    public void exportToZip(String path) {
        try {
            int c;
            ZipEntry ze;
            AbstractDataPackage abstractDataPackage = this;
            String tempdir = abstractDataPackage.config.getConfigDirectory() + File.separator + this.config.get("tempDir", 0);
            this.export(tempdir + "/tmppackage");
            File zipfile = new File(path);
            FileOutputStream fos = new FileOutputStream(zipfile);
            ZipOutputStream zos = new ZipOutputStream(fos);
            String temppackdir = tempdir + "/tmppackage/" + this.id + ".package";
            File packdirfile = new File(temppackdir);
            String[] dirlist = packdirfile.list();
            String packdir = this.id + ".package";
            for (int i = 0; i < dirlist.length; ++i) {
                String entry = temppackdir + "/" + dirlist[i];
                ZipEntry ze2 = new ZipEntry(packdir + "/" + dirlist[i]);
                File entryFile = new File(entry);
                if (entryFile.isDirectory()) continue;
                ze2.setSize(entryFile.length());
                zos.putNextEntry(ze2);
                FileInputStream fis = new FileInputStream(entryFile);
                int c2 = fis.read();
                while (c2 != -1) {
                    zos.write(c2);
                    c2 = fis.read();
                }
                zos.closeEntry();
            }
            String dataPackdir = packdir + "/data";
            String tempDatapackdir = temppackdir + "/data";
            File dataFile = new File(tempDatapackdir);
            String[] dataFileList = dataFile.list();
            if (dataFileList != null) {
                for (int i = 0; i < dataFileList.length; ++i) {
                    String entry = tempDatapackdir + "/" + dataFileList[i];
                    ZipEntry ze3 = new ZipEntry(dataPackdir + "/" + dataFileList[i]);
                    File entryFile = new File(entry);
                    ze3.setSize(entryFile.length());
                    zos.putNextEntry(ze3);
                    FileInputStream fis = new FileInputStream(entryFile);
                    int c3 = fis.read();
                    while (c3 != -1) {
                        zos.write(c3);
                        c3 = fis.read();
                    }
                    zos.closeEntry();
                }
            }
            try {
                String cssPath = packdir + "/export";
                InputStream input = this.getClass().getResourceAsStream("/style/CSS/export.css");
                InputStreamReader styleSheetReader = new InputStreamReader(input);
                StringBuffer buffer = IOUtil.getAsStringBuffer(styleSheetReader, true);
                ze = new ZipEntry(cssPath + "/export.css");
                ze.setSize(buffer.length());
                zos.putNextEntry(ze);
                int count = 0;
                c = buffer.charAt(count);
                while (c != -1) {
                    zos.write(c);
                    c = buffer.charAt(++count);
                }
                zos.closeEntry();
            }
            catch (Exception e) {
                Log.debug(30, "Error in copying css: " + e.getMessage());
            }
            packdir = packdir + "/metadata";
            temppackdir = temppackdir + "/metadata";
            File sourcedir = new File(temppackdir);
            File[] sourcefiles = this.listFiles(sourcedir);
            for (int i = 0; i < sourcefiles.length; ++i) {
                File f = sourcefiles[i];
                ze = new ZipEntry(packdir + "/" + f.getName());
                ze.setSize(f.length());
                zos.putNextEntry(ze);
                FileInputStream fis = new FileInputStream(f);
                c = fis.read();
                while (c != -1) {
                    zos.write(c);
                    c = fis.read();
                }
                zos.closeEntry();
            }
            zos.flush();
            zos.close();
        }
        catch (Exception e) {
            Log.debug(5, "Exception in exporting to zip file (AbstractDataPackage)");
        }
    }

    public void exportDataFiles(String path) {
        File dataFile = null;
        Morpho morpho = Morpho.thisStaticInstance;
        FileSystemDataStore fds = new FileSystemDataStore(morpho);
        MetacatDataStore mds = new MetacatDataStore(morpho);
        this.getEntityArray();
        if (this.entityArray == null) {
            Log.debug(20, "there is no data!");
            return;
        }
        for (int i = 0; i < this.entityArray.length; ++i) {
            String urlinfo = this.getDistributionUrl(i, 0, 0);
            int indx2 = urlinfo.indexOf("//");
            if (indx2 > -1) {
                urlinfo = urlinfo.substring(indx2 + 2);
            }
            if ((indx2 = urlinfo.indexOf("/")) > -1) {
                urlinfo = urlinfo.substring(indx2 + 1);
            }
            if ((indx2 = urlinfo.indexOf("/")) > -1) {
                urlinfo = urlinfo.substring(0, indx2);
            }
            if (urlinfo.length() == 0) continue;
            String origFileName = this.getPhysicalName(i, 0);
            if (origFileName.trim().equals("")) {
                origFileName = urlinfo;
            }
            try {
                if (this.location.equals(LOCAL) || this.location.equals(BOTH)) {
                    dataFile = fds.openFile(urlinfo);
                } else if (this.location.equals(METACAT)) {
                    dataFile = mds.openFile(urlinfo);
                }
            }
            catch (FileNotFoundException fnf) {
                ConfigXML profile = morpho.getProfile();
                String separator = profile.get("separator", 0);
                separator = separator.trim();
                String temp = new String();
                temp = urlinfo.substring(0, urlinfo.indexOf(separator));
                temp = temp + "/" + urlinfo.substring(urlinfo.indexOf(separator) + 1, urlinfo.length());
                try {
                    dataFile = fds.openTempFile(temp);
                }
                catch (Exception ex) {
                    Log.debug(5, "Some problem while writing data files has occurred!");
                    ex.printStackTrace();
                }
            }
            catch (Exception q) {
                Log.debug(5, "Some problem with saving data files has occurred!");
                q.printStackTrace();
            }
            try {
                String dataPath = path + "/" + urlinfo;
                File saveDatadir = new File(dataPath);
                saveDatadir.mkdirs();
                String fosname = dataPath + "/" + origFileName;
                FileInputStream fis = new FileInputStream(dataFile);
                FileOutputStream fos = new FileOutputStream(fosname);
                BufferedInputStream bis = new BufferedInputStream(fis);
                BufferedOutputStream bos = new BufferedOutputStream(fos);
                int d = bis.read();
                while (d != -1) {
                    bos.write(d);
                    d = bis.read();
                }
                bis.close();
                bos.flush();
                bos.close();
                continue;
            }
            catch (Exception f) {
                Log.debug(20, "Error exporting data file! (AbstractDataPackage)");
            }
        }
    }

    private void saveToFile(StringBuffer buff, File outputFile) throws IOException {
        FileWriter fileWriter = new FileWriter(outputFile);
        IOUtil.writeToWriter(buff, fileWriter, true);
    }

    private File[] listFiles(File dir) {
        String[] fileStrings = dir.list();
        int len = fileStrings.length;
        File[] list = new File[len];
        for (int i = 0; i < len; ++i) {
            list[i] = new File(dir, fileStrings[i]);
        }
        return list;
    }

    public void delete(String location) throws Exception {
        boolean success;
        boolean metacatLoc = false;
        boolean localLoc = false;
        if (location.equals(METACAT) || location.equals(BOTH)) {
            metacatLoc = true;
        }
        if (location.equals(LOCAL) || location.equals(BOTH)) {
            localLoc = true;
        }
        String accnum = this.getAccessionNumber();
        if (localLoc) {
            boolean localSuccess = this.fileSysDataStore.deleteFile(accnum);
            if (!localSuccess) {
                throw new Exception("User couldn't delete the local copy");
            }
            LocalQuery.removeFromCache(accnum);
        }
        if (metacatLoc && !(success = this.metacatDataStore.deleteFile(accnum))) {
            throw new Exception("User couldn't delete the network copy");
        }
    }

    public void showPackageSummary() {
        boolean sizelimit = true;
        StringBuffer sb = new StringBuffer();
        sb.append("Title: " + this.getTitle() + "\n");
        sb.append("AccessionNumber: " + this.getAccessionNumber() + "\n");
        sb.append("Author: " + this.getAuthor() + "\n");
        sb.append("keywords: " + this.getKeywords() + "\n");
        this.getEntityArray();
        if (this.entityArray != null) {
            for (int i = 0; i < this.entityArray.length; ++i) {
                sb.append("   entity " + i + " name: " + this.getEntityName(i) + "\n");
                sb.append("   entity " + i + " numRecords: " + this.getEntityNumRecords(i) + "\n");
                sb.append("   entity " + i + " description: " + this.getEntityDescription(i) + "\n");
                int maxattr = this.getAttributeArray(i).length;
                if (maxattr > 8) {
                    maxattr = 8;
                }
                for (int j = 0; j < maxattr; ++j) {
                    sb.append("      entity " + i + " attribute " + j + "--- name: " + this.getAttributeName(i, j) + "\n");
                    sb.append("      entity " + i + " attribute " + j + "--- unit: " + this.getAttributeUnit(i, j) + "\n");
                    sb.append("      entity " + i + " attribute " + j + "--- dataType: " + this.getAttributeDataType(i, j) + "\n");
                }
                for (int k = 0; k < this.getPhysicalArray(i).length; ++k) {
                    sb.append("   entity " + i + " physical " + k + "--- name: " + this.getPhysicalName(i, k) + "\n");
                    sb.append("   entity " + i + " physical " + k + "--- format: " + this.getPhysicalFormat(i, k) + "\n");
                    sb.append("   entity " + i + " physical " + k + "--- fieldDelimiter: " + this.getPhysicalFieldDelimiter(i, k) + "\n");
                    sb.append("   entity " + i + " physical " + k + "--- numHeaderLines: " + this.getPhysicalNumberHeaderLines(i, k) + "\n");
                    sb.append("   entity " + i + " physical " + k + "------ compression: " + this.getCompressionMethod(i, k) + "\n");
                    sb.append("   entity " + i + " physical " + k + "------ encoding: " + this.getEncodingMethod(i, k) + "\n");
                    sb.append("      entity " + i + " physical " + k + "------ inline: " + this.getDistributionInlineData(i, k, 0) + "\n");
                    sb.append("      entity " + i + " physical " + k + "------ url: " + this.getDistributionUrl(i, k, 0) + "\n");
                }
            }
        }
        Log.debug(1, sb.toString());
    }

    public Reader openAsReader(String id) throws DocumentNotFoundException {
        return null;
    }

    public Document openAsDom(String id) {
        return this.getMetadataNode().getOwnerDocument();
    }

    public void addAttributeForImport(String entityName, String attributeName, String scale, OrderedMap omap, String xPath, boolean newTable) {
        ArrayList<Object> t = new ArrayList<Object>();
        t.add(entityName);
        t.add(attributeName);
        t.add(scale);
        t.add(omap);
        t.add(xPath);
        t.add(new Boolean(newTable));
        if (this.toBeImported == null) {
            this.toBeImported = new ArrayList();
            this.toBeImportedCount = 0;
        }
        this.toBeImported.add(t);
        ++this.toBeImportedCount;
        Log.debug(10, "Adding Attr to Import - (" + entityName + ", " + attributeName + ") ; count = " + this.toBeImportedCount);
    }

    public String getCurrentImportEntityName() {
        if (this.toBeImportedCount == 0) {
            return null;
        }
        List t = (List)this.toBeImported.get(0);
        if (t == null) {
            return null;
        }
        return (String)t.get(0);
    }

    public String getCurrentImportAttributeName() {
        if (this.toBeImportedCount == 0) {
            return null;
        }
        List t = (List)this.toBeImported.get(0);
        if (t == null) {
            return null;
        }
        return (String)t.get(1);
    }

    public String getCurrentImportScale() {
        if (this.toBeImportedCount == 0) {
            return null;
        }
        List t = (List)this.toBeImported.get(0);
        if (t == null) {
            return null;
        }
        return (String)t.get(2);
    }

    public OrderedMap getCurrentImportMap() {
        if (this.toBeImportedCount == 0) {
            return null;
        }
        List t = (List)this.toBeImported.get(0);
        if (t == null) {
            return null;
        }
        return (OrderedMap)t.get(3);
    }

    public OrderedMap getSecondImportMap() {
        if (this.toBeImportedCount < 2) {
            return null;
        }
        List t = (List)this.toBeImported.get(1);
        if (t == null) {
            return null;
        }
        return (OrderedMap)t.get(3);
    }

    public String getCurrentImportXPath() {
        if (this.toBeImportedCount == 0) {
            return null;
        }
        List t = (List)this.toBeImported.get(0);
        if (t == null) {
            return null;
        }
        return (String)t.get(4);
    }

    public boolean isCurrentImportNewTable() {
        if (this.toBeImportedCount == 0) {
            return false;
        }
        List t = (List)this.toBeImported.get(0);
        if (t == null) {
            return false;
        }
        return (Boolean)t.get(5);
    }

    public int getAttributeImportCount() {
        return this.toBeImportedCount;
    }

    public void removeAttributeForImport() {
        if (this.toBeImportedCount == 0) {
            return;
        }
        this.toBeImported.remove(0);
        --this.toBeImportedCount;
    }

    public void setLastImportedEntity(String name) {
        this.lastImportedEntityName = name;
    }

    public void setLastImportedDataSet(Vector data) {
        this.lastImportedDataSet = data;
    }

    public void setLastImportedAttributes(List attr) {
        this.lastImportedAttributes = attr;
    }

    public String getLastImportedEntity() {
        return this.lastImportedEntityName;
    }

    public List getLastImportedAttributes() {
        return this.lastImportedAttributes;
    }

    public Vector getLastImportedDataSet() {
        return this.lastImportedDataSet;
    }

    public Entity[] getOriginalEntityArray() {
        return this.originalEntities;
    }

    public void setOriginalEntityArray(Entity[] arr) {
        this.originalEntities = arr;
    }

    public void clearAllAttributeImports() {
        this.originalEntities = null;
        this.toBeImported = null;
        this.toBeImportedCount = 0;
        this.lastImportedAttributes = null;
        this.lastImportedEntityName = null;
        this.lastImportedDataSet = null;
    }
}

