/*
 * Decompiled with CFR 0.152.
 */
package edu.tesc.scidb.databank.sms.tdm;

import edu.tesc.scidb.databank.sms.tdm.Col;
import edu.tesc.scidb.databank.sms.tdm.Table;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.apache.xerces.parsers.DOMParser;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMElement;
import org.dom4j.io.XMLWriter;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TableImpl
implements Table {
    public static final Comparator PKFIRST_SORTORDER = new PKFirstColComparator();
    public static final Comparator PROP_ORDER_SORTORDER;
    public static final Comparator DEFAULT_SORTORDER;
    private String name;
    private Map cols;

    public TableImpl(String name) {
        this.name = name;
        this.cols = new TreeMap();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Collection getCols() {
        return this.getCols(PKFIRST_SORTORDER);
    }

    public Collection getCols(Comparator sortOrder) {
        ArrayList l = new ArrayList(this.cols.values());
        Collections.sort(l, sortOrder);
        return l;
    }

    public Col getCol(String name) {
        return (Col)this.cols.get(name);
    }

    public Collection getPrimaryKeys() {
        LinkedList<Col> cols = new LinkedList<Col>();
        for (Col col : this.getCols()) {
            if (col.getProperty("primaryKey") == null) continue;
            cols.add(col);
        }
        LinkedList<Col> cols2 = new LinkedList<Col>();
        for (Col col : cols) {
            cols2.add(col);
        }
        return cols2;
    }

    public Collection getPrimaryKeysString() {
        LinkedList<String> cols = new LinkedList<String>();
        for (Col col : this.getCols()) {
            if (col.getProperty("primaryKey") == null) continue;
            cols.add(col.getName());
        }
        LinkedList<String> cols2 = new LinkedList<String>();
        for (String name : cols) {
            cols2.add(name);
        }
        return cols2;
    }

    public void addCol(Col col) {
        this.cols.put(col.getName(), col);
    }

    public String toString() {
        return "TableImpl name=" + this.name + "\n" + this.cols + "\n";
    }

    public Element getAsEML(Element parent) {
        Element table = parent.addElement("dataTable");
        table.addAttribute("id", this.getName());
        Element entityName = table.addElement("entityName");
        entityName.setText(this.getName());
        Element physical = table.addElement("physical");
        Element objectName = physical.addElement("objectName");
        Element dataFormat = physical.addElement("dataFormat");
        Element externallyDefinedFormat = dataFormat.addElement("externallyDefinedFormat");
        Element formatName = externallyDefinedFormat.addElement("formatName");
        formatName.setText("Microsoft Access");
        Element distribution = physical.addElement("distribution");
        Element offline = distribution.addElement("offline");
        Element attributeList = table.addElement("attributeList");
        Collection cols = this.getCols();
        for (Col col : cols) {
            col.getAsEML(attributeList, this.getName());
        }
        cols = this.getCols();
        for (Col col : cols) {
            String notNullProp;
            String referencesProp;
            String primaryKeyProp = (String)col.getProperty("primaryKey");
            if (primaryKeyProp != null && primaryKeyProp.equals("1")) {
                Element constraint = table.addElement("constraint");
                Element primaryKey = constraint.addElement("primaryKey");
                Element constraintName = primaryKey.addElement("constraintName");
                constraintName.setText("Primary Key");
                Element key = primaryKey.addElement("key");
                Element attributeReference = key.addElement("attributeReference");
                attributeReference.setText(this.getName() + "." + col.getName());
            }
            if ((referencesProp = (String)col.getProperty("references")) != null) {
                Element constraint = table.addElement("constraint");
                Element foreignKey = constraint.addElement("foreignKey");
                Element constraintName = foreignKey.addElement("constraintName");
                constraintName.setText("Foreign Key");
                Element key = foreignKey.addElement("key");
                Element attributeReference = key.addElement("attributeReference");
                attributeReference.setText(this.getName() + "." + col.getName());
                Element entityReference = foreignKey.addElement("entityReference");
                entityReference.setText(referencesProp);
            }
            if ((notNullProp = (String)col.getProperty("notNull")) == null || !notNullProp.equals("1")) continue;
            Element constraint = table.addElement("constraint");
            Element primaryKey = constraint.addElement("notNullConstraint");
            Element constraintName = primaryKey.addElement("constraintName");
            constraintName.setText("Not Nullable");
            Element key = primaryKey.addElement("key");
            Element attributeReference = key.addElement("attributeReference");
            attributeReference.setText(this.getName() + "." + col.getName());
        }
        return table;
    }

    public Node getDataTableNode() {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ByteArrayInputStream input = new ByteArrayInputStream(output.toByteArray());
        Node finalDocument = null;
        Element table = this.getAsEML((Element)new DOMElement("dummyElement"));
        DOMDocument domDoc = new DOMDocument();
        domDoc.setRootElement(table);
        try {
            XMLWriter writer = new XMLWriter((OutputStream)output);
            writer.write((Document)domDoc);
            writer.flush();
            input = new ByteArrayInputStream(output.toByteArray());
            InputSource inputSource = new InputSource(input);
            DOMParser domParser = new DOMParser();
            domParser.parse(inputSource);
            finalDocument = domParser.getDocument();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        return finalDocument.getFirstChild();
    }

    static {
        DEFAULT_SORTORDER = PROP_ORDER_SORTORDER = new PropOrderColComparator();
    }

    private static class PropOrderColComparator
    implements Comparator {
        private PropOrderColComparator() {
        }

        public int compare(Object o1, Object o2) {
            try {
                int val = ((Integer)((Col)o1).getProperty("order")).compareTo((Integer)((Col)o2).getProperty("order"));
                return val;
            }
            catch (Exception e) {
                return 1;
            }
        }
    }

    private static class PKFirstColComparator
    implements Comparator {
        private PKFirstColComparator() {
        }

        public int compare(Object o1, Object o2) {
            int val = ((Col)o1).getName().compareTo(((Col)o2).getName());
            if (((Col)o1).getProperty("primaryKey") != null) {
                if (((Col)o2).getProperty("primaryKey") != null) {
                    return val;
                }
                return -1;
            }
            if (((Col)o2).getProperty("primaryKey") != null) {
                return 1;
            }
            return val;
        }
    }
}

