/*
 * Decompiled with CFR 0.152.
 */
package com.wutka.dtd;

import com.wutka.dtd.DTD;
import com.wutka.dtd.DTDAny;
import com.wutka.dtd.DTDAttlist;
import com.wutka.dtd.DTDAttribute;
import com.wutka.dtd.DTDCardinal;
import com.wutka.dtd.DTDChoice;
import com.wutka.dtd.DTDComment;
import com.wutka.dtd.DTDContainer;
import com.wutka.dtd.DTDDecl;
import com.wutka.dtd.DTDElement;
import com.wutka.dtd.DTDEmpty;
import com.wutka.dtd.DTDEntity;
import com.wutka.dtd.DTDEnumeration;
import com.wutka.dtd.DTDItem;
import com.wutka.dtd.DTDMixed;
import com.wutka.dtd.DTDName;
import com.wutka.dtd.DTDNotation;
import com.wutka.dtd.DTDNotationList;
import com.wutka.dtd.DTDPCData;
import com.wutka.dtd.DTDParseException;
import com.wutka.dtd.DTDProcessingInstruction;
import com.wutka.dtd.DTDPublic;
import com.wutka.dtd.DTDSequence;
import com.wutka.dtd.DTDSystem;
import com.wutka.dtd.EntityExpansion;
import com.wutka.dtd.Scanner;
import com.wutka.dtd.Token;
import com.wutka.dtd.TokenType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;

public class DTDParser
implements EntityExpansion {
    protected Scanner scanner;
    protected DTD dtd;
    protected Object defaultLocation;

    public DTDParser(Reader in) {
        this.scanner = new Scanner(in, false, this);
        this.dtd = new DTD();
    }

    public DTDParser(Reader in, boolean trace) {
        this.scanner = new Scanner(in, trace, this);
        this.dtd = new DTD();
    }

    public DTDParser(File in) throws IOException {
        this.defaultLocation = new File(in.getParent());
        this.scanner = new Scanner(new BufferedReader(new FileReader(in)), false, this);
        this.dtd = new DTD();
    }

    public DTDParser(File in, boolean trace) throws IOException {
        this.defaultLocation = in.getParentFile();
        this.scanner = new Scanner(new BufferedReader(new FileReader(in)), trace, this);
        this.dtd = new DTD();
    }

    public DTDParser(URL in) throws IOException {
        this.defaultLocation = in;
        this.scanner = new Scanner(new BufferedReader(new InputStreamReader(in.openStream())), false, this);
        this.dtd = new DTD();
    }

    public DTDParser(URL in, boolean trace) throws IOException {
        this.defaultLocation = in;
        this.scanner = new Scanner(new BufferedReader(new InputStreamReader(in.openStream())), trace, this);
        this.dtd = new DTD();
    }

    public DTD parse() throws IOException {
        return this.parse(false);
    }

    public DTD parse(boolean guessRootElement) throws IOException {
        while (true) {
            Token token = this.scanner.peek();
            if (token.type == Scanner.EOF) break;
            this.parseTopLevelElement();
        }
        if (guessRootElement) {
            DTDElement element;
            Hashtable<String, DTDElement> roots = new Hashtable<String, DTDElement>();
            Enumeration e = this.dtd.elements.elements();
            while (e.hasMoreElements()) {
                element = (DTDElement)e.nextElement();
                roots.put(element.name, element);
            }
            e = this.dtd.elements.elements();
            while (e.hasMoreElements()) {
                element = (DTDElement)e.nextElement();
                if (!(element.content instanceof DTDContainer)) continue;
                Enumeration items = ((DTDContainer)element.content).getItemsVec().elements();
                while (items.hasMoreElements()) {
                    this.removeElements(roots, this.dtd, (DTDItem)items.nextElement());
                }
            }
            if (roots.size() == 1) {
                e = roots.elements();
                this.dtd.rootElement = (DTDElement)e.nextElement();
            } else {
                this.dtd.rootElement = null;
            }
        } else {
            this.dtd.rootElement = null;
        }
        return this.dtd;
    }

    protected void removeElements(Hashtable h, DTD dtd, DTDItem item) {
        if (item instanceof DTDName) {
            h.remove(((DTDName)item).value);
        } else if (item instanceof DTDContainer) {
            Enumeration e = ((DTDContainer)item).getItemsVec().elements();
            while (e.hasMoreElements()) {
                this.removeElements(h, dtd, (DTDItem)e.nextElement());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parseTopLevelElement() throws IOException {
        Token token = this.scanner.get();
        if (token.type == Scanner.LTQUES) {
            StringBuffer textBuffer = new StringBuffer();
            while (true) {
                String text = this.scanner.getUntil('?');
                textBuffer.append(text);
                token = this.scanner.peek();
                if (token.type == Scanner.GT) break;
                textBuffer.append('?');
            }
            this.scanner.get();
            DTDProcessingInstruction instruct = new DTDProcessingInstruction(textBuffer.toString());
            this.dtd.items.addElement(instruct);
            return;
        }
        if (token.type == Scanner.CONDITIONAL) {
            token = this.expect(Scanner.IDENTIFIER);
            if (token.value.equals("IGNORE")) {
                this.scanner.skipConditional();
                return;
            } else {
                if (!token.value.equals("INCLUDE")) throw new DTDParseException(this.scanner.getUriId(), "Invalid token in conditional: " + token.value, this.scanner.getLineNumber(), this.scanner.getColumn());
                this.scanner.skipUntil('[');
            }
            return;
        } else {
            if (token.type == Scanner.ENDCONDITIONAL) return;
            if (token.type == Scanner.COMMENT) {
                this.dtd.items.addElement(new DTDComment(token.value));
                return;
            } else {
                if (token.type != Scanner.LTBANG) return;
                token = this.expect(Scanner.IDENTIFIER);
                if (token.value.equals("ELEMENT")) {
                    this.parseElement();
                    return;
                } else if (token.value.equals("ATTLIST")) {
                    this.parseAttlist();
                    return;
                } else if (token.value.equals("ENTITY")) {
                    this.parseEntity();
                    return;
                } else if (token.value.equals("NOTATION")) {
                    this.parseNotation();
                    return;
                } else {
                    this.skipUntil(Scanner.GT);
                }
            }
        }
    }

    protected void skipUntil(TokenType stopToken) throws IOException {
        Token token = this.scanner.get();
        while (token.type != stopToken) {
            token = this.scanner.get();
        }
    }

    protected Token expect(TokenType expected) throws IOException {
        Token token = this.scanner.get();
        if (token.type != expected) {
            if (token.value == null) {
                throw new DTDParseException(this.scanner.getUriId(), "Expected " + expected.name + " instead of " + token.type.name, this.scanner.getLineNumber(), this.scanner.getColumn());
            }
            throw new DTDParseException(this.scanner.getUriId(), "Expected " + expected.name + " instead of " + token.type.name + "(" + token.value + ")", this.scanner.getLineNumber(), this.scanner.getColumn());
        }
        return token;
    }

    protected void parseElement() throws IOException {
        Token name = this.expect(Scanner.IDENTIFIER);
        DTDElement element = (DTDElement)this.dtd.elements.get(name.value);
        if (element == null) {
            element = new DTDElement(name.value);
            this.dtd.elements.put(element.name, element);
        }
        this.dtd.items.addElement(element);
        this.parseContentSpec(this.scanner, element);
        this.expect(Scanner.GT);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parseContentSpec(Scanner scanner, DTDElement element) throws IOException {
        Token token = scanner.get();
        if (token.type == Scanner.IDENTIFIER) {
            if (token.value.equals("EMPTY")) {
                element.content = new DTDEmpty();
                return;
            } else {
                if (!token.value.equals("ANY")) throw new DTDParseException(scanner.getUriId(), "Invalid token in entity content spec " + token.value, scanner.getLineNumber(), scanner.getColumn());
                element.content = new DTDAny();
            }
            return;
        } else {
            if (token.type != Scanner.LPAREN) return;
            token = scanner.peek();
            if (token.type == Scanner.IDENTIFIER) {
                if (token.value.equals("#PCDATA")) {
                    this.parseMixed(element);
                    return;
                } else {
                    this.parseChildren(element);
                }
                return;
            } else {
                if (token.type != Scanner.LPAREN) return;
                this.parseChildren(element);
            }
        }
    }

    protected void parseMixed(DTDElement element) throws IOException {
        Token token;
        DTDMixed mixed = new DTDMixed();
        mixed.add(new DTDPCData());
        this.scanner.get();
        element.content = mixed;
        while (true) {
            token = this.scanner.get();
            if (token.type == Scanner.RPAREN) {
                token = this.scanner.peek();
                if (token.type == Scanner.ASTERISK) {
                    this.scanner.get();
                    mixed.cardinal = DTDCardinal.ZEROMANY;
                } else {
                    mixed.cardinal = DTDCardinal.NONE;
                }
                return;
            }
            if (token.type != Scanner.PIPE) break;
            token = this.scanner.get();
            mixed.add(new DTDName(token.value));
        }
        throw new DTDParseException(this.scanner.getUriId(), "Invalid token in Mixed content type: " + token.type.name, this.scanner.getLineNumber(), this.scanner.getColumn());
    }

    protected void parseChildren(DTDElement element) throws IOException {
        DTDContainer choiceSeq = this.parseChoiceSequence();
        Token token = this.scanner.peek();
        choiceSeq.cardinal = this.parseCardinality();
        choiceSeq.cardinal = token.type == Scanner.QUES ? DTDCardinal.OPTIONAL : (token.type == Scanner.ASTERISK ? DTDCardinal.ZEROMANY : (token.type == Scanner.PLUS ? DTDCardinal.ONEMANY : DTDCardinal.NONE));
        element.content = choiceSeq;
    }

    protected DTDContainer parseChoiceSequence() throws IOException {
        Token token;
        DTDItem item;
        TokenType separator = null;
        DTDContainer cs = null;
        while (true) {
            item = this.parseCP();
            token = this.scanner.get();
            if (token.type != Scanner.PIPE && token.type != Scanner.COMMA) break;
            if (separator != null && separator != token.type) {
                throw new DTDParseException(this.scanner.getUriId(), "Can't mix separators in a choice/sequence", this.scanner.getLineNumber(), this.scanner.getColumn());
            }
            separator = token.type;
            if (cs == null) {
                cs = token.type == Scanner.PIPE ? new DTDChoice() : new DTDSequence();
            }
            cs.add(item);
        }
        if (token.type == Scanner.RPAREN) {
            if (cs == null) {
                cs = new DTDChoice();
            }
            cs.add(item);
            return cs;
        }
        throw new DTDParseException(this.scanner.getUriId(), "Found invalid token in sequence: " + token.type.name, this.scanner.getLineNumber(), this.scanner.getColumn());
    }

    protected DTDItem parseCP() throws IOException {
        Token token = this.scanner.get();
        DTDItem item = null;
        if (token.type == Scanner.IDENTIFIER) {
            item = new DTDName(token.value);
        } else if (token.type == Scanner.LPAREN) {
            item = this.parseChoiceSequence();
        } else {
            throw new DTDParseException(this.scanner.getUriId(), "Found invalid token in sequence: " + token.type.name, this.scanner.getLineNumber(), this.scanner.getColumn());
        }
        item.cardinal = this.parseCardinality();
        return item;
    }

    protected DTDCardinal parseCardinality() throws IOException {
        Token token = this.scanner.peek();
        if (token.type == Scanner.QUES) {
            this.scanner.get();
            return DTDCardinal.OPTIONAL;
        }
        if (token.type == Scanner.ASTERISK) {
            this.scanner.get();
            return DTDCardinal.ZEROMANY;
        }
        if (token.type == Scanner.PLUS) {
            this.scanner.get();
            return DTDCardinal.ONEMANY;
        }
        return DTDCardinal.NONE;
    }

    protected void parseAttlist() throws IOException {
        Token token = this.expect(Scanner.IDENTIFIER);
        DTDElement element = (DTDElement)this.dtd.elements.get(token.value);
        DTDAttlist attlist = new DTDAttlist(token.value);
        this.dtd.items.addElement(attlist);
        if (element == null) {
            element = new DTDElement(token.value);
            this.dtd.elements.put(token.value, element);
        }
        token = this.scanner.peek();
        while (token.type != Scanner.GT) {
            this.parseAttdef(this.scanner, element, attlist);
            token = this.scanner.peek();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parseAttdef(Scanner scanner, DTDElement element, DTDAttlist attlist) throws IOException {
        Token token = this.expect(Scanner.IDENTIFIER);
        DTDAttribute attr = new DTDAttribute(token.value);
        attlist.attributes.addElement(attr);
        element.attributes.put(token.value, attr);
        token = scanner.get();
        if (token.type == Scanner.IDENTIFIER) {
            attr.type = token.value.equals("NOTATION") ? this.parseNotationList() : token.value;
        } else if (token.type == Scanner.LPAREN) {
            attr.type = this.parseEnumeration();
        }
        token = scanner.peek();
        if (token.type == Scanner.IDENTIFIER) {
            scanner.get();
            if (token.value.equals("#FIXED")) {
                attr.decl = DTDDecl.FIXED;
                token = scanner.get();
                attr.defaultValue = token.value;
                return;
            } else if (token.value.equals("#REQUIRED")) {
                attr.decl = DTDDecl.REQUIRED;
                return;
            } else {
                if (!token.value.equals("#IMPLIED")) throw new DTDParseException(scanner.getUriId(), "Invalid token in attribute declaration: " + token.value, scanner.getLineNumber(), scanner.getColumn());
                attr.decl = DTDDecl.IMPLIED;
            }
            return;
        } else {
            if (token.type != Scanner.STRING) return;
            scanner.get();
            attr.decl = DTDDecl.VALUE;
            attr.defaultValue = token.value;
        }
    }

    protected DTDNotationList parseNotationList() throws IOException {
        DTDNotationList notation = new DTDNotationList();
        while (true) {
            Token token = this.scanner.get();
            if (token.type != Scanner.IDENTIFIER) {
                throw new DTDParseException(this.scanner.getUriId(), "Invalid token in notation: " + token.type.name, this.scanner.getLineNumber(), this.scanner.getColumn());
            }
            notation.add(token.value);
            token = this.scanner.peek();
            if (token.type == Scanner.RPAREN) {
                this.scanner.get();
                return notation;
            }
            if (token.type != Scanner.PIPE) {
                throw new DTDParseException(this.scanner.getUriId(), "Invalid token in notation: " + token.type.name, this.scanner.getLineNumber(), this.scanner.getColumn());
            }
            this.scanner.get();
        }
    }

    protected DTDEnumeration parseEnumeration() throws IOException {
        DTDEnumeration enumeration = new DTDEnumeration();
        while (true) {
            Token token = this.scanner.get();
            if (token.type != Scanner.IDENTIFIER && token.type != Scanner.NMTOKEN) {
                throw new DTDParseException(this.scanner.getUriId(), "Invalid token in enumeration: " + token.type.name, this.scanner.getLineNumber(), this.scanner.getColumn());
            }
            enumeration.add(token.value);
            token = this.scanner.peek();
            if (token.type == Scanner.RPAREN) {
                this.scanner.get();
                return enumeration;
            }
            if (token.type != Scanner.PIPE) {
                throw new DTDParseException(this.scanner.getUriId(), "Invalid token in enumeration: " + token.type.name, this.scanner.getLineNumber(), this.scanner.getColumn());
            }
            this.scanner.get();
        }
    }

    protected void parseEntity() throws IOException {
        boolean isParsed = false;
        Token name = this.scanner.get();
        if (name.type == Scanner.PERCENT) {
            isParsed = true;
            name = this.expect(Scanner.IDENTIFIER);
        } else if (name.type != Scanner.IDENTIFIER) {
            throw new DTDParseException(this.scanner.getUriId(), "Invalid entity declaration", this.scanner.getLineNumber(), this.scanner.getColumn());
        }
        DTDEntity entity = (DTDEntity)this.dtd.entities.get(name.value);
        if (entity == null) {
            entity = new DTDEntity(name.value, this.defaultLocation);
            this.dtd.entities.put(entity.name, entity);
        }
        this.dtd.items.addElement(entity);
        entity.isParsed = isParsed;
        this.parseEntityDef(entity);
        if (entity.isParsed && entity.value != null) {
            this.scanner.addEntity(entity.name, entity.value);
        }
    }

    protected void parseEntityDef(DTDEntity entity) throws IOException {
        Token token = this.scanner.get();
        if (token.type == Scanner.STRING) {
            entity.value = token.value;
        } else if (token.type == Scanner.IDENTIFIER) {
            if (token.value.equals("SYSTEM")) {
                DTDSystem sys = new DTDSystem();
                token = this.expect(Scanner.STRING);
                sys.system = token.value;
                entity.externalID = sys;
            } else if (token.value.equals("PUBLIC")) {
                DTDPublic pub = new DTDPublic();
                token = this.expect(Scanner.STRING);
                pub.pub = token.value;
                token = this.expect(Scanner.STRING);
                pub.system = token.value;
                entity.externalID = pub;
            } else {
                throw new DTDParseException(this.scanner.getUriId(), "Invalid External ID specification", this.scanner.getLineNumber(), this.scanner.getColumn());
            }
            if (entity.isParsed) {
                token = this.scanner.peek();
                if (token.type == Scanner.IDENTIFIER) {
                    if (!token.value.equals("NDATA")) {
                        throw new DTDParseException(this.scanner.getUriId(), "Invalid NData declaration", this.scanner.getLineNumber(), this.scanner.getColumn());
                    }
                    token = this.expect(Scanner.IDENTIFIER);
                    entity.ndata = token.value;
                }
            }
        } else {
            throw new DTDParseException(this.scanner.getUriId(), "Invalid entity definition", this.scanner.getLineNumber(), this.scanner.getColumn());
        }
        this.expect(Scanner.GT);
    }

    protected void parseNotation() throws IOException {
        DTDNotation notation = new DTDNotation();
        Token token = this.expect(Scanner.IDENTIFIER);
        notation.name = token.value;
        this.dtd.notations.put(notation.name, notation);
        this.dtd.items.addElement(notation);
        token = this.expect(Scanner.IDENTIFIER);
        if (token.value.equals("SYSTEM")) {
            DTDSystem sys = new DTDSystem();
            token = this.expect(Scanner.STRING);
            sys.system = token.value;
            notation.externalID = sys;
        } else if (token.value.equals("PUBLIC")) {
            DTDPublic pub = new DTDPublic();
            token = this.expect(Scanner.STRING);
            pub.pub = token.value;
            pub.system = null;
            token = this.scanner.peek();
            if (token.type == Scanner.STRING) {
                token = this.scanner.get();
                pub.system = token.value;
            }
            notation.externalID = pub;
        }
        this.expect(Scanner.GT);
    }

    public DTDEntity expandEntity(String name) {
        return (DTDEntity)this.dtd.entities.get(name);
    }
}

