/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.decoding.images;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.fonts.glyph.T3Glyph;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.raw.PdfDictionary;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class FormXObject {
    private static final boolean debug = false;
    private static final boolean showImage = false;
    private int width = 20;
    private int height = 20;
    private String whenToScale = null;
    private Map formFieldValues = null;
    private PdfObjectReader currentPdfFile;

    public FormXObject(PdfObjectReader pdfObjectReader) {
        this.currentPdfFile = pdfObjectReader;
    }

    private FormXObject() {
    }

    public BufferedImage decode(Map map) {
        boolean bl = false;
        try {
            float f;
            Object object;
            Object object2;
            PdfStreamDecoder pdfStreamDecoder = new PdfStreamDecoder(this.currentPdfFile, bl, true);
            ObjectStore objectStore = new ObjectStore();
            pdfStreamDecoder.setStore(objectStore);
            DynamicVectorRenderer dynamicVectorRenderer = new DynamicVectorRenderer(0, false, 20, objectStore);
            if (!bl) {
                dynamicVectorRenderer.setOptimisedRotation(false);
            } else {
                dynamicVectorRenderer.setHiResImageForDisplayMode(bl);
            }
            pdfStreamDecoder.init(false, true, 15, 0, new PdfPageData(), 0, dynamicVectorRenderer, this.currentPdfFile);
            try {
                object2 = (Map)this.currentPdfFile.resolveToMapOrString("Resources", map.get("Resources"));
                PdfObject pdfObject = PdfDictionary.convertMapToNewObject((Map)object2, this.currentPdfFile);
                if (object2 != null) {
                    pdfStreamDecoder.readResources(pdfObject, false);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("Exception " + exception + " reading resources in XForm");
            }
            object2 = (byte[])this.currentPdfFile.resolveToMapOrString("DecodedStream", map.get("DecodedStream"));
            if (object2 != null) {
                pdfStreamDecoder.decodeStreamIntoObjects((byte[])object2);
            }
            boolean bl2 = pdfStreamDecoder.ignoreColors;
            pdfStreamDecoder = null;
            objectStore.flush();
            T3Glyph t3Glyph = new T3Glyph(dynamicVectorRenderer, 0, 0, bl2, "");
            String string = (String)this.currentPdfFile.resolveToMapOrString("BBox", map.get("BBox"));
            float f2 = 0.0f;
            float f3 = 0.0f;
            if (string != null) {
                string = Strip.removeArrayDeleminators(string);
                object = new StringTokenizer(string);
                float f4 = Float.parseFloat(((StringTokenizer)object).nextToken());
                float f5 = Float.parseFloat(((StringTokenizer)object).nextToken());
                float f6 = Float.parseFloat(((StringTokenizer)object).nextToken());
                f = Float.parseFloat(((StringTokenizer)object).nextToken());
                f2 = f4;
                f3 = f5;
                this.width = (int)(f6 - f4);
                this.height = (int)(f - f5);
                if (this.formFieldValues != null) {
                    if (this.whenToScale == null || this.whenToScale.equals("A")) {
                        Rectangle rectangle = (Rectangle)this.formFieldValues.get("rect");
                        if (rectangle.width != this.width || rectangle.height != this.height) {
                            LogWriter.writeFormLog("{stream} XObject MK IF A command, the icon should be scaled to fit the BBox", false);
                        }
                    } else if (!this.whenToScale.equals("N")) {
                        LogWriter.writeFormLog("{XObject} XObject MK IF Unimplemented command=" + this.whenToScale, false);
                    }
                }
            }
            if (this.width < 0) {
                this.width = -this.width;
            }
            if (this.height < 0) {
                this.height = -this.height;
            }
            if (this.width == 0 || this.height == 0) {
                return null;
            }
            object = null;
            Graphics2D graphics2D = null;
            String string2 = (String)this.currentPdfFile.resolveToMapOrString("Matrix", map.get("Matrix"));
            if (string2 != null) {
                int n;
                StringTokenizer stringTokenizer = new StringTokenizer(Strip.removeArrayDeleminators(string2));
                f = Float.parseFloat(stringTokenizer.nextToken());
                float f7 = Float.parseFloat(stringTokenizer.nextToken());
                float f8 = Float.parseFloat(stringTokenizer.nextToken());
                float f9 = Float.parseFloat(stringTokenizer.nextToken());
                float f10 = Float.parseFloat(stringTokenizer.nextToken());
                float f11 = Float.parseFloat(stringTokenizer.nextToken());
                if (f8 < 0.0f) {
                    object = new BufferedImage(this.height, this.width, 2);
                    n = this.width;
                } else {
                    object = new BufferedImage(this.width, this.height, 2);
                    n = this.height;
                    if (f10 != 0.0f) {
                        f10 = -f2;
                    }
                    if (f11 != 0.0f) {
                        f11 = -f3;
                    }
                }
                graphics2D = (Graphics2D)((BufferedImage)object).getGraphics();
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate(0.0, n);
                affineTransform.scale(1.0, -1.0);
                graphics2D.setTransform(affineTransform);
                AffineTransform affineTransform2 = new AffineTransform(f, f7, f8, f9, f10, f11);
                graphics2D.transform(affineTransform2);
            } else {
                object = new BufferedImage(this.width, this.height, 2);
                graphics2D = (Graphics2D)((BufferedImage)object).getGraphics();
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate(0.0, this.height);
                affineTransform.scale(1.0, -1.0);
                graphics2D.setTransform(affineTransform);
            }
            t3Glyph.render(0, graphics2D, 0.0f);
            graphics2D.dispose();
            return object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

