/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.jpedal.decompression.CCITTFactory;
import org.jpedal.io.JAIHelper;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.TiffDecoder;
import org.jpedal.jbig2.JBIG2Decoder;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.sun.LZWDecoder;
import org.jpedal.sun.LZWDecoder2;
import org.jpedal.sun.TIFFFaxDecoder;
import org.jpedal.sun.TIFFLZWDecoder;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class PdfFilteredReader
extends PdfFileReader {
    static final boolean debugCaching = false;
    public static final int A85 = 1116165;
    public static final int AHx = 0x111848;
    public static final int ASCII85Decode = 1582784916;
    public static final int ASCIIHexDecode = 2074112677;
    public static final int CCITTFaxDecode = 2108391315;
    public static final int CCF = 0x131316;
    public static final int Crypt = 1112096855;
    public static final int DCTDecode = 1180911742;
    public static final int Fl = 5692;
    public static final int FlateDecode = 2005566619;
    public static final int JBIG2Decode = 1247500931;
    public static final int JPXDecode = 1399277700;
    public static final int LZW = 1845799;
    public static final int LZWDecode = 1566984326;
    public static final int RL = 8732;
    public static final int RunLengthDecode = -1815163937;
    BufferedOutputStream streamCache = null;
    BufferedInputStream bis = null;
    private String filter_type;
    private static final long[] base_85_indices = new long[]{52200625L, 614125L, 7225L, 85L, 1L};
    private static final long[] hex_indices = new long[]{0x1000000L, 65536L, 256L, 1L};

    public final byte[] decodeFilters(byte[] byArray, String string, Object object, int n, int n2, boolean bl, String string2) throws Exception {
        boolean bl2;
        this.streamCache = null;
        this.bis = null;
        Map map = new HashMap();
        boolean bl3 = string2 != null && byArray == null ? true : (bl2 = false);
        if (object != null) {
            if (object instanceof String) {
                this.convertStringToMap(map, object);
            } else {
                map = (Map)object;
            }
        }
        if (string.startsWith("[")) {
            string = string.endsWith("]") ? string.substring(1, string.length() - 1) : string.substring(1);
        } else if (string.endsWith("]")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            boolean bl4 = false;
            while (stringTokenizer.hasMoreTokens()) {
                boolean bl5;
                this.filter_type = stringTokenizer.nextToken();
                if (!this.filter_type.startsWith("/")) {
                    this.filter_type = "/" + this.filter_type;
                }
                boolean bl6 = bl5 = this.filter_type.indexOf("/DCTDecode") != -1 || this.filter_type.indexOf("/JPXDecode") != -1;
                if (bl2 && !bl5 && string2 != null) {
                    this.setupCachedObjectForDecoding(byArray, string2, false);
                }
                if (!this.filter_type.startsWith("/")) continue;
                bl4 = false;
                if (this.filter_type.indexOf("/FlateDecode") != -1 || this.filter_type.indexOf("/Fl") != -1) {
                    byArray = this.flateDecode(byArray, map, string2);
                } else if (this.filter_type.indexOf("/ASCII85Decode") != -1 || this.filter_type.indexOf("/A85") != -1) {
                    if (byArray != null) {
                        byArray = this.ascii85DecodeNEW(byArray);
                    }
                    if (this.bis != null) {
                        this.ascii85Decode(this.bis, this.streamCache);
                    }
                } else if (this.isCCITTEncoded(this.filter_type)) {
                    int n3;
                    JAIHelper.confirmJAIOnClasspath();
                    if (bl2) {
                        n3 = this.bis.available();
                        byArray = new byte[n3];
                        this.bis.read(byArray);
                    }
                    n3 = 0;
                    String string3 = (String)map.get("EncodedByteAlign");
                    if (string3 != null) {
                        n3 = Boolean.valueOf(string3).booleanValue() ? 1 : 0;
                    }
                    byte[] byArray2 = null;
                    if (n3 == 0 && bl && JAIHelper.isJAIused() && byArray != null) {
                        TiffDecoder tiffDecoder = new TiffDecoder(n, n2, map, byArray);
                        byArray2 = tiffDecoder.getRawBytes();
                    }
                    byArray = byArray2 == null ? this.ccittDecode(byArray, map, n, n2) : byArray2;
                    if (bl2) {
                        this.streamCache.write(byArray);
                    }
                } else if (this.filter_type.indexOf("/LZW") != -1) {
                    byArray = this.lzwDecode(this.bis, this.streamCache, byArray, map, n, n2, string2);
                } else if (this.filter_type.indexOf("/RunLengthDecode") != -1 | this.filter_type.indexOf("/RL") != -1) {
                    byArray = this.runLengthDecode(byArray, this.bis, this.streamCache);
                } else if (this.filter_type.indexOf("/ASCIIHexDecode") != -1 | this.filter_type.indexOf("/AHx") != -1) {
                    if (byArray != null) {
                        byArray = this.asciiHexDecode(byArray);
                    }
                    if (this.bis != null) {
                        this.asciiHexDecode(this.bis, this.streamCache);
                    }
                } else if (this.filter_type.indexOf("/Crypt") == -1) {
                    if (bl5) {
                        bl4 = true;
                    } else {
                        LogWriter.writeLog("[PDF] Unsupported decompression stream " + this.filter_type);
                        byArray = null;
                    }
                }
                if (!bl2) continue;
                if (this.bis != null) {
                    this.bis.close();
                }
                if (this.streamCache == null) continue;
                this.streamCache.flush();
                this.streamCache.close();
            }
        }
        return byArray;
    }

    public byte[] decodeFilters(PdfObject pdfObject, byte[] byArray, PdfArrayIterator pdfArrayIterator, int n, int n2, boolean bl, byte[] byArray2, String string) throws Exception {
        this.streamCache = null;
        this.bis = null;
        boolean bl2 = string != null && byArray == null;
        int n3 = -1;
        int n4 = pdfArrayIterator.getTokenCount();
        if (n4 > 0) {
            boolean bl3 = false;
            while (pdfArrayIterator.hasMoreTokens()) {
                boolean bl4;
                n3 = pdfArrayIterator.getNextValueAsConstant(true);
                boolean bl5 = bl4 = n3 != 1180911742 || n3 != 1399277700;
                if (bl2 && !bl4 && string != null) {
                    this.setupCachedObjectForDecoding(byArray, string, false);
                }
                bl3 = false;
                if (n3 == 2005566619 || n3 == 5692) {
                    try {
                        byArray = this.flateDecode(byArray, pdfObject, string);
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("Invalid flate stream");
                    }
                    catch (Error error) {
                        LogWriter.writeLog("Invalid flate stream");
                    }
                } else if (n3 == 1582784916 || n3 == 1116165) {
                    if (byArray != null) {
                        byArray = this.ascii85DecodeNEW(byArray);
                    }
                    if (this.bis != null) {
                        this.ascii85Decode(this.bis, this.streamCache);
                    }
                } else if (n3 == 2108391315 || n3 == 0x131316) {
                    Object object;
                    JAIHelper.confirmJAIOnClasspath();
                    if (bl2) {
                        int n5 = this.bis.available();
                        byArray = new byte[n5];
                        this.bis.read(byArray);
                    }
                    boolean bl6 = false;
                    if (pdfObject != null) {
                        bl6 = pdfObject.getBoolean(-823077984);
                    }
                    byte[] byArray3 = null;
                    boolean bl7 = true;
                    if (!bl7 && !bl6 && bl && JAIHelper.isJAIused() && byArray != null) {
                        object = new TiffDecoder(n, n2, pdfObject, byArray);
                        byArray3 = ((TiffDecoder)object).getRawBytes();
                    }
                    if (byArray3 == null) {
                        if (bl7 && 0 == pdfObject.getInt(27)) {
                            object = new CCITTFactory(byArray, n, n2, pdfObject);
                            byArray = ((CCITTFactory)object).decode();
                        } else {
                            byArray = this.ccittDecode(byArray, pdfObject, n, n2);
                        }
                    } else {
                        byArray = byArray3;
                    }
                    if (bl2) {
                        this.streamCache.write(byArray);
                    }
                } else if (n3 == 1566984326 || n3 == 1845799) {
                    byArray = this.lzwDecode(this.bis, this.streamCache, byArray, pdfObject, n, n2, string);
                } else if (n3 == -1815163937 || n3 == 8732) {
                    byArray = this.runLengthDecode(byArray, this.bis, this.streamCache);
                } else if (n3 == 1247500931) {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    this.bis = new BufferedInputStream(byteArrayInputStream);
                    byArray = this.JBIGDecode(this.bis, this.streamCache, byArray, byArray2, string);
                } else if (n3 == 2074112677 || n3 == 0x111848) {
                    if (byArray != null) {
                        byArray = this.asciiHexDecode(byArray);
                    }
                    if (this.bis != null) {
                        this.asciiHexDecode(this.bis, this.streamCache);
                    }
                } else if (n3 != 1112096855) {
                    if (bl4) {
                        bl3 = true;
                    } else {
                        LogWriter.writeLog("[PDF] Unsupported decompression stream ");
                        byArray = null;
                    }
                }
                if (!bl2) continue;
                if (this.bis != null) {
                    this.bis.close();
                }
                if (this.streamCache == null) continue;
                this.streamCache.flush();
                this.streamCache.close();
            }
        }
        return byArray;
    }

    public static String getFilterName(int n) {
        switch (n) {
            case 1116165: {
                return "A85";
            }
            case 0x111848: {
                return "AHx";
            }
            case 1582784916: {
                return "ASCII85Decode";
            }
            case 2074112677: {
                return "ASCIIHexDecode";
            }
            case 2108391315: {
                return "CCITTFaxDecode";
            }
            case 0x131316: {
                return "CCF";
            }
            case 1112096855: {
                return "Crypt";
            }
            case 1180911742: {
                return "DCTDecode";
            }
            case 5692: {
                return "Fl";
            }
            case 2005566619: {
                return "FlateDecode";
            }
            case 1247500931: {
                return "JBIG2Decode";
            }
            case 1399277700: {
                return "";
            }
            case 1845799: {
                return "";
            }
            case 1566984326: {
                return "";
            }
            case 8732: {
                return "";
            }
            case -1815163937: {
                return "";
            }
        }
        return "Unknown";
    }

    private void setupCachedObjectForDecoding(byte[] byArray, String string, boolean bl) throws IOException {
        File file = File.createTempFile("jpedal", ".raw");
        this.cachedObjects.put(file.getAbsolutePath(), "x");
        ObjectStore.copy(string, file.getAbsolutePath());
        File file2 = new File(string);
        file2.delete();
        this.streamCache = new BufferedOutputStream(new FileOutputStream(string));
        if (bl) {
            System.out.println("cache size=" + file.length());
        }
        this.bis = new BufferedInputStream(new FileInputStream(file));
        if (byArray != null) {
            // empty if block
        }
    }

    public void convertStringToMap(Map map, Object object) {
        StringTokenizer stringTokenizer = new StringTokenizer(Strip.removeArrayDeleminators((String)object));
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.startsWith("<<")) {
                string = string.substring(2).trim();
            }
            if (!string.startsWith("/")) continue;
            String string2 = string.substring(1);
            string = stringTokenizer.nextToken();
            if (string.endsWith(">>")) {
                string = string.substring(0, string.length() - 2).trim();
            }
            map.put(string2, string);
        }
    }

    private byte[] runLengthDecode(byte[] byArray, BufferedInputStream bufferedInputStream, BufferedOutputStream bufferedOutputStream) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        byte by = 0;
        int n4 = 0;
        if (byArray != null) {
            n = byArray.length;
            byteArrayOutputStream = new ByteArrayOutputStream(n);
        }
        if (bufferedInputStream != null) {
            n = bufferedInputStream.available();
        }
        if (byArray != null && bufferedInputStream != null && byArray.length != bufferedInputStream.available()) {
            System.out.println("Different lengths in RunLengthDecode");
            System.out.println(byArray.length + " " + bufferedInputStream.available());
            System.exit(1);
        }
        for (int i = 0; i < n; ++i) {
            int n5;
            if (byArray != null) {
                n2 = byArray[i];
            }
            if (bufferedInputStream != null) {
                n3 = bufferedInputStream.read();
                if (n3 >= 128) {
                    n3 -= 256;
                }
                if (byArray != null && n2 != n3) {
                    System.out.println("Len wrong =" + n2 + ' ' + n3);
                    System.exit(1);
                }
                n2 = n3;
            }
            if (n2 < 0) {
                n2 = 256 + n2;
            }
            if (n2 == 128) {
                i = n;
                continue;
            }
            if (n2 > 128) {
                ++i;
                n2 = 257 - n2;
                if (byArray != null) {
                    by = byArray[i];
                }
                if (bufferedOutputStream != null && (n4 = bufferedInputStream.read()) >= 128) {
                    n4 -= 256;
                }
                if (byArray != null && bufferedInputStream != null && by != n4) {
                    System.out.println("Different values in RunLengthDecode");
                    System.out.println(by + " " + n4 + ' ' + bufferedOutputStream);
                    System.exit(1);
                }
                for (n5 = 0; n5 < n2; ++n5) {
                    if (byArray != null) {
                        byteArrayOutputStream.write(by);
                    }
                    if (bufferedOutputStream == null) continue;
                    bufferedOutputStream.write(n4);
                }
                continue;
            }
            ++i;
            ++n2;
            for (n5 = 0; n5 < n2; ++n5) {
                if (byArray != null) {
                    by = byArray[i + n5];
                    byteArrayOutputStream.write(by);
                }
                if (bufferedOutputStream != null) {
                    n4 = bufferedInputStream.read();
                    if (n4 >= 128) {
                        n4 -= 256;
                    }
                    bufferedOutputStream.write(n4);
                }
                if (byArray == null || bufferedInputStream == null || by == n4) continue;
                System.out.println("2Different values in RunLengthDecode");
                System.out.println(by + " " + n4);
                System.exit(1);
            }
            i = i + n2 - 1;
        }
        if (byArray != null) {
            byteArrayOutputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
        }
        return byArray;
    }

    private final byte[] lzwDecode(BufferedInputStream bufferedInputStream, BufferedOutputStream bufferedOutputStream, byte[] byArray, PdfObject pdfObject, int n, int n2, String string) throws Exception {
        int n3 = 1;
        int n4 = 8;
        int n5 = n2;
        int n6 = n;
        int n7 = 1;
        int n8 = 8;
        boolean bl = true;
        if (pdfObject != null) {
            int n9;
            int n10;
            int n11 = pdfObject.getInt(-1344207655);
            if (n11 != -1) {
                n8 = n11;
            }
            if ((n10 = pdfObject.getInt(1010783618)) != -1) {
                n7 = n10;
            }
            if ((n9 = pdfObject.getInt(1162902911)) != -1) {
                n6 = n9;
            }
            n3 = pdfObject.getInt(1970893723);
            int n12 = pdfObject.getInt(574572355);
            if (n12 != -1) {
                n5 = n12;
            }
        }
        return this.lzwDecode(bufferedInputStream, bufferedOutputStream, byArray, string, n3, n4, n5, n6, n7, n8);
    }

    private final byte[] lzwDecode(BufferedInputStream bufferedInputStream, BufferedOutputStream bufferedOutputStream, byte[] byArray, Map map, int n, int n2, String string) throws Exception {
        int n3 = 1;
        int n4 = 8;
        int n5 = n2;
        int n6 = n;
        int n7 = 1;
        int n8 = 8;
        boolean bl = true;
        String string2 = (String)map.get("Predictor");
        if (string2 != null) {
            n3 = Integer.parseInt(string2);
        }
        if ((string2 = (String)map.get("Rows")) != null) {
            n5 = Integer.parseInt(string2);
        }
        if ((string2 = (String)map.get("Columns")) != null) {
            n6 = Integer.parseInt(string2);
        }
        if ((string2 = (String)map.get("EarlyChange")) != null) {
            int n9 = Integer.parseInt(string2);
        }
        if ((string2 = (String)map.get("BitsPerComponent")) != null) {
            n4 = Integer.parseInt(string2);
        }
        if ((string2 = (String)map.get("Colors")) != null) {
            n7 = Integer.parseInt(string2);
        }
        return this.lzwDecode(bufferedInputStream, bufferedOutputStream, byArray, string, n3, n4, n5, n6, n7, n8);
    }

    private byte[] lzwDecode(BufferedInputStream bufferedInputStream, BufferedOutputStream bufferedOutputStream, byte[] byArray, String string, int n, int n2, int n3, int n4, int n5, int n6) throws Exception, IOException {
        Object object;
        if (n3 * n4 == 1) {
            if (byArray != null) {
                byte[] byArray2 = new byte[n2 * n3 * (n4 + 7 >> 3)];
                TIFFLZWDecoder tIFFLZWDecoder = new TIFFLZWDecoder(n4, n, n2);
                tIFFLZWDecoder.decode(byArray, byArray2, n3);
                return this.applyPredictor(n, byArray2, n5, n2, n4);
            }
            return null;
        }
        if (bufferedInputStream != null) {
            object = new LZWDecoder2();
            ((LZWDecoder2)object).decode(byArray, bufferedOutputStream, bufferedInputStream);
        }
        if (byArray != null) {
            object = new ByteArrayOutputStream();
            LZWDecoder lZWDecoder = new LZWDecoder();
            lZWDecoder.decode(byArray, (OutputStream)object);
            ((ByteArrayOutputStream)object).close();
            byArray = ((ByteArrayOutputStream)object).toByteArray();
        }
        if (n != 1 && n != 10) {
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            if (string != null) {
                this.setupCachedObjectForDecoding(byArray, string, false);
            }
        }
        byArray = this.applyPredictor(n, byArray, n5, n6, n4);
        return byArray;
    }

    private final byte[] JBIGDecode(BufferedInputStream bufferedInputStream, BufferedOutputStream bufferedOutputStream, byte[] byArray, byte[] byArray2, String string) throws Exception {
        try {
            JBIG2Decoder jBIG2Decoder = new JBIG2Decoder();
            if (byArray2 != null) {
                jBIG2Decoder.setGlobalData(byArray2);
            }
            jBIG2Decoder.decodeJBIG2(byArray);
            byArray = jBIG2Decoder.getPageAsJBIG2Bitmap(0).getData(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray;
    }

    private byte[] ccittDecode(byte[] byArray, Map map, int n, int n2) throws Exception {
        boolean bl = false;
        int n3 = 1728;
        int n4 = n2;
        int n5 = 0;
        boolean bl2 = false;
        String string = (String)map.get("K");
        if (string != null) {
            n5 = Integer.parseInt(string);
        }
        if ((string = (String)map.get("EncodedByteAlign")) != null) {
            bl2 = Boolean.valueOf(string);
        }
        if ((string = (String)map.get("BlackIs1")) != null) {
            bl = Boolean.valueOf(string);
        }
        if ((string = (String)map.get("Rows")) != null) {
            n4 = Integer.parseInt(string);
        }
        if ((string = (String)map.get("Columns")) != null) {
            n3 = Integer.parseInt(string);
        }
        return this.sunCCITTDecode(byArray, bl, n3, n4, n5, bl2);
    }

    private byte[] ccittDecode(byte[] byArray, PdfObject pdfObject, int n, int n2) throws Exception {
        boolean bl = false;
        int n3 = 1728;
        int n4 = n2;
        int n5 = 0;
        boolean bl2 = false;
        if (pdfObject != null) {
            bl = pdfObject.getBoolean(1297445940);
            int n6 = pdfObject.getInt(1162902911);
            if (n6 != -1) {
                n3 = n6;
            }
            bl2 = pdfObject.getBoolean(-823077984);
            n5 = pdfObject.getInt(27);
            int n7 = pdfObject.getInt(574572355);
            if (n7 != -1) {
                n4 = n7;
            }
        }
        return this.sunCCITTDecode(byArray, bl, n3, n4, n5, bl2);
    }

    private byte[] sunCCITTDecode(byte[] byArray, boolean bl, int n, int n2, int n3, boolean bl2) {
        byte[] byArray2 = new byte[n2 * (n + 7 >> 3)];
        try {
            TIFFFaxDecoder tIFFFaxDecoder = new TIFFFaxDecoder(1, n, n2);
            if (n3 == 0) {
                tIFFFaxDecoder.decode1D(byArray2, byArray, 0, n2);
            } else if (n3 > 0) {
                tIFFFaxDecoder.decode2D(byArray2, byArray, 0, n2, 0L);
            } else if (n3 < 0) {
                tIFFFaxDecoder.decodeT6(byArray2, byArray, 0, n2, 0L, bl2);
            }
            if (!bl) {
                for (int i = 0; i < byArray2.length; ++i) {
                    byArray2[i] = (byte)(255 - byArray2[i]);
                }
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " accessing CCITT filter " + exception);
        }
        return byArray2;
    }

    private final byte[] ascii85DecodeNEW(byte[] byArray) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = byArray.length;
        for (n = 0; n < n4; ++n) {
            if (byArray[n] == 122) {
                ++n2;
            }
            if (byArray[n] != 10 && byArray[n] != 10) continue;
            ++n3;
        }
        n = 0;
        long l = 0L;
        byte[] byArray2 = new byte[n4 - n3 + 1 + n2 * 3];
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            int n6;
            l = 0L;
            byte by = byArray[i];
            while (by == 10 || by == 13) {
                if (++i == n4) {
                    by = 0;
                    continue;
                }
                by = byArray[i];
            }
            if (by == 122) {
                for (n6 = 0; n6 < 4; ++n6) {
                    byArray2[n] = 0;
                    ++n;
                }
                continue;
            }
            if (n4 - i <= 4 || by <= 32 || by >= 118) continue;
            for (n5 = 0; n5 < 5; ++n5) {
                by = byArray[i];
                while (by == 10 || by == 13) {
                    if (++i == n4) {
                        by = 0;
                        continue;
                    }
                    by = byArray[i];
                }
                ++i;
                if ((by <= 32 || by >= 118) && by != 126) continue;
                l += (long)(by - 33) * base_85_indices[n5];
            }
            for (n6 = 0; n6 < 4; ++n6) {
                byArray2[n] = (byte)(l / hex_indices[n6] & 0xFFL);
                ++n;
            }
            --i;
        }
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray2, 0, byArray3, 0, n);
        return byArray3;
    }

    private final void ascii85Decode(BufferedInputStream bufferedInputStream, BufferedOutputStream bufferedOutputStream) {
        long l = 0L;
        int n = 0;
        try {
            int n2 = bufferedInputStream.available();
            int n3 = 0;
            boolean bl = false;
            while (bufferedInputStream.available() > 0) {
                int n4;
                l = 0L;
                n = this.read(bufferedInputStream);
                if (n == 122) {
                    for (int i = 0; i < 4; ++i) {
                        bufferedOutputStream.write(0);
                    }
                    continue;
                }
                if (bufferedInputStream.available() < 4 || n <= 32 || n >= 118) continue;
                n3 = n;
                l += (long)(n - 33) * base_85_indices[0];
                String string = "";
                for (n4 = 1; n4 < 5; ++n4) {
                    n = this.read(bufferedInputStream);
                    string = string + n + ' ';
                    if (n == -1) {
                        n = 0;
                    }
                    if (n == -1) {
                        bl = true;
                    }
                    n3 = n;
                    if ((n <= 32 || n >= 118) && n != 126) continue;
                    l += (long)(n - 33) * base_85_indices[n4];
                }
                if (bl) continue;
                for (n4 = 0; n4 < 4; ++n4) {
                    byte by = (byte)(l / hex_indices[n4] & 0xFFL);
                    bufferedOutputStream.write(by);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private int read(BufferedInputStream bufferedInputStream) throws IOException {
        int n = bufferedInputStream.read();
        while (n == 13 || n == 10) {
            n = bufferedInputStream.read();
        }
        return n;
    }

    private final byte[] asciiHexDecode(byte[] byArray) throws IOException {
        String string = "";
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        BufferedReader bufferedReader = null;
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            bufferedReader = new BufferedReader(new InputStreamReader(byteArrayInputStream));
            if (bufferedReader != null) {
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuffer2.append(string);
                }
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " reading ASCII stream ");
        }
        if (bufferedReader != null) {
            try {
                bufferedReader.close();
                byteArrayInputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        int n = stringBuffer2.length();
        int n2 = 0;
        int n3 = 0;
        char c = ' ';
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        do {
            if (!((c = (char)stringBuffer2.charAt(n2)) >= '0' & c <= '9' | c >= 'a' & c <= 'f' | c >= 'A' & c <= 'F')) continue;
            stringBuffer.append(c);
            if (n3 == 1) {
                byteArrayOutputStream.write(Integer.valueOf(stringBuffer.toString(), 16));
                n3 = 0;
                stringBuffer = new StringBuffer();
                continue;
            }
            ++n3;
        } while (c != '>' && ++n2 != n);
        if (n3 == 1) {
            stringBuffer.append('0');
            byteArrayOutputStream.write(Integer.valueOf(stringBuffer.toString(), 16));
        }
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private final void asciiHexDecode(BufferedInputStream bufferedInputStream, BufferedOutputStream bufferedOutputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        char c = ' ';
        int n = bufferedInputStream.available();
        for (int i = 0; i < n; ++i) {
            c = (char)bufferedInputStream.read();
            while (c == '\n') {
                c = (char)bufferedInputStream.read();
            }
            if (c >= '0' & c <= '9' | c >= 'a' & c <= 'f' | c >= 'A' & c <= 'F') {
                stringBuffer.append(c);
                if (n == 1) {
                    bufferedOutputStream.write(Integer.valueOf(stringBuffer.toString(), 16));
                    n = 0;
                    stringBuffer = new StringBuffer();
                } else {
                    ++n;
                }
            }
            if (c == '>') break;
        }
        if (n == 1) {
            stringBuffer.append('0');
            bufferedOutputStream.write(Integer.valueOf(stringBuffer.toString(), 16));
        }
    }

    private final byte[] flateDecode(byte[] byArray, Map map, String string) throws Exception {
        byte[] byArray2 = null;
        int n = 1;
        String string2 = (String)map.get("Predictor");
        if (string2 != null) {
            n = Integer.parseInt(string2);
        }
        int n2 = 1;
        int n3 = 8;
        int n4 = 1;
        boolean bl = true;
        string2 = (String)map.get("Colors");
        if (string2 != null) {
            n2 = Integer.parseInt(string2);
        }
        if ((string2 = (String)map.get("BitsPerComponent")) != null) {
            n3 = Integer.parseInt(string2);
        }
        if ((string2 = (String)map.get("Columns")) != null) {
            n4 = Integer.parseInt(string2);
        }
        return this.flateDecode(byArray, string, byArray2, n, n2, n3, n4);
    }

    private final byte[] flateDecode(byte[] byArray, PdfObject pdfObject, String string) throws Exception {
        byte[] byArray2 = null;
        int n = 1;
        int n2 = 1;
        int n3 = 8;
        int n4 = 1;
        if (pdfObject != null) {
            int n5;
            int n6;
            int n7 = pdfObject.getInt(-1344207655);
            if (n7 != -1) {
                n3 = n7;
            }
            if ((n6 = pdfObject.getInt(1010783618)) != -1) {
                n2 = n6;
            }
            if ((n5 = pdfObject.getInt(1162902911)) != -1) {
                n4 = n5;
            }
            n = pdfObject.getInt(1970893723);
        }
        return this.flateDecode(byArray, string, byArray2, n, n2, n3, n4);
    }

    private byte[] flateDecode(byte[] byArray, String string, byte[] byArray2, int n, int n2, int n3, int n4) throws DataFormatException, Exception {
        int n5;
        Object object;
        if (byArray != null) {
            object = new Inflater();
            ((Inflater)object).setInput(byArray);
            n5 = byArray.length;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n5);
            int n6 = 512000;
            if (n5 < n6) {
                n6 = n5;
            }
            byte[] byArray3 = new byte[n6];
            int n7 = 20;
            while (!((Inflater)object).finished()) {
                int n8 = ((Inflater)object).inflate(byArray3);
                byteArrayOutputStream.write(byArray3, 0, n8);
                if (((Inflater)object).getRemaining() != 0) continue;
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        if (this.bis != null) {
            try {
                object = new InflaterInputStream(this.bis);
                n5 = 0;
                while (true) {
                    int n9 = ((InputStream)object).read();
                    if (byArray2 != null && n9 != (byArray2[n5] & 0xFF)) {
                        System.out.println("Different in flate at " + n5);
                        System.exit(1);
                    }
                    if (((InputStream)object).available() == 0 || n9 == -1) break;
                    this.streamCache.write(n9);
                    ++n5;
                }
                if (n != 1 && n != 10) {
                    this.streamCache.flush();
                    this.streamCache.close();
                    if (string != null) {
                        this.setupCachedObjectForDecoding(byArray, string, false);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        byArray2 = this.applyPredictor(n, byArray, n2, n3, n4);
        return byArray2;
    }

    private void applyPredictorFunction(int n, BufferedInputStream bufferedInputStream, OutputStream outputStream, int n2, int n3, int n4) throws Exception {
        int n5 = n;
        int n6 = bufferedInputStream.available();
        int n7 = (n2 * n3 + 7) / 8;
        int n8 = (n4 * n2 * n3 + 7) / 8 + n7;
        byte[] byArray = new byte[n8];
        byte[] byArray2 = new byte[n8];
        try {
            int n9 = 0;
            while (n6 > n9) {
                n5 = n;
                if (n5 == 15) {
                    n5 = bufferedInputStream.read();
                    if (n5 == -1) break;
                    n5 += 10;
                } else if (n5 >= 10) {
                    bufferedInputStream.read();
                }
                int n10 = 0;
                int n11 = n7;
                int n12 = n8;
                while (n11 < n12 && (n10 = bufferedInputStream.read(byArray, n11, n12 - n11)) != -1) {
                    n11 += n10;
                    n9 += n10;
                }
                if (n10 == -1) break;
                switch (n5) {
                    case 2: {
                        int n13;
                        int n14;
                        int n15;
                        for (n15 = n7; n15 < n8; ++n15) {
                            n14 = byArray[n15] & 0xFF;
                            n13 = byArray2[n15 - n7] & 0xFF;
                            byArray[n15] = (byte)(n14 + n13 & 0xFF);
                            outputStream.write(byArray[n15]);
                        }
                        break;
                    }
                    case 10: {
                        int n15;
                        for (n15 = n7; n15 < n8; ++n15) {
                            outputStream.write(byArray[n15]);
                        }
                        break;
                    }
                    case 11: {
                        int n13;
                        int n14;
                        int n15;
                        for (n15 = n7; n15 < n8; ++n15) {
                            n14 = byArray[n15] & 0xFF;
                            n13 = byArray[n15 - n7] & 0xFF;
                            byArray[n15] = (byte)(n14 + n13);
                            outputStream.write(byArray[n15]);
                        }
                        break;
                    }
                    case 12: {
                        int n13;
                        int n14;
                        int n15;
                        for (n15 = n7; n15 < n8; ++n15) {
                            n14 = byArray[n15] & 0xFF;
                            n13 = byArray2[n15] & 0xFF;
                            byArray[n15] = (byte)(n14 + n13 & 0xFF);
                            outputStream.write(byArray[n15]);
                        }
                        break;
                    }
                    case 13: {
                        int n13;
                        int n14;
                        int n15;
                        for (n15 = n7; n15 < n8; ++n15) {
                            n14 = byArray[n15] & 0xFF;
                            n13 = (byArray[n15 - n7] & 0xFF) + (byArray2[n15] & 0xFF) >> 1;
                            byArray[n15] = (byte)(n14 + n13);
                            outputStream.write(byArray[n15]);
                        }
                        break;
                    }
                    case 14: {
                        int n13;
                        int n14;
                        int n15;
                        for (n15 = n7; n15 < n8; ++n15) {
                            n14 = byArray[n15 - n7] & 0xFF;
                            n13 = byArray2[n15] & 0xFF;
                            int n16 = byArray2[n15 - n7] & 0xFF;
                            int n17 = n14 + n13 - n16;
                            int n18 = n17 - n14;
                            int n19 = n17 - n13;
                            int n20 = n17 - n16;
                            if (n18 < 0) {
                                n18 = -n18;
                            }
                            if (n19 < 0) {
                                n19 = -n19;
                            }
                            if (n20 < 0) {
                                n20 = -n20;
                            }
                            byArray[n15] = n18 <= n19 && n18 <= n20 ? (byte)(byArray[n15] + n14) : (n19 <= n20 ? (byte)(byArray[n15] + n13) : (byte)(byArray[n15] + n16));
                            outputStream.write(byArray[n15]);
                        }
                        break;
                    }
                    case 15: {
                        break;
                    }
                }
                System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
            }
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    private byte[] applyPredictor(int n, byte[] byArray, int n2, int n3, int n4) throws Exception {
        boolean bl;
        if (n == 1 || n == 10) {
            return byArray;
        }
        boolean bl2 = bl = byArray == null;
        if (bl) {
            this.applyPredictorFunction(n, this.bis, this.streamCache, n2, n3, n4);
            return null;
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(byArray));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.applyPredictorFunction(n, bufferedInputStream, byteArrayOutputStream, n2, n3, n4);
        return byteArrayOutputStream.toByteArray();
    }

    private boolean isCCITTEncoded(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith("/CCITT") | string.startsWith("/CCF");
    }
}

