/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.usermodel;

import java.awt.Color;
import org.apache.poi.hslf.model.MasterSheet;
import org.apache.poi.hslf.model.Sheet;
import org.apache.poi.hslf.model.TextRun;
import org.apache.poi.hslf.model.textproperties.BitMaskTextProp;
import org.apache.poi.hslf.model.textproperties.CharFlagsTextProp;
import org.apache.poi.hslf.model.textproperties.ParagraphFlagsTextProp;
import org.apache.poi.hslf.model.textproperties.TextProp;
import org.apache.poi.hslf.model.textproperties.TextPropCollection;
import org.apache.poi.hslf.record.ColorSchemeAtom;
import org.apache.poi.hslf.usermodel.SlideShow;

public class RichTextRun {
    private TextRun parentRun;
    private SlideShow slideShow;
    private int startPos;
    private int length;
    private String _fontname;
    private TextPropCollection paragraphStyle;
    private TextPropCollection characterStyle;
    private boolean sharingParagraphStyle;
    private boolean sharingCharacterStyle;

    public RichTextRun(TextRun parent, int startAt, int len) {
        this(parent, startAt, len, null, null, false, false);
    }

    public RichTextRun(TextRun parent, int startAt, int len, TextPropCollection pStyle, TextPropCollection cStyle, boolean pShared, boolean cShared) {
        this.parentRun = parent;
        this.startPos = startAt;
        this.length = len;
        this.paragraphStyle = pStyle;
        this.characterStyle = cStyle;
        this.sharingParagraphStyle = pShared;
        this.sharingCharacterStyle = cShared;
    }

    public void supplyTextProps(TextPropCollection pStyle, TextPropCollection cStyle, boolean pShared, boolean cShared) {
        if (this.paragraphStyle != null || this.characterStyle != null) {
            throw new IllegalStateException("Can't call supplyTextProps if run already has some");
        }
        this.paragraphStyle = pStyle;
        this.characterStyle = cStyle;
        this.sharingParagraphStyle = pShared;
        this.sharingCharacterStyle = cShared;
    }

    public void supplySlideShow(SlideShow ss) {
        this.slideShow = ss;
        if (this._fontname != null) {
            this.setFontName(this._fontname);
            this._fontname = null;
        }
    }

    public int getLength() {
        return this.length;
    }

    public String getText() {
        return this.parentRun.getText().substring(this.startPos, this.startPos + this.length);
    }

    public String getRawText() {
        return this.parentRun.getRawText().substring(this.startPos, this.startPos + this.length);
    }

    public void setText(String text) {
        this.length = text.length();
        this.parentRun.changeTextInRichTextRun(this, text);
    }

    public void updateStartPosition(int startAt) {
        this.startPos = startAt;
    }

    private boolean isCharFlagsTextPropVal(int index) {
        return this.getFlag(true, index);
    }

    private boolean getFlag(boolean isCharacter, int index) {
        String propname;
        TextPropCollection props;
        if (isCharacter) {
            props = this.characterStyle;
            propname = CharFlagsTextProp.NAME;
        } else {
            props = this.paragraphStyle;
            propname = ParagraphFlagsTextProp.NAME;
        }
        BitMaskTextProp prop = null;
        if (props != null) {
            prop = (BitMaskTextProp)props.findByName(propname);
        }
        if (prop == null) {
            Sheet sheet = this.parentRun.getSheet();
            int txtype = this.parentRun.getRunType();
            MasterSheet master = sheet.getMasterSheet();
            if (master != null) {
                prop = (BitMaskTextProp)master.getStyleAttribute(txtype, this.getIndentLevel(), propname, isCharacter);
            }
        }
        return prop == null ? false : prop.getSubValue(index);
    }

    private void setCharFlagsTextPropVal(int index, boolean value) {
        this.setFlag(true, index, value);
    }

    public void setFlag(boolean isCharacter, int index, boolean value) {
        String propname;
        TextPropCollection props;
        if (isCharacter) {
            props = this.characterStyle;
            propname = CharFlagsTextProp.NAME;
        } else {
            props = this.paragraphStyle;
            propname = ParagraphFlagsTextProp.NAME;
        }
        if (props == null) {
            this.parentRun.ensureStyleAtomPresent();
            props = isCharacter ? this.characterStyle : this.paragraphStyle;
        }
        BitMaskTextProp prop = (BitMaskTextProp)this.fetchOrAddTextProp(props, propname);
        prop.setSubValue(value, index);
    }

    private TextProp fetchOrAddTextProp(TextPropCollection textPropCol, String textPropName) {
        TextProp tp = textPropCol.findByName(textPropName);
        if (tp == null) {
            tp = textPropCol.addWithName(textPropName);
        }
        return tp;
    }

    private int getCharTextPropVal(String propName) {
        TextProp prop = null;
        if (this.characterStyle != null) {
            prop = this.characterStyle.findByName(propName);
        }
        if (prop == null) {
            Sheet sheet = this.parentRun.getSheet();
            int txtype = this.parentRun.getRunType();
            MasterSheet master = sheet.getMasterSheet();
            if (master != null) {
                prop = master.getStyleAttribute(txtype, this.getIndentLevel(), propName, true);
            }
        }
        return prop == null ? -1 : prop.getValue();
    }

    private int getParaTextPropVal(String propName) {
        TextProp prop = null;
        if (this.paragraphStyle != null) {
            prop = this.paragraphStyle.findByName(propName);
        }
        if (prop == null) {
            Sheet sheet = this.parentRun.getSheet();
            int txtype = this.parentRun.getRunType();
            MasterSheet master = sheet.getMasterSheet();
            if (master != null) {
                prop = master.getStyleAttribute(txtype, this.getIndentLevel(), propName, false);
            }
        }
        return prop == null ? -1 : prop.getValue();
    }

    public void setParaTextPropVal(String propName, int val) {
        if (this.paragraphStyle == null) {
            this.parentRun.ensureStyleAtomPresent();
        }
        TextProp tp = this.fetchOrAddTextProp(this.paragraphStyle, propName);
        tp.setValue(val);
    }

    public void setCharTextPropVal(String propName, int val) {
        if (this.characterStyle == null) {
            this.parentRun.ensureStyleAtomPresent();
        }
        TextProp tp = this.fetchOrAddTextProp(this.characterStyle, propName);
        tp.setValue(val);
    }

    public boolean isBold() {
        return this.isCharFlagsTextPropVal(0);
    }

    public void setBold(boolean bold) {
        this.setCharFlagsTextPropVal(0, bold);
    }

    public boolean isItalic() {
        return this.isCharFlagsTextPropVal(1);
    }

    public void setItalic(boolean italic) {
        this.setCharFlagsTextPropVal(1, italic);
    }

    public boolean isUnderlined() {
        return this.isCharFlagsTextPropVal(2);
    }

    public void setUnderlined(boolean underlined) {
        this.setCharFlagsTextPropVal(2, underlined);
    }

    public int getFontSize() {
        return this.getCharTextPropVal("font.size");
    }

    public void setFontSize(int fontSize) {
        this.setCharTextPropVal("font.size", fontSize);
    }

    public void setFontName(String fontName) {
        if (this.slideShow == null) {
            this._fontname = fontName;
        } else {
            int fontIdx = this.slideShow.getFontCollection().addFont(fontName);
            this.setCharTextPropVal("font.index", fontIdx);
        }
    }

    public String getFontName() {
        if (this.slideShow == null) {
            return this._fontname;
        }
        int fontIdx = this.getCharTextPropVal("font.index");
        if (fontIdx == -1) {
            return null;
        }
        return this.slideShow.getFontCollection().getFontWithId(fontIdx);
    }

    public Color getFontColor() {
        int rgb = this.getCharTextPropVal("font.color");
        if (rgb >= 0x8000000) {
            int idx = rgb % 0x8000000;
            ColorSchemeAtom ca = this.parentRun.getSheet().getColorScheme();
            if (idx >= 0 && idx <= 7) {
                rgb = ca.getColor(idx);
            }
        }
        Color tmp = new Color(rgb, true);
        return new Color(tmp.getBlue(), tmp.getGreen(), tmp.getRed());
    }

    public void setFontColor(int bgr) {
        this.setCharTextPropVal("font.color", bgr);
    }

    public void setFontColor(Color color) {
        int rgb = new Color(color.getBlue(), color.getGreen(), color.getRed(), 254).getRGB();
        this.setFontColor(rgb);
    }

    public void setAlignment(int align) {
        this.setParaTextPropVal("alignment", align);
    }

    public int getAlignment() {
        return this.getParaTextPropVal("alignment");
    }

    public int getIndentLevel() {
        return this.paragraphStyle == null ? 0 : (int)this.paragraphStyle.getReservedField();
    }

    public void setBullet(boolean flag) {
        this.setFlag(false, 0, flag);
    }

    public boolean isBullet() {
        return this.getFlag(false, 0);
    }

    public void setBulletChar(char c) {
        this.setParaTextPropVal("bullet.char", c);
    }

    public char getBulletChar() {
        return (char)this.getParaTextPropVal("bullet.char");
    }

    public void setBulletOffset(int offset) {
        this.setParaTextPropVal("bullet.offset", offset * 576 / 72);
    }

    public int getBulletOffset() {
        return this.getParaTextPropVal("bullet.offset") * 72 / 576;
    }

    public void setTextOffset(int offset) {
        this.setParaTextPropVal("text.offset", offset * 576 / 72);
    }

    public int getTextOffset() {
        return this.getParaTextPropVal("text.offset") * 72 / 576;
    }

    public TextPropCollection _getRawParagraphStyle() {
        return this.paragraphStyle;
    }

    public TextPropCollection _getRawCharacterStyle() {
        return this.characterStyle;
    }

    public boolean _isParagraphStyleShared() {
        return this.sharingParagraphStyle;
    }

    public boolean _isCharacterStyleShared() {
        return this.sharingCharacterStyle;
    }
}

