/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.util.Arrays;
import org.apache.poi.util.BitField;
import org.apache.poi.util.LittleEndian;

public class ListLevel {
    private int _iStartAt;
    private byte _nfc;
    private byte _info;
    private static BitField _jc;
    private static BitField _fLegal;
    private static BitField _fNoRestart;
    private static BitField _fPrev;
    private static BitField _fPrevSpace;
    private static BitField _fWord6;
    private byte[] _rgbxchNums;
    private byte _ixchFollow;
    private int _dxaSpace;
    private int _dxaIndent;
    private int _cbGrpprlChpx;
    private int _cbGrpprlPapx;
    private short _reserved;
    private byte[] _grpprlPapx;
    private byte[] _grpprlChpx;
    private char[] _numberText = null;

    public ListLevel(int startAt, int numberFormatCode, int alignment, byte[] numberProperties, byte[] entryProperties, String numberText) {
        this._iStartAt = startAt;
        this._nfc = (byte)numberFormatCode;
        _jc.setValue((int)this._info, alignment);
        this._grpprlChpx = numberProperties;
        this._grpprlPapx = entryProperties;
        this._numberText = numberText.toCharArray();
    }

    public ListLevel(int level, boolean numbered) {
        this._iStartAt = 1;
        this._grpprlPapx = new byte[0];
        this._grpprlChpx = new byte[0];
        this._numberText = new char[0];
        this._rgbxchNums = new byte[9];
        if (numbered) {
            this._rgbxchNums[0] = 1;
            this._numberText = new char[]{(char)level, '.'};
        } else {
            this._numberText = new char[]{'\u2022'};
        }
    }

    public ListLevel(byte[] buf, int offset) {
        this._iStartAt = LittleEndian.getInt((byte[])buf, (int)offset);
        offset += 4;
        this._nfc = buf[offset++];
        this._info = buf[offset++];
        this._rgbxchNums = new byte[9];
        for (int x = 0; x < 9; ++x) {
            this._rgbxchNums[x] = buf[offset++];
        }
        this._ixchFollow = buf[offset++];
        this._dxaSpace = LittleEndian.getInt((byte[])buf, (int)offset);
        this._dxaIndent = LittleEndian.getInt((byte[])buf, (int)(offset += 4));
        offset += 4;
        this._cbGrpprlChpx = LittleEndian.getUnsignedByte((byte[])buf, (int)offset++);
        this._cbGrpprlPapx = LittleEndian.getUnsignedByte((byte[])buf, (int)offset++);
        this._reserved = LittleEndian.getShort((byte[])buf, (int)offset);
        this._grpprlPapx = new byte[this._cbGrpprlPapx];
        this._grpprlChpx = new byte[this._cbGrpprlChpx];
        System.arraycopy(buf, offset += 2, this._grpprlPapx, 0, this._cbGrpprlPapx);
        System.arraycopy(buf, offset += this._cbGrpprlPapx, this._grpprlChpx, 0, this._cbGrpprlChpx);
        int numberTextLength = LittleEndian.getShort((byte[])buf, (int)(offset += this._cbGrpprlChpx));
        if (numberTextLength > 0) {
            this._numberText = new char[numberTextLength];
            offset += 2;
            for (int x = 0; x < numberTextLength; ++x) {
                this._numberText[x] = (char)LittleEndian.getShort((byte[])buf, (int)offset);
                offset += 2;
            }
        }
    }

    public int getStartAt() {
        return this._iStartAt;
    }

    public int getNumberFormat() {
        return this._nfc;
    }

    public int getAlignment() {
        return _jc.getValue((int)this._info);
    }

    public String getNumberText() {
        return new String(this._numberText);
    }

    public void setStartAt(int startAt) {
        this._iStartAt = startAt;
    }

    public void setNumberFormat(int numberFormatCode) {
        this._nfc = (byte)numberFormatCode;
    }

    public void setAlignment(int alignment) {
        _jc.setValue((int)this._info, alignment);
    }

    public void setNumberProperties(byte[] grpprl) {
        this._grpprlChpx = grpprl;
    }

    public void setLevelProperties(byte[] grpprl) {
        this._grpprlPapx = grpprl;
    }

    public byte[] getLevelProperties() {
        return this._grpprlPapx;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        ListLevel lvl = (ListLevel)obj;
        return this._cbGrpprlChpx == lvl._cbGrpprlChpx && lvl._cbGrpprlPapx == this._cbGrpprlPapx && lvl._dxaIndent == this._dxaIndent && lvl._dxaSpace == this._dxaSpace && Arrays.equals(lvl._grpprlChpx, this._grpprlChpx) && Arrays.equals(lvl._grpprlPapx, this._grpprlPapx) && lvl._info == this._info && lvl._iStartAt == this._iStartAt && lvl._ixchFollow == this._ixchFollow && lvl._nfc == this._nfc && Arrays.equals(lvl._numberText, this._numberText) && Arrays.equals(lvl._rgbxchNums, this._rgbxchNums) && lvl._reserved == this._reserved;
    }

    public byte[] toByteArray() {
        byte[] buf = new byte[this.getSizeInBytes()];
        int offset = 0;
        LittleEndian.putInt((byte[])buf, (int)offset, (int)this._iStartAt);
        offset += 4;
        buf[offset++] = this._nfc;
        buf[offset++] = this._info;
        System.arraycopy(this._rgbxchNums, 0, buf, offset, this._rgbxchNums.length);
        offset += this._rgbxchNums.length;
        buf[offset++] = this._ixchFollow;
        LittleEndian.putInt((byte[])buf, (int)offset, (int)this._dxaSpace);
        LittleEndian.putInt((byte[])buf, (int)(offset += 4), (int)this._dxaIndent);
        offset += 4;
        buf[offset++] = (byte)this._cbGrpprlChpx;
        buf[offset++] = (byte)this._cbGrpprlPapx;
        LittleEndian.putShort((byte[])buf, (int)offset, (short)this._reserved);
        System.arraycopy(this._grpprlChpx, 0, buf, offset += 2, this._cbGrpprlChpx);
        System.arraycopy(this._grpprlPapx, 0, buf, offset += this._cbGrpprlChpx, this._cbGrpprlPapx);
        LittleEndian.putShort((byte[])buf, (int)(offset += this._cbGrpprlPapx), (short)((short)this._numberText.length));
        offset += 2;
        for (int x = 0; x < this._numberText.length; ++x) {
            LittleEndian.putShort((byte[])buf, (int)offset, (short)((short)this._numberText[x]));
            offset += 2;
        }
        return buf;
    }

    public int getSizeInBytes() {
        if (this._numberText != null) {
            return 28 + this._cbGrpprlChpx + this._cbGrpprlPapx + this._numberText.length * 2 + 2;
        }
        return 28 + this._cbGrpprlChpx + this._cbGrpprlPapx + 2;
    }
}

