/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.query;

import edu.ucsb.nceas.morpho.query.QueryTerm;
import edu.ucsb.nceas.morpho.util.Log;
import java.util.Enumeration;
import java.util.Vector;

public class QueryGroup {
    private String operator = null;
    private Vector children = null;

    public QueryGroup(String operator) {
        this.operator = operator;
        this.children = new Vector();
    }

    public void addChild(QueryGroup qgroup) {
        this.children.addElement(qgroup);
    }

    public void addChild(QueryTerm qterm) {
        this.children.addElement(qterm);
    }

    public Enumeration getChildren() {
        return this.children.elements();
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String op) {
        this.operator = op;
    }

    public String printSQL(boolean useXMLIndex) {
        StringBuffer self = new StringBuffer();
        boolean first = true;
        self.append("(");
        Enumeration en = this.getChildren();
        while (en.hasMoreElements()) {
            Object qobject = en.nextElement();
            if (first) {
                first = false;
            } else {
                self.append(" " + this.operator + " ");
            }
            if (qobject instanceof QueryGroup) {
                QueryGroup qg = (QueryGroup)qobject;
                self.append(qg.printSQL(useXMLIndex));
                continue;
            }
            if (qobject instanceof QueryTerm) {
                QueryTerm qt = (QueryTerm)qobject;
                self.append(qt.printSQL(useXMLIndex));
                continue;
            }
            Log.debug(4, "qobject wrong type: fatal error");
        }
        self.append(") \n");
        return self.toString();
    }

    public String toXml(int indent) {
        StringBuffer self = new StringBuffer();
        for (int i = 0; i < indent; ++i) {
            self.append(" ");
        }
        self.append("<querygroup operator=\"");
        self.append(this.operator);
        self.append("\">\n");
        Enumeration en = this.getChildren();
        while (en.hasMoreElements()) {
            Object qobject = en.nextElement();
            if (qobject instanceof QueryGroup) {
                QueryGroup qg = (QueryGroup)qobject;
                self.append(qg.toXml(indent + 2));
                continue;
            }
            if (qobject instanceof QueryTerm) {
                QueryTerm qt = (QueryTerm)qobject;
                self.append(qt.toXml(indent + 2));
                continue;
            }
            Log.debug(4, "qobject wrong type: fatal error");
        }
        for (int i = 0; i < indent; ++i) {
            self.append(" ");
        }
        self.append("</querygroup>\n");
        return self.toString();
    }

    public String toString() {
        return this.toXml(0);
    }
}

