/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.printer;

import edu.ucsb.nceas.morpho.util.Log;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class PrintFrame
extends JFrame
implements ActionListener,
HyperlinkListener {
    JEditorPane editor = new JEditorPane();
    JButton printButton;
    JButton pageSetupButton;
    JButton exitButton;
    JScrollPane scrollPane = new JScrollPane(this.editor, 20, 30);
    PageFormat pageFormat = null;
    PrinterJob job = null;
    Rectangle editorBounds = null;

    PrintFrame(String text, String contentType) {
        this(text, contentType, new Dimension(800, 600));
    }

    PrintFrame(String text, String contentType, Dimension dim) {
        this.printButton = new JButton("Print");
        this.pageSetupButton = new JButton("Page Setup");
        this.exitButton = new JButton("Close");
        this.editor.setContentType(contentType);
        this.editor.setText(text);
        this.editor.setEditable(false);
        this.editor.addHyperlinkListener(this);
        this.editor.setCaretPosition(0);
        this.pageSetupButton.addActionListener(this);
        this.printButton.addActionListener(this);
        this.exitButton.addActionListener(this);
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        panel.add(this.pageSetupButton);
        panel.add(this.printButton);
        panel.add(this.exitButton);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)panel, "North");
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.editorBounds = this.editor.getBounds();
        this.job = PrinterJob.getPrinterJob();
        this.pageFormat = this.job.defaultPage();
        this.setSize((int)dim.getWidth(), (int)dim.getHeight());
        this.setVisible(true);
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        Log.debug(50, "hyperlinkUpdate called in PrintPlugin; eventType=" + e.getEventType());
        Log.debug(50, "hyperlinks not supported in Print Window");
    }

    public void setPageFormat(PageFormat format) {
        this.pageFormat = format;
    }

    public void print() {
        this.job = PrinterJob.getPrinterJob();
        if (this.editorBounds.getWidth() == 0.0) {
            this.editorBounds = new Rectangle(800, 600);
        }
        PrintableComponent pc = new PrintableComponent(this.editor, this.pageFormat, this.editorBounds);
        if (this.job.printDialog()) {
            pc.scaleToFitX();
            this.job.setPageable(pc);
            try {
                this.job.print();
            }
            catch (PrinterException pe) {
                Log.debug(6, "Printer Exception - " + pe);
            }
        }
    }

    public void actionPerformed(ActionEvent ae) {
        Object obj = ae.getSource();
        if (obj == this.printButton) {
            this.print();
        } else if (obj == this.pageSetupButton) {
            this.pageFormat = this.job.pageDialog(this.pageFormat);
        } else if (obj == this.exitButton) {
            this.dispose();
        }
    }

    public class PageableComponent
    implements Pageable {
        private int mNumPagesX;
        private int mNumPagesY;
        private int mNumPages;
        private Printable mPainter;
        private PageFormat mFormat;

        public PageableComponent(float width, float height, Printable painter, PageFormat format) {
            this.setPrintable(painter);
            this.setPageFormat(format);
            this.setSize(width, height);
        }

        protected PageableComponent() {
        }

        protected void setPrintable(Printable painter) {
            this.mPainter = painter;
        }

        protected void setPageFormat(PageFormat pageFormat) {
            this.mFormat = pageFormat;
        }

        protected void setSize(float width, float height) {
            this.mNumPagesX = (int)(((double)width + this.mFormat.getImageableWidth() - 1.0) / this.mFormat.getImageableWidth());
            this.mNumPagesY = (int)(((double)height + this.mFormat.getImageableHeight() - 1.0) / this.mFormat.getImageableHeight());
            this.mNumPages = this.mNumPagesX * this.mNumPagesY;
            Log.debug(30, "Number Of Pages for printing = " + this.mNumPages);
        }

        public int getNumberOfPages() {
            return this.mNumPages;
        }

        protected PageFormat getPageFormat() {
            return this.mFormat;
        }

        public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
            if (pageIndex >= this.mNumPages) {
                throw new IndexOutOfBoundsException();
            }
            return this.getPageFormat();
        }

        public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
            if (pageIndex >= this.mNumPages) {
                throw new IndexOutOfBoundsException();
            }
            if (this.mFormat == null) {
                this.mFormat = PrinterJob.getPrinterJob().defaultPage();
            }
            double originX = (double)(pageIndex % this.mNumPagesX) * this.mFormat.getImageableWidth();
            double originY = (double)(pageIndex / this.mNumPagesX) * this.mFormat.getImageableHeight();
            Point2D.Double origin = new Point2D.Double(originX, originY);
            return new TranslatedPrintable(this.mPainter, origin);
        }

        class TranslatedPrintable
        implements Printable {
            private Printable mPainter;
            private Point2D mOrigin;

            public TranslatedPrintable(Printable painter, Point2D origin) {
                this.mPainter = painter;
                this.mOrigin = origin;
            }

            public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
                Graphics2D g2 = (Graphics2D)graphics;
                g2.translate(-this.mOrigin.getX(), -this.mOrigin.getY());
                this.mPainter.print(g2, pageFormat, 1);
                return 0;
            }
        }
    }

    public class PrintableComponent
    extends PageableComponent
    implements Printable {
        private double mScaleX;
        private double mScaleY;
        Rectangle componentBounds;
        private JComponent mComponent;

        public PrintableComponent(JComponent c, PageFormat format, Rectangle bounds) {
            this.setPageFormat(format);
            this.setPrintable(this);
            this.setComponent(c);
            this.componentBounds = bounds;
            this.setSize(this.componentBounds.width, this.componentBounds.height);
            this.setScale(1.0, 1.0);
        }

        protected void setComponent(JComponent c) {
            this.mComponent = c;
        }

        protected void setScale(double scaleX, double scaleY) {
            this.mScaleX = scaleX;
            this.mScaleY = scaleY;
        }

        public void scaleToFit(boolean useSymmetricScaling) {
            PageFormat format = this.getPageFormat();
            Rectangle bounds = this.mComponent.getBounds(null);
            double scaleX = format.getImageableWidth() / (double)bounds.width;
            double scaleY = format.getImageableHeight() / (double)bounds.height;
            if (scaleX < 1.0 || scaleY < 1.0) {
                if (useSymmetricScaling) {
                    if (scaleX < scaleY) {
                        scaleY = scaleX;
                    } else {
                        scaleX = scaleY;
                    }
                }
                this.setSize((float)((double)bounds.width * scaleX), (float)((double)bounds.height * scaleY));
                this.setScale(scaleX, scaleY);
            }
        }

        public void scaleToFitX() {
            double scaleX;
            PageFormat format = this.getPageFormat();
            Rectangle bounds = this.mComponent.getBounds(null);
            if (bounds.getHeight() == 0.0 || bounds.getWidth() == 0.0) {
                bounds = this.componentBounds;
            }
            double scaleY = scaleX = format.getImageableWidth() / (double)bounds.width;
            if (scaleX < 1.0) {
                this.setSize((float)format.getImageableWidth(), (float)((double)bounds.height * scaleY));
                this.setScale(scaleX, scaleY);
            }
        }

        public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
            Graphics2D g2 = (Graphics2D)graphics;
            g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            Rectangle bounds = this.mComponent.getBounds(null);
            if (bounds.getHeight() == 0.0 || bounds.getWidth() == 0.0) {
                bounds = this.componentBounds;
            }
            g2.translate(-bounds.x, -bounds.y);
            g2.scale(this.mScaleX, this.mScaleY);
            boolean wasBuffered = this.mComponent.isDoubleBuffered();
            this.mComponent.paint(g2);
            this.mComponent.setDoubleBuffered(wasBuffered);
            return 0;
        }
    }
}

