/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages;

import edu.ucsb.nceas.morpho.plugins.datapackagewizard.AbstractCustomTablePopupHandler;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WidgetFactory;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class PopupHandler
extends AbstractCustomTablePopupHandler {
    private JList list;
    private Vector taxonData = null;
    private String displayString = null;
    private String[] taxa = new String[]{"Kingdom", "Phylum", "Class", "Order", "Family", "Genus", "Species"};

    PopupHandler() {
        this.setModal(true);
        this.init();
    }

    private void init() {
        this.fillTaxonData();
        JLabel headLabel = WidgetFactory.makeHTMLLabel("Select the taxon category", 1, false);
        JPanel panel = new JPanel(new BorderLayout());
        this.list = new JList(this.taxonData);
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent lse) {
                PopupHandler.this.displayString = (String)PopupHandler.this.list.getSelectedValue();
                PopupHandler.this.setVisible(false);
            }
        });
        this.list.setBorder(BorderFactory.createMatteBorder(2, 0, 0, 0, WizardSettings.TOP_PANEL_BG_COLOR));
        panel.add((Component)headLabel, "North");
        panel.add((Component)this.list, "Center");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)panel, "Center");
        this.setSize(150, 200);
    }

    private void fillTaxonData() {
        this.taxonData = new Vector();
        for (int i = 0; i < this.taxa.length; ++i) {
            this.taxonData.add(this.taxa[i]);
        }
    }

    public String getDisplayString() {
        return this.displayString;
    }

    public JDialog getPopupDialog() {
        this.displayString = null;
        this.list.setSelectedIndex(-1);
        return this;
    }
}

