/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.datapackage.AccessionNumber;
import edu.ucsb.nceas.morpho.datastore.FileSystemDataStore;
import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WidgetFactory;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardContainerFrame;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.FileChooserWidget;
import edu.ucsb.nceas.morpho.util.Base64;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.OrderedMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class DataLocation
extends AbstractUIPage {
    private final String pageID = "DATA_LOCATION";
    private String nextPageID = "TEXT_IMPORT_WIZARD";
    private final String pageNumber = "1";
    private final String title = "New Data Table Wizard";
    private final String subtitle = "Data Location";
    private final String FILE_LOCATOR_FIELD_FILENAME_LABEL = "File Name:";
    private final String FILE_LOCATOR_FIELD_OBJNAME_LABEL = "Name/Title:";
    private final String INIT_FILE_LOCATOR_TEXT = "   use button to select a file -->";
    private final String FILE_LOCATOR_IMPORT_DESC_INLINE = "<html><table width=\"100%\"><tr><td valign=\"top\" width=\"100%\"><font style=\"font-size: 9px;\" face=\"Sans-Serif\">Use the \"locate\" button to locate the data file on your computer:</font></td></tr></table></html>";
    private final String URN_ROOT = "ecogrid://knb/";
    private final String OBJECTNAME_XPATH = "/eml:eml/dataset/dataTable/physical/objectName";
    private final String MEDIUMNAME_XPATH = "/eml:eml/dataset/dataTable/physical/distribution/offline/mediumName";
    private final String INLINE_XPATH = "/eml:eml/dataset/dataTable/physical/distribution/inline";
    private final String ONLINE_URL_XPATH = "/eml:eml/dataset/dataTable/physical/distribution/online/url";
    private final String FILECHOOSER_PANEL_TITLE = "File Location:";
    private final String Q1_TITLE = "What do you want to do?";
    private final String[] Q1_LABELS = new String[]{"CREATE - Create a new, empty data table.", "IMPORT - Import a data file into the package.", "DESCRIBE - Include only the data file documentation (but not the data file itself) in the package."};
    private static final int CREATE_CHOICE = 0;
    private static final int IMPORT_CHOICE = 1;
    private static final int DESCRIBE_CHOICE = 2;
    private final String Q2_TITLE_IMPORT = "How do you want to enter the documentation for the data?";
    private final String[] Q2_LABELS_IMPORT = new String[]{"AUTOMATIC - Import the data file and extract the documentation for review.", "MANUAL - Import the data file but enter the documentation manually."};
    private final String Q2_TITLE_DESCRIBE = "How do you want to enter the documentation for the data?";
    private final String[] Q2_LABELS_DESCRIBE = new String[]{"AUTOMATIC - Create the documentation by inspecting the data file (but omit the data file from the package).", "MANUAL - Enter the documentation manually."};
    private final String Q3_TITLE = "Data Location?";
    private final String[] Q3_LABELS = new String[]{"Not available", "Online URL", "Archived"};
    private final Dimension Q3_RADIOPANEL_DIMS = new Dimension(120, 300);
    private WizardContainerFrame mainWizFrame;
    private JPanel mainRadioPanel;
    private JPanel q2RadioPanel_import;
    FileChooserWidget fileChooserWidget;
    private JLabel fileNameLabelOnline;
    private JTextField fileNameFieldOnline;
    private JLabel urlLabelOnline;
    private JTextField urlFieldOnline;
    private JLabel objNameLabel;
    private JLabel medNameLabel;
    private JTextField objNameField;
    private JTextField medNameField;
    private OrderedMap returnMap = new OrderedMap();
    private JPanel filechooserPanel;
    private JPanel onlinePanel;
    private JPanel offlinePanel;
    private JPanel blankPanel;
    private JPanel secondChoiceContainer;
    private JPanel currentSecondChoicePanel;
    private JPanel thirdChoiceContainer;
    private JPanel currentThirdChoicePanel;
    private JPanel q3Widget;
    private short INLINE_OR_ONLINE;
    private File dataFileObj;
    private final short CREATE = 0;
    private final short IMPORT = (short)10;
    private final short IMPORT_AUTO = (short)12;
    private final short IMPORT_MAN = (short)14;
    private final short DESCRIBE = (short)20;
    private final short DESCRIBE_AUTO = (short)22;
    private final short DESCRIBE_MAN = (short)24;
    private final short DESCRIBE_MAN_NODATA = (short)30;
    private final short DESCRIBE_MAN_ONLINE = (short)32;
    private final short DESCRIBE_MAN_OFFLINE = (short)34;
    private short lastEvent;
    private short distribution;
    private final String EMPTY_STRING = "";

    public DataLocation(WizardContainerFrame mainWizFrame) {
        this.mainWizFrame = mainWizFrame;
        this.INLINE_OR_ONLINE = (short)10;
        String inOnString = Morpho.getConfiguration().get("dataLocationInlineOnline", 0);
        if (inOnString != null && inOnString.equalsIgnoreCase("inline")) {
            this.INLINE_OR_ONLINE = 0;
        }
        this.init();
        this.setLastEvent((short)0);
    }

    private void init() {
        this.setLayout(new BorderLayout());
        ActionListener q2Listener_import = null;
        ActionListener q2Listener_describe = null;
        Box topBox = Box.createVerticalBox();
        JLabel desc = WidgetFactory.makeHTMLLabel("<p><b>Describe and optionally include a data table in your data package.</b> You may create a table from scratch and populate it using Morpho's spreadsheet-style data editor, or you can import certain types of existing data files and use the wizard to automatically extract much of the documentation from the data file itself. If you choose the second option, you will be prompted to review the information that is extracted and provide any required fields that can not be generated automatically.<br></br></p><p>You can also choose to manually enter all of the required fields (rather than using the metadata extractor), which is useful for proprietary file types like Excel, or other file types that are not yet supported.</p>", 7);
        topBox.add(desc);
        final DataLocation instance = this;
        q2Listener_import = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Log.debug(45, "IMPORT - AUTO/MAN ActionEvent: " + e.getActionCommand());
                DataLocation.this.onLoadAction();
                DataLocation.this.setQ3(DataLocation.this.filechooserPanel);
                DataLocation.this.fileChooserWidget.getTextArea().requestFocus();
                if (e.getActionCommand().equals(DataLocation.this.Q2_LABELS_IMPORT[0])) {
                    Log.debug(45, "IMPORT - AUTOMATIC");
                    DataLocation.this.setLastEvent((short)12);
                } else if (e.getActionCommand().equals(DataLocation.this.Q2_LABELS_IMPORT[1])) {
                    Log.debug(45, "IMPORT - MANUAL");
                    DataLocation.this.setLastEvent((short)14);
                }
                instance.validate();
                instance.repaint();
            }
        };
        q2Listener_describe = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Log.debug(45, "DESCRIBE - AUTO/MAN ActionEvent: " + e.getActionCommand());
                DataLocation.this.onLoadAction();
                if (e.getActionCommand().equals(DataLocation.this.Q2_LABELS_DESCRIBE[0])) {
                    Log.debug(45, "DESCRIBE - AUTOMATIC");
                    DataLocation.this.setQ3(DataLocation.this.filechooserPanel);
                    DataLocation.this.fileChooserWidget.getTextArea().requestFocus();
                    DataLocation.this.setLastEvent((short)22);
                } else if (e.getActionCommand().equals(DataLocation.this.Q2_LABELS_DESCRIBE[1])) {
                    Log.debug(45, "DESCRIBE - MANUAL");
                    DataLocation.this.setQ3(DataLocation.this.q3Widget);
                    DataLocation.this.objNameField.requestFocus();
                    DataLocation.this.setLastEvent((short)30);
                }
                instance.validate();
                instance.repaint();
            }
        };
        this.q2RadioPanel_import = this.getRadioPanel("How do you want to enter the documentation for the data?", this.Q2_LABELS_IMPORT, q2Listener_import, -1, true);
        final JPanel q2RadioPanel_describe = this.getRadioPanel("How do you want to enter the documentation for the data?", this.Q2_LABELS_DESCRIBE, q2Listener_describe, -1, true);
        ActionListener q1Listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Log.debug(45, "got includeOmitRadioPanel command: " + e.getActionCommand());
                DataLocation.this.onLoadAction();
                DataLocation.this.deselectRadioGroup(DataLocation.this.q2RadioPanel_import);
                DataLocation.this.deselectRadioGroup(q2RadioPanel_describe);
                if (e.getActionCommand().equals(DataLocation.this.Q1_LABELS[0])) {
                    DataLocation.this.setQ2(DataLocation.this.blankPanel);
                    DataLocation.this.setQ3(DataLocation.this.blankPanel);
                    DataLocation.this.setLastEvent((short)0);
                } else if (e.getActionCommand().equals(DataLocation.this.Q1_LABELS[1])) {
                    DataLocation.this.setQ2(DataLocation.this.q2RadioPanel_import);
                    DataLocation.this.setQ3(DataLocation.this.blankPanel);
                    DataLocation.this.setLastEvent((short)10);
                } else if (e.getActionCommand().equals(DataLocation.this.Q1_LABELS[2])) {
                    DataLocation.this.setQ2(q2RadioPanel_describe);
                    DataLocation.this.setQ3(DataLocation.this.blankPanel);
                    DataLocation.this.setLastEvent((short)20);
                }
                instance.validate();
                instance.repaint();
            }
        };
        this.mainRadioPanel = this.getRadioPanel("What do you want to do?", this.Q1_LABELS, q1Listener, 0, true);
        topBox.add(this.mainRadioPanel);
        topBox.add(WidgetFactory.makeDefaultSpacer());
        this.secondChoiceContainer = WidgetFactory.makeVerticalPanel(4);
        this.thirdChoiceContainer = WidgetFactory.makeVerticalPanel(6);
        topBox.add(this.secondChoiceContainer);
        this.add((Component)topBox, "North");
        this.q3Widget = new ThirdChoiceWidget();
        this.add((Component)this.thirdChoiceContainer, "Center");
        this.filechooserPanel = this.getFilechooserPanel();
        this.onlinePanel = this.getOnlinePanel();
        this.offlinePanel = this.getOfflinePanel();
        this.currentSecondChoicePanel = this.blankPanel = WidgetFactory.makeVerticalPanel(7);
        this.currentThirdChoicePanel = this.blankPanel;
    }

    private JPanel getFilechooserPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        WidgetFactory.addTitledBorder(panel, "File Location:");
        this.fileChooserWidget = new FileChooserWidget("File Name:", "<html><table width=\"100%\"><tr><td valign=\"top\" width=\"100%\"><font style=\"font-size: 9px;\" face=\"Sans-Serif\">Use the \"locate\" button to locate the data file on your computer:</font></td></tr></table></html>", "   use button to select a file -->");
        panel.add((Component)this.fileChooserWidget, "North");
        return panel;
    }

    private JPanel getOnlinePanel() {
        JPanel panel = WidgetFactory.makeVerticalPanel(7);
        WidgetFactory.addTitledBorder(panel, this.Q3_LABELS[1]);
        panel.add(WidgetFactory.makeDefaultSpacer());
        JPanel fileNamePanel = WidgetFactory.makePanel(1);
        this.fileNameLabelOnline = WidgetFactory.makeLabel("File Name:", true);
        fileNamePanel.add(this.fileNameLabelOnline);
        this.fileNameFieldOnline = WidgetFactory.makeOneLineTextField();
        fileNamePanel.add(this.fileNameFieldOnline);
        panel.add(fileNamePanel);
        panel.add(WidgetFactory.makeDefaultSpacer());
        JPanel urlPanel = WidgetFactory.makePanel(1);
        this.urlLabelOnline = WidgetFactory.makeLabel("URL:", true);
        urlPanel.add(this.urlLabelOnline);
        this.urlFieldOnline = WidgetFactory.makeOneLineTextField();
        urlPanel.add(this.urlFieldOnline);
        panel.add(urlPanel);
        panel.add(WidgetFactory.makeDefaultSpacer());
        panel.add(WidgetFactory.makeDefaultSpacer());
        panel.add(Box.createGlue());
        return panel;
    }

    private JPanel getOfflinePanel() {
        JPanel panel = WidgetFactory.makeVerticalPanel(7);
        WidgetFactory.addTitledBorder(panel, this.Q3_LABELS[2]);
        panel.add(WidgetFactory.makeHTMLLabel("Archived data may be stored on digital media (tapes, disks), or printed media (hardcopy).", 1));
        JPanel objNamePanel = WidgetFactory.makePanel();
        this.objNameLabel = WidgetFactory.makeLabel("Name/Title:", true);
        this.objNameField = WidgetFactory.makeOneLineTextField();
        objNamePanel.add(this.objNameLabel);
        objNamePanel.add(this.objNameField);
        JPanel medNamePanel = WidgetFactory.makePanel();
        this.medNameLabel = WidgetFactory.makeLabel("Medium Type:", true);
        this.medNameField = WidgetFactory.makeOneLineTextField();
        medNamePanel.add(this.medNameLabel);
        medNamePanel.add(this.medNameField);
        panel.add(WidgetFactory.makeHalfSpacer());
        panel.add(WidgetFactory.makeHTMLLabel("Type of medium on which data is distributed. <font style=\"font-size: 9px;\" color=\"#666666\">eg: Tape,&nbsp;3.5 inch Floppy Disk,&nbsp;hardcopy</font>", 1));
        panel.add(medNamePanel);
        panel.add(WidgetFactory.makeHalfSpacer());
        panel.add(WidgetFactory.makeHTMLLabel("Enter an identifying name in the space below&nbsp;<font style=\"font-size: 9px;\" color=\"#666666\"> eg a title for hardcopy, or a filename for digital media</font>", 1));
        panel.add(objNamePanel);
        panel.add(Box.createGlue());
        return panel;
    }

    private void deselectRadioGroup(JPanel radioPanel) {
        Component buttonPanelComp = radioPanel.getComponent(1);
        Container buttonPanel = (Container)buttonPanelComp;
        Component dummyButtonComp = buttonPanel.getComponent(0);
        JRadioButton dummyButton = (JRadioButton)dummyButtonComp;
        dummyButton.setSelected(true);
    }

    private void setLastEvent(short eventFlag) {
        this.lastEvent = eventFlag;
    }

    private short getLastEvent() {
        return this.lastEvent;
    }

    private void setQ2(JPanel newPanel) {
        this.secondChoiceContainer.remove(this.currentSecondChoicePanel);
        this.currentSecondChoicePanel = newPanel;
        this.secondChoiceContainer.add(this.currentSecondChoicePanel);
    }

    private void setQ3(JPanel newPanel) {
        this.thirdChoiceContainer.remove(this.currentThirdChoicePanel);
        this.currentThirdChoicePanel = newPanel;
        this.thirdChoiceContainer.add(this.currentThirdChoicePanel);
    }

    public void onLoadAction() {
        WidgetFactory.unhiliteComponent(this.fileChooserWidget.getLabel());
        WidgetFactory.unhiliteComponent(this.getNestedJComponent(this.currentSecondChoicePanel, 1));
        WidgetFactory.unhiliteComponent(this.fileNameLabelOnline);
        WidgetFactory.unhiliteComponent(this.urlLabelOnline);
        WidgetFactory.unhiliteComponent(this.objNameLabel);
        WidgetFactory.unhiliteComponent(this.medNameLabel);
        String prevPageID = this.mainWizFrame.getPreviousPageID();
        if (prevPageID != null && prevPageID.equals("CODE_IMPORT_PAGE")) {
            Container radioPanel = (Container)this.mainRadioPanel.getComponent(1);
            Container middlePanel = (Container)radioPanel.getComponent(1);
            JRadioButton jrb = (JRadioButton)middlePanel.getComponent(0);
            jrb.setEnabled(false);
            jrb = (JRadioButton)middlePanel.getComponent(2);
            jrb.setEnabled(false);
            jrb = (JRadioButton)middlePanel.getComponent(1);
            jrb.setSelected(true);
            this.setQ2(this.q2RadioPanel_import);
            this.setQ3(this.blankPanel);
            this.setLastEvent((short)10);
        }
    }

    public void onRewindAction() {
    }

    private JComponent getNestedJComponent(JPanel jpanel, int levels) {
        Container container = jpanel;
        Component nextComponent = null;
        for (int i = 0; i < levels - 1 && container.getComponentCount() >= 1; ++i) {
            nextComponent = container.getComponent(0);
            container = (Container)nextComponent;
        }
        if (container.getComponentCount() < 1) {
            return null;
        }
        return (JComponent)container.getComponent(0);
    }

    public boolean onAdvanceAction() {
        File dataFileObj = null;
        switch (this.getLastEvent()) {
            case 0: {
                this.distribution = this.INLINE_OR_ONLINE;
                File emptyDataFile = null;
                try {
                    emptyDataFile = File.createTempFile("~deleteme", null);
                    FileWriter fileWriter = new FileWriter(emptyDataFile);
                    fileWriter.write("");
                }
                catch (IOException ex) {
                    Log.debug(1, "error - cannot create a new empty data file!");
                    ex.printStackTrace();
                    return false;
                }
                this.setDataFile(emptyDataFile);
                this.setNextPageID("DATA_FORMAT");
                break;
            }
            case 10: 
            case 20: {
                WidgetFactory.hiliteComponent(this.getNestedJComponent(this.currentSecondChoicePanel, 1));
                return false;
            }
            case 12: {
                dataFileObj = this.validateDataFileSelection();
                if (dataFileObj == null) {
                    return false;
                }
                this.setDataFile(dataFileObj);
                this.distribution = this.INLINE_OR_ONLINE;
                this.setNextPageID("TEXT_IMPORT_WIZARD");
                break;
            }
            case 14: {
                dataFileObj = this.validateDataFileSelection();
                if (dataFileObj == null) {
                    return false;
                }
                this.setDataFile(dataFileObj);
                this.distribution = this.INLINE_OR_ONLINE;
                this.setNextPageID("DATA_FORMAT");
                break;
            }
            case 22: {
                dataFileObj = this.validateDataFileSelection();
                if (dataFileObj == null) {
                    return false;
                }
                this.setDataFile(dataFileObj);
                this.distribution = (short)20;
                this.setNextPageID("TEXT_IMPORT_WIZARD");
                break;
            }
            case 24: {
                break;
            }
            case 30: {
                this.distribution = (short)30;
                this.setDataFile(null);
                this.setNextPageID("DATA_FORMAT");
                break;
            }
            case 32: {
                if (this.fileNameFieldOnline.getText().trim().equals("")) {
                    WidgetFactory.hiliteComponent(this.fileNameLabelOnline);
                    this.fileNameFieldOnline.requestFocus();
                    return false;
                }
                WidgetFactory.unhiliteComponent(this.fileNameLabelOnline);
                if (this.urlFieldOnline.getText().trim().equals("")) {
                    WidgetFactory.hiliteComponent(this.urlLabelOnline);
                    this.urlFieldOnline.requestFocus();
                    return false;
                }
                WidgetFactory.unhiliteComponent(this.urlLabelOnline);
                this.distribution = (short)10;
                this.setDataFile(null);
                this.setNextPageID("DATA_FORMAT");
                break;
            }
            case 34: {
                if (this.medNameField.getText().trim().equals("")) {
                    WidgetFactory.hiliteComponent(this.medNameLabel);
                    return false;
                }
                WidgetFactory.unhiliteComponent(this.medNameLabel);
                if (this.objNameField.getText().trim().equals("")) {
                    WidgetFactory.hiliteComponent(this.objNameLabel);
                    return false;
                }
                WidgetFactory.unhiliteComponent(this.objNameLabel);
                this.distribution = (short)20;
                this.setDataFile(null);
                this.setNextPageID("DATA_FORMAT");
            }
        }
        return true;
    }

    private void setDataFile(File file) {
        this.dataFileObj = file;
    }

    public File getDataFile() {
        return this.dataFileObj;
    }

    private File validateDataFileSelection() {
        String fileURL = this.fileChooserWidget.getImportFileURL();
        if (fileURL == null) {
            WidgetFactory.hiliteComponent(this.fileChooserWidget.getLabel());
            this.fileChooserWidget.getButton().requestFocus();
            return null;
        }
        WidgetFactory.unhiliteComponent(this.fileChooserWidget.getLabel());
        File fileObj = null;
        try {
            fileObj = new File(fileURL.trim());
        }
        catch (Exception ex) {
            Log.debug(1, "error - cannot read your data file!");
            ex.printStackTrace();
            WidgetFactory.hiliteComponent(this.fileChooserWidget.getLabel());
            this.fileChooserWidget.getButton().requestFocus();
            return null;
        }
        if (!fileObj.exists()) {
            Log.debug(1, "error - your data file appears to have been moved or deleted!");
            WidgetFactory.hiliteComponent(this.fileChooserWidget.getLabel());
            this.fileChooserWidget.getButton().requestFocus();
            return null;
        }
        if (!fileObj.isFile()) {
            Log.debug(1, "error - selected location is a directory, not a file!");
            WidgetFactory.hiliteComponent(this.fileChooserWidget.getLabel());
            this.fileChooserWidget.getButton().requestFocus();
            return null;
        }
        if (!fileObj.canRead()) {
            Log.debug(1, "error - cannot read your data file (permissions problem?)");
            WidgetFactory.hiliteComponent(this.fileChooserWidget.getLabel());
            this.fileChooserWidget.getButton().requestFocus();
            return null;
        }
        return fileObj;
    }

    public OrderedMap getPageData() {
        this.returnMap.clear();
        switch (this.distribution) {
            case 10: {
                if (this.getDataFile() != null) {
                    String dataFileID = this.saveDataFileAsTemp(this.getDataFile());
                    this.returnMap.put((Object)"/eml:eml/dataset/dataTable/physical/distribution/online/url", (Object)("ecogrid://knb/" + dataFileID));
                    break;
                }
                this.returnMap.put((Object)"/eml:eml/dataset/dataTable/physical/objectName", (Object)this.fileNameFieldOnline.getText().trim());
                this.returnMap.put((Object)"/eml:eml/dataset/dataTable/physical/distribution/online/url", (Object)this.urlFieldOnline.getText().trim());
                break;
            }
            case 0: {
                String encoded = this.encodeAsBase64(this.getDataFile());
                this.returnMap.put((Object)"/eml:eml/dataset/dataTable/physical/distribution/inline", (Object)encoded);
                break;
            }
            case 20: {
                this.returnMap.put((Object)"/eml:eml/dataset/dataTable/physical/objectName", (Object)this.objNameField.getText().trim());
                this.returnMap.put((Object)"/eml:eml/dataset/dataTable/physical/distribution/offline/mediumName", (Object)this.medNameField.getText().trim());
                break;
            }
        }
        return this.returnMap;
    }

    public OrderedMap getPageData(String rootXPath) {
        throw new UnsupportedOperationException("getPageData(String rootXPath) Method Not Implemented");
    }

    private String saveDataFileAsTemp(File f) {
        AccessionNumber an = new AccessionNumber(Morpho.thisStaticInstance);
        String id = an.getNextId();
        FileSystemDataStore fds = new FileSystemDataStore(Morpho.thisStaticInstance);
        try {
            fds.saveTempDataFile(id, new FileInputStream(f));
        }
        catch (Exception w) {
            Log.debug(1, "error in TIW saving temp data file!");
        }
        return id;
    }

    private String encodeAsBase64(File f) {
        byte[] b = null;
        long len = f.length();
        if (len > 200000L) {
            Log.debug(1, "Data file is too long to be put 'inline'!");
            return null;
        }
        try {
            FileReader fsr = new FileReader(f);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int chr = 0;
            while ((chr = fsr.read()) != -1) {
                baos.write(chr);
            }
            fsr.close();
            baos.close();
            b = baos.toByteArray();
        }
        catch (Exception e) {
            Log.debug(1, "Problem encoding data as Base64!");
        }
        String enc = Base64.encode(b);
        return enc;
    }

    private void setNextPageID(String id) {
        this.nextPageID = id;
    }

    public String getPageID() {
        return "DATA_LOCATION";
    }

    public String getTitle() {
        return "New Data Table Wizard";
    }

    public String getSubtitle() {
        return "Data Location";
    }

    public String getNextPageID() {
        return this.nextPageID;
    }

    public String getPageNumber() {
        return "1";
    }

    public boolean setPageData(OrderedMap data, String xPathRoot) {
        return false;
    }

    private JPanel getRadioPanel(String title, String[] buttonLabels, ActionListener listener, int selected, boolean hiliteReqd) {
        JPanel panel = WidgetFactory.makeVerticalPanel(buttonLabels.length + 1);
        panel.add(WidgetFactory.makeHTMLLabel(title, 1, hiliteReqd));
        panel.add(WidgetFactory.makeRadioPanel(buttonLabels, selected, listener));
        return panel;
    }

    protected boolean isCreateChoice() {
        Container radioPanel = (Container)this.mainRadioPanel.getComponent(1);
        Container middlePanel = (Container)radioPanel.getComponent(1);
        JRadioButton jrb = (JRadioButton)middlePanel.getComponent(0);
        return jrb.isSelected();
    }

    protected String getFileName() {
        String ret = "";
        File file = this.getDataFile();
        if (file != null) {
            ret = file.getName();
        }
        return ret;
    }

    class ThirdChoiceWidget
    extends JPanel {
        private JPanel q3RadioPanel;
        private JPanel blankChoicePanel;
        private JPanel currentChoicePanel;

        public ThirdChoiceWidget() {
            this.init();
        }

        private void init() {
            this.setLayout(new BorderLayout());
            this.blankChoicePanel = WidgetFactory.makePanel(5);
            final ThirdChoiceWidget instance = this;
            ActionListener q3Listener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Log.debug(45, "QUESTION 3 - NOT AVAILABLE/ONLINE/ARCHIVED: " + e.getActionCommand());
                    if (e.getActionCommand().equals(DataLocation.this.Q3_LABELS[0])) {
                        Log.debug(45, "NOT AVAILABLE");
                        ThirdChoiceWidget.this.setChoicePanel(ThirdChoiceWidget.this.blankChoicePanel);
                        DataLocation.this.setLastEvent((short)30);
                    } else if (e.getActionCommand().equals(DataLocation.this.Q3_LABELS[1])) {
                        Log.debug(45, "ONLINE");
                        ThirdChoiceWidget.this.setChoicePanel(DataLocation.this.onlinePanel);
                        DataLocation.this.fileNameFieldOnline.requestFocus();
                        DataLocation.this.setLastEvent((short)32);
                    } else if (e.getActionCommand().equals(DataLocation.this.Q3_LABELS[2])) {
                        Log.debug(45, "ARCHIVED");
                        ThirdChoiceWidget.this.setChoicePanel(DataLocation.this.offlinePanel);
                        DataLocation.this.objNameField.requestFocus();
                        DataLocation.this.setLastEvent((short)34);
                    }
                    instance.validate();
                    instance.repaint();
                }
            };
            JPanel q3RadioPanel = new JPanel();
            q3RadioPanel.setLayout(new BoxLayout(q3RadioPanel, 1));
            q3RadioPanel.setPreferredSize(DataLocation.this.Q3_RADIOPANEL_DIMS);
            q3RadioPanel.setMaximumSize(DataLocation.this.Q3_RADIOPANEL_DIMS);
            q3RadioPanel.add(WidgetFactory.makeLabel("Data Location?", true));
            q3RadioPanel.add(WidgetFactory.makeRadioPanel(DataLocation.this.Q3_LABELS, 0, q3Listener));
            q3RadioPanel.add(Box.createGlue());
            this.currentChoicePanel = this.blankChoicePanel;
            this.add((Component)q3RadioPanel, "West");
            this.add((Component)this.currentChoicePanel, "Center");
        }

        private void setChoicePanel(JPanel panel) {
            this.remove(1);
            this.currentChoicePanel = panel;
            this.add((Component)this.currentChoicePanel, "Center");
        }
    }
}

