/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.framework;

import edu.ucsb.nceas.morpho.Morpho;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class SplashFrame
extends JFrame {
    private boolean frameSizeAdjusted = false;
    private static String[] coders = new String[]{"Matt Jones", "Dan Higgins", "Chad Berkley", "Jivka Bojilova", "Chris Jones", "Mark Schildhauer", "Eric Fegraus", "Matthew Brooke", "Jing Tao", "Christy Bowles", "Saurabh Garg", "Perumal Sambasivam", "Andrea Chadden", "Rick Reeves", "Sandy Andelman", "P. Mark Anderson", "Callie Bowdish", "Veronique Connolly", "Will Tyburczy"};
    private static String[] orgs = new String[]{"National Center for Ecological Analysis and Synthesis", "Long Term Ecological Research Network Office", "San Diego Supercomputer Center", "Texas Tech University"};
    private static String credit = "This material is based upon work supported\nby the National Science Foundation under Grant\nNo. DEB99-80154, DBI99-04777, and DBI01-31178. Also\nsupported by the National Center for Ecological\nAnalysis and Synthesis, a Center funded by\nNSF (Grant No. DEB-94-21535), the University of\nCalifornia - Santa Barbara, and the State of\nCalifornia. Any opinions, findings and conclusions\nor recommendations expressed in this material are\nthose of the author(s) and do not necessarily\nreflect the views of the National Science Foundation\n(NSF).\n\nThis software is named after the Morpho\nbutterfly which is common in South America. The\napparent color of this butterfly is highly dependent\non the angle of viewing, with the most common color\nbeing blue.";
    JLabel loadingLabel = new JLabel();
    JLabel titleLabel = new JLabel();
    JLabel subTitleLabel = new JLabel();
    JLabel versionLabel = new JLabel();
    JButton closeButton = new JButton();
    JButton fundingButton = new JButton();
    ImageIcon BFlyIcon = new ImageIcon();

    public SplashFrame(String sTitle, boolean showLoading) {
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().setBackground(Color.white);
        this.setVisible(false);
        this.getContentPane().add(Box.createVerticalStrut(8));
        this.loadingLabel.setHorizontalAlignment(0);
        this.loadingLabel.setText("Morpho is loading...");
        this.loadingLabel.setForeground(Color.red);
        this.loadingLabel.setFont(new Font("Dialog", 1, 14));
        this.loadingLabel.setVisible(false);
        this.getContentPane().add(this.loadingLabel);
        Box titleBox = Box.createHorizontalBox();
        titleBox.setBackground(Color.white);
        titleBox.add(Box.createHorizontalStrut(8));
        titleBox.add(Box.createHorizontalGlue());
        this.BFlyIcon = new ImageIcon(this.getClass().getResource("morpho-splash.gif"));
        JLabel imageLabel = new JLabel();
        imageLabel.setIcon(this.BFlyIcon);
        titleBox.add(imageLabel);
        titleBox.add(Box.createHorizontalStrut(8));
        Box subTitleBox = Box.createVerticalBox();
        subTitleBox.setBackground(Color.white);
        subTitleBox.add(Box.createVerticalStrut(8));
        subTitleBox.add(Box.createVerticalGlue());
        this.titleLabel.setHorizontalAlignment(2);
        this.titleLabel.setText("Morpho");
        this.titleLabel.setForeground(Color.blue);
        this.titleLabel.setFont(new Font("Dialog", 3, 36));
        subTitleBox.add(this.titleLabel);
        subTitleBox.add(Box.createVerticalStrut(4));
        this.subTitleLabel.setHorizontalAlignment(0);
        this.subTitleLabel.setText("Data Management for Ecologists");
        this.subTitleLabel.setForeground(Color.black);
        this.subTitleLabel.setFont(new Font("Dialog", 1, 14));
        subTitleBox.add(this.subTitleLabel);
        subTitleBox.add(Box.createVerticalGlue());
        subTitleBox.add(Box.createVerticalStrut(8));
        titleBox.add(subTitleBox);
        titleBox.add(Box.createHorizontalGlue());
        titleBox.add(Box.createHorizontalStrut(8));
        this.getContentPane().add(titleBox);
        this.getContentPane().add(Box.createVerticalStrut(8));
        JPanel contribPanel = new JPanel();
        contribPanel.setLayout(new BoxLayout(contribPanel, 1));
        contribPanel.setAlignmentY(0.0f);
        contribPanel.setBackground(Color.white);
        JLabel contributorsLabel = new JLabel("Contributors:");
        contributorsLabel.setForeground(Color.black);
        contributorsLabel.setFont(new Font("Dialog", 1, 12));
        contribPanel.add(contributorsLabel);
        for (int i = 0; i < coders.length; ++i) {
            JLabel coderLabel = new JLabel();
            coderLabel.setBackground(Color.white);
            coderLabel.setForeground(Color.black);
            coderLabel.setFont(new Font("Dialog", 0, 12));
            coderLabel.setText("    " + coders[i]);
            contribPanel.add(coderLabel);
        }
        JPanel orgPanel = new JPanel();
        orgPanel.setLayout(new BoxLayout(orgPanel, 1));
        orgPanel.setAlignmentY(0.0f);
        orgPanel.setBackground(Color.white);
        JLabel orgLabel = new JLabel("Sponsoring Organizations:");
        orgLabel.setForeground(Color.black);
        orgLabel.setFont(new Font("Dialog", 1, 12));
        orgPanel.add(orgLabel);
        for (int i = 0; i < orgs.length; ++i) {
            JLabel instLabel = new JLabel();
            instLabel.setBackground(Color.white);
            instLabel.setForeground(Color.black);
            instLabel.setFont(new Font("Dialog", 0, 12));
            instLabel.setText("    " + orgs[i]);
            orgPanel.add(instLabel);
        }
        Box creditsBox = Box.createHorizontalBox();
        creditsBox.setBackground(Color.white);
        creditsBox.add(Box.createHorizontalStrut(8));
        creditsBox.add(contribPanel);
        creditsBox.add(Box.createHorizontalStrut(8));
        creditsBox.add(Box.createHorizontalGlue());
        creditsBox.add(orgPanel);
        creditsBox.add(Box.createHorizontalStrut(8));
        this.getContentPane().add(creditsBox);
        this.getContentPane().add(Box.createVerticalStrut(8));
        this.getContentPane().add(Box.createVerticalGlue());
        this.versionLabel.setHorizontalAlignment(2);
        this.versionLabel.setText(Morpho.VERSION);
        this.versionLabel.setBackground(Color.white);
        this.versionLabel.setForeground(Color.black);
        this.versionLabel.setFont(new Font("Dialog", 1, 12));
        this.fundingButton.setText("Credits...");
        this.fundingButton.setActionCommand("Credits...");
        this.closeButton.setText("Close");
        this.closeButton.setActionCommand("Close");
        Box footerBox = Box.createHorizontalBox();
        footerBox.setBackground(Color.white);
        footerBox.add(Box.createHorizontalStrut(8));
        footerBox.add(this.versionLabel);
        footerBox.add(Box.createHorizontalGlue());
        footerBox.add(this.fundingButton);
        footerBox.add(Box.createHorizontalStrut(8));
        footerBox.add(this.closeButton);
        footerBox.add(Box.createHorizontalStrut(8));
        this.getContentPane().add(footerBox);
        this.getContentPane().add(Box.createVerticalStrut(8));
        this.setTitle(sTitle);
        if (showLoading) {
            this.loadingLabel.setVisible(showLoading);
            this.closeButton.setEnabled(false);
        }
        this.pack();
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle frameDim = this.getBounds();
        this.setLocation((screenDim.width - frameDim.width) / 2, (screenDim.height - frameDim.height) / 2);
        SymAction lSymAction = new SymAction();
        this.closeButton.addActionListener(lSymAction);
        this.fundingButton.addActionListener(lSymAction);
        ClickListener mouseClicks = new ClickListener();
        this.addMouseListener(mouseClicks);
    }

    public SplashFrame() {
        this("Morpho", false);
    }

    public SplashFrame(String sTitle) {
        this(sTitle, false);
    }

    public SplashFrame(boolean showLoading) {
        this("Morpho", showLoading);
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
    }

    public static void main(String[] args) {
        new SplashFrame().setVisible(true);
    }

    public void addNotify() {
        Dimension size = this.getSize();
        super.addNotify();
        if (this.frameSizeAdjusted) {
            return;
        }
        this.frameSizeAdjusted = true;
        Insets insets = this.getInsets();
        JMenuBar menuBar = this.getRootPane().getJMenuBar();
        int menuBarHeight = 0;
        if (menuBar != null) {
            menuBarHeight = menuBar.getPreferredSize().height;
        }
        this.setSize(insets.left + insets.right + size.width, insets.top + insets.bottom + size.height + menuBarHeight);
    }

    void closeButton_actionPerformed(ActionEvent event) {
        this.dispose();
    }

    void fundingButton_actionPerformed(ActionEvent event) {
        JOptionPane.showMessageDialog(null, credit);
    }

    private class ClickListener
    extends MouseAdapter {
        private ClickListener() {
        }

        public void mouseClicked(MouseEvent e) {
            SplashFrame.this.closeButton_actionPerformed(null);
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == SplashFrame.this.closeButton) {
                SplashFrame.this.closeButton_actionPerformed(event);
            } else if (object == SplashFrame.this.fundingButton) {
                SplashFrame.this.fundingButton_actionPerformed(event);
            }
        }
    }
}

