/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.framework;

import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.datapackage.DataViewContainerPanel;
import edu.ucsb.nceas.morpho.datapackage.SavePackageCommand;
import edu.ucsb.nceas.morpho.framework.ProgressIndicator;
import edu.ucsb.nceas.morpho.framework.SaveCommandInterface;
import edu.ucsb.nceas.morpho.framework.StatusBar;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.GUIAction;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.morpho.util.UISettings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class MorphoFrame
extends JFrame {
    Component gp;
    private JMenuBar menuBar;
    private TreeMap menuList;
    private TreeMap menuActions;
    private TreeMap toolbarActions;
    private JToolBar morphoToolbar;
    private StatusBar statusBar;
    private ProgressIndicator indicator;
    private Component contentComponent;
    private Dimension contentAreaSize;
    private Dimension jToolBarDims;
    private int toolbarHeight;
    private final MorphoFrame instance;
    private static int menuBarHeight = 0;
    private boolean busyFlag = false;
    public static final String SEARCHRESULTFRAME = "searchResultFrame";
    public static final String DATAPACKAGEFRAME = "dataPackageFrame";

    private MorphoFrame() {
        super("Morpho - Data Management for Ecologists");
        this.setVisible(false);
        this.setDefaultCloseOperation(0);
        this.setIconImage(UISettings.FRAME_AND_TASKBAR_ICON);
        JLayeredPane layeredPane = this.getLayeredPane();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout(0, 0));
        this.gp = new CustomGlassPane();
        this.setGlassPane(this.gp);
        this.gp.setVisible(false);
        ImageIcon bfly = null;
        ImageIcon flapping = null;
        try {
            bfly = new ImageIcon(this.getClass().getResource("Btfly.gif"));
            flapping = new ImageIcon(this.getClass().getResource("Btfly4.gif"));
        }
        catch (Exception w) {
            Log.debug(9, "Error in loading images");
        }
        this.indicator = new ProgressIndicator(bfly, flapping);
        layeredPane.add((Component)this.indicator, JLayeredPane.DEFAULT_LAYER);
        this.menuList = new TreeMap();
        this.menuActions = new TreeMap();
        this.menuBar = new JMenuBar();
        this.setMenuBar(this.menuBar);
        this.toolbarActions = new TreeMap();
        int indicatorHeight = (int)this.indicator.getSize().getHeight();
        int menuHeight = this.getMenuHeight();
        this.toolbarHeight = indicatorHeight - menuHeight;
        Log.debug(50, "(indicator, menu, tool) = (" + indicatorHeight + "," + menuHeight + "," + this.toolbarHeight + ")");
        this.morphoToolbar = new JToolBar();
        this.morphoToolbar.setFloatable(false);
        this.morphoToolbar.setPreferredSize(new Dimension(1, this.toolbarHeight));
        this.getContentPane().add("North", this.morphoToolbar);
        this.statusBar = new StatusBar();
        this.getContentPane().add("South", this.statusBar);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                Log.debug(50, "Processing window activated event");
                MorphoFrame.this.gp.setVisible(false);
                UIController controller = UIController.getInstance();
                controller.setCurrentActiveWindow(MorphoFrame.this.instance);
                controller.refreshWindows();
                MorphoFrame.this.indicator.repaint();
            }

            public void windowClosing(WindowEvent event) {
                Object object = event.getSource();
                if (object == MorphoFrame.this) {
                    MorphoFrame.this.close();
                }
            }

            public void windowDeactivated(WindowEvent event) {
                Object object = event.getSource();
                if (object == MorphoFrame.this) {
                    MorphoFrame.this.gp.setVisible(true);
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                MorphoFrame.this.updateProgressIndicatorLocation();
            }
        });
        this.pack();
        this.instance = this;
    }

    public static MorphoFrame getHiddenInstance() {
        MorphoFrame window = new MorphoFrame();
        window.setVisible(false);
        window.calculateDefaultSizes();
        window.addDefaultContentArea();
        return window;
    }

    public static MorphoFrame getInstance() {
        MorphoFrame window = new MorphoFrame();
        window.calculateDefaultSizes();
        window.addDefaultContentArea();
        return window;
    }

    public void setMainContentPane(Component comp) {
        if (comp != null) {
            Container contentPane = this.getContentPane();
            if (this.contentComponent != null) {
                contentPane.remove(this.contentComponent);
            }
            this.contentComponent = comp;
            contentPane.add("Center", comp);
            this.pack();
        } else {
            Log.debug(5, "Component was null so I could not set it!");
        }
    }

    public Component getContentComponent() {
        return this.contentComponent;
    }

    public DataViewContainerPanel getDataViewContainerPanel() {
        Component comp = this.getContentComponent();
        if (comp != null && comp instanceof DataViewContainerPanel) {
            return (DataViewContainerPanel)comp;
        }
        return null;
    }

    public AbstractDataPackage getAbstractDataPackage() {
        DataViewContainerPanel dataViewContainerPanel = this.getDataViewContainerPanel();
        if (dataViewContainerPanel == null) {
            Log.debug(20, "MorphoFrame.getAbstractDataPackage() - dataViewContainerPanel==null, returning NULL");
            return null;
        }
        return dataViewContainerPanel.getAbstractDataPackage();
    }

    public void setMenuBar(JMenuBar newMenuBar) {
        this.setJMenuBar(newMenuBar);
        this.getLayeredPane().invalidate();
    }

    public JToolBar getJToolBar() {
        return this.morphoToolbar;
    }

    public void addGuiAction(GUIAction action) {
        String menuName = action.getMenuName();
        int menuPosition = action.getMenuPosition();
        JMenu currentMenu = null;
        Integer currentPosition2 = null;
        boolean menuExists = false;
        for (Integer currentPosition2 : this.menuList.keySet()) {
            String currentMenuName;
            currentMenu = (JMenu)this.menuList.get(currentPosition2);
            if (currentMenu == null || !(currentMenuName = currentMenu.getText()).equals(menuName)) continue;
            menuExists = true;
            break;
        }
        if (!menuExists) {
            currentMenu = new JMenu(menuName);
            this.menuList.put(new Integer(menuPosition), currentMenu);
            TreeMap actionList = new TreeMap();
            this.menuActions.put(menuName, actionList);
            JMenuBar newBar = new JMenuBar();
            for (Integer position : this.menuList.keySet()) {
                JMenu menu = (JMenu)this.menuList.get(position);
                newBar.add(menu);
            }
            this.setMenuBar(newBar);
        }
        int menuPos = action.getMenuItemPosition();
        Integer menuPosInteger = new Integer(menuPos);
        TreeMap actionList = (TreeMap)this.menuActions.get(menuName);
        Vector actionVector = null;
        if (actionList.containsKey(menuPosInteger)) {
            actionVector = (Vector)actionList.get(menuPosInteger);
        } else {
            actionVector = new Vector();
            actionList.put(menuPosInteger, actionVector);
        }
        actionVector.add(action);
        this.rebuildMenu(currentMenu, actionList);
        int toolbarPosition = action.getToolbarPosition();
        if (toolbarPosition >= 0) {
            Integer position = new Integer(toolbarPosition);
            Vector toolbarActionVector = null;
            if (this.toolbarActions.containsKey(position)) {
                toolbarActionVector = (Vector)this.toolbarActions.get(position);
            } else {
                toolbarActionVector = new Vector();
                this.toolbarActions.put(position, toolbarActionVector);
            }
            toolbarActionVector.add(action);
            this.rebuildToolbar();
        }
    }

    public void removeGuiAction(GUIAction action) {
        for (JMenu currentMenu : this.menuList.values()) {
            String currentMenuName = currentMenu.getText();
            TreeMap actionList = (TreeMap)this.menuActions.get(currentMenuName);
            for (Vector actionVector : actionList.values()) {
                if (!actionVector.contains(action)) continue;
                actionVector.remove(action);
                this.rebuildMenu(currentMenu, actionList);
            }
        }
        for (Vector actionVector : this.toolbarActions.values()) {
            if (!actionVector.contains(action)) continue;
            actionVector.remove(action);
            this.rebuildToolbar();
        }
    }

    public GUIAction lookupGuiActionByCommand(Class commandClass) {
        for (JMenu currentMenu : this.menuList.values()) {
            String currentMenuName = currentMenu.getText();
            TreeMap actionList = (TreeMap)this.menuActions.get(currentMenuName);
            for (Vector actionVector : actionList.values()) {
                for (int i = 0; i < actionVector.size(); ++i) {
                    GUIAction action = (GUIAction)actionVector.get(i);
                    if (!commandClass.isInstance(action.getCommand())) continue;
                    return action;
                }
            }
        }
        for (Vector actionVector : this.toolbarActions.values()) {
            for (int i = 0; i < actionVector.size(); ++i) {
                GUIAction action = (GUIAction)actionVector.get(i);
                if (!commandClass.isInstance(action.getCommand())) continue;
                return action;
            }
        }
        return null;
    }

    public void setBusy(boolean isBusy) {
        if (this.busyFlag ^ isBusy) {
            this.indicator.setBusyFlag(isBusy);
            SwingUtilities.invokeLater(this.indicator);
            this.busyFlag = isBusy;
        }
    }

    public void setMessage(String message) {
        this.statusBar.setMessage(message);
    }

    public Dimension getDefaultContentAreaSize() {
        return this.contentAreaSize;
    }

    public Dimension getJToolBarDims() {
        this.calculateDefaultSizes();
        return this.jToolBarDims;
    }

    protected StatusBar getStatusBar() {
        return this.statusBar;
    }

    private void rebuildMenu(JMenu currentMenu, TreeMap actionList) {
        currentMenu.removeAll();
        for (Integer position : actionList.keySet()) {
            Vector actionVector = (Vector)actionList.get(position);
            for (int i = 0; i < actionVector.size(); ++i) {
                GUIAction action = (GUIAction)actionVector.elementAt(i);
                String hasDefaultSep = action.getSeparatorPosition();
                if (hasDefaultSep != null && hasDefaultSep.equals("separator_preceding")) {
                    currentMenu.addSeparator();
                }
                JMenuItem currentItem = currentMenu.add(action);
                currentItem.setAccelerator((KeyStroke)action.getValue("AcceleratorKey"));
                if (hasDefaultSep == null || !hasDefaultSep.equals("separator_following")) continue;
                currentMenu.addSeparator();
            }
        }
    }

    private void rebuildToolbar() {
        this.morphoToolbar.removeAll();
        for (Integer position : this.toolbarActions.keySet()) {
            Vector actionVector = (Vector)this.toolbarActions.get(position);
            for (int i = 0; i < actionVector.size(); ++i) {
                GUIAction action = (GUIAction)actionVector.elementAt(i);
                JButton toolButton = this.morphoToolbar.add(action);
                String toolTip = action.getToolTipText();
                if (toolTip == null) continue;
                toolButton.setToolTipText(toolTip);
            }
        }
    }

    private void updateProgressIndicatorLocation() {
        Log.debug(50, "Resized Window");
        Dimension indicatorSize = this.indicator.getSize();
        Dimension cpSize = this.getContentPane().getSize();
        this.indicator.setLocation((int)(cpSize.getWidth() - indicatorSize.getWidth()), 0);
    }

    public void close() {
        Component contentsPanel = this.getContentComponent();
        if (contentsPanel instanceof DataViewContainerPanel) {
            int res;
            DataViewContainerPanel dvcp = (DataViewContainerPanel)contentsPanel;
            dvcp.saveDataChanges();
            String loc = dvcp.getPackageLocation();
            if (loc.equals("") && (res = JOptionPane.showConfirmDialog(null, "Would you like to save the current package?", "Save ?", 0)) == 0) {
                GUIAction saveAction = this.lookupGuiActionByCommand(SaveCommandInterface.class);
                Command spc = null;
                spc = saveAction != null ? saveAction.getCommand() : new SavePackageCommand(dvcp.getAbstractDataPackage(), false);
                spc.execute(null);
                return;
            }
        }
        this.setVisible(false);
        UIController controller = UIController.getInstance();
        controller.removeWindow(this);
        this.dispose();
        Component comp = this.getContentComponent();
        comp = null;
        System.gc();
    }

    public boolean isDirty() {
        Component contentsPanel = this.getContentComponent();
        if (contentsPanel instanceof DataViewContainerPanel) {
            DataViewContainerPanel dvcp = (DataViewContainerPanel)contentsPanel;
            dvcp.saveDataChanges();
            String loc = dvcp.getPackageLocation();
            if (loc.equals("")) {
                return true;
            }
        }
        return false;
    }

    private void calculateDefaultSizes() {
        Log.debug(50, "Screen size (w,h): (" + UISettings.CLIENT_SCREEN_WIDTH + ", " + UISettings.CLIENT_SCREEN_HEIGHT + ")");
        double windowWidth = UISettings.DEFAULT_WINDOW_WIDTH;
        double windowHeight = UISettings.DEFAULT_WINDOW_HEIGHT;
        Insets insets = this.getInsets();
        Log.debug(50, "Insets (t, b, l, r): (" + insets.top + ", " + insets.bottom + ", " + insets.left + ", " + insets.right + ")");
        double indicatorHeight = this.indicator.getSize().getHeight();
        double statusHeight = this.statusBar.getSize().getHeight();
        double contentWidth = windowWidth - (double)insets.left - (double)insets.right;
        double contentHeight = windowHeight - (double)insets.top - (double)insets.bottom - indicatorHeight - statusHeight;
        this.contentAreaSize = new Dimension((int)contentWidth, (int)contentHeight);
        this.jToolBarDims = new Dimension(this.getBounds().width - insets.left - insets.right - this.indicator.getSize().width, this.morphoToolbar.getBounds().height);
        Log.debug(50, "Content size (w, h): (" + this.contentAreaSize.getWidth() + ", " + this.contentAreaSize.getHeight() + ")");
    }

    private void addDefaultContentArea() {
        JPanel content = new JPanel();
        content.setLayout(new BoxLayout(content, 0));
        Component hstrut = Box.createHorizontalStrut((int)this.contentAreaSize.getWidth());
        Component vstrut = Box.createVerticalStrut((int)this.contentAreaSize.getHeight());
        content.add(hstrut);
        content.add(vstrut);
        content.setBackground(Color.darkGray);
        this.setMainContentPane(content);
    }

    private int getMenuHeight() {
        if (menuBarHeight <= 0) {
            JMenuBar testBar = new JMenuBar();
            JMenu testMenu = new JMenu("Test");
            testBar.add(testMenu);
            menuBarHeight = (int)testBar.getPreferredSize().getHeight();
        }
        return menuBarHeight;
    }

    class CustomGlassPane
    extends JPanel {
        public CustomGlassPane() {
            this.setOpaque(false);
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    Log.debug(11, "mousePressed");
                }
            });
        }
    }
}

