/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datapackage;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.datapackage.AccessionNumber;
import edu.ucsb.nceas.morpho.datapackage.DataPackage;
import edu.ucsb.nceas.morpho.datapackage.PackageUtil;
import edu.ucsb.nceas.morpho.datapackage.Triple;
import edu.ucsb.nceas.morpho.datapackage.TripleCollection;
import edu.ucsb.nceas.morpho.datastore.FileSystemDataStore;
import edu.ucsb.nceas.morpho.datastore.MetacatDataStore;
import edu.ucsb.nceas.morpho.datastore.MetacatUploadException;
import edu.ucsb.nceas.morpho.framework.ConfigXML;
import edu.ucsb.nceas.morpho.framework.DataPackageInterface;
import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceNotHandledException;
import edu.ucsb.nceas.morpho.plugins.ServiceProvider;
import edu.ucsb.nceas.morpho.util.Log;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.StringReader;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class NewDataFile
extends JDialog {
    private DataPackage dataPackage = null;
    ConfigXML config;
    Morpho morpho = null;
    File addedFile = null;
    String entityId;
    Frame parent;
    boolean frameSizeAdjusted = false;
    JPanel ControlsPanel = new JPanel();
    JButton AddFileButton = new JButton();
    JButton CancelAddButton = new JButton();
    JLabel HelpLabel = new JLabel();
    JPanel CenterPanel = new JPanel();
    JPanel JPanel1 = new JPanel();
    JPanel JPanel2 = new JPanel();
    JPanel JPanel3 = new JPanel();
    JTextField FileNameTextField = new JTextField();
    JButton FileDialogButton = new JButton();
    JPanel JPanel4 = new JPanel();

    public NewDataFile(Frame parent) {
        super(parent);
        this.parent = parent;
        this.setTitle("Add Data File");
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.setSize(400, 225);
        this.setVisible(false);
        this.ControlsPanel.setLayout(new FlowLayout(1, 5, 5));
        this.getContentPane().add("South", this.ControlsPanel);
        this.AddFileButton.setText("Add File");
        this.AddFileButton.setActionCommand("Add File");
        this.ControlsPanel.add(this.AddFileButton);
        this.CancelAddButton.setText("Cancel");
        this.CancelAddButton.setActionCommand("Cancel");
        this.ControlsPanel.add(this.CancelAddButton);
        this.HelpLabel.setHorizontalTextPosition(0);
        this.HelpLabel.setHorizontalAlignment(0);
        this.HelpLabel.setForeground(Color.black);
        this.HelpLabel.setText("<html><p><br>Select Data File to be Associated with this Metadata</html>");
        this.getContentPane().add("North", this.HelpLabel);
        this.CenterPanel.setLayout(new GridLayout(4, 1, 0, 0));
        this.getContentPane().add("Center", this.CenterPanel);
        this.JPanel1.setLayout(new FlowLayout(1, 5, 5));
        this.CenterPanel.add(this.JPanel1);
        this.JPanel2.setLayout(new FlowLayout(1, 5, 5));
        this.CenterPanel.add(this.JPanel2);
        this.JPanel3.setLayout(new FlowLayout(1, 5, 5));
        this.CenterPanel.add(this.JPanel3);
        this.FileNameTextField.setColumns(20);
        this.JPanel3.add(this.FileNameTextField);
        this.FileDialogButton.setText("Browse...");
        this.FileDialogButton.setActionCommand("jbutton");
        this.JPanel3.add(this.FileDialogButton);
        this.JPanel4.setLayout(new FlowLayout(1, 5, 5));
        this.CenterPanel.add(this.JPanel4);
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle frameDim = this.getBounds();
        this.setLocation((screenDim.width - frameDim.width) / 2, (screenDim.height - frameDim.height) / 2);
        SymAction lSymAction = new SymAction();
        this.FileDialogButton.addActionListener(lSymAction);
        this.CancelAddButton.addActionListener(lSymAction);
        this.AddFileButton.addActionListener(lSymAction);
    }

    public NewDataFile() {
        this((Frame)null);
    }

    public NewDataFile(String sTitle) {
        this();
        this.setTitle(sTitle);
    }

    public NewDataFile(Frame parent, DataPackage dp, Morpho morpho, String entityId) {
        this(parent);
        this.dataPackage = dp;
        this.morpho = morpho;
        this.config = morpho.getConfiguration();
        this.entityId = entityId;
    }

    public static void main(String[] args) {
        new NewDataFile().setVisible(true);
    }

    public void addNotify() {
        Dimension size = this.getSize();
        super.addNotify();
        if (this.frameSizeAdjusted) {
            return;
        }
        this.frameSizeAdjusted = true;
        Insets insets = this.getInsets();
        this.setSize(insets.left + insets.right + size.width, insets.top + insets.bottom + size.height);
    }

    void FileDialogButton_actionPerformed(ActionEvent event) {
        JFileChooser filechooser = new JFileChooser();
        filechooser.showOpenDialog(this);
        File datafile = filechooser.getSelectedFile();
        this.FileNameTextField.setText(datafile.getAbsolutePath());
    }

    void CancelAddButton_actionPerformed(ActionEvent event) {
        this.hide();
        this.dispose();
    }

    void AddFileButton_actionPerformed(ActionEvent event) {
        String fileName = this.FileNameTextField.getText();
        if (fileName.length() > 0) {
            this.addedFile = new File(fileName);
            if (!this.addedFile.exists()) {
                this.addedFile = null;
                JOptionPane.showConfirmDialog(this, "The file you selected was not found.", "File Not Found", 2, 2);
                return;
            }
            this.doAddFile(this.addedFile);
        }
    }

    public void doAddFile(File addedFile) {
        String dataPackageId = null;
        AccessionNumber a = new AccessionNumber(this.morpho);
        String newid = "";
        String location = this.dataPackage.getLocation();
        boolean locMetacat = false;
        boolean locLocal = false;
        FileSystemDataStore fsds = new FileSystemDataStore(this.morpho);
        File packageFile = this.dataPackage.getTriplesFile();
        if (location.equals("local") || location.equals("localmetacat")) {
            locLocal = true;
        }
        if (location.equals("metacat") || location.equals("localmetacat")) {
            locMetacat = true;
        }
        if (addedFile != null) {
            newid = a.getNextId();
            dataPackageId = this.handleAddDataFile(locLocal, locMetacat, newid);
        }
        this.hide();
        this.dispose();
        if (dataPackageId != null) {
            DataPackage newpackage;
            this.dataPackage = newpackage = new DataPackage(this.dataPackage.getLocation(), dataPackageId, null, this.morpho, true);
            MorphoFrame thisFrame = UIController.getInstance().getCurrentActiveWindow();
            try {
                ServiceController services = ServiceController.getInstance();
                ServiceProvider provider = services.getServiceProvider(DataPackageInterface.class);
                DataPackageInterface dataPackage = (DataPackageInterface)((Object)provider);
                dataPackage.openDataPackage(location, newpackage.getID(), null, null, null);
            }
            catch (ServiceNotHandledException snhe) {
                Log.debug(6, snhe.getMessage());
            }
            thisFrame.setVisible(false);
            UIController controller = UIController.getInstance();
            controller.removeWindow(thisFrame);
            thisFrame.dispose();
        }
    }

    private String handleAddDataFile(boolean locLocal, boolean locMetacat, String newid) {
        File newDPTempFile;
        String dataPackageId = null;
        String relationship = "isRelatedTo";
        AccessionNumber a = new AccessionNumber(this.morpho);
        FileSystemDataStore fsds = new FileSystemDataStore(this.morpho);
        if (this.addedFile != null && ((relationship = this.FileNameTextField.getText()).indexOf("/") != -1 || relationship.indexOf("\\") != -1)) {
            int slashindex = relationship.lastIndexOf("/") + 1;
            if (slashindex == 0) {
                slashindex = relationship.lastIndexOf("\\") + 1;
            }
            relationship = relationship.substring(slashindex, relationship.length());
            relationship = "isDataFileFor(" + relationship + ")";
        }
        Triple t = new Triple(newid, relationship, this.dataPackage.getID());
        TripleCollection triples = new TripleCollection();
        triples.addTriple(t);
        String accessId = this.dataPackage.getAccessFileIdForDataPackage();
        Triple tacc = new Triple(accessId, "provides access control rules for", newid);
        triples.addTriple(tacc);
        Triple t1 = new Triple(this.entityId, "provides table-entity information for DATAFILE", newid);
        triples.addTriple(t1);
        File packageFile = this.dataPackage.getTriplesFile();
        String docString = PackageUtil.addTriplesToTriplesFile(triples, this.dataPackage, this.morpho);
        dataPackageId = a.incRev(this.dataPackage.getID());
        Log.debug(20, "datapackageid: " + this.dataPackage.getID() + " newid: " + dataPackageId);
        try {
            newDPTempFile = fsds.saveTempFile(dataPackageId, new StringReader(docString));
            docString = a.incRevInTriples(newDPTempFile, this.dataPackage.getID(), dataPackageId);
            newDPTempFile = fsds.saveTempFile(dataPackageId, new StringReader(docString));
        }
        catch (Exception e) {
            Log.debug(0, "Error saving file: " + e.getMessage());
            e.printStackTrace();
            return dataPackageId;
        }
        if (locLocal) {
            try {
                if (this.addedFile != null) {
                    File e = fsds.newDataFile(newid, new FileInputStream(this.addedFile));
                }
            }
            catch (Exception e) {
                Log.debug(0, "Error saving file: " + e.getMessage());
                e.printStackTrace();
                e.printStackTrace();
                return dataPackageId;
            }
            try {
                fsds.saveFile(dataPackageId, new FileReader(newDPTempFile));
            }
            catch (Exception e) {
                Log.debug(0, "Error saving file: " + e.getMessage());
                e.printStackTrace();
                return dataPackageId;
            }
        }
        if (locMetacat) {
            Log.debug(20, "Sending file(s) to metacat.");
            MetacatDataStore mds = new MetacatDataStore(this.morpho);
            try {
                mds.newDataFile(newid, this.addedFile);
            }
            catch (Exception mue) {
                Log.debug(0, "Error saving data file to metacat: " + mue.getMessage());
                mue.printStackTrace();
                return dataPackageId;
            }
            try {
                mds.saveFile(dataPackageId, new FileReader(newDPTempFile));
            }
            catch (MetacatUploadException mue) {
                Log.debug(0, "Error saving package file to metacat: " + mue.getMessage());
                mue.printStackTrace();
                return dataPackageId;
            }
            catch (FileNotFoundException fnfe) {
                Log.debug(0, "Error saving package file to metacat(2): " + fnfe.getMessage());
                fnfe.printStackTrace();
                return dataPackageId;
            }
            catch (Exception e) {
                Log.debug(0, "Error saving package file to metacat(3): " + e.getMessage());
                e.printStackTrace();
                return dataPackageId;
            }
        }
        return dataPackageId;
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == NewDataFile.this.FileDialogButton) {
                NewDataFile.this.FileDialogButton_actionPerformed(event);
            } else if (object == NewDataFile.this.CancelAddButton) {
                NewDataFile.this.CancelAddButton_actionPerformed(event);
            } else if (object == NewDataFile.this.AddFileButton) {
                NewDataFile.this.AddFileButton_actionPerformed(event);
            }
        }
    }
}

