/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.ui;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import multivalent.Behavior;
import multivalent.Browser;
import multivalent.DocInfo;
import multivalent.Document;
import multivalent.INode;
import multivalent.Node;
import multivalent.SemanticEvent;
import multivalent.gui.VMenu;
import multivalent.node.LeafUnicode;
import phelps.lang.Maths;

public class ForwardBack
extends Behavior {
    static final boolean DEBUG = false;
    public static final String MSG_BACKWARD = "backwardDocument";
    public static final String MSG_FORWARD = "forwardDocument";
    public static final String MSG_OPEN_DOCUMENTS = "openDocuments";
    static final String BACKWARDEVENT = "event backwardDocument";
    static final String FORWARDEVENT = "event forwardDocument";
    List<DocRec> pages_ = new ArrayList<DocRec>(100);
    int pagesi_ = -1;
    DocRec docnow_ = null;
    DocRec doclast_ = null;
    Document rootdoc_ = null;
    private boolean skipit_ = false;

    public void moveDelta(int n) {
        this.moveTo(Maths.minmax(0, this.pagesi_ + n, this.pages_.size() - 1));
    }

    public void moveTo(int n) {
        if (n != this.pagesi_) {
            this.pagesi_ = n;
            this.docnow_ = this.pages_.get(this.pagesi_);
            Browser browser = this.getBrowser();
            if (this.docnow_.page != null) {
                this.getDocument().putAttr("page", this.docnow_.page);
            } else {
                this.getDocument().removeAttr("page");
            }
            this.skipit_ = true;
            browser.eventq("openDocument", this.docnow_.uri);
        }
    }

    public boolean semanticEventBefore(SemanticEvent semanticEvent, String string) {
        boolean bl;
        boolean bl2 = this.pagesi_ + 1 < this.pages_.size();
        boolean bl3 = bl = this.pagesi_ > 0;
        if (super.semanticEventBefore(semanticEvent, string)) {
            return true;
        }
        if ("closeDocument" == string) {
            Document document;
            if (this.doclast_ != null && (document = (Document)semanticEvent.getArg()) != null) {
                this.doclast_.yposn = document.getVsb().getValue();
                this.doclast_.title = document.getAttr("title");
                this.doclast_.page = document.getAttr("page");
            }
        } else if ("createWidget/Go" == string) {
            INode iNode = (INode)semanticEvent.getOut();
            this.createUI("button", "Back", BACKWARDEVENT, iNode, "Go", !bl);
            this.createUI("button", "Forward", FORWARDEVENT, iNode, "Go", !bl2);
        } else if ("createWidget/DOCPOPUP" == string && semanticEvent.getIn() == null) {
            INode iNode = (INode)semanticEvent.getOut();
            this.createUI("button", "Back", BACKWARDEVENT, iNode, "NAVIGATE", !bl);
            this.createUI("button", "Forward", FORWARDEVENT, iNode, "NAVIGATE", !bl2);
        } else if ("createWidget/Toolbar" == string) {
            INode iNode = (INode)semanticEvent.getOut();
            INode iNode2 = (INode)this.createUI("menubutton", "<img src='systemresource:/sys/images/Back16.gif'>", BACKWARDEVENT, iNode, null, !bl);
            new FBMenu("menu", null, iNode2, true);
            INode iNode3 = (INode)this.createUI("menubutton", "<img src='systemresource:/sys/images/Forward16.gif'>", FORWARDEVENT, iNode, null, !bl2);
            new FBMenu("menu", null, iNode3, false);
        }
        return false;
    }

    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        Object object = semanticEvent.getArg();
        if ("redirectedDocument" == string) {
            if (this.pagesi_ >= 0) {
                this.pages_.remove(this.pagesi_);
                --this.pagesi_;
            }
        } else if (MSG_OPEN_DOCUMENTS == string) {
            if (object instanceof List) {
                for (int i = this.pages_.size() - 1; i > this.pagesi_; --i) {
                    this.pages_.remove(i);
                }
                List list = (List)object;
                System.out.println("openDocuments in f/b " + list.size() + " @ " + this.pagesi_);
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    Object e = list.get(i);
                    if (e instanceof URI) {
                        this.pages_.add(new DocRec((URI)e));
                        continue;
                    }
                    if (!(e instanceof String)) continue;
                    try {
                        this.pages_.add(new DocRec(new URI((String)e)));
                        continue;
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                }
                System.out.println("pages_.size() = " + this.pages_.size());
            }
        } else if ("openedDocument" == string) {
            DocInfo docInfo = (DocInfo)object;
            this.rootdoc_ = docInfo.doc;
            if (this.skipit_) {
                this.skipit_ = false;
                docInfo.doc.putAttr("page", this.docnow_.page);
            } else if (docInfo.doc == this.getBrowser().getDocRoot().childAt(0)) {
                URI uRI = docInfo.uri;
                if (this.pagesi_ == -1 || !uRI.equals(this.pages_.get((int)this.pagesi_).uri)) {
                    for (int i = this.pages_.size() - 1; i > this.pagesi_; --i) {
                        this.pages_.remove(i);
                    }
                    this.docnow_ = new DocRec(uRI);
                    this.pages_.add(this.docnow_);
                    ++this.pagesi_;
                }
            }
            this.doclast_ = this.docnow_;
        } else if ("formattedDocument" == string) {
            if (this.rootdoc_ == object && this.docnow_.yposn != -1) {
                this.rootdoc_.scrollTo(0, this.docnow_.yposn);
            }
        } else if (MSG_FORWARD == string) {
            this.moveDelta(1);
        } else if (MSG_BACKWARD == string) {
            this.moveDelta(-1);
        }
        return super.semanticEventAfter(semanticEvent, string);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FBMenu
    extends VMenu {
        protected boolean backward_;
        protected int postedat_;

        public FBMenu(String string, Map<String, Object> map, INode iNode, boolean bl) {
            super(string, map, iNode);
            this.backward_ = true;
            this.backward_ = bl;
        }

        @Override
        public void post(int n, int n2, Browser browser) {
            this.removeAllChildren();
            int n3 = this.backward_ ? -1 : 1;
            int n4 = ForwardBack.this.pages_.size();
            for (int i = ForwardBack.this.pagesi_ + n3; i >= 0 && i < n4; i += n3) {
                DocRec docRec = ForwardBack.this.pages_.get(i);
                new LeafUnicode(docRec.title, null, this);
            }
            this.postedat_ = ForwardBack.this.pagesi_;
            super.post(n, n2, browser);
        }

        @Override
        public void invoke() {
            super.invoke();
            Node node = this.getSelected();
            if (node != null) {
                ForwardBack.this.moveTo((this.backward_ ? -1 : 1) * (node.childNum() + 1) + this.postedat_);
            }
        }
    }

    private static class DocRec {
        public URI uri;
        public String title = null;
        public String target = null;
        public int yposn = -1;
        public String page = null;

        DocRec(URI uRI) {
            this.uri = uRI;
            this.title = uRI.toString();
        }

        public String toString() {
            return this.title + "  /  " + this.uri + ", y=" + this.yposn;
        }
    }
}

