/*
 * Decompiled with CFR 0.152.
 */
package multivalent.gui;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import multivalent.Browser;
import multivalent.Context;
import multivalent.EventListener;
import multivalent.INode;
import multivalent.IScrollPane;
import multivalent.Node;
import multivalent.Span;
import multivalent.TreeEvent;
import multivalent.gui.VMenuButton;
import multivalent.gui.VScrollbar;
import multivalent.gui.VSeparator;
import multivalent.node.LeafShadow;
import multivalent.node.Root;
import multivalent.std.VScript;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VMenu
extends IScrollPane
implements EventListener {
    public static final String MSG_CREATE_FILE = "createWidget/File";
    public static final String MSG_CREATE_EDIT = "createWidget/Edit";
    public static final String MSG_CREATE_GO = "createWidget/Go";
    public static final String MSG_CREATE_BOOKMARK = "createWidget/Bookmark";
    public static final String MSG_CREATE_LENS = "createWidget/Lens";
    public static final String MSG_CREATE_STYLE = "createWidget/Style";
    public static final String MSG_CREATE_ANNO = "createWidget/Anno";
    public static final String MSG_CREATE_VIEW = "createWidget/View";
    public static final String MSG_CREATE_HELP = "createWidget/Help";
    public static final String CATEGORY_MEDIUM = "medium";
    public static final String VAR_MENUSTACK = "MENUSTACK";
    public static int Maxsize = 20;
    boolean multiple_ = false;
    private Node activeitem_ = null;
    private ActiveSpan activespan_ = null;
    private Node activenew_ = null;
    private Node shadow_ = null;
    private boolean posted_ = false;
    private boolean tickled_ = false;

    public VMenu(String string, Map<String, Object> map, INode iNode) {
        super(string, map, iNode);
    }

    @Override
    public Node addCategory(Node node, String string) {
        if (string == null) {
            this.appendChild(node);
        } else {
            String string2;
            int n;
            Node node2;
            if (!string.startsWith("_")) {
                string = new StringBuffer().append("_").append(string).toString();
            }
            if ((node2 = this.findBFS(string)) == null) {
                node2 = new VSeparator(string, null, this);
            }
            int n2 = this.size();
            for (n = node2.childNum() + 1; n < n2 && (string2 = this.childAt(n).getName()) != null && !string2.startsWith("_"); ++n) {
            }
            this.insertChildAt(node, n);
        }
        return node;
    }

    public Node getSelected() {
        return this.activeitem_;
    }

    public void setSelected(Node node) {
        if (node != this.activeitem_) {
            if (node == null) {
                this.activeitem_ = null;
            } else if (node.getParentNode() == this) {
                this.activeitem_ = node;
            }
        }
    }

    @Override
    public boolean formatNode(int n, int n2, Context context) {
        Node node;
        int n3;
        Root root = this.getRoot();
        int n4 = 0;
        boolean bl = false;
        int n5 = Integer.MAX_VALUE;
        int n6 = 0;
        int n7 = this.size();
        for (n3 = 0; n3 < n7; ++n3) {
            node = this.childAt(n3);
            if (!node.isValid()) {
                node.formatBeforeAfter(root.bbox.width, n2, context);
            }
            Rectangle rectangle = node.bbox;
            rectangle.setLocation(0, n6);
            n6 += rectangle.height;
            if (n3 == Maxsize) {
                n5 = n6;
            }
            n4 = Math.max(n4, rectangle.width);
        }
        n7 = this.size();
        for (n3 = 0; n3 < n7; ++n3) {
            node = this.childAt(n3);
            node.bbox.width = n4;
        }
        n3 = root.bbox.height;
        if (n6 > n3) {
            for (n7 = this.size() - 1; n7 >= 1; --n7) {
                int n8 = this.childAt((int)n7).bbox.y;
                if (n8 > n3) continue;
                this.bbox.setSize(n4 + VScrollbar.SIZE, n8 - 1);
                break;
            }
            this.getVsb().setShowPolicy((byte)1);
            this.getHsb().setShowPolicy((byte)0);
        } else {
            this.bbox.setSize(n4, n6);
            this.setScrollbarShowPolicy((byte)0);
        }
        this.baseline = this.bbox.height;
        return super.formatNode(n, n2, context);
    }

    @Override
    public void paintNode(Rectangle rectangle, Context context) {
        Root root = this.getRoot();
        int n = root.bbox.y + root.bbox.height;
        if (this.bbox.y > 0 && this.bbox.y + this.bbox.height > n) {
            this.bbox.y = Math.max(n - this.bbox.height, 0);
            this.repaint();
            return;
        }
        super.paintNode(rectangle, context);
    }

    public void post(int n, int n2, Browser browser) {
        if (this.posted_) {
            this.repaint();
            return;
        }
        Root root = browser.getRoot();
        INode iNode = this.getParentNode();
        this.shadow_ = iNode == null || iNode == root ? this : new LeafShadow("menu", null, null, this);
        this.bbox.setLocation(n, n2);
        browser.setCurNode(null);
        browser.setGrab(this);
        ArrayList<VMenu> arrayList = (ArrayList<VMenu>)root.getVar(VAR_MENUSTACK);
        if (arrayList == null) {
            arrayList = new ArrayList<VMenu>(10);
            root.putVar(VAR_MENUSTACK, arrayList);
        }
        arrayList.add(this);
        root.appendChild(this.shadow_);
        this.activespan_ = new ActiveSpan();
        this.activespan_.restore(null, null, root.getLayer("<scratch>"));
        this.posted_ = true;
        this.tickled_ = false;
        if (this.bbox.width <= 0) {
            if (iNode != null) {
                iNode.markDirty();
            }
            browser.repaint();
        } else {
            this.repaint(10L);
        }
    }

    public void unpost() {
        if (!this.posted_) {
            return;
        }
        this.posted_ = false;
        Browser browser = this.getBrowser();
        browser.releaseGrab(this);
        this.activespan_.moveq(null);
        Root root = browser.getRoot();
        this.repaint(50L);
        this.shadow_.repaint();
        this.shadow_.remove();
        this.shadow_ = null;
        List list = (List)root.getVar(VAR_MENUSTACK);
        int n = list.indexOf(this);
        if (n != -1) {
            for (int i = list.size() - 1; i > n; --i) {
                ((VMenu)list.get(i)).unpost();
            }
            list.remove(n);
        }
    }

    @Override
    public boolean eventBeforeAfter(AWTEvent aWTEvent, Point point) {
        if (super.eventBeforeAfter(aWTEvent, point)) {
            return true;
        }
        return point != null && this.contains(point);
    }

    @Override
    public void event(AWTEvent aWTEvent) {
        Browser browser = this.getBrowser();
        Point point = browser.getCurScrn();
        Point point2 = new Point(point.x - this.shadow_.bbox.x + this.bbox.x, point.y - this.shadow_.bbox.y + this.bbox.y);
        if (super.eventBeforeAfter(aWTEvent, point2)) {
            return;
        }
        int n = aWTEvent.getID();
        List list = (List)browser.getRoot().getVar(VAR_MENUSTACK);
        if (n == 501) {
            if (this.posted_) {
                this.tickled_ = true;
            }
        } else if (n == 506 || n == 503) {
            if (this.shadow_.bbox.contains(point)) {
                TreeEvent treeEvent = new TreeEvent(browser, 2002);
                browser.setCurNode(null);
                this.shadow_.eventBeforeAfter(treeEvent, point);
                Node node = browser.getCurNode();
                if (node != this && this.contains(node)) {
                    while (node.getParentNode() != this) {
                        node = node.getParentNode();
                    }
                }
                if (this.activenew_ != node && node != this) {
                    Rectangle rectangle;
                    if (this.activenew_ != null) {
                        rectangle = this.activenew_.bbox;
                        this.repaint(50L, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    }
                    this.activenew_ = node;
                    if (node == null) {
                        this.activespan_.moveq(null);
                    } else {
                        this.activespan_.moveq(node.getFirstLeaf(), 0, node.getLastLeaf(), node.getLastLeaf().size());
                        rectangle = node.bbox;
                        this.repaint(50L, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        if (node instanceof VMenuButton) {
                            browser.releaseGrab(this);
                            ((VMenuButton)node).post();
                        }
                    }
                }
                this.tickled_ = true;
            } else {
                this.activenew_ = null;
                Root root = browser.getRoot();
                browser.setCurNode(null);
                root.eventBeforeAfter(new TreeEvent(browser, 2002), point);
                if (browser.getCurNode() != null) {
                    for (Node node = browser.getCurNode(); node != null; node = node.getParentNode()) {
                        if (node instanceof VMenuButton) {
                            int n2;
                            browser.releaseGrab(this);
                            VMenu vMenu = null;
                            vMenu = node.getParentNode() instanceof VMenu ? (VMenu)list.get((n2 = list.indexOf(vMenu = (VMenu)node.getParentNode())) + 1 < list.size() ? n2 + 1 : 0) : (VMenu)list.get(0);
                            vMenu.unpost();
                            ((VMenuButton)node).post(vMenu);
                        } else {
                            if (!(node instanceof VMenu)) continue;
                            browser.releaseGrab(this);
                            VMenu vMenu = (VMenu)node;
                            if (vMenu != this && list.indexOf(vMenu) != list.size() - 1) {
                                int n3 = vMenu.bbox.x;
                                int n4 = vMenu.bbox.y;
                                vMenu.unpost();
                                vMenu.post(n3, n4, browser);
                            }
                        }
                        break;
                    }
                }
            }
        } else if (n == 502) {
            if (this.posted_ && this.tickled_) {
                ((VMenu)list.get(0)).unpost();
            }
            browser.repaint(100L);
            if (this.activenew_ != null && this.activenew_ != this.activeitem_) {
                this.setSelected(this.activenew_);
                this.invoke();
            }
        }
    }

    public void invoke() {
        if (this.activeitem_ != null) {
            VScript.eval(this.activeitem_.getValue("script"), this.getDocument(), this.activeitem_.getAttributes(), this.activeitem_);
        }
    }

    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
        if (this.shadow_ != null && this.shadow_ != this) {
            this.shadow_.repaint(l, n + this.dx(), n2 + this.dy(), n3, n4);
        } else {
            super.repaint(l, n, n2, n3, n4);
        }
    }

    static class ActiveSpan
    extends Span {
        ActiveSpan() {
            this.name_ = "active";
        }

        public boolean appearance(Context context, boolean bl) {
            Color color = context.foreground;
            context.foreground = context.background;
            context.background = color;
            return false;
        }

        public int getPriority() {
            return 102250;
        }
    }
}

