/*
 * Decompiled with CFR 0.152.
 */
package multivalent.devel;

import com.pt.awt.NFont;
import java.awt.Color;
import java.awt.Graphics2D;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import multivalent.Behavior;
import multivalent.Browser;
import multivalent.Context;
import multivalent.ContextListener;
import multivalent.CursorMark;
import multivalent.DocInfo;
import multivalent.Document;
import multivalent.INode;
import multivalent.Layer;
import multivalent.Leaf;
import multivalent.Mark;
import multivalent.Multivalent;
import multivalent.Node;
import multivalent.SemanticEvent;
import multivalent.Span;
import multivalent.StyleSheet;
import multivalent.gui.VCheckbox;
import multivalent.gui.VFrame;
import multivalent.node.Root;
import phelps.lang.Booleans;

public class Debug
extends Behavior {
    public static final String MSG_SET_MODE = "debugSetMode";
    public static final String PREF_MODE = "Debug/Monitor";
    public static final String MSG_CREATE_DEBUG = "createWidget/Debug";
    static String[] titleev = new String[]{"VALIDATE Document Tree", "debugValidate", "Stats over nodes", "debugNodesStats", "Stats on current node", "debugNodeStats", "Call GC", "debugGC", "<b>Dump misc</b>", "debugDumpMisc", "dump personal layer", "debugDumpPersonal", "Dump span loc", "debugDumpLoc", "<b>Dump Layers</b>", "debugDumpLayers", "Show profile stats", "debugShowProfile", "Reset profile stats", "debugResetProfile", "Reformat", "debugReformat", "Repaint", "debugRepaint", "leaf walk", "debugLeafWalk", "dump prefs", "debugDumpPrefs", "Dump root (3 levels)", "debugDumpRoot/3", "Dump root (4 levels)", "debugDumpRoot/4", "Dump root (5 levels)", "debugDumpRoot/5", "Dump doc tree (4 levels)", "debugDumpDoc/4", "Dump doc tree (20 levels)", "debugDumpDoc/20"};
    Node obs_ = null;
    boolean fsemev = false;
    boolean fpaint = false;
    private static NFont smallFont_ = NFont.getInstance("Times", 400, 2, 9.0f);

    public boolean semanticEventBefore(SemanticEvent semanticEvent, String string) {
        if (this.fsemev) {
            System.out.println("B: " + semanticEvent);
        }
        if (super.semanticEventBefore(semanticEvent, string)) {
            return true;
        }
        if (Booleans.parseBoolean(this.getPreference("DebugMode", "false"), false)) {
            if (MSG_CREATE_DEBUG == string) {
                int n;
                INode iNode = (INode)semanticEvent.getOut();
                Browser browser = this.getBrowser();
                this.createUI("button", "ABORT", "event debugAbort", iNode, null, false);
                VCheckbox vCheckbox = (VCheckbox)this.createUI("checkbox", "Track Semantic Events", new SemanticEvent(browser, "debugSemanticEvents", null), iNode, null, false);
                vCheckbox.setState(this.fsemev);
                vCheckbox = (VCheckbox)this.createUI("checkbox", "Track Paint", new SemanticEvent(browser, "debugPaint", null), iNode, null, false);
                vCheckbox.setState(this.fsemev);
                int n2 = titleev.length;
                for (n = 0; n < n2; n += 2) {
                    this.createUI("button", titleev[n], "event " + titleev[n + 1], iNode, null, false);
                }
                vCheckbox = (VCheckbox)this.createUI("checkbox", "Always Validate Document", new SemanticEvent(browser, MSG_SET_MODE, null), iNode, null, false);
                n = Booleans.parseBoolean(this.getPreference(PREF_MODE, "true"), true) ? 1 : 0;
                vCheckbox.setState(n != 0);
            } else if ("createWidget/Toolbar" == string) {
                this.createUI("button", "ABORT", "event debugAbort", (INode)semanticEvent.getOut(), null, false);
                this.createUI("button", "AA", "event debugAA", (INode)semanticEvent.getOut(), null, false);
            }
        }
        return false;
    }

    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        if (this.fsemev) {
            System.out.println("A: " + semanticEvent);
        }
        Browser browser = this.getBrowser();
        Document document = browser.getCurDocument();
        Node node = null;
        int n = -1;
        Object var7_7 = null;
        Span span = browser.getSelectionSpan();
        CursorMark cursorMark = browser.getCursorMark();
        Root root = browser.getRoot();
        if ("currentDocument" == string) {
            if (this.obs_ != null) {
                this.obs_.deleteObserver(this);
            }
            Document document2 = (Document)semanticEvent.getArg();
            boolean bl = Booleans.parseBoolean(this.getPreference("DebugMode", "false"), false);
        } else if ("debugGC" == string) {
            Runtime.getRuntime().gc();
            browser.repaint();
        } else if ("debugMakeWindow" == string) {
            VFrame vFrame = new VFrame("Note198372342", null, document);
            vFrame.setBounds(200, 75, 300, 200);
            vFrame.setTitle("Test Window");
            Document document3 = new Document("Note198372342", null, vFrame, browser);
            document.repaint();
            DocInfo docInfo = null;
            try {
                docInfo = new DocInfo(new URI(this.getClass().getResource("/sys/Release.html").toString()));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            docInfo.doc = document3;
            browser.eventq("openDocument", docInfo);
        } else if ("debugDumpPersonal" == string) {
            Layer layer = document.getLayer("personal");
            StringBuffer stringBuffer = new StringBuffer(10000);
            stringBuffer.append("*** PERSONAL LAYER ***\n");
            layer.save().writeXML();
        } else if (string != null && string.startsWith("debugDumpDoc")) {
            int n2 = 4;
            int n3 = string.indexOf(47);
            if (n3 != -1) {
                try {
                    n2 = Integer.parseInt(string.substring(n3 + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            document.dump(n2);
        } else if (string != null && string.startsWith("debugDumpRoot")) {
            int n4 = 4;
            int n5 = string.indexOf(47);
            if (n5 != -1) {
                try {
                    n4 = Integer.parseInt(string.substring(n5 + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            root.dump(n4);
        } else if ("debugAbort" == string) {
            System.exit(0);
        } else if ("debugAA" == string) {
            NFont.setUseBitmaps(!NFont.isUseBitmaps());
            browser.repaint(100L);
        } else if ("debugDumpPrefs" == string) {
            System.out.println("PREFERENCES");
            Multivalent multivalent = this.getGlobal();
            Iterator<String> iterator = multivalent.prefKeyIterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next();
                System.out.println(string2 + " => " + multivalent.getPreference(string2, null));
            }
        } else if ("debugDumpLayers" == string) {
            document.getLayers().dump();
        } else if ("debugDumpLoc" == string) {
            if (!span.isSet()) {
                System.out.println("Locations reported on endpoints of selection => need to select a range");
            }
        } else if ("debugDumpMisc" == string) {
            int n6;
            System.out.println("root = " + browser.getRoot() + "\n\tobservers: " + browser.getRoot().getObservers() + "\nURI=" + document.getURI() + ", pagenum=" + document.getAttr("page") + "\nattrs: " + document.getAttributes() + "\ncurdoc = " + document);
            System.out.println("curdoc = " + document.getName() + ", valid=" + document.isValid() + ", bbox=" + document.bbox + ", #children=" + document.size());
            System.out.print("Document Layers, immediate (not nested):");
            Layer layer = document.getLayers();
            int n7 = layer.size();
            for (n6 = 0; n6 < n7; ++n6) {
                System.out.print("  " + layer.getBehavior(n6).getName());
            }
            System.out.println();
            System.out.print("Personal Layer:");
            layer = document.getLayer("personal");
            n7 = layer.size();
            for (n6 = 0; n6 < n7; ++n6) {
                System.out.print("  " + layer.getBehavior(n6).getName());
            }
            System.out.println();
            if (cursorMark.isSet()) {
                List<ContextListener> list = cursorMark.getMark().leaf.getActivesAt(cursorMark.getMark().offset);
                System.out.println("ACTIVE BEHAVIORS");
                int n8 = list.size();
                for (n7 = 0; n7 < n8; ++n7) {
                    System.out.println(list.get(n7));
                }
            }
        } else if ("debugValidate" == string) {
            System.out.println("*** Validation trace");
            try {
                browser.checkRep();
            }
            catch (AssertionError assertionError) {
                ((Throwable)((Object)assertionError)).printStackTrace();
            }
            System.out.println("*** END Validation trace");
        } else if ("debugNodeStats" == string) {
            Mark mark = null;
            if (cursorMark.isSet()) {
                mark = cursorMark.getMark();
            } else if (span.isSet()) {
                mark = span.getStart();
            }
            if (mark != null) {
                node = mark.leaf;
                n = mark.offset;
                System.out.println("At node |" + node.getName() + "|, offset=" + n + ", class=" + node.getClass().getName() + ", hashcode=" + node.hashCode());
                System.out.println("attrs = " + node.getAttributes());
                System.out.println("bbox = " + node.bbox + ", baseline=" + node.baseline + ", valid=" + node.isValid() + ", dx=" + node.dx() + ", dy=" + node.dy() + ", break before=" + node.breakBefore() + "/after=" + node.breakAfter());
                System.out.println("getActivesAt: " + node.getActivesAt(n));
                Document document4 = node.getDocument();
                StyleSheet styleSheet = document4.getStyleSheet();
                Context context = styleSheet.getContext();
                context.reset(node, n);
                System.out.println("  context = " + context);
                System.out.println("getActivesAt(-1): " + node.getActivesAt(-1));
            }
        } else if ("debugNodeStats" == string) {
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            int n13 = 0;
            ArrayList<Node> arrayList = new ArrayList<Node>(1000);
            arrayList.add(this.getBrowser().getRoot());
            while (arrayList.size() > 0) {
                Node node2;
                node = (Node)arrayList.remove(0);
                if (node.isStruct()) {
                    node2 = (INode)node;
                    ++n9;
                    n11 += node.sizeSticky();
                    int n14 = ((INode)node2).size();
                    for (int i = 0; i < n14; ++i) {
                        arrayList.add(((INode)node2).childAt(i));
                    }
                    continue;
                }
                node2 = (Leaf)node;
                ++n10;
                n12 += node.sizeSticky();
            }
            System.out.println(n9 + " internal nodes, with " + n11 + " stickies");
            System.out.println("\t" + n13 + " empty stickies");
            System.out.println(n10 + " leaf nodes, with " + n12 + " stickies");
        } else if ("debugShowProfile" == string) {
            browser.resetProfile();
        } else if ("debugResetProfile" == string) {
            StringBuffer stringBuffer = new StringBuffer(4000);
            browser.showProfile(stringBuffer);
            System.out.println(stringBuffer);
        } else if ("debugReformat" == string) {
            browser.getRoot().markDirtySubtree(true);
            browser.repaint();
        } else if ("debugReformatTimed" == string) {
            int n15 = 100;
            long l = System.currentTimeMillis();
            for (int i = 0; i < n15; ++i) {
                browser.getRoot().markDirtySubtree(true);
                browser.format();
            }
            long l2 = System.currentTimeMillis();
            System.out.println("FULL reformatting took " + (l2 - l) / (long)n15 + " ms (for each of " + n15 + " iterations)");
            l = System.currentTimeMillis();
            for (int i = 0; i < n15; ++i) {
                browser.getRoot().markDirtySubtree(false);
                browser.format();
            }
            l2 = System.currentTimeMillis();
            System.out.println("SKIP VALID LEAF NODES reformatting took " + (l2 - l) / (long)n15 + " ms");
            browser.repaint();
        } else if ("debugRepaint" == string) {
            browser.repaint(50L);
        } else if ("debugLeafWalk" == string) {
            for (Leaf leaf = browser.getCurDocument().getFirstLeaf(); leaf != null; leaf = leaf.getNextLeaf()) {
                System.out.println(leaf);
            }
        } else if (MSG_SET_MODE == string) {
            boolean bl = Booleans.parseBoolean(this.getPreference(PREF_MODE, "false"), false);
            bl = Booleans.parseBoolean(semanticEvent.getArg(), !bl);
            this.putPreference(PREF_MODE, bl ? "true" : "false");
            if (bl) {
                browser.eventq("debugValidate", null);
            }
        } else if ("debugSemanticEvents" == string) {
            this.fsemev = !this.fsemev;
        } else if ("debugPaint" == string) {
            this.fpaint = !this.fpaint;
        } else if ("formattedDocument" != string || Booleans.parseBoolean(this.getPreference(PREF_MODE, "true"), true)) {
            // empty if block
        }
        return super.semanticEventAfter(semanticEvent, string);
    }

    public void nodeStats(Node node) {
        if (node.isStruct()) {
            // empty if block
        }
    }

    public void buildAfter(Document document) {
        document.getRoot().addObserver(this);
        super.buildAfter(document);
    }

    public boolean paintBefore(Context context, Node node) {
        if (this.fpaint) {
            System.out.println("paint B: " + context.g.getClip());
        }
        return super.paintBefore(context, node);
    }

    public boolean paintAfter(Context context, Node node) {
        if (this.fpaint) {
            System.out.println("paint A: " + context.g.getClip());
        }
        Runtime runtime = Runtime.getRuntime();
        Graphics2D graphics2D = context.g;
        graphics2D.setColor(Color.BLACK);
        NFont nFont = smallFont_;
        int n = node.bbox.width - 75;
        long l = Math.round(runtime.totalMemory() * 10L / 0x100000L);
        long l2 = Math.round(runtime.freeMemory() * 10L / 0x100000L);
        nFont.drawString(graphics2D, "Mem " + l, n, 50.0f);
        nFont.drawString(graphics2D, "Free " + l2, n, 65.0f);
        return super.paintAfter(context, node);
    }
}

