/*
 * Decompiled with CFR 0.152.
 */
package com.pt.awt.font;

import com.pt.awt.font.CMapIdentity;
import com.pt.awt.font.CMapIdentity2;
import com.pt.awt.font.CMapReverse;
import com.pt.doc.PostScript;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import phelps.util.Arrayss;

public class CMap {
    static final boolean DEBUG = true;
    public static final CMap IDENTITY;
    public static final CMap IDENTITY_H;
    public static final CMap IDENTITY_V;
    public static final CMap IDENTITY_UTF16BE;
    private static final Map<String, SoftReference<CMap>> cache_;
    private static final char[] BLANK;
    private char[][] toSel_;
    private int[] first_;
    private int[] last_;
    private CMap rev_ = null;
    private CMap usecmap_;
    private boolean[] onebyte_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CMap(char[] cArray) {
        this(new char[][]{cArray}, null);
    }

    public CMap(char[][] cArray) {
        this(cArray, null);
    }

    public CMap(char[][] cArray, boolean[] blArray) {
        if (!$assertionsDisabled && cArray == null) {
            throw new AssertionError();
        }
        this.usecmap_ = null;
        this.onebyte_ = blArray;
        this.compact(cArray);
    }

    public static char[] createBlankPage() {
        return (char[])BLANK.clone();
    }

    CMap() {
        this.toSel_ = null;
        this.onebyte_ = null;
        this.usecmap_ = null;
    }

    public CMap(CMap cMap, InputStream inputStream) throws IOException {
        Object object;
        this.usecmap_ = cMap;
        char[][] cArrayArray = new char[256][];
        this.onebyte_ = new boolean[256];
        Arrays.fill(this.onebyte_, true);
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 5);
        Object[] objectArray = new Object[100];
        int n = 0;
        PostScript.eatSpace(pushbackInputStream);
        while ((object = PostScript.readObject(pushbackInputStream)) != null) {
            int n2;
            int n3;
            int n4;
            int n5;
            StringBuffer stringBuffer;
            StringBuffer stringBuffer2;
            int n6;
            Class<?> clazz = object.getClass();
            if (PostScript.CLASS_COMMENT == clazz) continue;
            if (PostScript.CLASS_NAME != clazz) {
                objectArray[n++] = object;
                continue;
            }
            if (((String)object).startsWith("/")) {
                objectArray[n++] = ((String)object).substring(1);
                continue;
            }
            String string = (String)object;
            int n7 = 0;
            if ("begincodespacerange".equals(string)) {
                n6 = ((Number)objectArray[n - 1]).intValue();
                for (int i = 0; i < n6; ++i) {
                    stringBuffer2 = (StringBuffer)PostScript.readObject(pushbackInputStream);
                    stringBuffer = (StringBuffer)PostScript.readObject(pushbackInputStream);
                    int n8 = stringBuffer2.length();
                    if (!$assertionsDisabled && n8 != stringBuffer.length()) {
                        throw new AssertionError((Object)(stringBuffer2 + " vs " + stringBuffer));
                    }
                    if (n8 == 1) {
                        n5 = stringBuffer.charAt(0);
                        for (n4 = stringBuffer2.charAt(0); n4 <= n5; ++n4) {
                            this.onebyte_[n4] = true;
                        }
                        continue;
                    }
                    if (n8 == 2) {
                        n5 = Math.min(stringBuffer.charAt(0), 255);
                        for (n4 = stringBuffer2.charAt(0); n4 <= n5; ++n4) {
                            this.onebyte_[n4] = false;
                        }
                        continue;
                    }
                    if (n8 == 3) {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        continue;
                    }
                    if ($assertionsDisabled) continue;
                    if (n8 == 4) {
                        // empty if block
                    }
                    throw new AssertionError(n8);
                }
                PostScript.readObject(pushbackInputStream);
            } else if ("beginbfchar".equals(string)) {
                n6 = ((Number)objectArray[n - 1]).intValue();
                for (int i = 0; i < n6; ++i) {
                    stringBuffer2 = (StringBuffer)PostScript.readObject(pushbackInputStream);
                    stringBuffer = (StringBuffer)PostScript.readObject(pushbackInputStream);
                    int n9 = this.s2i(stringBuffer2)[0];
                    n4 = this.s2c(stringBuffer)[0];
                    n5 = n9 >> 8;
                    if (cArrayArray[n5] == null) {
                        cArrayArray[n5] = CMap.createBlankPage();
                    }
                    cArrayArray[n5][n9 & 0xFF] = n4;
                }
                PostScript.readObject(pushbackInputStream);
            } else if ("beginbfrange".equals(string)) {
                n6 = ((Number)objectArray[n - 1]).intValue();
                for (int i = 0; i < n6; ++i) {
                    stringBuffer2 = (StringBuffer)PostScript.readObject(pushbackInputStream);
                    stringBuffer = (StringBuffer)PostScript.readObject(pushbackInputStream);
                    Object object2 = PostScript.readObject(pushbackInputStream);
                    n5 = this.s2i(stringBuffer)[0];
                    if (PostScript.CLASS_STRING == object2.getClass()) {
                        n3 = this.s2c((StringBuffer)object2)[0];
                        while (n4 <= n5) {
                            n2 = n4 >> 8;
                            if (cArrayArray[n2] == null) {
                                cArrayArray[n2] = CMap.createBlankPage();
                            }
                            cArrayArray[n2][n4 & 0xFF] = n3;
                            ++n4;
                            n3 = (char)(n3 + 1);
                        }
                        continue;
                    }
                    if (!$assertionsDisabled && !"[".equals(object2)) {
                        throw new AssertionError();
                    }
                    for (n4 = this.s2i(stringBuffer2)[0]; n4 <= n5; ++n4) {
                        n3 = n4 >> 8;
                        if (cArrayArray[n3] == null) {
                            cArrayArray[n3] = CMap.createBlankPage();
                        }
                        object2 = PostScript.readObject(pushbackInputStream);
                        cArrayArray[n3][n4 & 0xFF] = ((StringBuffer)object2).charAt(0);
                    }
                    object2 = PostScript.readObject(pushbackInputStream);
                    if (!$assertionsDisabled && !"]".equals(object2)) {
                        throw new AssertionError();
                    }
                }
                PostScript.readObject(pushbackInputStream);
            } else if ("begincidrange".equals(string)) {
                n6 = ((Number)objectArray[n - 1]).intValue();
                for (int i = 0; i < n6; ++i) {
                    stringBuffer2 = (StringBuffer)PostScript.readObject(pushbackInputStream);
                    stringBuffer = (StringBuffer)PostScript.readObject(pushbackInputStream);
                    Object object3 = PostScript.readObject(pushbackInputStream);
                    n4 = this.s2i(stringBuffer2)[0];
                    n5 = this.s2i(stringBuffer)[0];
                    n3 = ((Number)object3).intValue();
                    while (n4 <= n5) {
                        n2 = n4 >> 8;
                        if (cArrayArray[n2] == null) {
                            cArrayArray[n2] = CMap.createBlankPage();
                        }
                        cArrayArray[n2][n4 & 0xFF] = n3;
                        ++n4;
                        n3 = (char)(n3 + 1);
                    }
                }
                PostScript.readObject(pushbackInputStream);
            } else if ("beginnotdefrange".equals(string)) {
                n6 = ((Number)objectArray[n - 1]).intValue();
                for (int i = 0; i < n6; ++i) {
                    stringBuffer2 = (StringBuffer)PostScript.readObject(pushbackInputStream);
                    stringBuffer = (StringBuffer)PostScript.readObject(pushbackInputStream);
                    Object object4 = PostScript.readObject(pushbackInputStream);
                    n4 = this.s2i(stringBuffer2)[0];
                    n5 = this.s2i(stringBuffer)[0];
                    n3 = (char)((Number)object4).intValue();
                }
                PostScript.readObject(pushbackInputStream);
            } else if (!"begincmap".equals(string)) {
                if ("endmap".equals(string)) break;
                if ("usecmap".equals(string)) {
                    if (!$assertionsDisabled && this.usecmap_ != null) {
                        throw new AssertionError();
                    }
                    this.usecmap_ = CMap.getInstance((String)objectArray[n - 1]);
                } else if ("[".equals(string)) {
                    ArrayList<Object> arrayList = new ArrayList<Object>(10);
                    n6 = 1;
                    while (n6 > 0) {
                        object = PostScript.readObject(pushbackInputStream);
                        if ("]".equals(object)) {
                            if (--n6 <= 0) continue;
                            arrayList.add(object);
                            continue;
                        }
                        arrayList.add(object);
                    }
                    objectArray[n++] = arrayList;
                    n7 = n;
                }
            }
            n = n7;
        }
        pushbackInputStream.close();
        this.compact(cArrayArray);
    }

    private int[] s2i(StringBuffer stringBuffer) {
        int[] nArray = new int[stringBuffer.length()];
        int n = 0;
        int n2 = 0;
        int n3 = stringBuffer.length();
        while (n2 < n3) {
            char c;
            if (this.onebyte_[c = stringBuffer.charAt(n2++)]) {
                nArray[n++] = c;
                continue;
            }
            if (n2 == n3) {
                nArray[n++] = c;
                this.onebyte_[c] = true;
                continue;
            }
            nArray[n++] = c << 8 | stringBuffer.charAt(n2++);
        }
        return Arrayss.resize(nArray, n);
    }

    private char[] s2c(StringBuffer stringBuffer) {
        char[] cArray;
        if (!$assertionsDisabled && stringBuffer == null) {
            throw new AssertionError();
        }
        int n = stringBuffer.length();
        if (n == 1) {
            cArray = new char[]{stringBuffer.charAt(0)};
        } else {
            cArray = new char[n / 2];
            int n2 = 0;
            int n3 = 0;
            while (n2 < n) {
                cArray[n3] = (char)(stringBuffer.charAt(n2) << 8 | stringBuffer.charAt(n2 + 1));
                n2 += 2;
                ++n3;
            }
        }
        return cArray;
    }

    public static CMap getInstance(String string) {
        CMap cMap;
        if ("Identity".equals(string)) {
            cMap = IDENTITY;
        } else if ("Identity-H".equals(string)) {
            cMap = IDENTITY_H;
        } else if ("Identity-V".equals(string)) {
            cMap = IDENTITY_V;
        } else {
            SoftReference<CMap> softReference = cache_.get(string);
            if (softReference == null || (cMap = softReference.get()) == null) {
                InputStream inputStream = CMap.class.getResourceAsStream("/com/adobe/CMap/" + string);
                if (inputStream != null) {
                    try {
                        System.out.println("reading " + string + " from JAR");
                        cMap = new CMap(null, inputStream);
                        if (!$assertionsDisabled && cMap.toSel_ == null) {
                            throw new AssertionError((Object)string);
                        }
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        cMap = IDENTITY;
                    }
                    cache_.put(string, new SoftReference<CMap>(cMap));
                } else {
                    System.err.println("no cmap file " + string);
                    cMap = null;
                }
            }
        }
        return cMap;
    }

    private void compact(char[][] cArray) {
        int n = 1;
        for (int i = cArray.length - 1; i >= 0; --i) {
            if (cArray[i] == null) continue;
            n = i + 1;
            break;
        }
        char[][] cArrayArray = new char[n][];
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int n2 = n * 12;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            int n4;
            int n5;
            if (cArray[i] == null) continue;
            char[] cArray2 = cArray[i];
            int n6 = cArray2.length;
            n3 += n6;
            for (n5 = 0; n5 < n6 && '\u0000' == cArray2[n5]; ++n5) {
            }
            for (n4 = n6; n4 > n5 && '\u0000' == cArray2[n4 - 1]; --n4) {
            }
            if (n5 == n4) {
                n6 = 0;
            } else if (n4 - n5 < n6 - 20) {
                n6 = n4 - n5;
                cArray2 = Arrayss.subset(cArray2, n5, n6);
            } else {
                n5 = 0;
            }
            if (n6 >= 2) {
                int n7;
                char c = cArray2[0];
                for (n7 = 0; n7 < n6 && c == cArray2[n7]; ++n7) {
                }
                if (n7 == n6) {
                    cArray2 = new char[]{c};
                    n6 = 1;
                }
            }
            if (n6 < 10 || cArray2[1] - cArray2[0] == 1) {
                // empty if block
            }
            n5 = (i << 8) + n5;
            n4 = (i << 8) + n4 - 1;
            cArrayArray[i] = cArray2;
            nArray[i] = n5;
            nArray2[i] = n4;
            n2 += cArray2.length * 2;
        }
        this.toSel_ = cArrayArray;
        this.first_ = nArray;
        this.last_ = nArray2;
    }

    public String toSelector(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (this.onebyte_ != null && !this.onebyte_[c]) {
                c = (char)(c << 8 | string.charAt(++i));
            }
            stringBuffer.append(this.toSelector(c));
        }
        return stringBuffer.toString();
    }

    public char toSelector(int n) {
        char c = '\u0000';
        int n2 = n >> 8;
        if (n2 < this.toSel_.length && this.first_[n2] <= n && n <= this.last_[n2]) {
            char[] cArray = this.toSel_[n2];
            c = cArray == null ? (char)'\u0000' : (cArray.length == 1 ? cArray[0] : cArray[n - this.first_[n2]]);
        }
        return c != '\u0000' || this.usecmap_ == null ? c : this.usecmap_.toSelector(n);
    }

    public String fromSelector(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = this.fromSelector(string.charAt(i));
            if (!(this.onebyte_ == null || (c & 0xFF00) == 0 && this.onebyte_[c])) {
                stringBuffer.append((char)(c >> 8)).append((char)(c & 0xFF));
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public char fromSelector(int n) {
        char c;
        if (this.rev_ == null) {
            this.rev_ = this.reverse();
        }
        return (c = this.rev_.toSelector(n)) != '\u0000' || this.usecmap_ == null ? c : this.usecmap_.fromSelector(n);
    }

    public CMap reverse() {
        CMap cMap;
        if (this.rev_ != null) {
            return this.rev_;
        }
        if (this.toSel_ == null) {
            cMap = new CMapReverse(this);
        } else {
            char[][] cArrayArray = new char[256][];
            int n = this.toSel_.length;
            for (int i = 0; i < n; ++i) {
                int n2 = this.first_[i];
                char[] cArray = this.toSel_[i];
                if (cArray == null) continue;
                int n3 = cArray.length;
                for (int j = 0; j < n3; ++j) {
                    char c = cArray[j];
                    if ('\u0000' == c) continue;
                    int n4 = c >> 8;
                    if (cArrayArray[n4] == null) {
                        cArrayArray[n4] = CMap.createBlankPage();
                    }
                    cArrayArray[n4][c & 0xFF] = (char)(n2 + j);
                }
            }
            cMap = new CMap(cArrayArray, null);
        }
        cMap.rev_ = this;
        return cMap;
    }

    public int census(int n, int n2) {
        if (this.toSel_ == null || this.toSel_.length == 0) {
            return 0;
        }
        int n3 = 0;
        int n4 = Math.min(n2 + 255 >> 8, this.toSel_.length);
        for (int i = n >> 8; i < n4; ++i) {
            int n5;
            char[] cArray = this.toSel_[i];
            int n6 = this.first_[i];
            int n7 = Math.min(this.last_[i], n2);
            if (cArray == null) continue;
            if (cArray.length == 1) {
                if (cArray[0] == '\u0000') continue;
                n3 += n7 - n5 + 1;
                continue;
            }
            for (n5 = Math.max(n6, n); n5 <= n7; ++n5) {
                if (cArray[n5 - n6] == '\u0000') continue;
                ++n3;
            }
        }
        return n3;
    }

    static {
        $assertionsDisabled = !CMap.class.desiredAssertionStatus();
        IDENTITY = new CMapIdentity();
        IDENTITY_H = new CMapIdentity2();
        IDENTITY_V = new CMapIdentity2();
        IDENTITY_UTF16BE = new CMapIdentity();
        cache_ = new HashMap<String, SoftReference<CMap>>(20);
        BLANK = new char[256];
        Arrays.fill(BLANK, '\u0000');
    }
}

